/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.VesselType;
import fr.ifremer.isisfish.entities.VesselTypeImpl;
import fr.ifremer.isisfish.entities.TripType;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.triptype.TripTypeListModel;
import jaxx.runtime.swing.editor.NumberEditor;

public class VesselTypeUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWWz28bRRTHJyY/mqY/QxIKbSAlAVRVrHFT2kIiSnCJcORQiJ0S8IGOvc/xVOvdZeat43BASFwR6okDF+DOkTuqOHLiyv+AEP8Bb3Yd22uW8UorctiN38z77Pd9d+bN/vQnm1KSXX3Eu11LBi6KNlg7WwcH9+uPoIH3QDWk8NGTLPqbyLFcjc3Z/bhCtlor6/R8Lz1f9Nq+54I7lL1RZqcVHjugWgCIbDHKaCiVr/TDG10/kCe0vpgk2g9//5V7bH/5Y46xrk+qlqmElXFZgwomyywnbGTz9KQOzzvcPSQZUriHpPOsjhUdrtT7vA2fsS/YTJlN+1wSDNmL6UsNGWF+10d2Ya3k+gEWPRdp+n7pNWTXmtISTQltoLsSqilUywqEJfRE6wEoBU712If9ku+HoGlkk3XgLrLrSanEFShADaWW2r4znOzZx8guxZxSR1S3VeV1BwYzZ9bCQEH/vKgv5/tDp9Z2yrwOzg3yT1vV7RGiqJ4035/7dFOAYw/kaEeRLcXSqtDFbT0tnnrymHX9eyk+tjiCLYN7iC09+Gwy5GYCZGEEUvEBbAPj9QTG8yOMXd6t0iq4F0iOwnMNtFsJtCsjtK0Gio7A4z1an2Bg3U5gPTeqTLhFCUcV8bmJdCeBtDpC2ncFbgfgFD2F95tVyTvRW/8P5BsJyHNrO5WG9BznA+5CgXbCM7EVMRiLp813+iK0y/qO7HLCYtb9qywU6ryb/fTZnqJCYaykGzp6Kz5jacQH2vrtsCUs/ms5b0ngOmtzyI1oP60nbKhJRRbSXolh3gkQowW01Z843eBuIzL73dEReiJC0ogNDsRHpH4UeUbN1xo030F3nKixKRlQmJpWbdCn9ygUdeheNASE0e+/+q7z7c+/vHnSjl+mZ5yNTRk6Pag9+tLzQepWhex81IMDFE5+l/sbNTZLBtPREx4tC0MCKr0wiSD+RZ1m6TTrPa5alDo188eTX5ce/v4Uy22z047H7W2u55fYLLYkVek5dte/+3ao5MzRKbpe0Jqo24Gr3w6dCOc2bY58pS5cm17DW12qdmGo2r6E3x5/vXvlm+XbJxVPRIpGpg2qnvqETQvXES6ER0/vVEk8auZ8BYHtDU6PpPNkQt8X/V7D/jC87ieVNom0HmnrbEZPX+FI51w9QKDadNLHoXj9Xy0lU4c/0peDZMKlVIRPMxNMGi6n1/AwC8GkYTmzD+kIJg0vZPYhHcGk4WpmH9IRTBpWM/uQjmDS8FKK3TqHnudU6WijTWsQMx41ztJ0BFM5r2S2NB3BpOFaZh/SEUwarmf2IR3BpOHVzD6kI5g05DP7kI5g0lDI7EM6gknDemYfxhOQnaHvQGcPXBskSIOaO5nrGU+gr6boiw3sB9wJQP2vejYy+5uOYNJwN/M604R/AHf0CUF7EQAA";
    protected fr.ifremer.isisfish.entities.VesselTypeImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JButton delete;
    protected javax.swing.JTextField fieldVesselTypeActivityRange;
    protected javax.swing.JTextArea fieldVesselTypeComment;
    protected javax.swing.JTextField fieldVesselTypeLength;
    protected javax.swing.JTextField fieldVesselTypeMaxTripDuration;
    protected javax.swing.JTextField fieldVesselTypeMinCrewSize;
    protected javax.swing.JTextField fieldVesselTypeName;
    protected javax.swing.JTextField fieldVesselTypeSpeed;
    protected javax.swing.JTextField fieldVesselTypeUnitFuelCostOfTravel;
    protected javax.swing.JButton save;
    protected jaxx.runtime.swing.JAXXList vesselTypeTripType;
    private fr.ifremer.isisfish.ui.input.VesselTypeUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JScrollPane $JScrollPane10;
    private javax.swing.JScrollPane $JScrollPane12;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table13;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeName.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeName.text");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeLength.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeLength.text");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeSpeed.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeSpeed.text");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeMaxTripDuration.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeMaxTripDuration.text");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeActivityRange.enabled");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeActivityRange.text");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource30 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeMinCrewSize.enabled");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeMinCrewSize.text");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource33 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeUnitFuelCostOfTravel.enabled");
    private java.beans.PropertyChangeListener $DataSource34 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeUnitFuelCostOfTravel.text");
    private java.beans.PropertyChangeListener $DataSource35 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel9.enabled");
    private java.beans.PropertyChangeListener $DataSource37 = new jaxx.runtime.DataBindingListener($InputContentUI0, "vesselTypeTripType.enabled");
    private java.beans.PropertyChangeListener $DataSource38 = new jaxx.runtime.DataBindingListener($InputContentUI0, "vesselTypeTripType.selectedValues");
    private java.beans.PropertyChangeListener $DataSource39 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel11.enabled");
    private java.beans.PropertyChangeListener $DataSource40 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeComment.enabled");
    private java.beans.PropertyChangeListener $DataSource41 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldVesselTypeComment.text");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        VesselType vesselType = getVerifier().getEntity(VesselType.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((VesselTypeImpl) vesselType);
    
        if (getBean() != null) {
            setListModel();
            
            /* NumberEditor is not working
            fieldVesselTypeLength.init();
            fieldVesselTypeLength.init();
            fieldVesselTypeSpeed.init();
            fieldVesselTypeActivityRange.init();
            fieldVesselTypeMinCrewSize.init();
            fieldVesselTypeSpeed.init();
            fieldVesselTypeUnitFuelCostOfTravel.init(); */
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "VesselType");
        getVerifier().setDeleteButton(delete);
    }
    
    protected void setListModel() {
        java.util.List<TripType> tripTypes = getRegion().getTripType();
        TripTypeListModel tripTypeModel = new TripTypeListModel(tripTypes);
        vesselTypeTripType.setModel(tripTypeModel);
        
        if (getBean() != null && getBean().getTripType() != null) {
            vesselTypeTripType.setSelectedValues(getBean().getTripType().toArray());
        }
    }
    protected void tripTypeChanged(){
        java.util.List<TripType> tripTypes = new java.util.ArrayList<TripType>();
        for (Object o : vesselTypeTripType.getSelectedValues()) {
            tripTypes.add((TripType)o);
        }
        getBean().setTripType(tripTypes);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public VesselTypeUI() {
        super();
        $initialize();
    }

    public VesselTypeUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldVesselTypeName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldVesselTypeName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource16);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldVesselTypeLength.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldVesselTypeLength.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("length", $DataSource19);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldVesselTypeSpeed.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldVesselTypeSpeed.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("speed", $DataSource22);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldVesselTypeMaxTripDuration.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldVesselTypeMaxTripDuration.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("maxTripDuration", $DataSource25);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldVesselTypeActivityRange.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldVesselTypeActivityRange.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource28);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("activityRange", $DataSource28);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource29);
            }
        } else if ("fieldVesselTypeMinCrewSize.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource30);
            }
        } else if ("fieldVesselTypeMinCrewSize.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource31);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("minCrewSize", $DataSource31);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource32);
            }
        } else if ("fieldVesselTypeUnitFuelCostOfTravel.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource33);
            }
        } else if ("fieldVesselTypeUnitFuelCostOfTravel.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource34);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("unitFuelCostOfTravel", $DataSource34);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource35);
            }
        } else if ("vesselTypeTripType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource37);
            }
        } else if ("vesselTypeTripType.selectedValues".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource38);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("tripType", $DataSource38);
            }if ( getBean() != null) {
                 getBean().addPropertyChangeListener("tripType", $DataSource38);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource39);
            }
        } else if ("fieldVesselTypeComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource40);
            }
        } else if ("fieldVesselTypeComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource41);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource41);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeName.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeName, String.valueOf((getBean().getName())));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeLength.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeLength.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeLength.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeLength, String.valueOf((getBean().getLength())));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeSpeed.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeSpeed.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeSpeed.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeSpeed, String.valueOf((getBean().getSpeed())));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeMaxTripDuration.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeMaxTripDuration.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeMaxTripDuration.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeMaxTripDuration, String.valueOf((getBean().getMaxTripDuration().getHour())));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeActivityRange.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeActivityRange.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeActivityRange.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeActivityRange, String.valueOf((getBean().getActivityRange())));
            }
            } else if ("$JLabel7.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel7.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeMinCrewSize.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeMinCrewSize.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeMinCrewSize.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeMinCrewSize, String.valueOf((getBean().getMinCrewSize())));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel8.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeUnitFuelCostOfTravel.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeUnitFuelCostOfTravel.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeUnitFuelCostOfTravel.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeUnitFuelCostOfTravel, String.valueOf((getBean().getUnitFuelCostOfTravel())));
            }
            } else if ("$JLabel9.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel9.setEnabled((isActif()));
            }
            } else if ("vesselTypeTripType.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                vesselTypeTripType.setEnabled((isActif()));
            }
            } else if ("vesselTypeTripType.selectedValues".equals($dest)) {
            if ( getBean() != null) {
                vesselTypeTripType.setSelectedValues((getBean().getTripType() == null ? null : getBean().getTripType().toArray()));
            }
            } else if ("$JLabel11.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel11.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldVesselTypeComment.setEnabled((isActif()));
            }
            } else if ("fieldVesselTypeComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldVesselTypeComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldVesselTypeName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldVesselTypeName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource16);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldVesselTypeLength.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldVesselTypeLength.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("length", $DataSource19);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldVesselTypeSpeed.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldVesselTypeSpeed.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("speed", $DataSource22);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldVesselTypeMaxTripDuration.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldVesselTypeMaxTripDuration.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("maxTripDuration", $DataSource25);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldVesselTypeActivityRange.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldVesselTypeActivityRange.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource28);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("activityRange", $DataSource28);
            }
        } else if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource29);
            }
        } else if ("fieldVesselTypeMinCrewSize.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource30);
            }
        } else if ("fieldVesselTypeMinCrewSize.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource31);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("minCrewSize", $DataSource31);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource32);
            }
        } else if ("fieldVesselTypeUnitFuelCostOfTravel.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource33);
            }
        } else if ("fieldVesselTypeUnitFuelCostOfTravel.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource34);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("unitFuelCostOfTravel", $DataSource34);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource35);
            }
        } else if ("vesselTypeTripType.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource37);
            }
        } else if ("vesselTypeTripType.selectedValues".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource38);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("tripType", $DataSource38);
            }if ( getBean() != null) {
                 getBean().removePropertyChangeListener("tripType", $DataSource38);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource39);
            }
        } else if ("fieldVesselTypeComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource40);
            }
        } else if ("fieldVesselTypeComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource41);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource41);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldVesselTypeActivityRange(java.awt.event.KeyEvent event) {
        getBean().setActivityRange(Double.parseDouble(fieldVesselTypeActivityRange.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldVesselTypeComment.getText());
    }

    public void doKeyReleased__on__fieldVesselTypeLength(java.awt.event.KeyEvent event) {
        getBean().setLength(Integer.parseInt(fieldVesselTypeLength.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeMaxTripDuration(java.awt.event.KeyEvent event) {
        getBean().setMaxTripDuration(new TimeUnit(Double.parseDouble(fieldVesselTypeMaxTripDuration.getText()) * 3600));
    }

    public void doKeyReleased__on__fieldVesselTypeMinCrewSize(java.awt.event.KeyEvent event) {
        getBean().setMinCrewSize(Integer.parseInt(fieldVesselTypeMinCrewSize.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldVesselTypeName.getText());
    }

    public void doKeyReleased__on__fieldVesselTypeSpeed(java.awt.event.KeyEvent event) {
        getBean().setSpeed(Double.parseDouble(fieldVesselTypeSpeed.getText()));
    }

    public void doKeyReleased__on__fieldVesselTypeUnitFuelCostOfTravel(java.awt.event.KeyEvent event) {
        getBean().setUnitFuelCostOfTravel(Double.parseDouble(fieldVesselTypeUnitFuelCostOfTravel.getText()));
    }

    public void doMouseClicked__on__vesselTypeTripType(java.awt.event.MouseEvent event) {
        tripTypeChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.VesselTypeImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JTextField getFieldVesselTypeActivityRange() {
        return fieldVesselTypeActivityRange;
    }

    public javax.swing.JTextArea getFieldVesselTypeComment() {
        return fieldVesselTypeComment;
    }

    public javax.swing.JTextField getFieldVesselTypeLength() {
        return fieldVesselTypeLength;
    }

    public javax.swing.JTextField getFieldVesselTypeMaxTripDuration() {
        return fieldVesselTypeMaxTripDuration;
    }

    public javax.swing.JTextField getFieldVesselTypeMinCrewSize() {
        return fieldVesselTypeMinCrewSize;
    }

    public javax.swing.JTextField getFieldVesselTypeName() {
        return fieldVesselTypeName;
    }

    public javax.swing.JTextField getFieldVesselTypeSpeed() {
        return fieldVesselTypeSpeed;
    }

    public javax.swing.JTextField getFieldVesselTypeUnitFuelCostOfTravel() {
        return fieldVesselTypeUnitFuelCostOfTravel;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public jaxx.runtime.swing.JAXXList getVesselTypeTripType() {
        return vesselTypeTripType;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.VesselTypeImpl newValue) {
        fr.ifremer.isisfish.entities.VesselTypeImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.VesselTypeUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JScrollPane get$JScrollPane10() {
        return $JScrollPane10;
    }

    protected javax.swing.JScrollPane get$JScrollPane12() {
        return $JScrollPane12;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table13() {
        return $Table13;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeLength), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeSpeed), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeMaxTripDuration), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeActivityRange), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel7, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeMinCrewSize), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeUnitFuelCostOfTravel), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel9, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane10, new GridBagConstraints(1, 7, 1, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel11, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane12, new GridBagConstraints(1, 8, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        addChildrenToFieldVesselTypeLength();
        
        addChildrenToFieldVesselTypeSpeed();
        
        addChildrenToFieldVesselTypeMaxTripDuration();
        
        addChildrenToFieldVesselTypeActivityRange();
        
        addChildrenToFieldVesselTypeMinCrewSize();
        
        addChildrenToFieldVesselTypeUnitFuelCostOfTravel();
        
        $JScrollPane10.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(vesselTypeTripType));
        
        addChildrenToVesselTypeTripType();
        
        $JScrollPane12.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldVesselTypeComment));
        
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table13.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldVesselTypeName.enabled");
        applyDataBinding("fieldVesselTypeName.text");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldVesselTypeLength.enabled");
        applyDataBinding("fieldVesselTypeLength.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldVesselTypeSpeed.enabled");
        applyDataBinding("fieldVesselTypeSpeed.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldVesselTypeMaxTripDuration.enabled");
        applyDataBinding("fieldVesselTypeMaxTripDuration.text");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("fieldVesselTypeActivityRange.enabled");
        applyDataBinding("fieldVesselTypeActivityRange.text");
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldVesselTypeMinCrewSize.enabled");
        applyDataBinding("fieldVesselTypeMinCrewSize.text");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldVesselTypeUnitFuelCostOfTravel.enabled");
        applyDataBinding("fieldVesselTypeUnitFuelCostOfTravel.text");
        applyDataBinding("$JLabel9.enabled");
        vesselTypeTripType.setCellRenderer((new fr.ifremer.isisfish.ui.input.triptype.TripTypeListRenderer()));
        applyDataBinding("vesselTypeTripType.enabled");
        applyDataBinding("vesselTypeTripType.selectedValues");
        applyDataBinding("$JLabel11.enabled");
        applyDataBinding("fieldVesselTypeComment.enabled");
        applyDataBinding("fieldVesselTypeComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.vesselType.name"));
        
        createFieldVesselTypeName();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.vesselType.length"));
        
        createFieldVesselTypeLength();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.vesselType.speed"));
        
        createFieldVesselTypeSpeed();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.vesselType.maxDuration"));
        
        createFieldVesselTypeMaxTripDuration();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.vesselType.activityRange"));
        
        createFieldVesselTypeActivityRange();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.vesselType.miniCrew"));
        
        createFieldVesselTypeMinCrewSize();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.vesselType.fuelCost"));
        
        createFieldVesselTypeUnitFuelCostOfTravel();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.common.tripType"));
        
        $JScrollPane10 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane10", $JScrollPane10);
        $JScrollPane10.setName("$JScrollPane10");
        
        createVesselTypeTripType();
        
        $JLabel11 = new javax.swing.JLabel();
        $objectMap.put("$JLabel11", $JLabel11);
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(_("isisfish.vesselType.comments"));
        
        $JScrollPane12 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane12", $JScrollPane12);
        $JScrollPane12.setName("$JScrollPane12");
        
        createFieldVesselTypeComment();
        
        $Table13 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table13", $Table13);
        $Table13.setName("$Table13");
        
        createSave();
        createCancel();
        createCreate();
        createDelete();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        setButtonTitle(_("isisfish.input.continueSetOfVessels"));setNextPath("$root/$setOfVessels");addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldVesselTypeName.setText("");
                    fieldVesselTypeLength.setText("");
                    fieldVesselTypeSpeed.setText("");
                    fieldVesselTypeMaxTripDuration.setText("");
                    fieldVesselTypeActivityRange.setText("");
                    fieldVesselTypeMinCrewSize.setText("");
                    fieldVesselTypeSpeed.setText("");
                    fieldVesselTypeUnitFuelCostOfTravel.setText("");
                    fieldVesselTypeComment.setText("");
                }
                if (evt.getNewValue() != null) {
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table13, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldVesselTypeActivityRange() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeActivityRange.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeActivityRange.putClientProperty("method", "ActivityRange");
    }

    protected void addChildrenToFieldVesselTypeLength() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeLength.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeLength.putClientProperty("method", "Length");
    }

    protected void addChildrenToFieldVesselTypeMaxTripDuration() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeMaxTripDuration.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeMaxTripDuration.putClientProperty("method", "MaxTripDuration");
    }

    protected void addChildrenToFieldVesselTypeMinCrewSize() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeMinCrewSize.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeMinCrewSize.putClientProperty("method", "MinCrewSize");
    }

    protected void addChildrenToFieldVesselTypeSpeed() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeSpeed.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeSpeed.putClientProperty("method", "Speed");
    }

    protected void addChildrenToFieldVesselTypeUnitFuelCostOfTravel() {
        if (!allComponentsCreated) {
            return;
        }
        fieldVesselTypeUnitFuelCostOfTravel.putClientProperty("bean", VesselTypeImpl.class);
        fieldVesselTypeUnitFuelCostOfTravel.putClientProperty("method", "UnitFuelCostOfTravel");
    }

    protected void addChildrenToVesselTypeTripType() {
        if (!allComponentsCreated) {
            return;
        }
        vesselTypeTripType.putClientProperty("bean", VesselTypeImpl.class);
        vesselTypeTripType.putClientProperty("method", "TripType");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createDelete() {
        delete = new javax.swing.JButton();
        $objectMap.put("delete", delete);
        delete.setName("delete");
    }

    protected void createFieldVesselTypeActivityRange() {
        fieldVesselTypeActivityRange = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeActivityRange", fieldVesselTypeActivityRange);
        fieldVesselTypeActivityRange.setName("fieldVesselTypeActivityRange");
        fieldVesselTypeActivityRange.setColumns(15);
        fieldVesselTypeActivityRange.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeActivityRange"));
    }

    protected void createFieldVesselTypeComment() {
        fieldVesselTypeComment = new javax.swing.JTextArea();
        $objectMap.put("fieldVesselTypeComment", fieldVesselTypeComment);
        fieldVesselTypeComment.setName("fieldVesselTypeComment");
        fieldVesselTypeComment.setColumns(15);
        fieldVesselTypeComment.setLineWrap(true);
        fieldVesselTypeComment.setWrapStyleWord(true);
        fieldVesselTypeComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeComment"));
    }

    protected void createFieldVesselTypeLength() {
        fieldVesselTypeLength = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeLength", fieldVesselTypeLength);
        fieldVesselTypeLength.setName("fieldVesselTypeLength");
        fieldVesselTypeLength.setColumns(15);
        fieldVesselTypeLength.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeLength"));
    }

    protected void createFieldVesselTypeMaxTripDuration() {
        fieldVesselTypeMaxTripDuration = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeMaxTripDuration", fieldVesselTypeMaxTripDuration);
        fieldVesselTypeMaxTripDuration.setName("fieldVesselTypeMaxTripDuration");
        fieldVesselTypeMaxTripDuration.setColumns(15);
        fieldVesselTypeMaxTripDuration.setToolTipText(_("isisfish.common.duration.inhours"));
        fieldVesselTypeMaxTripDuration.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeMaxTripDuration"));
    }

    protected void createFieldVesselTypeMinCrewSize() {
        fieldVesselTypeMinCrewSize = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeMinCrewSize", fieldVesselTypeMinCrewSize);
        fieldVesselTypeMinCrewSize.setName("fieldVesselTypeMinCrewSize");
        fieldVesselTypeMinCrewSize.setColumns(15);
        fieldVesselTypeMinCrewSize.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeMinCrewSize"));
    }

    protected void createFieldVesselTypeName() {
        fieldVesselTypeName = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeName", fieldVesselTypeName);
        fieldVesselTypeName.setName("fieldVesselTypeName");
        fieldVesselTypeName.setColumns(15);
        fieldVesselTypeName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeName"));
    }

    protected void createFieldVesselTypeSpeed() {
        fieldVesselTypeSpeed = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeSpeed", fieldVesselTypeSpeed);
        fieldVesselTypeSpeed.setName("fieldVesselTypeSpeed");
        fieldVesselTypeSpeed.setColumns(15);
        fieldVesselTypeSpeed.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeSpeed"));
    }

    protected void createFieldVesselTypeUnitFuelCostOfTravel() {
        fieldVesselTypeUnitFuelCostOfTravel = new javax.swing.JTextField();
        $objectMap.put("fieldVesselTypeUnitFuelCostOfTravel", fieldVesselTypeUnitFuelCostOfTravel);
        fieldVesselTypeUnitFuelCostOfTravel.setName("fieldVesselTypeUnitFuelCostOfTravel");
        fieldVesselTypeUnitFuelCostOfTravel.setColumns(15);
        fieldVesselTypeUnitFuelCostOfTravel.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldVesselTypeUnitFuelCostOfTravel"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createVesselTypeTripType() {
        vesselTypeTripType = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("vesselTypeTripType", vesselTypeTripType);
        vesselTypeTripType.setName("vesselTypeTripType");
        vesselTypeTripType.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseClicked", $InputContentUI0, "doMouseClicked__on__vesselTypeTripType"));
    }

}
