/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.StrategyImpl;
import fr.ifremer.isisfish.entities.Strategy;
import fr.ifremer.isisfish.entities.Formule;
import fr.ifremer.isisfish.entities.SetOfVessels;
import org.nuiton.topia.persistence.TopiaEntity;
import fr.ifremer.isisfish.ui.WelcomePanelUI;

public class StrategyTabUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWz28TRxSeuHESfoSQNA7QgggQqQKJdcuPghrUFkwjHAyJMKkQvjDeHcdD1zPLzFuz4VBV6rWqOHHgAr33yL2qeuyp1/4PVcV/wJtde+1NVpuVNodN/OZ93/vem7ef8/t/pKwVOfOUBoGlfAG8x6z1m48ebbSfMhtuM20r7oFUJPqZKJFSixxy4rgGcq7VMPDqAF6tyZ4nBRNj6NUGOahhx2W6yxgAqUQIW+tqMw6vBp6vhmyxmDS2t+//L710fvqtREjgoaoKtrC8H2rUwWSDlLgDZAEr9WnVpWIbZSgutlHnrInVXKr1fdpjz8iPZLpBpjyqkAzI2fythhwhPvCAHF2pC8+HmhSA6Vv1z4Fc6CiLdxTrMfytue5w3bV8bnGTaKEgCmx75yFtb9U9L2SaAjLZZlQAOZ+GRWIOnOkYW+957jhUOjtAjicGpZ9j2xYWcdkoc3olDHxhPs6bx1x8NLOy3qBt5l7C8ZlJBQOGKGqSFuLc+Q5nrjMUY8YJZCkBesgCWDNJSeCwyGXzeSl5diJB2mSw0fmeac1c3MTTKa2ZZcZrastbMkivciWlyrlElU0lPamASzFez6Se2EO5SQVzr+6eThhN5n4SltjS7LtnPjXcdUFt4H0OeEmVBLrWZfYPe/Qv6OE1jwGrmUsV7uCGiEtu1dNH8mXKSGZX1pu2kq5rerkG5FhC4ugoiVpMDBIvohe+R5U9a3BTMWow1u4tvJ6yhZOa9nGZPk6w3PIBpDAZV+LEKZsKO5r89d0nWBBY2glOT/YTJ8qUwtVCw7JGhjVylIkWKSsfw/iit0be9gBDkasNoiFBGH3z8+v+q3d/fDW0sGNYYzaRMua4aCkeriBT5u0GMhf5lg/crd6j3mqLHMB9RLsO7XhxTEBzEEYRyD9vYJaBWXeo7iK0PP3vn38tPfnnI1JaIwddSZ01avLr5AB0FXYpXSfwvvk2VHL4+Qw+jxpNeDlMmMtBFz1yw6FAl9tcOHgNXwfY7eJYt7GEv1/+cu/kr6euDTueiBTtSht1XX5MprhwuWChXQ+cONWeD3ma+Y4cOW6aB0+Y3xVv4HK3w+edtNYmAdcRX68bUfVlCvjd0PaBYW8G1AjFm7/u5+Q04XXzuJvOcDwXw4PCDFkaPs2voVmEIUvDqcIMy4W7yMeQpeFs4dvMx5Cl4bMcez4TmQZzCvHsN888SsJ/ajJUXMjBcdhwbEYuuZOhJw9X2XbpixcFBc11pOqhj9fMN59UxTTtN+V8DFkbc7GwhnwMWRouFX5zDMMHC5gD/dQMAAA=";
    protected fr.ifremer.isisfish.entities.StrategyImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldStrategyComment;
    protected javax.swing.JTextField fieldStrategyName;
    protected javax.swing.JTextField fieldStrategyProportionSetOfVessels;
    protected jaxx.runtime.swing.JAXXComboBox fieldStrategySetOfVessels;
    protected javax.swing.JCheckBox fieldUseEquationInactivity;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI strategyInactivity;
    private fr.ifremer.isisfish.ui.input.StrategyTabUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JPanel $JPanel5;
    private javax.swing.JScrollPane $JScrollPane7;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table8;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyName.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyName.text");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategySetOfVessels.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyProportionSetOfVessels.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyProportionSetOfVessels.text");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldUseEquationInactivity.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldUseEquationInactivity.selected");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "strategyInactivity.bean");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyComment.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldStrategyComment.text");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        Strategy strategy = (Strategy)getVerifier().getEntity(Strategy.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((StrategyImpl) strategy);
    
        if (getBean() != null) {
            setSetOfVesselsModel();
            //fieldStrategyProportionSetOfVessels.init();
            
            // code to replace bindings :
            strategyInactivity.setActif(isActif() && getBean().getInactivityEquationUsed());
            
            getVerifier().addCurrentPanel(strategyInactivity);
        }
        else {
            // listener seam to be called after refresh and remove content :(
            fieldStrategyName.setText("");
            //fieldStrategyProportionSetOfVessels.setModelText("0.0");
            fieldStrategyProportionSetOfVessels.setText("0.0");
            fieldStrategyComment.setText("");
            
            // code to replace bindings :
            strategyInactivity.setActif(isActif());
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Strategy");
        getVerifier().setDeleteButton(remove);
    }
    
    protected void setSetOfVesselsModel() {
       ActionListener[] listeners = fieldStrategySetOfVessels.getActionListeners();
       for (ActionListener listener : listeners) {
           fieldStrategySetOfVessels.removeActionListener(listener);
       }
       jaxx.runtime.SwingUtil.fillComboBox(fieldStrategySetOfVessels,getRegion().getSetOfVessels(), getBean().getSetOfVessels(), true);
       for (ActionListener listener : listeners) {
           fieldStrategySetOfVessels.addActionListener(listener);
       }
    }
    
    protected void inactivityEquationActionPerformed() {
        boolean checked = fieldUseEquationInactivity.isSelected();
        getBean().setInactivityEquationUsed(checked);
        strategyInactivity.setActif(checked);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public StrategyTabUI() {
        super();
        $initialize();
    }

    public StrategyTabUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldStrategyName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldStrategyName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource11);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource11);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldStrategySetOfVessels.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldStrategyProportionSetOfVessels.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldStrategyProportionSetOfVessels.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("proportionSetOfVessels", $DataSource16);
            }
        } else if ("fieldUseEquationInactivity.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldUseEquationInactivity.selected".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("inactivityEquationUsed", $DataSource18);
            }
        } else if ("strategyInactivity.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldStrategyComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldStrategyComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource23);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldStrategyName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyName.setEnabled((isActif()));
            }
            } else if ("fieldStrategyName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldStrategyName, String.valueOf((getBean().getName())));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldStrategySetOfVessels.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategySetOfVessels.setEnabled((isActif()));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldStrategyProportionSetOfVessels.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyProportionSetOfVessels.setEnabled((isActif()));
            }
            } else if ("fieldStrategyProportionSetOfVessels.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldStrategyProportionSetOfVessels, String.valueOf((getBean().getProportionSetOfVessels())));
            }
            } else if ("fieldUseEquationInactivity.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldUseEquationInactivity.setEnabled((isActif()));
            }
            } else if ("fieldUseEquationInactivity.selected".equals($dest)) {
            if (getBean() != null) {
                fieldUseEquationInactivity.setSelected((getBean().getInactivityEquationUsed()));
            }
            } else if ("strategyInactivity.bean".equals($dest)) {
            strategyInactivity.setBean((getBean()));
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("fieldStrategyComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldStrategyComment.setEnabled((isActif()));
            }
            } else if ("fieldStrategyComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldStrategyComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldStrategyName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldStrategyName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource11);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource11);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldStrategySetOfVessels.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldStrategyProportionSetOfVessels.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldStrategyProportionSetOfVessels.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("proportionSetOfVessels", $DataSource16);
            }
        } else if ("fieldUseEquationInactivity.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldUseEquationInactivity.selected".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("inactivityEquationUsed", $DataSource18);
            }
        } else if ("strategyInactivity.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldStrategyComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldStrategyComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource23);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldStrategySetOfVessels(java.awt.event.ActionEvent event) {
        getBean().setSetOfVessels((SetOfVessels)fieldStrategySetOfVessels.getSelectedItem());
    }

    public void doActionPerformed__on__fieldUseEquationInactivity(java.awt.event.ActionEvent event) {
        inactivityEquationActionPerformed();
    }

    public void doKeyReleased__on__fieldStrategyComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldStrategyComment.getText());
    }

    public void doKeyReleased__on__fieldStrategyName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldStrategyName.getText());
    }

    public void doKeyReleased__on__fieldStrategyProportionSetOfVessels(java.awt.event.KeyEvent event) {
        getBean().setProportionSetOfVessels(Double.parseDouble(fieldStrategyProportionSetOfVessels.getText()));
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.StrategyImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldStrategyComment() {
        return fieldStrategyComment;
    }

    public javax.swing.JTextField getFieldStrategyName() {
        return fieldStrategyName;
    }

    public javax.swing.JTextField getFieldStrategyProportionSetOfVessels() {
        return fieldStrategyProportionSetOfVessels;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldStrategySetOfVessels() {
        return fieldStrategySetOfVessels;
    }

    public javax.swing.JCheckBox getFieldUseEquationInactivity() {
        return fieldUseEquationInactivity;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getStrategyInactivity() {
        return strategyInactivity;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.StrategyImpl newValue) {
        fr.ifremer.isisfish.entities.StrategyImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.StrategyTabUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table8() {
        return $Table8;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyName), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategySetOfVessels), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyProportionSetOfVessels), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldUseEquationInactivity), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(strategyInactivity), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane7, new GridBagConstraints(1, 5, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        addChildrenToFieldStrategyProportionSetOfVessels();
        
        addChildrenToStrategyInactivity();
        
        $JScrollPane7.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldStrategyComment));
        
        $Table8.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table8.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldStrategyName.enabled");
        applyDataBinding("fieldStrategyName.text");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldStrategySetOfVessels.enabled");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldStrategyProportionSetOfVessels.enabled");
        applyDataBinding("fieldStrategyProportionSetOfVessels.text");
        applyDataBinding("fieldUseEquationInactivity.enabled");
        applyDataBinding("fieldUseEquationInactivity.selected");
        applyDataBinding("strategyInactivity.bean");
        strategyInactivity.setClazz((fr.ifremer.isisfish.equation.StrategyInactivityEquation.class));
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("fieldStrategyComment.enabled");
        applyDataBinding("fieldStrategyComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.strategy.name"));
        
        createFieldStrategyName();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.common.setOfVessels"));
        
        createFieldStrategySetOfVessels();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.strategy.proportionSetOfVessels"));
        
        createFieldStrategyProportionSetOfVessels();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        
        createFieldUseEquationInactivity();
        createStrategyInactivity();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.strategy.comments"));
        
        $JScrollPane7 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane7", $JScrollPane7);
        $JScrollPane7.setName("$JScrollPane7");
        
        createFieldStrategyComment();
        
        $Table8 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table8", $Table8);
        $Table8.setName("$Table8");
        
        createSave();
        createCancel();
        createCreate();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table8, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldStrategyProportionSetOfVessels() {
        if (!allComponentsCreated) {
            return;
        }
        fieldStrategyProportionSetOfVessels.putClientProperty("bean", StrategyImpl.class);
        fieldStrategyProportionSetOfVessels.putClientProperty("method", "ProportionSetOfVessels");
    }

    protected void addChildrenToStrategyInactivity() {
        if (!allComponentsCreated) {
            return;
        }
        strategyInactivity.putClientProperty("bean", StrategyImpl.class);
        strategyInactivity.putClientProperty("method", "Inactivity");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldStrategyComment() {
        fieldStrategyComment = new javax.swing.JTextArea();
        $objectMap.put("fieldStrategyComment", fieldStrategyComment);
        fieldStrategyComment.setName("fieldStrategyComment");
        fieldStrategyComment.setColumns(15);
        fieldStrategyComment.setLineWrap(true);
        fieldStrategyComment.setWrapStyleWord(true);
        fieldStrategyComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldStrategyComment"));
    }

    protected void createFieldStrategyName() {
        fieldStrategyName = new javax.swing.JTextField();
        $objectMap.put("fieldStrategyName", fieldStrategyName);
        fieldStrategyName.setName("fieldStrategyName");
        fieldStrategyName.setColumns(15);
        fieldStrategyName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldStrategyName"));
    }

    protected void createFieldStrategyProportionSetOfVessels() {
        fieldStrategyProportionSetOfVessels = new javax.swing.JTextField();
        $objectMap.put("fieldStrategyProportionSetOfVessels", fieldStrategyProportionSetOfVessels);
        fieldStrategyProportionSetOfVessels.setName("fieldStrategyProportionSetOfVessels");
        fieldStrategyProportionSetOfVessels.setColumns(15);
        fieldStrategyProportionSetOfVessels.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldStrategyProportionSetOfVessels"));
    }

    protected void createFieldStrategySetOfVessels() {
        fieldStrategySetOfVessels = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldStrategySetOfVessels", fieldStrategySetOfVessels);
        fieldStrategySetOfVessels.setName("fieldStrategySetOfVessels");
        fieldStrategySetOfVessels.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldStrategySetOfVessels"));
    }

    protected void createFieldUseEquationInactivity() {
        fieldUseEquationInactivity = new javax.swing.JCheckBox();
        $objectMap.put("fieldUseEquationInactivity", fieldUseEquationInactivity);
        fieldUseEquationInactivity.setName("fieldUseEquationInactivity");
        fieldUseEquationInactivity.setText(_("isisfish.strategy.inactivityEquationUsed"));
        fieldUseEquationInactivity.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldUseEquationInactivity"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createStrategyInactivity() {
        strategyInactivity =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("strategyInactivity", strategyInactivity);
        strategyInactivity.removeDataBinding("$InputContentUI0.name");
        
        strategyInactivity.setName("strategyInactivity");
        strategyInactivity.removeDataBinding("$InputContentUI0.bean");
        
        strategyInactivity.removeDataBinding("$InputContentUI0.beanProperty");
        
        strategyInactivity.setBeanProperty("InactivityEquation");
        strategyInactivity.removeDataBinding("$InputContentUI0.clazz");
        
        strategyInactivity.removeDataBinding("$InputContentUI0.formuleCategory");
        
        strategyInactivity.setFormuleCategory("Inactivity");
        strategyInactivity.removeDataBinding("$InputContentUI0.text");
        
        strategyInactivity.setText(_("isisfish.strategy.inactivity"));
    }

}
