/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.SpeciesImpl;
import jaxx.runtime.swing.editor.NumberEditor;

public class SpeciesUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWzW/TSBSfhqblY0sLpaEsIAqEhZXAKZ8FWi0fgUJKyu42VKrIhYk9oYMce5h5LuaCVtorQj3tYS8Ld47c0WqPnLjyP6wQ/wFv7HzYYLmWnIMTv3m/3/zemzc/5e3/pKgkOfqE+r4hPQd4hxlLN9bWfm09YSbcYsqUXIArSfgZKpBCk+yy+nEF5HizruGVLrxSdTvCdZgTQc/XyU4Fz22m1hkDIFMhwlSq0uiH533hyR5bX0wS2+svnwub1h9vCoT4AlWVsISZrVCDCobrpMAtIHtxpw1asanzGGVI7jxGnWM6VrWpUvdphz0lL8honYwIKpEMyLHspQYcAd4XQCbKNUd4UHUdwPTV2iyQn9rS4G3JOgy/FVdtrtYNjxtcJxoNwUzO1GpNiIBlBMhwi1EHyKkkHJJywPwertYRdhTpWs+BTMd6pJ5hxcYD2rLZIHO0HATO6tc9+jHeX9peXqrTFrPPYed0k/wuQxjVSXv7uRNtzmyrq0U3EkgphnnAfFjUOXFcb4/z+r0UX/sxytnAB5bR5mbvmA4kM11IYCpFmaquxVa8Vos7KSwXE1jGYyy3b6fALyXAp8q9UkB6JniSWau1OSCzWcYiikne8nLClmPlpYYpXdv+jTrsCpD9sSMZLMVRk/FudTrBTZj67jhvSEY15ExESzhMswnTNKzoBk7FZIzmpgfgBudwvp84YlLHDOdr7tsV3BFY0orFbBZfkXornH70HGPgOQNTGGqSovQwjMPbHNjTCoZCY+pGA4Ig+s+ff2/89e791Z4LTeMeY7GUiGmiKwjpCib1JcXZCa3HA25XlqmYb5IdCiWboaPuiwhodMMoAvn3aJihYcZdqtYRWhz99O9/pUcft5HCItlpu9RapDq/RnbAusQqXdvyxbXrgZIfnm3H54TWhFedOfp00Ah3L1gU6AxeAQuP4Rcfq90XqbYv4cPmy+VDrw7P9SoeChV9kzaouviQjHDH5g4LHLdrpokOu0so5lnuwDSTbHRIf0+JrltVg+edpNKGAecRbWoh3H2GAtp7ywOGtWnQvUC8/rWckVOHg5u2lMwwnYnh99wMaRoOZtewkochTcPh3H3IxpCm4UjuPmRjSNNwNHcfsjGkaTieuw/ZGNI0nMjdh2wMaRpO5u7D1gxAimi7vJ0i4+csxqX/4uXi2KoZp3M3IxtDmoazuYdCM3wFA/8d2bwMAAA=";
    protected fr.ifremer.isisfish.entities.SpeciesImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JButton delete;
    protected javax.swing.JTextField fieldSpeciesCEE;
    protected javax.swing.JTextField fieldSpeciesCodeRubbin;
    protected javax.swing.JTextArea fieldSpeciesComment;
    protected javax.swing.JTextField fieldSpeciesName;
    protected javax.swing.JTextField fieldSpeciesScientificName;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.SpeciesUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JScrollPane $JScrollPane9;
    private fr.ifremer.isisfish.ui.input.SpeciesStructuredUI $SpeciesStructuredUI7;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table10;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesName.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesName.text");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesScientificName.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesScientificName.text");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesCodeRubbin.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesCodeRubbin.text");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesCEE.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesCEE.text");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$SpeciesStructuredUI7.actif");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$SpeciesStructuredUI7.bean");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesComment.enabled");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldSpeciesComment.text");

    /* begin raw body code */    
    
    public void refresh() {
        Species species = (Species)getVerifier().getEntity(Species.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((SpeciesImpl) species);
    
        if (getBean() != null) {
            setNextPath("$root/$species/" + getBean().getTopiaId() + "/$populations");
            // Number Editor is not working
            //fieldSpeciesCEE.init();
        }
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Species");
        getVerifier().setDeleteButton(delete);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public SpeciesUI() {
        super();
        $initialize();
    }

    public SpeciesUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldSpeciesName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldSpeciesName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource13);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource13);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldSpeciesScientificName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldSpeciesScientificName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("scientificName", $DataSource16);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldSpeciesCodeRubbin.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldSpeciesCodeRubbin.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("codeRubbin", $DataSource19);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldSpeciesCEE.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldSpeciesCEE.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("codeCEE", $DataSource22);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("$SpeciesStructuredUI7.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("$SpeciesStructuredUI7.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource25);
        
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldSpeciesComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldSpeciesComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource28);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource28);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSpeciesName.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldSpeciesName, String.valueOf((getBean().getName())));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesScientificName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSpeciesScientificName.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesScientificName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldSpeciesScientificName, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getScientificName()))));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesCodeRubbin.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSpeciesCodeRubbin.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesCodeRubbin.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldSpeciesCodeRubbin, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getCodeRubbin()))));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesCEE.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSpeciesCEE.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesCEE.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldSpeciesCEE, String.valueOf((getBean().getCodeCEE())));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("$SpeciesStructuredUI7.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                $SpeciesStructuredUI7.setActif((isActif()));
            }
            } else if ("$SpeciesStructuredUI7.bean".equals($dest)) {
            $SpeciesStructuredUI7.setBean((getBean()));
            } else if ("$JLabel8.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel8.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldSpeciesComment.setEnabled((isActif()));
            }
            } else if ("fieldSpeciesComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldSpeciesComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldSpeciesName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("fieldSpeciesName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource13);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource13);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldSpeciesScientificName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldSpeciesScientificName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource16);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("scientificName", $DataSource16);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldSpeciesCodeRubbin.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldSpeciesCodeRubbin.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("codeRubbin", $DataSource19);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldSpeciesCEE.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldSpeciesCEE.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource22);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("codeCEE", $DataSource22);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("$SpeciesStructuredUI7.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("$SpeciesStructuredUI7.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource25);
        
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldSpeciesComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldSpeciesComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource28);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource28);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldSpeciesCEE(java.awt.event.KeyEvent event) {
        getBean().setCodeCEE(Integer.parseInt(fieldSpeciesCEE.getText()));
    }

    public void doKeyReleased__on__fieldSpeciesCodeRubbin(java.awt.event.KeyEvent event) {
        getBean().setCodeRubbin(fieldSpeciesCodeRubbin.getText());
    }

    public void doKeyReleased__on__fieldSpeciesComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldSpeciesComment.getText());
    }

    public void doKeyReleased__on__fieldSpeciesName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldSpeciesName.getText());
    }

    public void doKeyReleased__on__fieldSpeciesScientificName(java.awt.event.KeyEvent event) {
        getBean().setScientificName(fieldSpeciesScientificName.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.SpeciesImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JButton getDelete() {
        return delete;
    }

    public javax.swing.JTextField getFieldSpeciesCEE() {
        return fieldSpeciesCEE;
    }

    public javax.swing.JTextField getFieldSpeciesCodeRubbin() {
        return fieldSpeciesCodeRubbin;
    }

    public javax.swing.JTextArea getFieldSpeciesComment() {
        return fieldSpeciesComment;
    }

    public javax.swing.JTextField getFieldSpeciesName() {
        return fieldSpeciesName;
    }

    public javax.swing.JTextField getFieldSpeciesScientificName() {
        return fieldSpeciesScientificName;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.SpeciesImpl newValue) {
        fr.ifremer.isisfish.entities.SpeciesImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.SpeciesUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JScrollPane get$JScrollPane9() {
        return $JScrollPane9;
    }

    protected fr.ifremer.isisfish.ui.input.SpeciesStructuredUI get$SpeciesStructuredUI7() {
        return $SpeciesStructuredUI7;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table10() {
        return $Table10;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSpeciesName), new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSpeciesScientificName), new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSpeciesCodeRubbin), new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSpeciesCEE), new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel6, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer($SpeciesStructuredUI7), new GridBagConstraints(1, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel8, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane9, new GridBagConstraints(1, 5, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        addChildrenToFieldSpeciesScientificName();
        
        addChildrenToFieldSpeciesCodeRubbin();
        
        addChildrenToFieldSpeciesCEE();
        
        $SpeciesStructuredUI7.putClientProperty("bean", SpeciesImpl.class);
        $SpeciesStructuredUI7.putClientProperty("method", "AgeGroupType");
        
        
        $JScrollPane9.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldSpeciesComment));
        
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table10.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(delete), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldSpeciesName.enabled");
        applyDataBinding("fieldSpeciesName.text");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldSpeciesScientificName.enabled");
        applyDataBinding("fieldSpeciesScientificName.text");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldSpeciesCodeRubbin.enabled");
        applyDataBinding("fieldSpeciesCodeRubbin.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldSpeciesCEE.enabled");
        applyDataBinding("fieldSpeciesCEE.text");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("$SpeciesStructuredUI7.actif");
        applyDataBinding("$SpeciesStructuredUI7.bean");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldSpeciesComment.enabled");
        applyDataBinding("fieldSpeciesComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.species.name"));
        
        createFieldSpeciesName();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.species.scientificName"));
        
        createFieldSpeciesScientificName();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.species.rubbinCode"));
        
        createFieldSpeciesCodeRubbin();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.species.cee"));
        
        createFieldSpeciesCEE();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.species.structured"));
        
        $SpeciesStructuredUI7 = new fr.ifremer.isisfish.ui.input.SpeciesStructuredUI();
        $objectMap.put("$SpeciesStructuredUI7", $SpeciesStructuredUI7);
        $SpeciesStructuredUI7.removeDataBinding("$InputContentUI0.name");
        
        $SpeciesStructuredUI7.setName("$SpeciesStructuredUI7");
        $SpeciesStructuredUI7.removeDataBinding("$InputContentUI0.actif");
        
        $SpeciesStructuredUI7.removeDataBinding("$InputContentUI0.bean");
        
        
        
        
        
        
        
        
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.species.comments"));
        
        $JScrollPane9 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane9", $JScrollPane9);
        $JScrollPane9.setName("$JScrollPane9");
        
        createFieldSpeciesComment();
        
        $Table10 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table10", $Table10);
        $Table10.setName("$Table10");
        
        createSave();
        createCancel();
        createCreate();
        createDelete();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        setButtonTitle(_("isisfish.input.continuePopulations"));addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldSpeciesName.setText("");
                    fieldSpeciesScientificName.setText("");
                    fieldSpeciesCodeRubbin.setText("");
                    fieldSpeciesCEE.setText("");
                    fieldSpeciesComment.setText("");
                }
                if (evt.getNewValue() != null) {
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table10, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldSpeciesCEE() {
        if (!allComponentsCreated) {
            return;
        }
        fieldSpeciesCEE.putClientProperty("bean", SpeciesImpl.class);
        fieldSpeciesCEE.putClientProperty("method", "CodeCEE");
    }

    protected void addChildrenToFieldSpeciesCodeRubbin() {
        if (!allComponentsCreated) {
            return;
        }
        fieldSpeciesCodeRubbin.putClientProperty("bean", SpeciesImpl.class);
        fieldSpeciesCodeRubbin.putClientProperty("method", "CodeRubbin");
    }

    protected void addChildrenToFieldSpeciesScientificName() {
        if (!allComponentsCreated) {
            return;
        }
        fieldSpeciesScientificName.putClientProperty("bean", SpeciesImpl.class);
        fieldSpeciesScientificName.putClientProperty("method", "ScientificName");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createDelete() {
        delete = new javax.swing.JButton();
        $objectMap.put("delete", delete);
        delete.setName("delete");
    }

    protected void createFieldSpeciesCEE() {
        fieldSpeciesCEE = new javax.swing.JTextField();
        $objectMap.put("fieldSpeciesCEE", fieldSpeciesCEE);
        fieldSpeciesCEE.setName("fieldSpeciesCEE");
        fieldSpeciesCEE.setColumns(15);
        fieldSpeciesCEE.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldSpeciesCEE"));
    }

    protected void createFieldSpeciesCodeRubbin() {
        fieldSpeciesCodeRubbin = new javax.swing.JTextField();
        $objectMap.put("fieldSpeciesCodeRubbin", fieldSpeciesCodeRubbin);
        fieldSpeciesCodeRubbin.setName("fieldSpeciesCodeRubbin");
        fieldSpeciesCodeRubbin.setColumns(15);
        fieldSpeciesCodeRubbin.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldSpeciesCodeRubbin"));
    }

    protected void createFieldSpeciesComment() {
        fieldSpeciesComment = new javax.swing.JTextArea();
        $objectMap.put("fieldSpeciesComment", fieldSpeciesComment);
        fieldSpeciesComment.setName("fieldSpeciesComment");
        fieldSpeciesComment.setColumns(15);
        fieldSpeciesComment.setLineWrap(true);
        fieldSpeciesComment.setWrapStyleWord(true);
        fieldSpeciesComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldSpeciesComment"));
    }

    protected void createFieldSpeciesName() {
        fieldSpeciesName = new javax.swing.JTextField();
        $objectMap.put("fieldSpeciesName", fieldSpeciesName);
        fieldSpeciesName.setName("fieldSpeciesName");
        fieldSpeciesName.setColumns(15);
        fieldSpeciesName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldSpeciesName"));
    }

    protected void createFieldSpeciesScientificName() {
        fieldSpeciesScientificName = new javax.swing.JTextField();
        $objectMap.put("fieldSpeciesScientificName", fieldSpeciesScientificName);
        fieldSpeciesScientificName.setName("fieldSpeciesScientificName");
        fieldSpeciesScientificName.setColumns(15);
        fieldSpeciesScientificName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldSpeciesScientificName"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
