/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Port;
import fr.ifremer.isisfish.entities.PortImpl;
import fr.ifremer.isisfish.entities.Cell;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.OMToolSet;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import com.bbn.openmap.event.SelectMouseMode;

public class PortUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1WQW8bRRSeuEncNgTStEkLtGpoXVQhsaZAKZBQaF2i2nJKSVxU4Quz3ok91XhmmJl1NxwQEkcQ6okDF+DOkTtCHDn1yn9AiH/Q98aON3a2tpHJYdf75nvffu+9mW/zy99kzhry0gOaJIGJpeNtFlRu3L//UfiANdwtZhuGa6cM6f7N5EiuThaiftw6crFexfRiL71YUm2tJJMHster5Lh1e4LZFmPOkZVuRsPa4k4/vJ7o2Oyz9cVksf307z+5R9FXP+cISTSoOg0lrI3LSiuYrZIcjxxZhjd1aFFQ2QQZhssm6FzEWElQa+/QNvucfEnyVTKvqQEyRy5MXqrn8PmJdmSpUJY6diUlHcDvlV+Dvu2agO8a1mZwt9zuctsKYh5wBAZ3lQGY1p5i3pHZkFHpyKWsJGDkjjPrk8ptLdK0k4UdL6wsAUEF/4KZK46c981qgHougOgQZGT+67h0YiTkjSHIbKiiPUfODMzIPoSOBzUaCpYi81gCxBxZxUEkPVRlRwvu7lLpJ7Kawgs+/018PIOX5/tLRwuVKg2ZuAqDHqDyUQSd7WMXdzkTEb4ahz787hpL3CYCBpP2X/AWPq8NERYq0BQlBEq+5sjpwWL6S0OMGhSUmBCOvJjRKjyXVW4dol8+JOPtcTLeweDlQcBSv3DYym2/xVcO1X7DMIr4IJ2npR1o08kB6M3YOSUH+ecbVDa63b46vAKsjmWtwO5WnayVI22qh6eJlYnByeedUmILoedgiwdhKAOlmYTkoAnnqwar/ayNNAub77MyDyZml+EBEDfhJPZyDfYAj5K1QepkqdXM1MmciSEMra6nprcNoa7d9aKewEd//PqHzve//vbuvretwDsWByAHrBi8RhuozeDpd+S5rqHFjosi6Fyvk2OWCfBx79OnDgjY6YVBBPCfwLQA04Lb1LYgdS7/1+9/rH72+AjJbZLjQtFokyK+TI65loEqlYgS/f4HXskzD4/CdQk1gYaId3jETFU1qONgd2R5g0vBJVujDkw2jB27nkDlpw5U3pfz56Nvt85+d+7afvUzXXVDsLQDc5+S+S679/SeXWd6+IK2LI5UastZRj2D9xd0z48q/nonq8xZ2WP+OInxtu3F4q/axBzL8OmoqbjR+jDRVEZoZFMyLijD4RD7xk9JlWcSBcFn8tmNiDq6FnIZwYm7nk15fpKeOTCTEbLGc2C4iZdWNsOFiRjaUzOM0nBpcg1P6cNkDKM0vDLBNBa71sCiT6iI2f9DBttuS0WjdvF4snG1vTp1fydjGKXhytT7bDwDfAgF3VOxG8Hy3iSjwc8XM3vbrNlzhaeQlf7LpsH/UuxUZBj+ZsSUkOEJpJIj2p8MAAA=";
    protected javax.swing.JSplitPane PortTab;
    protected fr.ifremer.isisfish.entities.PortImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextArea fieldPortComment;
    protected javax.swing.JTextField fieldPortName;
    protected javax.swing.JPanel map;
    protected jaxx.runtime.swing.JAXXList portCell;
    protected fr.ifremer.isisfish.map.IsisMapBean portMap;
    protected javax.swing.JButton remove;
    protected javax.swing.JButton save;
    protected com.bbn.openmap.gui.ToolPanel toolMap;
    private fr.ifremer.isisfish.ui.input.PortUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JScrollPane $JScrollPane7;
    private javax.swing.JScrollPane $JScrollPane9;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPortName.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPortName.text");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "portCell.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "portCell.selectedValue");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPortComment.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPortComment.text");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "portMap.fisheryRegion");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "portMap.selectedCells");

    /* begin raw body code */
    protected OMToolSet toolSet;
    protected OpenMapEvents mapListener;
    boolean portChanged;
    
    
    @Override
    public void refresh() {
        Port port = getVerifier().getEntity(Port.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PortImpl) port);
        // reload region in map
        refreshRegionInMap(portMap);
    
        fillList();
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
        getVerifier().setNewButton(create, "Port");
        getVerifier().setDeleteButton(remove);
    }
    
    protected void fillList() {
        if (getBean() != null) {
            jaxx.runtime.Util.assignment(portChanged = false, "portChanged", fr.ifremer.isisfish.ui.input.PortUI.this);
            portCell.fillList(getRegion().getCell(), getBean().getCell());
            portCell.setSelectedValue(getBean().getCell());
            jaxx.runtime.Util.assignment(portChanged = true, "portChanged", fr.ifremer.isisfish.ui.input.PortUI.this);
        }
    }
    protected void setMapListener() {
        if (mapListener == null) {
            jaxx.runtime.Util.assignment(mapListener = new OpenMapEvents(portMap, new SelectMouseMode(false), CellSelectionLayer.SINGLE_SELECTION) {
                @Override
                public boolean mouseClicked(MouseEvent e) {
                    for (Cell c : portMap.getSelectedCells()) {
                        if (getBean() != null) {
                            if (getBean().getCell() != null) {
                                if (!getBean().getCell().getTopiaId().equals(c.getTopiaId())){
                                    getBean().setCell(c);
                                    return true;
                                }
                            }
                            else {
                                getBean().setCell(c);
                                return true;
                            }
                        }
                    }
                    return true;
                }
            }, "mapListener", fr.ifremer.isisfish.ui.input.PortUI.this);
        }
    }
    
    protected void portChanged() {
        if (portChanged) {
            getBean().setCell((Cell)portCell.getSelectedValue());
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PortUI() {
        super();
        $initialize();
    }

    public PortUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPortName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPortName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource12);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("portCell.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("portCell.selectedValue".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cell", $DataSource15);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldPortComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPortComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource18);
            }
        } else if ("portMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("region", $DataSource20);
            }
        } else if ("portMap.selectedCells".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("cell", $DataSource21);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldPortName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPortName.setEnabled((isActif()));
            }
            } else if ("fieldPortName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPortName, String.valueOf((SwingUtil.getStringValue(getBean().getName()))));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("portCell.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                portCell.setEnabled((isActif()));
            }
            } else if ("portCell.selectedValue".equals($dest)) {
            if (getBean() != null) {
                portCell.setSelectedValue((getBean().getCell()));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel8.setEnabled((isActif()));
            }
            } else if ("fieldPortComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPortComment.setEnabled((isActif()));
            }
            } else if ("fieldPortComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPortComment, String.valueOf((SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else if ("portMap.fisheryRegion".equals($dest)) {
            if ($InputContentUI0 != null) {
                portMap.setFisheryRegion((getRegion()));
            }
            } else if ("portMap.selectedCells".equals($dest)) {
            if (getBean() != null) {
                portMap.setSelectedCells((getBean().getCell()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPortName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPortName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource12);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("portCell.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("portCell.selectedValue".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cell", $DataSource15);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldPortComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPortComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource18);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource18);
            }
        } else if ("portMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("region", $DataSource20);
            }
        } else if ("portMap.selectedCells".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource21);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("cell", $DataSource21);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldPortComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldPortComment.getText());
    }

    public void doKeyReleased__on__fieldPortName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldPortName.getText());
    }

    public void doMouseClicked__on__portCell(java.awt.event.MouseEvent event) {
        portChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PortImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextArea getFieldPortComment() {
        return fieldPortComment;
    }

    public javax.swing.JTextField getFieldPortName() {
        return fieldPortName;
    }

    public javax.swing.JPanel getMap() {
        return map;
    }

    public jaxx.runtime.swing.JAXXList getPortCell() {
        return portCell;
    }

    public fr.ifremer.isisfish.map.IsisMapBean getPortMap() {
        return portMap;
    }

    public javax.swing.JSplitPane getPortTab() {
        return PortTab;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public com.bbn.openmap.gui.ToolPanel getToolMap() {
        return toolMap;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PortImpl newValue) {
        fr.ifremer.isisfish.entities.PortImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPortMap(fr.ifremer.isisfish.map.IsisMapBean newValue) {
        fr.ifremer.isisfish.map.IsisMapBean oldValue = this.portMap;
        this.portMap = newValue;
        firePropertyChange("portMap", oldValue, newValue);
    }

    public void setToolMap(com.bbn.openmap.gui.ToolPanel newValue) {
        com.bbn.openmap.gui.ToolPanel oldValue = this.toolMap;
        this.toolMap = newValue;
        firePropertyChange("toolMap", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PortUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JScrollPane get$JScrollPane7() {
        return $JScrollPane7;
    }

    protected javax.swing.JScrollPane get$JScrollPane9() {
        return $JScrollPane9;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        
        
        
        addChildrenToBody();
        addChildrenToPortTab();
        $Table4.add($JLabel5, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPortName), new GridBagConstraints(0, 1, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel6, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane7, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JLabel8, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane9, new GridBagConstraints(0, 5, 2, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 6, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        $JScrollPane7.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(portCell));
        
        
        $JScrollPane9.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPortComment));
        
        addChildrenToMap();
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldPortName.enabled");
        applyDataBinding("fieldPortName.text");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("portCell.enabled");
        applyDataBinding("portCell.selectedValue");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldPortComment.enabled");
        applyDataBinding("fieldPortComment.text");
        applyDataBinding("portMap.fisheryRegion");
        applyDataBinding("portMap.selectedCells");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        toolSet = new OMToolSet();
        
        mapListener = null;
        
        portChanged = true;
        
        createPortTab();
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.port.name"));
        
        createFieldPortName();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.port.cell"));
        
        $JScrollPane7 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane7", $JScrollPane7);
        $JScrollPane7.setName("$JScrollPane7");
        
        createPortCell();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.port.comments"));
        
        $JScrollPane9 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane9", $JScrollPane9);
        $JScrollPane9.setName("$JScrollPane9");
        
        createFieldPortComment();
        createSave();
        createCancel();
        createCreate();
        createRemove();
        createMap();
        createToolMap();
        createPortMap();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        toolSet.setupListeners(portMap);toolMap.add((Tool)toolSet);// add copy to clipboard support
        portMap.addMapMouseListener(new CopyMapToClipboardListener(portMap));setMapListener();setButtonTitle(_("isisfish.input.continueSpecies"));setNextPath("$root/$species");addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldPortName.setText("");
                    fieldPortComment.setText("");
                }
                if (evt.getNewValue() != null) {
        
            }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add(PortTab, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(toolMap), BorderLayout.NORTH);
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(portMap), BorderLayout.CENTER);
    }

    protected void addChildrenToPortTab() {
        if (!allComponentsCreated) {
            return;
        }
        PortTab.add($Table4, JSplitPane.LEFT);
        PortTab.add(map, JSplitPane.RIGHT);
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
    }

    protected void createFieldPortComment() {
        fieldPortComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPortComment", fieldPortComment);
        fieldPortComment.setName("fieldPortComment");
        fieldPortComment.setColumns(15);
        fieldPortComment.setLineWrap(true);
        fieldPortComment.setWrapStyleWord(true);
        fieldPortComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPortComment"));
    }

    protected void createFieldPortName() {
        fieldPortName = new javax.swing.JTextField();
        $objectMap.put("fieldPortName", fieldPortName);
        fieldPortName.setName("fieldPortName");
        fieldPortName.setColumns(15);
        fieldPortName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPortName"));
    }

    protected void createMap() {
        map = new javax.swing.JPanel();
        $objectMap.put("map", map);
        map.setName("map");
        map.setLayout((new BorderLayout()));
    }

    protected void createPortCell() {
        portCell = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("portCell", portCell);
        portCell.setName("portCell");
        portCell.setSelectionMode(0);
        portCell.addMouseListener((java.awt.event.MouseListener) jaxx.runtime.Util.getEventListener(java.awt.event.MouseListener.class, "mouseClicked", $InputContentUI0, "doMouseClicked__on__portCell"));
    }

    protected void createPortMap() {
        portMap = new fr.ifremer.isisfish.map.IsisMapBean();
        $objectMap.put("portMap", portMap);
        portMap.setName("portMap");
        portMap.setSelectionMode(1);
    }

    protected void createPortTab() {
        PortTab = new javax.swing.JSplitPane();
        $objectMap.put("PortTab", PortTab);
        PortTab.setName("PortTab");
        PortTab.setDividerLocation(270);
        PortTab.setName("Ports");
        PortTab.setOneTouchExpandable(true);
        PortTab.setOrientation(1);
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createToolMap() {
        toolMap = new com.bbn.openmap.gui.ToolPanel();
        $objectMap.put("toolMap", toolMap);
        toolMap.setName("toolMap");
    }

}
