/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.ui.util.ErrorHelper;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEditor;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationSeasonSpacializedUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAALVVz28bRRR+MUmcNP1FSYFDgZRGrVBhTSmlUlMobWiKg5NGTSNV9YVxdmJPNZ4ZZt4mWw4IiStCPXHgAtw5ckeIIyeu/A8I8R/0zazj9QbLWWrhw6795r3vfd/MvM8//QVTzsLZRyxNI5soFF0erd588OBu6xHfxo+427bCoLaQfSYqUGnCXNyPO4RzzYYvr/XKa8u6a7TiaqB6qQFHHD6W3HU4R4TTWcW2c7XNfngpNYndR+uTGYb2wz9/V57EX/5YAUgNsTpBEhYOq8oVTDagImKEU9Rpl9UkU22iYYVqE89jPrYsmXPrrMs/gy+g2oBpwyyBIbxeXmrACPWpQTi5WFcmwWWtkNK36m8jXNuxkdixvMvp7YTbEa4TJSISPjHa0CaRDIVWm5w5ehq2LZgUn/N4q25MQJ5GmGxxphAuDsOiRgIFdwNY9a6RefG8OdCkrnY0wpWSYHnNv2HztXWN64mUCM/7nY38bke3tJbEOy85ytr8jtWJuf/YhE2fz9eqi/dZS/JLCC8Xztjt0YlFYc1nzg4UbDDF5TsIx0NLtkfb6SN+/aV+2mXLYqEPygksljvEkje4amNnXQ9sfeCwy9Je89V7HuJWgqhVEfxSOfABaF/4WhFkZnG1wVpcXqa7WmgbosXc2cXVjMe7CC8UkofSa4Xgofyy2s2O3vOFF4ogvX2+4n+eKS5d6DIaqDSsH2ySIWddEN7Uth2pRFCbiIo6UVYZtWkS1nKQ2zFl2GKT9/7zHoc1muIh98ibXqY2JNH1s34fKY9cKspdKreRiSZM2YTCNN3N3NDuUSizsl40AITo9199t/vtz79c2/et09TjWCFlwGbJR4zVhls/dQgnMrNKUMjaGjNLTZh1XJJHBw+eHyCw2QsTCcLPps6XRR8z16HSqeqfv/724qd/PAeVFTgiNYtXmM+vwyx2LKnUMk7NjQ8Dk6N7M/Q86TkhzLXyDaIreV0oKRRfYEjHREv8g5RUzw+o7lP5/cnXa2e+eeXqvvKJjNmBtFz91EOYztCDV/dseKg3zxnHk1jndjvMgCf8+1XTM5Wr4bk0TGKVK28oNOjHr8cM2UJLqJjuB0nzNTcCd//tZmnImeycsglfeXacSeQp+tUxuFR3ydB7hvnMVHz4/RFEzpZCuD2CQzmET8ZG2Bhbxdb/yuHc2BzKIYw6i/NjqyiHMEpFOYRRKt4YW0U5hFEqyiGMUvFWiRGfzv5Ax0I5TIlHeAqeOoP+OwwAAA==";
    protected java.lang.Boolean ageGroupType;
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton buttonPopulationSeasonGroupChangeLengthButtonShow;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor matrixPanelPopulationSeasonLengthChange;
    protected java.lang.Boolean popSeasonInfoNotNull;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl populationSeasonInfo;
    protected javax.swing.JRadioButton radioPopulationSeasonGroupChangeLengthNoSpacialized;
    protected javax.swing.JRadioButton radioPopulationSeasonGroupChangeLengthSpacialized;
    protected jaxx.runtime.swing.JAXXButtonGroup radioPopulationSeasonGroupChangeLengthSpacializedGroup;
    private fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI $InputContentUI0 = this;
    private javax.swing.JButton $JButton4;
    private javax.swing.JLabel $JLabel3;
    private java.awt.Panel $Panel2;
    private java.awt.Panel $Panel5;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthSpacialized.selected");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthSpacialized.visible");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.visible");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JButton4.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JButton4.visible");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "buttonPopulationSeasonGroupChangeLengthButtonShow.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "buttonPopulationSeasonGroupChangeLengthButtonShow.visible");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "matrixPanelPopulationSeasonLengthChange.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "matrixPanelPopulationSeasonLengthChange.matrix");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "matrixPanelPopulationSeasonLengthChange.visible");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthNoSpacialized.selected");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthNoSpacialized.visible");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "radioPopulationSeasonGroupChangeLengthSpacialized.enabled");

    /* begin raw body code */    
    
    protected void populationSeasonLengthMatrixChanged(MatrixPanelEvent event) {
        if (getPopulationSeasonInfo() != null && matrixPanelPopulationSeasonLengthChange.getMatrix() != null) {
            // must be a copy for fire event
            MatrixND lengthChangeMatrix = matrixPanelPopulationSeasonLengthChange.getMatrix().copy();
            getPopulationSeasonInfo().setLengthChangeMatrix(lengthChangeMatrix);
        }
    }
    
    /*addPropertyChangeListener("populationSeasonInfo", new PropertyChangeListener() {
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getOldValue() != null || evt.getNewValue() == null) {
                matrixPanelPopulationSeasonLengthChange.setMatrix(null);
            }
            if (evt.getNewValue() != null) {
                matrixPanelPopulationSeasonLengthChange.setMatrix(getPopulationSeasonInfo().getLengthChangeMatrix().copy());
            }
        }
    });*/
    
    @Override
    public void refresh() {
        // TODO add only once
        //matrixPanelPopulationSeasonLengthChange.addMatrixListener(matrixPanelListener);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    /**
     * Called on spacialized radio button change.
     */
    protected void spacializedActionPerformed() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        boolean spacializedSelection = radioPopulationSeasonGroupChangeLengthNoSpacialized.isSelected();
        popInfo.setSimpleLengthChangeMatrix(spacializedSelection);
        try {
            MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
            if (lengthChangeMatrix != null) {
                if (popInfo.getSimpleLengthChangeMatrix()) {
                    lengthChangeMatrix = popInfo.unspacializeLengthChangeMatrix(lengthChangeMatrix);
                } else {
                    lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
                }
                popInfo.setLengthChangeMatrix(lengthChangeMatrix);
                matrixPanelPopulationSeasonLengthChange.setMatrix(lengthChangeMatrix);
            }
        } catch(Exception eee) {
            if (log.isErrorEnabled()) {
                log.error("Can't (un)spacialize Matrix Change Of Group", eee);
            }
            ErrorHelper.showErrorDialog(_("isisfish.error.input.spacializematrix"), eee);
        }
    }
    
    protected void computeMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.computeLengthChangeMatrix();
        if (!popInfo.getSimpleLengthChangeMatrix()){
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        popInfo.setLengthChangeMatrix(lengthChangeMatrix);
    }
    
    protected void showSpacializedMatrixChangeOfGroup() {
        PopulationSeasonInfo popInfo = getPopulationSeasonInfo();
        MatrixND lengthChangeMatrix = popInfo.getLengthChangeMatrix();
        if (popInfo.getSimpleLengthChangeMatrix()) {
            lengthChangeMatrix = popInfo.spacializeLengthChangeMatrix(lengthChangeMatrix);
        }
        MatrixPanelEditor panel = new MatrixPanelEditor(false, 800, 300);
        panel.setMatrix(lengthChangeMatrix);
        JOptionPane.showMessageDialog(null, panel, _("isisfish.populationSeasons.spacialized.visualisation"), JOptionPane.INFORMATION_MESSAGE);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationSeasonSpacializedUI() {
        super();
        $initialize();
    }

    public PopulationSeasonSpacializedUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource6);
        
        } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.selected".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource7);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("simpleLengthChangeMatrix", $DataSource7);
            }
        } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource8);
        
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource9);
        
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.selected".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource10);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().addPropertyChangeListener("simpleLengthChangeMatrix", $DataSource10);
            }
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource11);
        
        } else if ("$JLabel3.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource12);
        
        } else if ("$JButton4.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource13);
        
        } else if ("$JButton4.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource14);
        
        } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.enabled".equals($binding)) {
            if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                $bindingSources.put("radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel()", radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel());
        radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel().addChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $InputContentUI0, "$pr$u0"));
        radioPopulationSeasonGroupChangeLengthNoSpacialized.addPropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this , "buttonPopulationSeasonGroupChangeLengthButtonShow.enabled"));
            }
        } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource16);
        
        } else if ("matrixPanelPopulationSeasonLengthChange.enabled".equals($binding)) {
                addPropertyChangeListener("popSeasonInfoNotNull", $DataSource17);
        
        } else if ("matrixPanelPopulationSeasonLengthChange.matrix".equals($binding)) {
                addPropertyChangeListener("populationSeasonInfo", $DataSource18);
        if ( getPopulationSeasonInfo() != null) {
                 getPopulationSeasonInfo().addPropertyChangeListener("lengthChangeMatrix", $DataSource18);
            }
        } else if ("matrixPanelPopulationSeasonLengthChange.visible".equals($binding)) {
                addPropertyChangeListener("ageGroupType", $DataSource19);
        
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled".equals($dest)) {
            radioPopulationSeasonGroupChangeLengthNoSpacialized.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.selected".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                radioPopulationSeasonGroupChangeLengthNoSpacialized.setSelected((getPopulationSeasonInfo().getSimpleLengthChangeMatrix()));
            }
            } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.visible".equals($dest)) {
            radioPopulationSeasonGroupChangeLengthNoSpacialized.setVisible((isAgeGroupType()));
            } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.enabled".equals($dest)) {
            radioPopulationSeasonGroupChangeLengthSpacialized.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.selected".equals($dest)) {
            if (getPopulationSeasonInfo() != null) {
                radioPopulationSeasonGroupChangeLengthSpacialized.setSelected((!getPopulationSeasonInfo().getSimpleLengthChangeMatrix()));
            }
            } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.visible".equals($dest)) {
            radioPopulationSeasonGroupChangeLengthSpacialized.setVisible((isAgeGroupType()));
            } else if ("$JLabel3.visible".equals($dest)) {
            $JLabel3.setVisible((isAgeGroupType()));
            } else if ("$JButton4.enabled".equals($dest)) {
            $JButton4.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("$JButton4.visible".equals($dest)) {
            $JButton4.setVisible((isAgeGroupType()));
            } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.enabled".equals($dest)) {
            if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                buttonPopulationSeasonGroupChangeLengthButtonShow.setEnabled((radioPopulationSeasonGroupChangeLengthNoSpacialized.isSelected()));
            }
            } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.visible".equals($dest)) {
            buttonPopulationSeasonGroupChangeLengthButtonShow.setVisible((isAgeGroupType()));
            } else if ("matrixPanelPopulationSeasonLengthChange.enabled".equals($dest)) {
            matrixPanelPopulationSeasonLengthChange.setEnabled((isPopSeasonInfoNotNull()));
            } else if ("matrixPanelPopulationSeasonLengthChange.matrix".equals($dest)) {
            if ( getPopulationSeasonInfo() != null) {
                matrixPanelPopulationSeasonLengthChange.setMatrix((getPopulationSeasonInfo() == null ? null : getPopulationSeasonInfo().getLengthChangeMatrix().copy()));
            }
            } else if ("matrixPanelPopulationSeasonLengthChange.visible".equals($dest)) {
            matrixPanelPopulationSeasonLengthChange.setVisible((isAgeGroupType()));
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource6);
        
        } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.selected".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource7);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("simpleLengthChangeMatrix", $DataSource7);
            }
        } else if ("radioPopulationSeasonGroupChangeLengthNoSpacialized.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource8);
        
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource9);
        
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.selected".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource10);
        if (getPopulationSeasonInfo() != null) {
                getPopulationSeasonInfo().removePropertyChangeListener("simpleLengthChangeMatrix", $DataSource10);
            }
        } else if ("radioPopulationSeasonGroupChangeLengthSpacialized.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource11);
        
        } else if ("$JLabel3.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource12);
        
        } else if ("$JButton4.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource13);
        
        } else if ("$JButton4.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource14);
        
        } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.enabled".equals($binding)) {
            if (radioPopulationSeasonGroupChangeLengthNoSpacialized != null) {
                ((javax.swing.ButtonModel) $bindingSources.remove("radioPopulationSeasonGroupChangeLengthNoSpacialized.getModel()")).removeChangeListener((javax.swing.event.ChangeListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ChangeListener.class, $InputContentUI0, "$pr$u0"));
        radioPopulationSeasonGroupChangeLengthNoSpacialized.removePropertyChangeListener("model", jaxx.runtime.Util.getDataBindingUpdateListener(this, "buttonPopulationSeasonGroupChangeLengthButtonShow.enabled"));
            }
        } else if ("buttonPopulationSeasonGroupChangeLengthButtonShow.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource16);
        
        } else if ("matrixPanelPopulationSeasonLengthChange.enabled".equals($binding)) {
                removePropertyChangeListener("popSeasonInfoNotNull", $DataSource17);
        
        } else if ("matrixPanelPopulationSeasonLengthChange.matrix".equals($binding)) {
                removePropertyChangeListener("populationSeasonInfo", $DataSource18);
        if ( getPopulationSeasonInfo() != null) {
                 getPopulationSeasonInfo().removePropertyChangeListener("lengthChangeMatrix", $DataSource18);
            }
        } else if ("matrixPanelPopulationSeasonLengthChange.visible".equals($binding)) {
                removePropertyChangeListener("ageGroupType", $DataSource19);
        
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JButton4(java.awt.event.ActionEvent event) {
        computeMatrixChangeOfGroup();
    }

    public void doActionPerformed__on__buttonPopulationSeasonGroupChangeLengthButtonShow(java.awt.event.ActionEvent event) {
        showSpacializedMatrixChangeOfGroup();
    }

    public void doActionPerformed__on__radioPopulationSeasonGroupChangeLengthNoSpacialized(java.awt.event.ActionEvent event) {
        spacializedActionPerformed();
    }

    public void doActionPerformed__on__radioPopulationSeasonGroupChangeLengthSpacialized(java.awt.event.ActionEvent event) {
        spacializedActionPerformed();
    }

    public void doMatrixChanged__on__matrixPanelPopulationSeasonLengthChange(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationSeasonLengthMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.lang.Boolean getAgeGroupType() {
        return ageGroupType;
    }

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getButtonPopulationSeasonGroupChangeLengthButtonShow() {
        return buttonPopulationSeasonGroupChangeLengthButtonShow;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getMatrixPanelPopulationSeasonLengthChange() {
        return matrixPanelPopulationSeasonLengthChange;
    }

    public java.lang.Boolean getPopSeasonInfoNotNull() {
        return popSeasonInfoNotNull;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopulationSeasonInfo() {
        return populationSeasonInfo;
    }

    public javax.swing.JRadioButton getRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        return radioPopulationSeasonGroupChangeLengthNoSpacialized;
    }

    public javax.swing.JRadioButton getRadioPopulationSeasonGroupChangeLengthSpacialized() {
        return radioPopulationSeasonGroupChangeLengthSpacialized;
    }

    public jaxx.runtime.swing.JAXXButtonGroup getRadioPopulationSeasonGroupChangeLengthSpacializedGroup() {
        return radioPopulationSeasonGroupChangeLengthSpacializedGroup;
    }

    public java.lang.Boolean isAgeGroupType() {
        return ageGroupType !=null && ageGroupType;
    }

    public java.lang.Boolean isPopSeasonInfoNotNull() {
        return popSeasonInfoNotNull !=null && popSeasonInfoNotNull;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setAgeGroupType(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.ageGroupType;
        this.ageGroupType = newValue;
        firePropertyChange("ageGroupType", oldValue, newValue);
    }

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPopSeasonInfoNotNull(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.popSeasonInfoNotNull;
        this.popSeasonInfoNotNull = newValue;
        firePropertyChange("popSeasonInfoNotNull", oldValue, newValue);
    }

    public void setPopulationSeasonInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.populationSeasonInfo;
        this.populationSeasonInfo = newValue;
        firePropertyChange("populationSeasonInfo", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void $pr$u0(javax.swing.event.ChangeEvent event) {
        $DataSource15.propertyChange(null);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationSeasonSpacializedUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JButton get$JButton4() {
        return $JButton4;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected java.awt.Panel get$Panel2() {
        return $Panel2;
    }

    protected java.awt.Panel get$Panel5() {
        return $Panel5;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add($Panel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(radioPopulationSeasonGroupChangeLengthNoSpacialized), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(radioPopulationSeasonGroupChangeLengthSpacialized), new GridBagConstraints(2, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer($JButton4), new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(buttonPopulationSeasonGroupChangeLengthButtonShow), new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Panel5, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(matrixPanelPopulationSeasonLengthChange), new GridBagConstraints(1, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToRadioPopulationSeasonGroupChangeLengthNoSpacialized();
        addChildrenToRadioPopulationSeasonGroupChangeLengthSpacialized();
        
        
        
        addChildrenToMatrixPanelPopulationSeasonLengthChange();
        applyDataBinding("radioPopulationSeasonGroupChangeLengthNoSpacialized.enabled");
        applyDataBinding("radioPopulationSeasonGroupChangeLengthNoSpacialized.selected");
        applyDataBinding("radioPopulationSeasonGroupChangeLengthNoSpacialized.visible");
        applyDataBinding("radioPopulationSeasonGroupChangeLengthSpacialized.enabled");
        applyDataBinding("radioPopulationSeasonGroupChangeLengthSpacialized.selected");
        applyDataBinding("radioPopulationSeasonGroupChangeLengthSpacialized.visible");
        applyDataBinding("$JLabel3.visible");
        applyDataBinding("$JButton4.enabled");
        applyDataBinding("$JButton4.visible");
        applyDataBinding("buttonPopulationSeasonGroupChangeLengthButtonShow.enabled");
        applyDataBinding("buttonPopulationSeasonGroupChangeLengthButtonShow.visible");
        applyDataBinding("matrixPanelPopulationSeasonLengthChange.enabled");
        applyDataBinding("matrixPanelPopulationSeasonLengthChange.matrix");
        applyDataBinding("matrixPanelPopulationSeasonLengthChange.visible");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopulationSeasonInfo();
        createPopSeasonInfoNotNull();
        createAgeGroupType();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $Panel2 = new java.awt.Panel();
        $objectMap.put("$Panel2", $Panel2);
        $Panel2.setName("$Panel2");
        
        createRadioPopulationSeasonGroupChangeLengthNoSpacialized();
        createRadioPopulationSeasonGroupChangeLengthSpacialized();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationSeasons.changeGroup"));
        
        create$JButton4();
        createButtonPopulationSeasonGroupChangeLengthButtonShow();
        
        $Panel5 = new java.awt.Panel();
        $objectMap.put("$Panel5", $Panel5);
        $Panel5.setName("$Panel5");
        
        createMatrixPanelPopulationSeasonLengthChange();
        createRadioPopulationSeasonGroupChangeLengthSpacializedGroup();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        $completeSetup();
    }

    protected void addChildrenToMatrixPanelPopulationSeasonLengthChange() {
        if (!allComponentsCreated) {
            return;
        }
        matrixPanelPopulationSeasonLengthChange.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        matrixPanelPopulationSeasonLengthChange.putClientProperty("method", "LengthChangeMatrix");
    }

    protected void addChildrenToRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = radioPopulationSeasonGroupChangeLengthSpacializedGroup; radioPopulationSeasonGroupChangeLengthNoSpacialized.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(radioPopulationSeasonGroupChangeLengthNoSpacialized); }
    }

    protected void addChildrenToRadioPopulationSeasonGroupChangeLengthSpacialized() {
        if (!allComponentsCreated) {
            return;
        }
        { javax.swing.ButtonGroup $buttonGroup = radioPopulationSeasonGroupChangeLengthSpacializedGroup; radioPopulationSeasonGroupChangeLengthSpacialized.putClientProperty("$buttonGroup", $buttonGroup); $buttonGroup.add(radioPopulationSeasonGroupChangeLengthSpacialized); }
    }

    protected void create$JButton4() {
        $JButton4 = new javax.swing.JButton();
        $objectMap.put("$JButton4", $JButton4);
        $JButton4.setName("$JButton4");
        $JButton4.setText(_("isisfish.populationSeasons.computeCoefficient"));
        $JButton4.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__$JButton4"));
    }

    protected void createAgeGroupType() {
        ageGroupType = false;
        $objectMap.put("ageGroupType", ageGroupType);
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createButtonPopulationSeasonGroupChangeLengthButtonShow() {
        buttonPopulationSeasonGroupChangeLengthButtonShow = new javax.swing.JButton();
        $objectMap.put("buttonPopulationSeasonGroupChangeLengthButtonShow", buttonPopulationSeasonGroupChangeLengthButtonShow);
        buttonPopulationSeasonGroupChangeLengthButtonShow.setName("buttonPopulationSeasonGroupChangeLengthButtonShow");
        buttonPopulationSeasonGroupChangeLengthButtonShow.setText(_("isisfish.populationSeasons.showSpacialized"));
        buttonPopulationSeasonGroupChangeLengthButtonShow.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__buttonPopulationSeasonGroupChangeLengthButtonShow"));
    }

    protected void createMatrixPanelPopulationSeasonLengthChange() {
        matrixPanelPopulationSeasonLengthChange = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("matrixPanelPopulationSeasonLengthChange", matrixPanelPopulationSeasonLengthChange);
        matrixPanelPopulationSeasonLengthChange.removeDataBinding("$MatrixEditor0.name");
        
        matrixPanelPopulationSeasonLengthChange.setName("matrixPanelPopulationSeasonLengthChange");
        matrixPanelPopulationSeasonLengthChange.removeDataBinding("$MatrixEditor0.enabled");
        
        matrixPanelPopulationSeasonLengthChange.removeDataBinding("$MatrixEditor0.matrix");
        
        matrixPanelPopulationSeasonLengthChange.removeDataBinding("$MatrixEditor0.visible");
        
        
        
        
        
        
        
        
        
        
        
        
        matrixPanelPopulationSeasonLengthChange.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__matrixPanelPopulationSeasonLengthChange"));
    }

    protected void createPopSeasonInfoNotNull() {
        popSeasonInfoNotNull = false;
        $objectMap.put("popSeasonInfoNotNull", popSeasonInfoNotNull);
    }

    protected void createPopulationSeasonInfo() {
        populationSeasonInfo = null;
        $objectMap.put("populationSeasonInfo", populationSeasonInfo);
    }

    protected void createRadioPopulationSeasonGroupChangeLengthNoSpacialized() {
        radioPopulationSeasonGroupChangeLengthNoSpacialized = new javax.swing.JRadioButton();
        $objectMap.put("radioPopulationSeasonGroupChangeLengthNoSpacialized", radioPopulationSeasonGroupChangeLengthNoSpacialized);
        radioPopulationSeasonGroupChangeLengthNoSpacialized.setName("radioPopulationSeasonGroupChangeLengthNoSpacialized");
        radioPopulationSeasonGroupChangeLengthNoSpacialized.setText(_("isisfish.populationSeasons.noSpacialized"));
        radioPopulationSeasonGroupChangeLengthNoSpacialized.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__radioPopulationSeasonGroupChangeLengthNoSpacialized"));
    }

    protected void createRadioPopulationSeasonGroupChangeLengthSpacialized() {
        radioPopulationSeasonGroupChangeLengthSpacialized = new javax.swing.JRadioButton();
        $objectMap.put("radioPopulationSeasonGroupChangeLengthSpacialized", radioPopulationSeasonGroupChangeLengthSpacialized);
        radioPopulationSeasonGroupChangeLengthSpacialized.setName("radioPopulationSeasonGroupChangeLengthSpacialized");
        radioPopulationSeasonGroupChangeLengthSpacialized.setText(_("isisfish.populationSeasons.spacialized"));
        radioPopulationSeasonGroupChangeLengthSpacialized.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__radioPopulationSeasonGroupChangeLengthSpacialized"));
    }

    protected void createRadioPopulationSeasonGroupChangeLengthSpacializedGroup() {
        radioPopulationSeasonGroupChangeLengthSpacializedGroup = new jaxx.runtime.swing.JAXXButtonGroup();
        $objectMap.put("radioPopulationSeasonGroupChangeLengthSpacializedGroup", radioPopulationSeasonGroupChangeLengthSpacializedGroup);
    }

}
