/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationRecruitmentUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVz28bRRSemNjpr5AmTUorfiiFqAio1gUKlZqK0rhJ68ihUdNKBUuo492xPdXs7HTmbbLpoarEFaGeOHAB7hy5I8SRE1f+B4T4D/pm1vZ608Wxah9md9+8973vezPv+Zd/SNlocu4hTRJPxxJ4yLzN6/fv3249ZD7cYMbXXEGkSfqbKpFSkxwPBnYD5J1mw4ZXe+HVWhSqSDI5FL3aIMcM7AtmuowBkKU0wjemujMwryYq1n20AZkitJ/++7f0LHj6c4mQRCGreZSwfFhUpmC6QUo8ALKAmXZpVVDZQRqayw7ynLW2mqDGfEFD9og8ITMNUlFUIxiQt8eX6jBcfKKAnFypSxVDLZKA7vfqF4FcamuPtzULGT4NN21uul7MPW4dve1IxYICj+Qd5uuYQ+jilHKYFSDTLUYlkA+KUNCVA2dmCKUeKjEcHAX7QM7kimb2sATeXdoSLPOcWXGGD+3nvF3mBluLmikdBbFv8dcfxS4PkOpIXa4MtyXr+9+rW7SFAeiRlc0GbTHxEZ6PPYqkRyu15n29NmciyDRuYfruTarWGOwxhoVDeq56wEJ3fKdziHdZAhsWoZjBx/b7bH7v/IGMQ2dzgxu8Q604LcKFSHc8iVuR9EIKXbtonngdLMSWe92mkon1AD30C/nd3qWDFXDWvG/F14wCA3Iq57kWAyYulvVJgazZlc0dX0dC2BSfAnkth5Zt5aPO/X8xsDHSii+9UPHryNgCvH/wil0uuGLThu66rO/a5eKQbir9tBj9HW1rgLcZh4qXDZWs66eapKxjNGMzNrP5cwdN6eTpWR2As/74zQ+73//625X+mDmFOWZzLkNTEdseb5ti2vYdkLl0tuBtENUtqlab5KhhAkeqG5mLQwR2emYkgfjzNsyzYd4taroYWp75+/c/Tj/46xVS2iDHRESDDWr96+QodDWqjESQqGufOyYn9o7getJyGkyIV68GFOhyi8sAD+GzBKUuDkkd5P/z2bdbb3z35uW+3KmUzgG3THL5K1LhUnDJ3DztjcrC+XlcGRYHUTYSi4bklH0uqd7oWXXrtSJdJ6yu7bTYOMQWrqYslimkDchQow2uORH2bX1s7LIv6OPHdnvt5UHm2pEO8XrUsDU7kd63jpsvDzcN2DYTYswwaXssGKHszKEw1vzlCCLjIXw9gsPr43OYCGEUh7cmrsN4CKM4LI9xpJX0L2UilMN4nJ+4FuMhjOLw3sQcxkMYxcGb+F5ahOfEy52ubgsAAA==";
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JButton create;
    protected javax.swing.JTextField fieldPopulationMonthGapBetweenReproRecrutement;
    protected javax.swing.JTextArea fieldPopulationRecruitmentComment;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor fieldPopulationRecruitmentDistribution;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI reproductionEquation;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.PopulationRecruitmentUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JPanel $JPanel4;
    private javax.swing.JScrollPane $JScrollPane6;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table7;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMonthGapBetweenReproRecrutement.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMonthGapBetweenReproRecrutement.text");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationRecruitmentDistribution.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationRecruitmentDistribution.matrix");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "create.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationRecruitmentComment.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationRecruitmentComment.text");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "reproductionEquation.bean");

    /* begin raw body code */    
    
    protected void populationRecruitmentDistributionMatrixChanged(MatrixPanelEvent event) {
        if (getBean() != null){
            if (fieldPopulationRecruitmentDistribution.getMatrix() != null){
                getBean().setRecruitmentDistribution(fieldPopulationRecruitmentDistribution.getMatrix().copy());
            }
        }
    }
    
    @Override
    public void refresh() {
        Population population = getVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PopulationImpl) population);
    
        getVerifier().addCurrentPanel(reproductionEquation);
    
        if (getBean() != null && getBean().getRecruitmentDistribution() != null) {
            fieldPopulationRecruitmentDistribution.setMatrix(getBean().getRecruitmentDistribution().copy());
            
            // chatellier : number editor is not working
            //fieldPopulationMonthGapBetweenReproRecrutement.init();
        }
        
        // TODO add only once
        //fieldPopulationRecruitmentDistribution.addMatrixListener(listener);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationRecruitmentUI() {
        super();
        $initialize();
    }

    public PopulationRecruitmentUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("reproductionEquation.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource8);
        
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPopulationMonthGapBetweenReproRecrutement.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationMonthGapBetweenReproRecrutement.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("monthGapBetweenReproRecrutement", $DataSource12);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("fieldPopulationRecruitmentDistribution.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldPopulationRecruitmentDistribution.matrix".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("recruitmentDistribution", $DataSource15);
            }if ( getBean() != null) {
                 getBean().addPropertyChangeListener("recruitmentDistribution", $DataSource15);
            }
        } else if ("create.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPopulationRecruitmentComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldPopulationRecruitmentComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("recruitmentComment", $DataSource19);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("reproductionEquation.bean".equals($dest)) {
            reproductionEquation.setBean((getBean()));
            } else if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMonthGapBetweenReproRecrutement.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMonthGapBetweenReproRecrutement.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMonthGapBetweenReproRecrutement.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationMonthGapBetweenReproRecrutement, String.valueOf((getBean().getMonthGapBetweenReproRecrutement())));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationRecruitmentDistribution.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationRecruitmentDistribution.setEnabled((isActif()));
            }
            } else if ("fieldPopulationRecruitmentDistribution.matrix".equals($dest)) {
            if ( getBean() != null) {
                fieldPopulationRecruitmentDistribution.setMatrix((getBean().getRecruitmentDistribution() == null ? null : getBean().getRecruitmentDistribution().copy()));
            }
            } else if ("create.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                create.setEnabled((isActif()));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldPopulationRecruitmentComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationRecruitmentComment.setEnabled((isActif()));
            }
            } else if ("fieldPopulationRecruitmentComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationRecruitmentComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getRecruitmentComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("reproductionEquation.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource8);
        
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPopulationMonthGapBetweenReproRecrutement.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationMonthGapBetweenReproRecrutement.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource12);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("monthGapBetweenReproRecrutement", $DataSource12);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("fieldPopulationRecruitmentDistribution.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("fieldPopulationRecruitmentDistribution.matrix".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource15);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("recruitmentDistribution", $DataSource15);
            }if ( getBean() != null) {
                 getBean().removePropertyChangeListener("recruitmentDistribution", $DataSource15);
            }
        } else if ("create.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("fieldPopulationRecruitmentComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldPopulationRecruitmentComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource19);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("recruitmentComment", $DataSource19);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__create(java.awt.event.ActionEvent event) {
        getAction().createRecruitmentDistribution(getBean());
    }

    public void doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement(java.awt.event.KeyEvent event) {
        getBean().setMonthGapBetweenReproRecrutement(Integer.parseInt(fieldPopulationMonthGapBetweenReproRecrutement.getText()));
    }

    public void doKeyReleased__on__fieldPopulationRecruitmentComment(java.awt.event.KeyEvent event) {
        getBean().setRecruitmentComment(fieldPopulationRecruitmentComment.getText());
    }

    public void doMatrixChanged__on__fieldPopulationRecruitmentDistribution(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationRecruitmentDistributionMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JButton getCreate() {
        return create;
    }

    public javax.swing.JTextField getFieldPopulationMonthGapBetweenReproRecrutement() {
        return fieldPopulationMonthGapBetweenReproRecrutement;
    }

    public javax.swing.JTextArea getFieldPopulationRecruitmentComment() {
        return fieldPopulationRecruitmentComment;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getFieldPopulationRecruitmentDistribution() {
        return fieldPopulationRecruitmentDistribution;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getReproductionEquation() {
        return reproductionEquation;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationRecruitmentUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected javax.swing.JScrollPane get$JScrollPane6() {
        return $JScrollPane6;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table7() {
        return $Table7;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(reproductionEquation), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationMonthGapBetweenReproRecrutement), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentDistribution), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(create), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel5, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JScrollPane6, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        addChildrenToReproductionEquation();
        
        addChildrenToFieldPopulationMonthGapBetweenReproRecrutement();
        
        addChildrenToFieldPopulationRecruitmentDistribution();
        
        
        $JScrollPane6.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationRecruitmentComment));
        
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        applyDataBinding("reproductionEquation.bean");
        reproductionEquation.setClazz((fr.ifremer.isisfish.equation.PopulationReproductionEquation.class));
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldPopulationMonthGapBetweenReproRecrutement.enabled");
        applyDataBinding("fieldPopulationMonthGapBetweenReproRecrutement.text");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationRecruitmentDistribution.enabled");
        applyDataBinding("fieldPopulationRecruitmentDistribution.matrix");
        applyDataBinding("create.enabled");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldPopulationRecruitmentComment.enabled");
        applyDataBinding("fieldPopulationRecruitmentComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        createReproductionEquation();
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationRecruitment.monthgapgetweenreprorecruitment"));
        
        createFieldPopulationMonthGapBetweenReproRecrutement();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationRecruitment.recruitmentDistribution"));
        
        createFieldPopulationRecruitmentDistribution();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        
        createCreate();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.populationRecruitment.comments"));
        
        $JScrollPane6 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane6", $JScrollPane6);
        $JScrollPane6.setName("$JScrollPane6");
        
        createFieldPopulationRecruitmentComment();
        
        $Table7 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table7", $Table7);
        $Table7.setName("$Table7");
        
        createSave();
        createCancel();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    //jaxx.runtime.SwingUtil.removeDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                    fieldPopulationMonthGapBetweenReproRecrutement.setText("");
                    fieldPopulationRecruitmentComment.setText("");
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    //jaxx.runtime.SwingUtil.applyDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table7, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldPopulationMonthGapBetweenReproRecrutement() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("bean", PopulationImpl.class);
        fieldPopulationMonthGapBetweenReproRecrutement.putClientProperty("method", "MonthGapBetweenReproRecrutement");
    }

    protected void addChildrenToFieldPopulationRecruitmentDistribution() {
        if (!allComponentsCreated) {
            return;
        }
        fieldPopulationRecruitmentDistribution.putClientProperty("bean", PopulationImpl.class);
        fieldPopulationRecruitmentDistribution.putClientProperty("method", "RecruitmentDistribution");
    }

    protected void addChildrenToReproductionEquation() {
        if (!allComponentsCreated) {
            return;
        }
        reproductionEquation.putClientProperty("bean", PopulationImpl.class);
        reproductionEquation.putClientProperty("method", "ReproductionEquation");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createCreate() {
        create = new javax.swing.JButton();
        $objectMap.put("create", create);
        create.setName("create");
        create.setText(_("isisfish.common.newMatrix"));
        create.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__create"));
    }

    protected void createFieldPopulationMonthGapBetweenReproRecrutement() {
        fieldPopulationMonthGapBetweenReproRecrutement = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationMonthGapBetweenReproRecrutement", fieldPopulationMonthGapBetweenReproRecrutement);
        fieldPopulationMonthGapBetweenReproRecrutement.setName("fieldPopulationMonthGapBetweenReproRecrutement");
        fieldPopulationMonthGapBetweenReproRecrutement.setColumns(15);
        fieldPopulationMonthGapBetweenReproRecrutement.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationMonthGapBetweenReproRecrutement"));
    }

    protected void createFieldPopulationRecruitmentComment() {
        fieldPopulationRecruitmentComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPopulationRecruitmentComment", fieldPopulationRecruitmentComment);
        fieldPopulationRecruitmentComment.setName("fieldPopulationRecruitmentComment");
        fieldPopulationRecruitmentComment.setColumns(15);
        fieldPopulationRecruitmentComment.setLineWrap(true);
        fieldPopulationRecruitmentComment.setWrapStyleWord(true);
        fieldPopulationRecruitmentComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationRecruitmentComment"));
    }

    protected void createFieldPopulationRecruitmentDistribution() {
        fieldPopulationRecruitmentDistribution = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("fieldPopulationRecruitmentDistribution", fieldPopulationRecruitmentDistribution);
        fieldPopulationRecruitmentDistribution.removeDataBinding("$MatrixEditor0.name");
        
        fieldPopulationRecruitmentDistribution.setName("fieldPopulationRecruitmentDistribution");
        fieldPopulationRecruitmentDistribution.removeDataBinding("$MatrixEditor0.enabled");
        
        fieldPopulationRecruitmentDistribution.removeDataBinding("$MatrixEditor0.matrix");
        
        
        
        
        
        
        
        
        
        
        
        
        fieldPopulationRecruitmentDistribution.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__fieldPopulationRecruitmentDistribution"));
    }

    protected void createReproductionEquation() {
        reproductionEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("reproductionEquation", reproductionEquation);
        reproductionEquation.removeDataBinding("$InputContentUI0.name");
        
        reproductionEquation.setName("reproductionEquation");
        reproductionEquation.removeDataBinding("$InputContentUI0.bean");
        
        reproductionEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        reproductionEquation.setBeanProperty("ReproductionEquation");
        reproductionEquation.removeDataBinding("$InputContentUI0.clazz");
        
        reproductionEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        reproductionEquation.setFormuleCategory("Reproduction");
        reproductionEquation.removeDataBinding("$InputContentUI0.text");
        
        reproductionEquation.setText(_("isisfish.populationRecruitment.reproductionEquation"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
