/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.ui.input.population.PopulationSeasonInfoComboModel;
import fr.ifremer.isisfish.ui.input.population.PopulationSeasonInfoComboRenderer;

public class PopulationMigrationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVWQW8bRRSemNhJ2qa0pSW0SklaXAmp0pqWhoo6UBo3VR05pWoSFOFWYuwdx1Nmd6Yzs+nmgpCQOCHUEwcuwJ0jd4Q4cuLKf0Co/4A3u/buTrJ1N3UOa/vN+773vXlv38uv/6KykujCYxyGjgx8TT3irN3a3v6085h09W2iupIKzSWK/yZKqNRGR93ErjR6p90y8NoAXmtwT3Cf+Bl0vYWOKL3HiOoTojU6EyO6StU2EnM9FIEcsiVi8th+fv5f6Zn79S8lhEIBquYghcWXodIMJluoRF2NTkGkXVxj2N8BGZL6O6Bz1tgaDCt1D3vkCfoKTbVQRWAJZBpdLJ5qxBHhQ6HRiWrTF4FucF+D+1bzPY2u9qRDe5J4BD4VVT2q+k5AHWocnftcBAxryv11uiOjL1tNISLGikaTHYJ9jS7ncUAAqilRGY6mJ1gKnhJcNP0e12ipIH6DYAUsgLGZ5hVh0CfEzXPV6KS5TMdcsLPCOQPJ2Qy4u6fRW1bd1FOogrOJO4ykntPVtRbuEHYFSmYIw4FbbDVOZxLfSz1KmJtzebGsRp9zRaRGCzlhTd9DRTt8hYc269mIdUuR1SeBTQu9bElq9En3ywP4Y33qmpzuY5+w/VlERtv/+DDeOoa+DDWasxBwPx24csAZ/wsJ7G1xMO9M92hUP2zLZdAmRjUJtZgTqul52WAfHTaYhbfDLeSEW7WiLR822uoLg53PCzYovAl149ChErBdr2FjXzW/z9ktMFtd2+hKzpgp8/v7OyA9slELL2p/6GsvmmB2u26SUN+SBBv4UjofqtEbeM38nLMDTCq8SzR6w2JZCbTmvvGoJ46VLva7cV/ftE9mDLuZD0sanct/+82pOAj4wBhu5xxcHx5IowwYYbM46WZJR/9EG5VlAGaYyO10CT0AU7x+BtaIILL+9M2Puz/89vuN4a45BTFmLZfMaoTZLyQXMGCoCfF6vGACTVltHYt6G83E8zLam6czAjYGZhAB/PHYNDDnLlZ9gJan/vnjzze/+Ps1VLqDjjCO3TvY+DfRjO5LyJIzNxQ3P4mUHHs6Dc8TRhPUkvimlrDuji+7WOPFDvVduOaPQ8j2dCbbRMJfz75bn//+/PVhxhOxon1uadblz1GF+oz6JNqrg5WZu0ePCkUCl6erMW9ZTpjPs2JQ5nvR80FeapMauhem6XIcfRFrGJadQBPIzYA+i8Sbb9sFOY150zy28hnmC6gqe9yN+34Mkmn4d8MlksixeF6WzkIRJcMNPxaPMT80j0evrqTC8B4P9AgdF8e+kUtFCgxvHu2NIHm3kIxvRzBcHpvBGZvhytiXeW3stijGMErDh8U1jGD4H28QbfknDQAA";
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected javax.swing.JButton cancel;
    protected javax.swing.JTextArea fieldPopulationMigrationComment;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationSeasonChooser;
    protected javax.swing.JCheckBox fieldUseEquationMigration;
    protected javax.swing.JTabbedPane fieldUseMatrix;
    protected javax.swing.JPanel hidablePanel;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl popInfo;
    protected fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI populationMigrationEmigrationUI;
    protected fr.ifremer.isisfish.ui.input.PopulationMigrationEquationUI populationMigrationEquationUI;
    protected fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI populationMigrationImmigrationUI;
    protected fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI populationMigrationMigrationUI;
    protected javax.swing.JButton save;
    protected java.lang.Boolean selectedPopulationSeasonInfo;
    private fr.ifremer.isisfish.ui.input.PopulationMigrationUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JScrollPane $JScrollPane3;
    private jaxx.runtime.swing.TabInfo $TabInfo5;
    private jaxx.runtime.swing.TabInfo $TabInfo6;
    private jaxx.runtime.swing.TabInfo $TabInfo7;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldUseEquationMigration.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldUseEquationMigration.selected");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldUseMatrix.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationMigrationUI.actif");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationImmigrationUI.actif");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationEmigrationUI.actif");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationEquationUI.actif");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationComment.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationComment.text");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel1.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationSeasonChooser.enabled");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        Population population = getVerifier().getEntity(Population.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((PopulationImpl) population);
    
        // refresh psi list in combo box
        PopulationSeasonInfoComboModel model = (PopulationSeasonInfoComboModel)fieldPopulationMigrationSeasonChooser.getModel();
        if (getBean() != null) {
            PopulationSeasonInfo previousSelected = (PopulationSeasonInfo)model.getSelectedItem();
            model.setPopulationSeasonInfos(getBean().getPopulationSeasonInfo());
            
            // do this to keep selected after cancel/refresh
            if (previousSelected != null) {
                for (PopulationSeasonInfo psi : getBean().getPopulationSeasonInfo()) {
                    if (psi.getTopiaId().equals(previousSelected.getTopiaId())) {
                        model.setSelectedItem(psi);
                    }
                }
            }
    
            seasonChanged();
        }
        else {
            model.setPopulationSeasonInfos(null);
        }
    
        getVerifier().addCurrentPanel(populationMigrationEquationUI, populationMigrationMigrationUI, populationMigrationImmigrationUI, populationMigrationEmigrationUI);
        // addCurrentPanel set all to isActif()
        // force it to isSelectedPopulationSeasonInfo()
        // twice for real change event :(
        setSelectedPopulationSeasonInfo(fieldPopulationMigrationSeasonChooser.getModel().getSelectedItem() == null);
        setSelectedPopulationSeasonInfo(fieldPopulationMigrationSeasonChooser.getModel().getSelectedItem() != null);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    
    protected void seasonChanged() {
        PopulationSeasonInfoComboModel model = (PopulationSeasonInfoComboModel)fieldPopulationMigrationSeasonChooser.getModel();
        PopulationSeasonInfo selectedPSI = (PopulationSeasonInfo)model.getSelectedItem();
        setPopInfo((PopulationSeasonInfoImpl)selectedPSI);
        if (getPopInfo() != null) {
            getVerifier().addCurrentEntity(getPopInfo());
            populationMigrationEquationUI.init(getPopInfo());
            populationMigrationMigrationUI.init(getPopInfo());
            populationMigrationImmigrationUI.init(getPopInfo());
            populationMigrationEmigrationUI.init(getPopInfo());
    
            setSelectedPopulationSeasonInfo(isActif());
        }
        else {
            setSelectedPopulationSeasonInfo(false);
        }
        refreshHidablePanel();
    }
    protected void useEquationChanged() {
        getPopInfo().setUseEquationMigration(fieldUseEquationMigration.isSelected());
        refreshHidablePanel();
    }
    protected void refreshHidablePanel() {
        if (getPopInfo() != null) {
            if (getPopInfo().getUseEquationMigration()) {
                fieldUseEquationMigration.setSelected(true);
                ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "fieldUseEquation");
            }
            else {
                fieldUseEquationMigration.setSelected(false);
                ((CardLayout) hidablePanel.getLayout()).show(hidablePanel, "fieldUseMatrix");
            }
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationMigrationUI() {
        super();
        $initialize();
    }

    public PopulationMigrationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("fieldPopulationMigrationSeasonChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldUseEquationMigration.enabled".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource12);
        
        } else if ("fieldUseEquationMigration.selected".equals($binding)) {
                addPropertyChangeListener("popInfo", $DataSource13);
        if (getPopInfo() != null) {
                getPopInfo().addPropertyChangeListener("useEquationMigration", $DataSource13);
            }
        } else if ("fieldUseMatrix.enabled".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource15);
        
        } else if ("populationMigrationMigrationUI.actif".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource17);
        
        } else if ("populationMigrationImmigrationUI.actif".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource19);
        
        } else if ("populationMigrationEmigrationUI.actif".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource21);
        
        } else if ("populationMigrationEquationUI.actif".equals($binding)) {
                addPropertyChangeListener("selectedPopulationSeasonInfo", $DataSource22);
        
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldPopulationMigrationComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldPopulationMigrationComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("migrationComment", $DataSource25);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel1.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel1.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationSeasonChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationSeasonChooser.setEnabled((isActif()));
            }
            } else if ("fieldUseEquationMigration.enabled".equals($dest)) {
            fieldUseEquationMigration.setEnabled((isSelectedPopulationSeasonInfo()));
            } else if ("fieldUseEquationMigration.selected".equals($dest)) {
            if (getPopInfo() != null) {
                fieldUseEquationMigration.setSelected((getPopInfo().getUseEquationMigration()));
            }
            } else if ("fieldUseMatrix.enabled".equals($dest)) {
            fieldUseMatrix.setEnabled((isSelectedPopulationSeasonInfo()));
            } else if ("populationMigrationMigrationUI.actif".equals($dest)) {
            populationMigrationMigrationUI.setActif((isSelectedPopulationSeasonInfo()));
            } else if ("populationMigrationImmigrationUI.actif".equals($dest)) {
            populationMigrationImmigrationUI.setActif((isSelectedPopulationSeasonInfo()));
            } else if ("populationMigrationEmigrationUI.actif".equals($dest)) {
            populationMigrationEmigrationUI.setActif((isSelectedPopulationSeasonInfo()));
            } else if ("populationMigrationEquationUI.actif".equals($dest)) {
            populationMigrationEquationUI.setActif((isSelectedPopulationSeasonInfo()));
            } else if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationComment.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldPopulationMigrationComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getMigrationComment()))));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("fieldPopulationMigrationSeasonChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldUseEquationMigration.enabled".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource12);
        
        } else if ("fieldUseEquationMigration.selected".equals($binding)) {
                removePropertyChangeListener("popInfo", $DataSource13);
        if (getPopInfo() != null) {
                getPopInfo().removePropertyChangeListener("useEquationMigration", $DataSource13);
            }
        } else if ("fieldUseMatrix.enabled".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource15);
        
        } else if ("populationMigrationMigrationUI.actif".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource17);
        
        } else if ("populationMigrationImmigrationUI.actif".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource19);
        
        } else if ("populationMigrationEmigrationUI.actif".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource21);
        
        } else if ("populationMigrationEquationUI.actif".equals($binding)) {
                removePropertyChangeListener("selectedPopulationSeasonInfo", $DataSource22);
        
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldPopulationMigrationComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldPopulationMigrationComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource25);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("migrationComment", $DataSource25);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldPopulationMigrationSeasonChooser(java.awt.event.ActionEvent event) {
        seasonChanged();
    }

    public void doActionPerformed__on__fieldUseEquationMigration(java.awt.event.ActionEvent event) {
        useEquationChanged();
    }

    public void doKeyReleased__on__fieldPopulationMigrationComment(java.awt.event.KeyEvent event) {
        getBean().setMigrationComment(fieldPopulationMigrationComment.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public javax.swing.JTextArea getFieldPopulationMigrationComment() {
        return fieldPopulationMigrationComment;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationSeasonChooser() {
        return fieldPopulationMigrationSeasonChooser;
    }

    public javax.swing.JCheckBox getFieldUseEquationMigration() {
        return fieldUseEquationMigration;
    }

    public javax.swing.JTabbedPane getFieldUseMatrix() {
        return fieldUseMatrix;
    }

    public javax.swing.JPanel getHidablePanel() {
        return hidablePanel;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopInfo() {
        return popInfo;
    }

    public fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI getPopulationMigrationEmigrationUI() {
        return populationMigrationEmigrationUI;
    }

    public fr.ifremer.isisfish.ui.input.PopulationMigrationEquationUI getPopulationMigrationEquationUI() {
        return populationMigrationEquationUI;
    }

    public fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI getPopulationMigrationImmigrationUI() {
        return populationMigrationImmigrationUI;
    }

    public fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI getPopulationMigrationMigrationUI() {
        return populationMigrationMigrationUI;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public java.lang.Boolean getSelectedPopulationSeasonInfo() {
        return selectedPopulationSeasonInfo;
    }

    public java.lang.Boolean isSelectedPopulationSeasonInfo() {
        return selectedPopulationSeasonInfo !=null && selectedPopulationSeasonInfo;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setPopInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.popInfo;
        this.popInfo = newValue;
        firePropertyChange("popInfo", oldValue, newValue);
    }

    public void setSelectedPopulationSeasonInfo(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.selectedPopulationSeasonInfo;
        this.selectedPopulationSeasonInfo = newValue;
        firePropertyChange("selectedPopulationSeasonInfo", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationMigrationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JScrollPane get$JScrollPane3() {
        return $JScrollPane3;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo5() {
        return $TabInfo5;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo6() {
        return $TabInfo6;
    }

    protected jaxx.runtime.swing.TabInfo get$TabInfo7() {
        return $TabInfo7;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        
        addChildrenToHidablePanel();
        addChildrenToFieldUseMatrix();
        addChildrenToPopulationMigrationMigrationUI();
        addChildrenToPopulationMigrationImmigrationUI();
        addChildrenToPopulationMigrationEmigrationUI();
        
        $JScrollPane3.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPopulationMigrationComment));
        
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        applyDataBinding("$JLabel1.enabled");
        applyDataBinding("fieldPopulationMigrationSeasonChooser.enabled");
        fieldPopulationMigrationSeasonChooser.setModel((new PopulationSeasonInfoComboModel()));
        fieldPopulationMigrationSeasonChooser.setRenderer((new PopulationSeasonInfoComboRenderer()));
        applyDataBinding("fieldUseEquationMigration.enabled");
        applyDataBinding("fieldUseEquationMigration.selected");
        applyDataBinding("fieldUseMatrix.enabled");
        $TabInfo5.setTitle((_("isisfish.populationMigrationMigration.title")));
        applyDataBinding("populationMigrationMigrationUI.actif");
        $TabInfo6.setTitle((_("isisfish.populationMigrationImmigration.title")));
        applyDataBinding("populationMigrationImmigrationUI.actif");
        $TabInfo7.setTitle((_("isisfish.populationMigrationEmigration.title")));
        applyDataBinding("populationMigrationEmigrationUI.actif");
        applyDataBinding("populationMigrationEquationUI.actif");
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldPopulationMigrationComment.enabled");
        applyDataBinding("fieldPopulationMigrationComment.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopInfo();
        createSelectedPopulationSeasonInfo();
        
        $JLabel1 = new javax.swing.JLabel();
        $objectMap.put("$JLabel1", $JLabel1);
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.populationMigration.selectSeason"));
        
        createFieldPopulationMigrationSeasonChooser();
        createFieldUseEquationMigration();
        createHidablePanel();
        createFieldUseMatrix();
        createPopulationMigrationMigrationUI();
        createPopulationMigrationImmigrationUI();
        createPopulationMigrationEmigrationUI();
        createPopulationMigrationEquationUI();
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigration.comments"));
        
        $JScrollPane3 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane3", $JScrollPane3);
        $JScrollPane3.setName("$JScrollPane3");
        
        createFieldPopulationMigrationComment();
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        createSave();
        createCancel();
        
        $TabInfo5 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo5", $TabInfo5);
        
        $TabInfo6 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo6", $TabInfo6);
        
        $TabInfo7 = new jaxx.runtime.swing.TabInfo();
        $objectMap.put("$TabInfo7", $TabInfo7);
        
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldPopulationMigrationComment.setText("");
                    fieldUseEquationMigration.setSelected(false);
                }
                /*if (evt.getNewValue() != null) {
        
                }*/
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationSeasonChooser, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldUseEquationMigration), new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(hidablePanel, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.7, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel2, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JScrollPane3, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.3, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table4, new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToFieldUseMatrix() {
        if (!allComponentsCreated) {
            return;
        }
        fieldUseMatrix.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(populationMigrationMigrationUI));
        fieldUseMatrix.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(populationMigrationImmigrationUI));
        fieldUseMatrix.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(populationMigrationEmigrationUI));
        $TabInfo5.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(fieldUseMatrix, 0));
        $TabInfo6.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(fieldUseMatrix, 1));
        $TabInfo7.addPropertyChangeListener(new jaxx.runtime.swing.TabInfoPropertyChangeListener(fieldUseMatrix, 2));
    }

    protected void addChildrenToHidablePanel() {
        if (!allComponentsCreated) {
            return;
        }
        hidablePanel.add(fieldUseMatrix, "fieldUseMatrix");
        hidablePanel.add(populationMigrationEquationUI, "fieldUseEquation");
    }

    protected void addChildrenToPopulationMigrationEmigrationUI() {
        if (!allComponentsCreated) {
            return;
        }
        populationMigrationEmigrationUI.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        populationMigrationEmigrationUI.putClientProperty("method", "EmigrationMatrix");
    }

    protected void addChildrenToPopulationMigrationImmigrationUI() {
        if (!allComponentsCreated) {
            return;
        }
        populationMigrationImmigrationUI.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        populationMigrationImmigrationUI.putClientProperty("method", "ImmigrationMatrix");
    }

    protected void addChildrenToPopulationMigrationMigrationUI() {
        if (!allComponentsCreated) {
            return;
        }
        populationMigrationMigrationUI.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        populationMigrationMigrationUI.putClientProperty("method", "MigrationMatrix");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createFieldPopulationMigrationComment() {
        fieldPopulationMigrationComment = new javax.swing.JTextArea();
        $objectMap.put("fieldPopulationMigrationComment", fieldPopulationMigrationComment);
        fieldPopulationMigrationComment.setName("fieldPopulationMigrationComment");
        fieldPopulationMigrationComment.setColumns(15);
        fieldPopulationMigrationComment.setLineWrap(true);
        fieldPopulationMigrationComment.setWrapStyleWord(true);
        fieldPopulationMigrationComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationMigrationComment"));
    }

    protected void createFieldPopulationMigrationSeasonChooser() {
        fieldPopulationMigrationSeasonChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationSeasonChooser", fieldPopulationMigrationSeasonChooser);
        fieldPopulationMigrationSeasonChooser.setName("fieldPopulationMigrationSeasonChooser");
        fieldPopulationMigrationSeasonChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationSeasonChooser"));
    }

    protected void createFieldUseEquationMigration() {
        fieldUseEquationMigration = new javax.swing.JCheckBox();
        $objectMap.put("fieldUseEquationMigration", fieldUseEquationMigration);
        fieldUseEquationMigration.setName("fieldUseEquationMigration");
        fieldUseEquationMigration.setText(_("isisfish.populationMigration.useEquation"));
        fieldUseEquationMigration.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldUseEquationMigration"));
    }

    protected void createFieldUseMatrix() {
        fieldUseMatrix = new javax.swing.JTabbedPane();
        $objectMap.put("fieldUseMatrix", fieldUseMatrix);
        fieldUseMatrix.setName("fieldUseMatrix");
    }

    protected void createHidablePanel() {
        hidablePanel = new javax.swing.JPanel();
        $objectMap.put("hidablePanel", hidablePanel);
        hidablePanel.setName("hidablePanel");
        hidablePanel.setLayout((new CardLayout()));
    }

    protected void createPopInfo() {
        popInfo = null;
        $objectMap.put("popInfo", popInfo);
    }

    protected void createPopulationMigrationEmigrationUI() {
        populationMigrationEmigrationUI =  new fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI(this);
        $objectMap.put("populationMigrationEmigrationUI", populationMigrationEmigrationUI);
        populationMigrationEmigrationUI.removeDataBinding("$InputContentUI0.name");
        
        populationMigrationEmigrationUI.setName("populationMigrationEmigrationUI");
        populationMigrationEmigrationUI.removeDataBinding("$InputContentUI0.actif");
    }

    protected void createPopulationMigrationEquationUI() {
        populationMigrationEquationUI =  new fr.ifremer.isisfish.ui.input.PopulationMigrationEquationUI(this);
        $objectMap.put("populationMigrationEquationUI", populationMigrationEquationUI);
        populationMigrationEquationUI.removeDataBinding("$InputContentUI0.name");
        
        populationMigrationEquationUI.setName("populationMigrationEquationUI");
        populationMigrationEquationUI.removeDataBinding("$InputContentUI0.actif");
    }

    protected void createPopulationMigrationImmigrationUI() {
        populationMigrationImmigrationUI =  new fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI(this);
        $objectMap.put("populationMigrationImmigrationUI", populationMigrationImmigrationUI);
        populationMigrationImmigrationUI.removeDataBinding("$InputContentUI0.name");
        
        populationMigrationImmigrationUI.setName("populationMigrationImmigrationUI");
        populationMigrationImmigrationUI.removeDataBinding("$InputContentUI0.actif");
    }

    protected void createPopulationMigrationMigrationUI() {
        populationMigrationMigrationUI =  new fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI(this);
        $objectMap.put("populationMigrationMigrationUI", populationMigrationMigrationUI);
        populationMigrationMigrationUI.removeDataBinding("$InputContentUI0.name");
        
        populationMigrationMigrationUI.setName("populationMigrationMigrationUI");
        populationMigrationMigrationUI.removeDataBinding("$InputContentUI0.actif");
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

    protected void createSelectedPopulationSeasonInfo() {
        selectedPopulationSeasonInfo = false;
        $objectMap.put("selectedPopulationSeasonInfo", selectedPopulationSeasonInfo);
    }

}
