/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.Zone;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationMigrationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVVS2/TQBDepk8o5dEWhASoD4qQoDiFUoEo4tGUQlBSEAVUNRc28SZZ5Owuu+tiOCAkrghx4sAFuHPkjhBHTlz5DwjxD5i1nThGJolwDhtnPPPNN7MzXz7+RINKopmH2PMs6TJNG8S6eXVz81b5IanoVaIqkgrNJQo+fRmUKaFRu2VXGh0tFUx4NgzP5nhDcEZYW/RyAe1U+olDVJ0QrdH+IKKiVHajZV72hCubaC0ySWjvf//KvLaff8gg5AlgNQElTHeLiioYKKAMtTUah0zbOOtgVgMakrIa8BwztpyDlVrHDfIIPUPDBTQksAQwjWZ7L9XH8OM9odHeuTwTrs5xpsH9Xn5Bo+WqtGhVkgaBb0VVlaq65VKLGkfrNheugzXlrEhrMv5wLy+EDz2k0UCZYKbRySQwyEQ1JaoNLN8QThQ8LLjIsyrXaKnH+A2CFaBATBxpVw18NogDQ0OgtftMFy3TWWuFcwcoRq7jT6FlqwRaqpsB5s1k5DFhPK5KSbex8w+X0Qon1XXO7lOb/PVqoMztJxodjA2EegzXa93FZYdEniNzNwu4TJzTQMoQ9kK3wGqcDrV8T1UpcexOt3Jdclfk6pwrIjWaSkhvFgtGpsxXuBdHbzI5Y35Px9/Nd82cg15UaYX6I3ogVsld4uk1E5+cbzEh31LXfMHluZJswT2FFZvgo8lJziYkWeyaJLz/zin6sQ3TNhErecXVmrO434zokMmfCugzlzWLuRSCrQbWdXNI6lk12Mmi/3gbM+Jcs8FDxuGHYHH4tj+Ii+EbaVjBBIDGWZHGRSLUV0KD0gUzaEMpksM7YAqEMLT6AL713Yu3228+fb7QVL1xyDEWc2kTaVAhIbmASaQmxZ5A6lxNnWwRi+US2qH8xfIVfLKNwEZoBhKAH+yxCbNuYFWH0MHhH1++HnjwvR9l1tBOh2N7DRv/PNqh6xKq5I7tictXfCa7Ho/AuddwArEhzDQa7mv3RRtrPF2mzIYbu+RBtZNt1bYofHv9snj41ZFzzYr7AkZ/uUVVD26hIcocyoiv8KF4Jyr6qFDEtXkk0kmy3We+p0QoGJf8cyWptAENawYicjHIPo01jEvZ1QRqM0FrPnnzdKNHTGNeNce1ZITZ1AjHekIomKOYBqETh+OpEU6krqI3hE4c5lMjWKmr6A2hE4eF1AhnUlfRG0InDks9bOuo2VEsi9wO/uT/G6obmfOpG2IQ/gCkEeDGpAsAAA==";
    protected javax.swing.JButton add;
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected java.lang.Boolean coefNonVide;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationMigrationArrivalZoneChooser;
    protected javax.swing.JTextField fieldPopulationMigrationMigrationCoefficient;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationMigrationDepartureZoneChooser;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationMigrationGroupChooser;
    protected java.lang.Boolean gPopSelected;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl popInfo;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor populationMigrationMigrationTable;
    protected javax.swing.JButton remove;
    protected java.lang.Boolean zoneArrivalSelected;
    protected java.lang.Boolean zoneDepartSelected;
    private fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationMigrationDepartureZoneChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationMigrationArrivalZoneChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "add.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationMigrationTable.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "remove.enabled");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel1.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationMigrationGroupChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationMigrationCoefficient.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");

    /* begin raw body code */    
    
    protected void populationMigrationMigrationMatrixChanged(MatrixPanelEvent event) {
        if (getPopInfo() != null) {
             getPopInfo().setMigrationMatrix(populationMigrationMigrationTable.getMatrix().clone());
        }
    }
    public void init(PopulationSeasonInfo pi) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setPopInfo(null);
        setPopInfo((PopulationSeasonInfoImpl)pi);
    
        if (getPopInfo() != null && getPopInfo().getMigrationMatrix() != null){
            populationMigrationMigrationTable.setMatrix(getPopInfo().getMigrationMatrix().copy());
        }
    }
    
    @Override
    public void refresh() {
        Population population = getVerifier().getEntity(Population.class);
        // setBean(null); is useless here
        setBean((PopulationImpl) population);
        
        refreshPanel();
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    public void refreshPanel(){
        setFieldPopulationMigrationMigrationGroupChooserModel();
        setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
        setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
    
        //populationMigrationMigrationTable.addMatrixListener(listener);
    
        remove.setEnabled(false);
        setAddButton();
    }
    protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
        if (getBean() != null && getBean().getPopulationGroup() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationGroupChooser,getBean().getPopulationGroup(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationDepartureZoneChooser,getBean().getPopulationZone(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationMigrationArrivalZoneChooser,getBean().getPopulationZone(), null, true);
        }
    }
    protected void add(){
        getAction().addMigration(getPopInfo(),
                (PopulationGroup) fieldPopulationMigrationMigrationGroupChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem(),
                Double.parseDouble(fieldPopulationMigrationMigrationCoefficient.getText()));
        populationMigrationMigrationTable.setMatrix(getPopInfo().getMigrationMatrix().clone());
    }
    protected void remove(){
      int row = populationMigrationMigrationTable.getTable().getSelectedRow();
      Object group = populationMigrationMigrationTable.getTable().getValueAt(row, 0);
      Object departure = populationMigrationMigrationTable.getTable().getValueAt(row, 1);
      Object arrival = populationMigrationMigrationTable.getTable().getValueAt(row, 2);
    
      MatrixND mat = getPopInfo().getMigrationMatrix().clone();
      mat.setValue(group, departure, arrival, 0);
      getPopInfo().setMigrationMatrix(mat);
      remove.setEnabled(false);
    }
    protected void groupChanged(){
        setGPopSelected(fieldPopulationMigrationMigrationGroupChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void coefChanged(){
        setCoefNonVide(!fieldPopulationMigrationMigrationCoefficient.getText().equals(""));
        setAddButton();
    }
    protected void zoneDepartueChanged(){
        setZoneDepartSelected(fieldPopulationMigrationMigrationDepartureZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void zoneArrivalChanged(){
        setZoneArrivalSelected(fieldPopulationMigrationMigrationArrivalZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void setAddButton(){
        add.setEnabled(getGPopSelected() && getZoneDepartSelected() && getZoneArrivalSelected() && getCoefNonVide());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationMigrationMigrationUI() {
        super();
        $initialize();
    }

    public PopulationMigrationMigrationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldPopulationMigrationMigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource6);
            }
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource7);
            }
        } else if ("fieldPopulationMigrationMigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldPopulationMigrationMigrationDepartureZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationMigrationMigrationArrivalZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("populationMigrationMigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel1.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel1.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationMigrationGroupChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationMigrationGroupChooser.setEnabled((isActif()));
            }
            } else if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationMigrationCoefficient.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationMigrationCoefficient.setEnabled((isActif()));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationMigrationDepartureZoneChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationMigrationDepartureZoneChooser.setEnabled((isActif()));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationMigrationArrivalZoneChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationMigrationArrivalZoneChooser.setEnabled((isActif()));
            }
            } else if ("add.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                add.setEnabled((isActif()));
            }
            } else if ("populationMigrationMigrationTable.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                populationMigrationMigrationTable.setEnabled((isActif()));
            }
            } else if ("remove.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                remove.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldPopulationMigrationMigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource6);
            }
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource7);
            }
        } else if ("fieldPopulationMigrationMigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldPopulationMigrationMigrationDepartureZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("fieldPopulationMigrationMigrationArrivalZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("populationMigrationMigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationMigrationArrivalZoneChooser(java.awt.event.ActionEvent event) {
        zoneArrivalChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationMigrationDepartureZoneChooser(java.awt.event.ActionEvent event) {
        zoneDepartueChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationMigrationGroupChooser(java.awt.event.ActionEvent event) {
        groupChanged();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationMigrationCoefficient(java.awt.event.KeyEvent event) {
        coefChanged();
    }

    public void doMatrixChanged__on__populationMigrationMigrationTable(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationMigrationMigrationMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAdd() {
        return add;
    }

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public java.lang.Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationMigrationArrivalZoneChooser() {
        return fieldPopulationMigrationMigrationArrivalZoneChooser;
    }

    public javax.swing.JTextField getFieldPopulationMigrationMigrationCoefficient() {
        return fieldPopulationMigrationMigrationCoefficient;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationMigrationDepartureZoneChooser() {
        return fieldPopulationMigrationMigrationDepartureZoneChooser;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationMigrationGroupChooser() {
        return fieldPopulationMigrationMigrationGroupChooser;
    }

    public java.lang.Boolean getGPopSelected() {
        return gPopSelected;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopInfo() {
        return popInfo;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getPopulationMigrationMigrationTable() {
        return populationMigrationMigrationTable;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public java.lang.Boolean getZoneArrivalSelected() {
        return zoneArrivalSelected;
    }

    public java.lang.Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public java.lang.Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public java.lang.Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public java.lang.Boolean isZoneArrivalSelected() {
        return zoneArrivalSelected !=null && zoneArrivalSelected;
    }

    public java.lang.Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setCoefNonVide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.coefNonVide;
        this.coefNonVide = newValue;
        firePropertyChange("coefNonVide", oldValue, newValue);
    }

    public void setGPopSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.gPopSelected;
        this.gPopSelected = newValue;
        firePropertyChange("gPopSelected", oldValue, newValue);
    }

    public void setPopInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.popInfo;
        this.popInfo = newValue;
        firePropertyChange("popInfo", oldValue, newValue);
    }

    public void setZoneArrivalSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.zoneArrivalSelected;
        this.zoneArrivalSelected = newValue;
        firePropertyChange("zoneArrivalSelected", oldValue, newValue);
    }

    public void setZoneDepartSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = newValue;
        firePropertyChange("zoneDepartSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationMigrationMigrationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        
        
        
        
        applyDataBinding("$JLabel1.enabled");
        applyDataBinding("fieldPopulationMigrationMigrationGroupChooser.enabled");
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldPopulationMigrationMigrationCoefficient.enabled");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationMigrationMigrationDepartureZoneChooser.enabled");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldPopulationMigrationMigrationArrivalZoneChooser.enabled");
        applyDataBinding("add.enabled");
        applyDataBinding("populationMigrationMigrationTable.enabled");
        populationMigrationMigrationTable.setLinearModel((true));
        applyDataBinding("remove.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createZoneArrivalSelected();
        createCoefNonVide();
        
        $JLabel1 = new javax.swing.JLabel();
        $objectMap.put("$JLabel1", $JLabel1);
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.common.populationGroup"));
        
        createFieldPopulationMigrationMigrationGroupChooser();
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigrationMigration.coefficient"));
        
        createFieldPopulationMigrationMigrationCoefficient();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationMigrationMigration.departureZone"));
        
        createFieldPopulationMigrationMigrationDepartureZoneChooser();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.populationMigrationMigration.arrivalZone"));
        
        createFieldPopulationMigrationMigrationArrivalZoneChooser();
        createAdd();
        createPopulationMigrationMigrationTable();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    //jaxx.runtime.SwingUtil.removeDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                    populationMigrationMigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    //jaxx.runtime.SwingUtil.applyDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                }
            }
        });populationMigrationMigrationTable.getTable().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                remove.setEnabled(populationMigrationMigrationTable.getTable().getSelectedRow() != -1);
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationMigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationMigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationMigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel4, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationMigrationArrivalZoneChooser, new GridBagConstraints(3, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(populationMigrationMigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAdd() {
        add = new javax.swing.JButton();
        $objectMap.put("add", add);
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCoefNonVide() {
        coefNonVide = false;
        $objectMap.put("coefNonVide", coefNonVide);
    }

    protected void createFieldPopulationMigrationMigrationArrivalZoneChooser() {
        fieldPopulationMigrationMigrationArrivalZoneChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationMigrationArrivalZoneChooser", fieldPopulationMigrationMigrationArrivalZoneChooser);
        fieldPopulationMigrationMigrationArrivalZoneChooser.setName("fieldPopulationMigrationMigrationArrivalZoneChooser");
        fieldPopulationMigrationMigrationArrivalZoneChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationMigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationCoefficient() {
        fieldPopulationMigrationMigrationCoefficient = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationMigrationMigrationCoefficient", fieldPopulationMigrationMigrationCoefficient);
        fieldPopulationMigrationMigrationCoefficient.setName("fieldPopulationMigrationMigrationCoefficient");
        fieldPopulationMigrationMigrationCoefficient.setColumns(15);
        fieldPopulationMigrationMigrationCoefficient.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationMigrationMigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationMigrationDepartureZoneChooser() {
        fieldPopulationMigrationMigrationDepartureZoneChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationMigrationDepartureZoneChooser", fieldPopulationMigrationMigrationDepartureZoneChooser);
        fieldPopulationMigrationMigrationDepartureZoneChooser.setName("fieldPopulationMigrationMigrationDepartureZoneChooser");
        fieldPopulationMigrationMigrationDepartureZoneChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationMigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationMigrationGroupChooser() {
        fieldPopulationMigrationMigrationGroupChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationMigrationGroupChooser", fieldPopulationMigrationMigrationGroupChooser);
        fieldPopulationMigrationMigrationGroupChooser.setName("fieldPopulationMigrationMigrationGroupChooser");
        fieldPopulationMigrationMigrationGroupChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationMigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        gPopSelected = false;
        $objectMap.put("gPopSelected", gPopSelected);
    }

    protected void createPopInfo() {
        popInfo = null;
        $objectMap.put("popInfo", popInfo);
    }

    protected void createPopulationMigrationMigrationTable() {
        populationMigrationMigrationTable = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("populationMigrationMigrationTable", populationMigrationMigrationTable);
        populationMigrationMigrationTable.removeDataBinding("$MatrixEditor0.name");
        
        populationMigrationMigrationTable.setName("populationMigrationMigrationTable");
        populationMigrationMigrationTable.removeDataBinding("$MatrixEditor0.enabled");
        
        populationMigrationMigrationTable.removeDataBinding("$MatrixEditor0.linearModel");
        
        
        
        
        
        
        
        
        
        
        
        
        populationMigrationMigrationTable.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__populationMigrationMigrationTable"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__remove"));
    }

    protected void createZoneArrivalSelected() {
        zoneArrivalSelected = false;
        $objectMap.put("zoneArrivalSelected", zoneArrivalSelected);
    }

    protected void createZoneDepartSelected() {
        zoneDepartSelected = false;
        $objectMap.put("zoneDepartSelected", zoneDepartSelected);
    }

}
