/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Zone;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationImmigrationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS28TMRB2Qx+UtkChVCDxKLRICNCGV4VEebWBQqoEEG1RRS44WScx2tjG9rYLB4TEFSFOHLgAd47cEeLIiSv/ASH+AWNvks2WJV0pOXid8cw334zH36dfaEBJdPQxDgJH+kzTBnGW5tfW7pYfk4q+QVRFUqG5ROGvL4MyJTTitu1Ko+lSwYRnm+HZHG8IzgjriJ4roB1KP/WIqhOiNdoXRlSUyi63zXOB8GULrU0mCe3Dn9+ZN+6LjxmEAgGsxqGEqa2iogr6CyhDXY32QKZ1nPUwqwENSVkNeI4ZW87DSt3BDfIEPUdDBTQosAQwjY6lL9Vi2PhAaLR7Js+Er3OcaXBfzZ/R6EpVOrQqSYPAV1FVparu+NShxtG5x4XvYU05K9KatJt8o9HaruaFsOCDGvWXCWYanUqCg1xUU6I64PIN4UXBQ4KLPKtyjWZTxi8TrAAFYuJIozXwWSYejA2B5o6bPjqmt84C5x5QjFz3PIOm3SDQVN0KMCcTkcdIhZPqHc4eUJdsOhqaWcFlj5zVaH/sytUGXKBjz4zncDtg+8xSAZeJdw4SG1JB0zW0GqcDbd9slRLP7d77W5L7IlfnXBGp0ZEEEuYBwWiU+QIP4vgtLufN/8PxMydF7hy0pUor1A7jZKyaFRLoRYOQnPFCQsbZFBnnpaTr2HsIN9as2QQf/SfJPcyIN7u5xdYa992GXRiPvTG3BV9rzuJ+06IrL3vRGp3msuYwn0K408C6bhZJA6cGD6lot5bCTRc8ZDzBIMw6X7fDcqZ5Ig0vuE4QJicSpkg5+kpoQPpghgddijTsPphC9WpaLYC1vn/5bv3t5y+XWlK1C3KMxVw6lBWkQ0guYKyoSbEr1CdfUy9bxGKuhIaVfS5Wdic6CCw3zUAC8MOnZ8Kc21jVIXRg6OfXb5OPfmxDmUW0w+PYXcTGP4+GdV1CldxzA3HtumUyurEd1t2GE7w2wkyj4cZ2XnaxxlNlyly4s6sBVDvRUW2bwvc3r4oHXx+62Kq4L2S0yS2qeuAhGqTMo4xYWW4qbqIMjwhFfJdHypqktX3me0g0BWPOrteSSuvX8GJgYC+H2aewhnEp+5pAbSYoZ8mb3c2UmMY8b5aFZISpnhGmUyHkzbLUC0I3Dsd7RjjRcxXpELpxONkzQrbnKtIhdONwLsWcj5jpxrLI3VCK/0Nma6ityMz23BCD8BfNdU5qkwoAAA==";
    protected javax.swing.JButton add;
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected java.lang.Boolean coefNonVide;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationImmigrationArrivalZoneChooser;
    protected javax.swing.JTextField fieldPopulationMigrationImmigrationCoefficient;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationImmigrationGroupChooser;
    protected java.lang.Boolean gPopSelected;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl popInfo;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor populationMigrationImmigrationTable;
    protected javax.swing.JButton remove;
    protected java.lang.Boolean zoneDepartSelected;
    private fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JPanel $JPanel5;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "add.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationImmigrationTable.enabled");
    private java.beans.PropertyChangeListener $DataSource14 = new jaxx.runtime.DataBindingListener($InputContentUI0, "remove.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationImmigrationGroupChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationImmigrationCoefficient.enabled");

    /* begin raw body code */    
    
    /*populationMigrationImmigrationTable.addMatrixListener(new MatrixPanelListener() {
        @Override
        public void matrixChanged(MatrixPanelEvent arg0) {
            if (getPopInfo() != null) {
                getPopInfo().setImmigrationMatrix(populationMigrationImmigrationTable.getMatrix().clone());
            }
        }
    });*/
    
    protected void populationMigrationImmigrationMatrixChanged(MatrixPanelEvent event) {
        if (getPopInfo() != null){
            getPopInfo().setImmigrationMatrix(populationMigrationImmigrationTable.getMatrix().clone());
        }
    }
    
    public void init(PopulationSeasonInfo pi) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setPopInfo(null);
        setPopInfo((PopulationSeasonInfoImpl)pi);
    
        populationMigrationImmigrationTable.setMatrix(getPopInfo().getImmigrationMatrix().copy());
    }
    
    @Override
    public void refresh(){
        Population population = getVerifier().getEntity(Population.class);
        setBean((PopulationImpl) population);
    
        refreshPanel();
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    public void refreshPanel(){
        setFieldPopulationMigrationMigrationGroupChooserModel();
        setFieldPopulationMigrationMigrationArrivalZoneChooserModel();
    
        remove.setEnabled(false);
        setAddButton();
    }
    protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
        if (getBean() != null && getBean().getPopulationGroup() != null){
             jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationImmigrationGroupChooser, getBean().getPopulationGroup(), null, true);
        }
    }
    protected void setFieldPopulationMigrationMigrationArrivalZoneChooserModel(){
        if (getBean() != null && getBean().getPopulationZone() != null){
            jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationImmigrationArrivalZoneChooser, getBean().getPopulationZone(), null, true);
        }
    }
    protected void add(){
        getContextValue(InputAction.class).addImmigration(getPopInfo(),
                (PopulationGroup) fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem(),
                (Zone) fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem(),
                Double.parseDouble(fieldPopulationMigrationImmigrationCoefficient.getText()));
        populationMigrationImmigrationTable.setMatrix(getPopInfo().getImmigrationMatrix().clone());
    }
    protected void remove(){
          int row = populationMigrationImmigrationTable.getTable().getSelectedRow();
          Object group = populationMigrationImmigrationTable.getTable().getValueAt(row, 0);
          Object departure = populationMigrationImmigrationTable.getTable().getValueAt(row, 1);
          Object arrival = populationMigrationImmigrationTable.getTable().getValueAt(row, 2);
    
          MatrixND mat = getPopInfo().getImmigrationMatrix().clone();
          mat.setValue(group, departure, arrival, 0);
          getPopInfo().setImmigrationMatrix(mat);
          remove.setEnabled(false);
    }
    protected void groupChanged(){
        setGPopSelected(fieldPopulationMigrationImmigrationGroupChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void coefChanged(){
        setCoefNonVide(!fieldPopulationMigrationImmigrationCoefficient.getText().equals(""));
        setAddButton();
    }
    protected void zoneChanged(){
        setZoneDepartSelected(fieldPopulationMigrationImmigrationArrivalZoneChooser.getSelectedItem() != null);
        setAddButton();
    }
    protected void setAddButton(){
        add.setEnabled(getGPopSelected() && getZoneDepartSelected() && getCoefNonVide());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationMigrationImmigrationUI() {
        super();
        $initialize();
    }

    public PopulationMigrationImmigrationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource6);
            }
        } else if ("fieldPopulationMigrationImmigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource7);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("fieldPopulationMigrationImmigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("populationMigrationImmigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource14);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationImmigrationGroupChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationImmigrationGroupChooser.setEnabled((isActif()));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationImmigrationCoefficient.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationImmigrationCoefficient.setEnabled((isActif()));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationImmigrationArrivalZoneChooser.setEnabled((isActif()));
            }
            } else if ("add.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                add.setEnabled((isActif()));
            }
            } else if ("populationMigrationImmigrationTable.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                populationMigrationImmigrationTable.setEnabled((isActif()));
            }
            } else if ("remove.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                remove.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource6);
            }
        } else if ("fieldPopulationMigrationImmigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource7);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("fieldPopulationMigrationImmigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("populationMigrationImmigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource14);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser(java.awt.event.ActionEvent event) {
        zoneChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser(java.awt.event.ActionEvent event) {
        groupChanged();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient(java.awt.event.KeyEvent event) {
        coefChanged();
    }

    public void doMatrixChanged__on__populationMigrationImmigrationTable(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationMigrationImmigrationMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAdd() {
        return add;
    }

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public java.lang.Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        return fieldPopulationMigrationImmigrationArrivalZoneChooser;
    }

    public javax.swing.JTextField getFieldPopulationMigrationImmigrationCoefficient() {
        return fieldPopulationMigrationImmigrationCoefficient;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationImmigrationGroupChooser() {
        return fieldPopulationMigrationImmigrationGroupChooser;
    }

    public java.lang.Boolean getGPopSelected() {
        return gPopSelected;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopInfo() {
        return popInfo;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getPopulationMigrationImmigrationTable() {
        return populationMigrationImmigrationTable;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public java.lang.Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public java.lang.Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public java.lang.Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public java.lang.Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setCoefNonVide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.coefNonVide;
        this.coefNonVide = newValue;
        firePropertyChange("coefNonVide", oldValue, newValue);
    }

    public void setGPopSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.gPopSelected;
        this.gPopSelected = newValue;
        firePropertyChange("gPopSelected", oldValue, newValue);
    }

    public void setPopInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.popInfo;
        this.popInfo = newValue;
        firePropertyChange("popInfo", oldValue, newValue);
    }

    public void setZoneDepartSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = newValue;
        firePropertyChange("zoneDepartSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationMigrationImmigrationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JPanel get$JPanel5() {
        return $JPanel5;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add($JLabel2, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldPopulationMigrationImmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel3, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldPopulationMigrationImmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JLabel4, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(fieldPopulationMigrationImmigrationArrivalZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel5, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(populationMigrationImmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldPopulationMigrationImmigrationGroupChooser.enabled");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationMigrationImmigrationCoefficient.enabled");
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldPopulationMigrationImmigrationArrivalZoneChooser.enabled");
        applyDataBinding("add.enabled");
        applyDataBinding("populationMigrationImmigrationTable.enabled");
        applyDataBinding("remove.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createCoefNonVide();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.common.populationGroup"));
        
        createFieldPopulationMigrationImmigrationGroupChooser();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationMigrationImmigration.coefficient"));
        
        createFieldPopulationMigrationImmigrationCoefficient();
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.populationMigrationImmigration.arrivalZone"));
        
        createFieldPopulationMigrationImmigrationArrivalZoneChooser();
        
        $JPanel5 = new javax.swing.JPanel();
        $objectMap.put("$JPanel5", $JPanel5);
        $JPanel5.setName("$JPanel5");
        
        createAdd();
        createPopulationMigrationImmigrationTable();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    //jaxx.runtime.SwingUtil.removeDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                    populationMigrationImmigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    //jaxx.runtime.SwingUtil.applyDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                }
            }
        });populationMigrationImmigrationTable.getTable().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                remove.setEnabled(populationMigrationImmigrationTable.getTable().getSelectedRow() != -1);
            }
        });
        $completeSetup();
    }

    protected void createAdd() {
        add = new javax.swing.JButton();
        $objectMap.put("add", add);
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createCoefNonVide() {
        coefNonVide = false;
        $objectMap.put("coefNonVide", coefNonVide);
    }

    protected void createFieldPopulationMigrationImmigrationArrivalZoneChooser() {
        fieldPopulationMigrationImmigrationArrivalZoneChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationImmigrationArrivalZoneChooser", fieldPopulationMigrationImmigrationArrivalZoneChooser);
        fieldPopulationMigrationImmigrationArrivalZoneChooser.setName("fieldPopulationMigrationImmigrationArrivalZoneChooser");
        fieldPopulationMigrationImmigrationArrivalZoneChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationImmigrationArrivalZoneChooser"));
    }

    protected void createFieldPopulationMigrationImmigrationCoefficient() {
        fieldPopulationMigrationImmigrationCoefficient = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationMigrationImmigrationCoefficient", fieldPopulationMigrationImmigrationCoefficient);
        fieldPopulationMigrationImmigrationCoefficient.setName("fieldPopulationMigrationImmigrationCoefficient");
        fieldPopulationMigrationImmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationImmigrationCoefficient.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationMigrationImmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationImmigrationGroupChooser() {
        fieldPopulationMigrationImmigrationGroupChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationImmigrationGroupChooser", fieldPopulationMigrationImmigrationGroupChooser);
        fieldPopulationMigrationImmigrationGroupChooser.setName("fieldPopulationMigrationImmigrationGroupChooser");
        fieldPopulationMigrationImmigrationGroupChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationImmigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        gPopSelected = false;
        $objectMap.put("gPopSelected", gPopSelected);
    }

    protected void createPopInfo() {
        popInfo = null;
        $objectMap.put("popInfo", popInfo);
    }

    protected void createPopulationMigrationImmigrationTable() {
        populationMigrationImmigrationTable = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("populationMigrationImmigrationTable", populationMigrationImmigrationTable);
        populationMigrationImmigrationTable.removeDataBinding("$MatrixEditor0.name");
        
        populationMigrationImmigrationTable.setName("populationMigrationImmigrationTable");
        populationMigrationImmigrationTable.removeDataBinding("$MatrixEditor0.enabled");
        
        populationMigrationImmigrationTable.removeDataBinding("$MatrixEditor0.linearModel");
        
        populationMigrationImmigrationTable.setLinearModel(true);
        
        
        
        
        
        
        
        
        
        
        
        populationMigrationImmigrationTable.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__populationMigrationImmigrationTable"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__remove"));
    }

    protected void createZoneDepartSelected() {
        zoneDepartSelected = false;
        $objectMap.put("zoneDepartSelected", zoneDepartSelected);
    }

}
