/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;

public class PopulationMigrationEquationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWUz08TQRTHXyst8kt+SjioQUTjwWzFxJAAQUmVWFPEiCTEXpx2p+2Q/THMvIWFgzHxagwnD17Uu0fvxnj05NX/wRj/A2empVuwWTe0h93N2/c++/3Oe6+ffkFGCri8TcLQEoGHzKXWw5WtrfXyNq3gPSorgnH0BTR+qTSkSzBgt+IS4UqpqMtzzfJc3ne571GvrXqxCP0S9x0q65QiwvlGRUXK3EYrvBjyQBzRWmI60T78+Z0+tF9+TAOEXKnKKgvT/6uKHPQUIc1shDH1pV2Sc4hXUzIE82pK55CO5R0i5SPi0h14Ab1FyHIiFAxhJrlVwzD1IUcYmS14PMC876FK3yzcRFioCotVBXWpuksmq0zWrYBZTCdaj30eOASZ762xmjAP93cCc98scG7IWYRe7vOCV/URbnfCqW8xZFS24TYokb6nawoud9pIs09J2aFzCFPHjlLuqYOxzDud2dcqGHVPCkPIxXoyR7Du0ciIRg23iGP0H6R+M3E8a5y5sWkCxo0BNV1WNF1R+1MlyIhAhVVXStEgPlGhxgg2owZgou9fvdt9+/nLwtG8jalvDB1LaVsP1X8ufE6FPneE4caQBcic3BrhiyXok9RRu2V2Z6JNwEYzrEQo/qgus3SZ9YDIuirN9P78+m3y+Y8zkF6Ffscn9irR+QXow7pQLn3HDvmdu0bJ4N5ZdR3RmhAyKo9VEc4t2QTJdJl5turpcqi8TrR5bQn4fvh67cKbi/NHflMNPSfSIs+ZZ5BlnsM8ajaruTQdN2mASxrYfrQcndYlpe/jvDmbl8x1ppOxnjIlpvdXw0Dfrhmx+ul6YsagZjxudGxfzeBSw8k0QfWXUA6QLp+enak45OCgS4HDVV+4asbyBGnNF/s68dbpcT1IQ+yKocOzMaYmExFudE2Yi3GRjDDftYalrjWsdE2I68VU171IRojrRTJCXC+SEeJ6kYwQ1wtN+AvBRrTjLwkAAA==";
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI emigrationEquation;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI immigrationEquation;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI migrationEquation;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl popInfo;
    private fr.ifremer.isisfish.ui.input.PopulationMigrationEquationUI $InputContentUI0 = this;
    private jaxx.runtime.swing.Table $Table1;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource2 = new jaxx.runtime.DataBindingListener($InputContentUI0, "migrationEquation.actif");
    private java.beans.PropertyChangeListener $DataSource3 = new jaxx.runtime.DataBindingListener($InputContentUI0, "migrationEquation.bean");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "emigrationEquation.actif");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "emigrationEquation.bean");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "immigrationEquation.actif");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "immigrationEquation.bean");

    /* begin raw body code */    
    
    public void init(PopulationSeasonInfo pi) {
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setPopInfo(null);
        setPopInfo((PopulationSeasonInfoImpl)pi);
    }
    
    @Override
    public void refresh() {
        getVerifier().addCurrentPanel(immigrationEquation, emigrationEquation, migrationEquation);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationMigrationEquationUI() {
        super();
        $initialize();
    }

    public PopulationMigrationEquationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("migrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource2);
            }
        } else if ("migrationEquation.bean".equals($binding)) {
                addPropertyChangeListener("popInfo", $DataSource3);
        
        } else if ("emigrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("emigrationEquation.bean".equals($binding)) {
                addPropertyChangeListener("popInfo", $DataSource6);
        
        } else if ("immigrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("immigrationEquation.bean".equals($binding)) {
                addPropertyChangeListener("popInfo", $DataSource9);
        
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("migrationEquation.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                migrationEquation.setActif((isActif()));
            }
            } else if ("migrationEquation.bean".equals($dest)) {
            migrationEquation.setBean((getPopInfo()));
            } else if ("emigrationEquation.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                emigrationEquation.setActif((isActif()));
            }
            } else if ("emigrationEquation.bean".equals($dest)) {
            emigrationEquation.setBean((getPopInfo()));
            } else if ("immigrationEquation.actif".equals($dest)) {
            if ($InputContentUI0 != null) {
                immigrationEquation.setActif((isActif()));
            }
            } else if ("immigrationEquation.bean".equals($dest)) {
            immigrationEquation.setBean((getPopInfo()));
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("migrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource2);
            }
        } else if ("migrationEquation.bean".equals($binding)) {
                removePropertyChangeListener("popInfo", $DataSource3);
        
        } else if ("emigrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("emigrationEquation.bean".equals($binding)) {
                removePropertyChangeListener("popInfo", $DataSource6);
        
        } else if ("immigrationEquation.actif".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("immigrationEquation.bean".equals($binding)) {
                removePropertyChangeListener("popInfo", $DataSource9);
        
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getEmigrationEquation() {
        return emigrationEquation;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getImmigrationEquation() {
        return immigrationEquation;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getMigrationEquation() {
        return migrationEquation;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopInfo() {
        return popInfo;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setPopInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.popInfo;
        this.popInfo = newValue;
        firePropertyChange("popInfo", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationMigrationEquationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(migrationEquation), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(emigrationEquation), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(immigrationEquation), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        
        addChildrenToMigrationEquation();
        addChildrenToEmigrationEquation();
        addChildrenToImmigrationEquation();
        applyDataBinding("migrationEquation.actif");
        applyDataBinding("migrationEquation.bean");
        migrationEquation.setClazz((fr.ifremer.isisfish.equation.MigrationEquation.class));
        applyDataBinding("emigrationEquation.actif");
        applyDataBinding("emigrationEquation.bean");
        emigrationEquation.setClazz((fr.ifremer.isisfish.equation.EmigrationEquation.class));
        applyDataBinding("immigrationEquation.actif");
        applyDataBinding("immigrationEquation.bean");
        immigrationEquation.setClazz((fr.ifremer.isisfish.equation.ImmigrationEquation.class));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createPopInfo();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        createMigrationEquation();
        createEmigrationEquation();
        createImmigrationEquation();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        $completeSetup();
    }

    protected void addChildrenToEmigrationEquation() {
        if (!allComponentsCreated) {
            return;
        }
        emigrationEquation.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        emigrationEquation.putClientProperty("method", "EmigrationEquation");
    }

    protected void addChildrenToImmigrationEquation() {
        if (!allComponentsCreated) {
            return;
        }
        immigrationEquation.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        immigrationEquation.putClientProperty("method", "ImmigrationEquation");
    }

    protected void addChildrenToMigrationEquation() {
        if (!allComponentsCreated) {
            return;
        }
        migrationEquation.putClientProperty("bean", PopulationSeasonInfoImpl.class);
        migrationEquation.putClientProperty("method", "MigrationEquation");
    }

    protected void createEmigrationEquation() {
        emigrationEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("emigrationEquation", emigrationEquation);
        emigrationEquation.removeDataBinding("$InputContentUI0.name");
        
        emigrationEquation.setName("emigrationEquation");
        emigrationEquation.removeDataBinding("$InputContentUI0.actif");
        
        emigrationEquation.removeDataBinding("$InputContentUI0.bean");
        
        emigrationEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        emigrationEquation.setBeanProperty("EmigrationEquation");
        emigrationEquation.removeDataBinding("$InputContentUI0.clazz");
        
        emigrationEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        emigrationEquation.setFormuleCategory("Emigration");
        emigrationEquation.removeDataBinding("$InputContentUI0.text");
        
        emigrationEquation.setText(_("isisfish.common.emigration"));
    }

    protected void createImmigrationEquation() {
        immigrationEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("immigrationEquation", immigrationEquation);
        immigrationEquation.removeDataBinding("$InputContentUI0.name");
        
        immigrationEquation.setName("immigrationEquation");
        immigrationEquation.removeDataBinding("$InputContentUI0.actif");
        
        immigrationEquation.removeDataBinding("$InputContentUI0.bean");
        
        immigrationEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        immigrationEquation.setBeanProperty("ImmigrationEquation");
        immigrationEquation.removeDataBinding("$InputContentUI0.clazz");
        
        immigrationEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        immigrationEquation.setFormuleCategory("Immigration");
        immigrationEquation.removeDataBinding("$InputContentUI0.text");
        
        immigrationEquation.setText(_("isisfish.common.immigration"));
    }

    protected void createMigrationEquation() {
        migrationEquation =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("migrationEquation", migrationEquation);
        migrationEquation.removeDataBinding("$InputContentUI0.name");
        
        migrationEquation.setName("migrationEquation");
        migrationEquation.removeDataBinding("$InputContentUI0.actif");
        
        migrationEquation.removeDataBinding("$InputContentUI0.bean");
        
        migrationEquation.removeDataBinding("$InputContentUI0.beanProperty");
        
        migrationEquation.setBeanProperty("MigrationEquation");
        migrationEquation.removeDataBinding("$InputContentUI0.clazz");
        
        migrationEquation.removeDataBinding("$InputContentUI0.formuleCategory");
        
        migrationEquation.setFormuleCategory("Migration");
        migrationEquation.removeDataBinding("$InputContentUI0.text");
        
        migrationEquation.setText(_("isisfish.common.migration"));
    }

    protected void createPopInfo() {
        popInfo = null;
        $objectMap.put("popInfo", popInfo);
    }

}
