/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Population;
import fr.ifremer.isisfish.entities.PopulationImpl;
import fr.ifremer.isisfish.entities.PopulationGroup;
import fr.ifremer.isisfish.entities.PopulationSeasonInfo;
import fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl;
import fr.ifremer.isisfish.entities.Zone;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.gui.MatrixPanelEvent;

public class PopulationMigrationEmigrationUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUS28TMRB20xdQChQKAolHgSIhHhteBYlWFBpaSJWUilKEmgtO1kmMNraxve3CASFxRagnDlyAO0fuCHHkxJX/gBD/gLE3yWbLkkRKDl5nPPPNN+Px9+kXGlQSHX+Cg8CRPtO0RpzFW48e3Ss+ISV9m6iSpEJzicJfXwqlCmjEbdqVRicLOROeroenM7wmOCOsJXo6h3Yo/cwjqkqI1mh/GFFSKr3SNE8HwpcNtCaZJLQPf36nNt2XH1MIBQJYjUEJE52iogoGcihFXY32QqZ1nPYwqwANSVkFeI4aW8bDSi3hGnmKXqDhHBoSWAKYRie6L9Vi2PhAaLRnMsuErzOcaXBfzV7QaKYsHVqWpEbgq6gqU1V1fOpQ4+gsc+F7WFPO8rQi7Wa+1titZoWw2EMaDRQJZhqdTUKDVFRTolrQsjXhRcHDgossK3ONprqMXyFYAQrExJF2VsBnhXgwNQR6O2ba6JjWOnOce0Axct37HHp2m0BPdSPAnIxHHiMlTspLnD2kLtlyNFDk7jONDsauW23A5TkPcNEjkee2ycUcLhLvImQ0bIK6W2g1Toeavk6ZEs9t2/M7kvsiU+VcEanRsYT85t3ARBT5HA/i8A0ql8z/o/Gz851TZ6AbZVqidgQPxGp5QAK9YACSE15OSHi1c8LwcnxJ1uCm6jWb6OP/ZFnGjHhXtnbYWuO+/diFsdgXc5vzteYs7ndCtCNmr1ijc1xWHOZTiHZqWFfNImngVOD55O3WMph3wUPG8YdgxPm6naoL9RNpaMFtghw5kRxFetFXQIPSBzM840KkXPfBFGpW3WoBrPX9q3frbz9/ud4QqN2QYzTm0qKnIBhCcgFTRU2K3aEq+Zp66TwW0wW0XdlXYsV2vIXASt0MJAA/fHEmzLmLVRVCB4d/fv124PGPfpRaQDs8jt0FbPyzaLuuSqiSe24gZm9aJjs3tsG6x3ACWSDMNBoubNeMizWeKFLmwpXdCKDa8ZZqmxS+b77OH35z5Fqj4r6Q0Ra3qOrBNTREmUcZsWJc19lE8R0Rivguj/Q0SWH7zPeIqL/+abvOJpU2oOHFwLzOhNknsIZxKfqaQG0mKGPJm918l5jGfMssc8kIEz0jnOwKIWuWxV4Q2nE41TPC6Z6r6A6hHYczPSOke66iO4R2HC51MecjZrqxzHM3VOL/kOkM1YnMVM8NMQh/AQH9Lv2JCgAA";
    protected javax.swing.JButton add;
    protected fr.ifremer.isisfish.entities.PopulationImpl bean;
    protected java.lang.Boolean coefNonVide;
    protected javax.swing.JTextField fieldPopulationMigrationEmigrationCoefficient;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationEmigrationDepartureZoneChooser;
    protected jaxx.runtime.swing.JAXXComboBox fieldPopulationMigrationEmigrationGroupChooser;
    protected java.lang.Boolean gPopSelected;
    protected fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl popInfo;
    protected org.nuiton.math.matrix.gui.MatrixPanelEditor populationMigrationEmigrationTable;
    protected javax.swing.JButton remove;
    protected java.lang.Boolean zoneDepartSelected;
    private fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel1;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JLabel $JLabel3;
    private javax.swing.JPanel $JPanel4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource10 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "add.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "populationMigrationEmigrationTable.enabled");
    private java.beans.PropertyChangeListener $DataSource13 = new jaxx.runtime.DataBindingListener($InputContentUI0, "remove.enabled");
    private java.beans.PropertyChangeListener $DataSource5 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel1.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationEmigrationGroupChooser.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPopulationMigrationEmigrationCoefficient.enabled");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel3.enabled");

    /* begin raw body code */    
    
        public void init(PopulationSeasonInfo pi){
            // add null before, for second to be considered as a changed event
            // otherwize, setBean has no effect
            setPopInfo(null);
            setPopInfo((PopulationSeasonInfoImpl)pi);
            populationMigrationEmigrationTable.setMatrix(getPopInfo().getEmigrationMatrix().copy());
        }
        
        @Override
        public void refresh(){
            Population population = getVerifier().getEntity(Population.class);
    
            // setBean(null); useless here
            setBean((PopulationImpl) population);
    
            refreshPanel();
        }
        
        @Override
        public void setActionButtons() {
    
        }
        
        public void refreshPanel() {
            setFieldPopulationMigrationMigrationGroupChooserModel();
            setFieldPopulationMigrationMigrationDepartureZoneChooserModel();
            remove.setEnabled(false);
            setAddButton();
    
            /*populationMigrationEmigrationTable.addMatrixListener(new MatrixPanelListener() {
                @Override
                public void matrixChanged(MatrixPanelEvent arg0) {
                    remove.setEnabled(populationMigrationEmigrationTable.getTable().getSelectedRow() != -1);
                    if (popInfo != null){
                        popInfo.setMigrationMatrix(populationMigrationEmigrationTable.getMatrix().clone());
                    }
                }
            });*/
        }
    
        protected void populationMigrationEmigrationMatrixChanged(MatrixPanelEvent event) {
            remove.setEnabled(populationMigrationEmigrationTable.getTable().getSelectedRow() != -1);
            if (popInfo != null){
                popInfo.setMigrationMatrix(populationMigrationEmigrationTable.getMatrix().clone());
            }
        }
    
        protected void setFieldPopulationMigrationMigrationGroupChooserModel(){
            if (getBean() != null && getBean().getPopulationGroup() != null){
                jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationEmigrationGroupChooser,getBean().getPopulationGroup(), null, true);
            }
        }
        protected void setFieldPopulationMigrationMigrationDepartureZoneChooserModel(){
            if (getBean() != null && getBean().getPopulationZone() != null){
                jaxx.runtime.SwingUtil.fillComboBox(fieldPopulationMigrationEmigrationDepartureZoneChooser,getBean().getPopulationZone(), null, true);
            }
        }
        protected void add(){
            getContextValue(InputAction.class).addEmigration(
                    getPopInfo(),
                    (PopulationGroup) fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem(),
                    (Zone) fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem(),
                    Double.parseDouble(fieldPopulationMigrationEmigrationCoefficient.getText()));
             populationMigrationEmigrationTable.setMatrix(getPopInfo().getEmigrationMatrix().clone());
        }
        
        protected void remove() {
            log.debug("removeEmigration called");
            try {
                int row = populationMigrationEmigrationTable.getTable().getSelectedRow();
                Object group = populationMigrationEmigrationTable.getTable().getValueAt(row, 0);
                Object departure = populationMigrationEmigrationTable.getTable().getValueAt(row, 1);
    
                MatrixND mat = popInfo.getEmigrationMatrix().clone();
                mat.setValue(group, departure, 0);
                popInfo.setEmigrationMatrix(mat);
                remove.setEnabled(false);
            } catch(Exception eee) {
                log.error("Can't remove migration", eee);
            }
        }
        protected void groupChanged() {
            setGPopSelected(fieldPopulationMigrationEmigrationGroupChooser.getSelectedItem() != null);
            setAddButton();
        }
        protected void coefChanged() {
            setCoefNonVide(!fieldPopulationMigrationEmigrationCoefficient.getText().equals(""));
            setAddButton();
        }
        protected void zoneChanged() {
            setZoneDepartSelected(fieldPopulationMigrationEmigrationDepartureZoneChooser.getSelectedItem() != null);
            setAddButton();
        }
        protected void setAddButton() {
            add.setEnabled(getGPopSelected() && getZoneDepartSelected() && getCoefNonVide());
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public PopulationMigrationEmigrationUI() {
        super();
        $initialize();
    }

    public PopulationMigrationEmigrationUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldPopulationMigrationEmigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource6);
            }
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource7);
            }
        } else if ("fieldPopulationMigrationEmigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource10);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource11);
            }
        } else if ("populationMigrationEmigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource12);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource13);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel1.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel1.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationEmigrationGroupChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationEmigrationGroupChooser.setEnabled((isActif()));
            }
            } else if ("$JLabel2.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel2.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationEmigrationCoefficient.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationEmigrationCoefficient.setEnabled((isActif()));
            }
            } else if ("$JLabel3.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel3.setEnabled((isActif()));
            }
            } else if ("fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldPopulationMigrationEmigrationDepartureZoneChooser.setEnabled((isActif()));
            }
            } else if ("add.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                add.setEnabled((isActif()));
            }
            } else if ("populationMigrationEmigrationTable.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                populationMigrationEmigrationTable.setEnabled((isActif()));
            }
            } else if ("remove.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                remove.setEnabled((isActif()));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel1.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource5);
            }
        } else if ("fieldPopulationMigrationEmigrationGroupChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource6);
            }
        } else if ("$JLabel2.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource7);
            }
        } else if ("fieldPopulationMigrationEmigrationCoefficient.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource8);
            }
        } else if ("$JLabel3.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource9);
            }
        } else if ("fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource10);
            }
        } else if ("add.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource11);
            }
        } else if ("populationMigrationEmigrationTable.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource12);
            }
        } else if ("remove.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource13);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__fieldPopulationMigrationEmigrationDepartureZoneChooser(java.awt.event.ActionEvent event) {
        zoneChanged();
    }

    public void doActionPerformed__on__fieldPopulationMigrationEmigrationGroupChooser(java.awt.event.ActionEvent event) {
        groupChanged();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    public void doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient(java.awt.event.KeyEvent event) {
        coefChanged();
    }

    public void doMatrixChanged__on__populationMigrationEmigrationTable(org.nuiton.math.matrix.gui.MatrixPanelEvent event) {
        populationMigrationEmigrationMatrixChanged(event);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAdd() {
        return add;
    }

    public fr.ifremer.isisfish.entities.PopulationImpl getBean() {
        return bean;
    }

    public java.lang.Boolean getCoefNonVide() {
        return coefNonVide;
    }

    public javax.swing.JTextField getFieldPopulationMigrationEmigrationCoefficient() {
        return fieldPopulationMigrationEmigrationCoefficient;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        return fieldPopulationMigrationEmigrationDepartureZoneChooser;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldPopulationMigrationEmigrationGroupChooser() {
        return fieldPopulationMigrationEmigrationGroupChooser;
    }

    public java.lang.Boolean getGPopSelected() {
        return gPopSelected;
    }

    public fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl getPopInfo() {
        return popInfo;
    }

    public org.nuiton.math.matrix.gui.MatrixPanelEditor getPopulationMigrationEmigrationTable() {
        return populationMigrationEmigrationTable;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public java.lang.Boolean getZoneDepartSelected() {
        return zoneDepartSelected;
    }

    public java.lang.Boolean isCoefNonVide() {
        return coefNonVide !=null && coefNonVide;
    }

    public java.lang.Boolean isGPopSelected() {
        return gPopSelected !=null && gPopSelected;
    }

    public java.lang.Boolean isZoneDepartSelected() {
        return zoneDepartSelected !=null && zoneDepartSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.PopulationImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setCoefNonVide(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.coefNonVide;
        this.coefNonVide = newValue;
        firePropertyChange("coefNonVide", oldValue, newValue);
    }

    public void setGPopSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.gPopSelected;
        this.gPopSelected = newValue;
        firePropertyChange("gPopSelected", oldValue, newValue);
    }

    public void setPopInfo(fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.PopulationSeasonInfoImpl oldValue = this.popInfo;
        this.popInfo = newValue;
        firePropertyChange("popInfo", oldValue, newValue);
    }

    public void setZoneDepartSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.zoneDepartSelected;
        this.zoneDepartSelected = newValue;
        firePropertyChange("zoneDepartSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.PopulationMigrationEmigrationUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel1() {
        return $JLabel1;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JLabel get$JLabel3() {
        return $JLabel3;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        
        
        
        
        applyDataBinding("$JLabel1.enabled");
        applyDataBinding("fieldPopulationMigrationEmigrationGroupChooser.enabled");
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldPopulationMigrationEmigrationCoefficient.enabled");
        applyDataBinding("$JLabel3.enabled");
        applyDataBinding("fieldPopulationMigrationEmigrationDepartureZoneChooser.enabled");
        applyDataBinding("add.enabled");
        applyDataBinding("populationMigrationEmigrationTable.enabled");
        applyDataBinding("remove.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createPopInfo();
        createGPopSelected();
        createZoneDepartSelected();
        createCoefNonVide();
        
        $JLabel1 = new javax.swing.JLabel();
        $objectMap.put("$JLabel1", $JLabel1);
        $JLabel1.setName("$JLabel1");
        $JLabel1.setText(_("isisfish.common.populationGroup"));
        
        createFieldPopulationMigrationEmigrationGroupChooser();
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.populationMigrationEmigration.coefficient"));
        
        createFieldPopulationMigrationEmigrationCoefficient();
        
        $JLabel3 = new javax.swing.JLabel();
        $objectMap.put("$JLabel3", $JLabel3);
        $JLabel3.setName("$JLabel3");
        $JLabel3.setText(_("isisfish.populationMigrationEmigration.departureZone"));
        
        createFieldPopulationMigrationEmigrationDepartureZoneChooser();
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        
        createAdd();
        createPopulationMigrationEmigrationTable();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    // remove previous binding on getBean()
                    //jaxx.runtime.SwingUtil.removeDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");fieldPopulationBasicsName.setText("");
                    populationMigrationEmigrationTable.setMatrix(null);
                }
                if (evt.getNewValue() != null) {
                    // add binding on getBean()
                    //jaxx.runtime.SwingUtil.applyDataBinding(get$Table0(), "fieldCellName.text", "fieldCellLongitude.text", "fieldCellLatitude.text", "fieldCellLand.selected", "fieldCellComment.text");
                }
            }
        });populationMigrationEmigrationTable.getTable().addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                remove.setEnabled(populationMigrationEmigrationTable.getTable().getSelectedRow() != -1);
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($JLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationEmigrationGroupChooser, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel2, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationEmigrationCoefficient, new GridBagConstraints(3, 0, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JLabel3, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        body.add(fieldPopulationMigrationEmigrationDepartureZoneChooser, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add($JPanel4, new GridBagConstraints(2, 1, 2, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(add, new GridBagConstraints(0, 2, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        body.add(populationMigrationEmigrationTable, new GridBagConstraints(0, 3, 4, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add(remove, new GridBagConstraints(0, 4, 4, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void createAdd() {
        add = new javax.swing.JButton();
        $objectMap.put("add", add);
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createCoefNonVide() {
        coefNonVide = false;
        $objectMap.put("coefNonVide", coefNonVide);
    }

    protected void createFieldPopulationMigrationEmigrationCoefficient() {
        fieldPopulationMigrationEmigrationCoefficient = new javax.swing.JTextField();
        $objectMap.put("fieldPopulationMigrationEmigrationCoefficient", fieldPopulationMigrationEmigrationCoefficient);
        fieldPopulationMigrationEmigrationCoefficient.setName("fieldPopulationMigrationEmigrationCoefficient");
        fieldPopulationMigrationEmigrationCoefficient.setColumns(15);
        fieldPopulationMigrationEmigrationCoefficient.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldPopulationMigrationEmigrationCoefficient"));
    }

    protected void createFieldPopulationMigrationEmigrationDepartureZoneChooser() {
        fieldPopulationMigrationEmigrationDepartureZoneChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationEmigrationDepartureZoneChooser", fieldPopulationMigrationEmigrationDepartureZoneChooser);
        fieldPopulationMigrationEmigrationDepartureZoneChooser.setName("fieldPopulationMigrationEmigrationDepartureZoneChooser");
        fieldPopulationMigrationEmigrationDepartureZoneChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationEmigrationDepartureZoneChooser"));
    }

    protected void createFieldPopulationMigrationEmigrationGroupChooser() {
        fieldPopulationMigrationEmigrationGroupChooser = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldPopulationMigrationEmigrationGroupChooser", fieldPopulationMigrationEmigrationGroupChooser);
        fieldPopulationMigrationEmigrationGroupChooser.setName("fieldPopulationMigrationEmigrationGroupChooser");
        fieldPopulationMigrationEmigrationGroupChooser.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldPopulationMigrationEmigrationGroupChooser"));
    }

    protected void createGPopSelected() {
        gPopSelected = false;
        $objectMap.put("gPopSelected", gPopSelected);
    }

    protected void createPopInfo() {
        popInfo = null;
        $objectMap.put("popInfo", popInfo);
    }

    protected void createPopulationMigrationEmigrationTable() {
        populationMigrationEmigrationTable = new org.nuiton.math.matrix.gui.MatrixPanelEditor();
        $objectMap.put("populationMigrationEmigrationTable", populationMigrationEmigrationTable);
        populationMigrationEmigrationTable.removeDataBinding("$MatrixEditor0.name");
        
        populationMigrationEmigrationTable.setName("populationMigrationEmigrationTable");
        populationMigrationEmigrationTable.removeDataBinding("$MatrixEditor0.enabled");
        
        populationMigrationEmigrationTable.removeDataBinding("$MatrixEditor0.linearModel");
        
        populationMigrationEmigrationTable.setLinearModel(true);
        
        
        
        
        
        
        
        
        
        
        
        populationMigrationEmigrationTable.addMatrixPanelListener((org.nuiton.math.matrix.gui.MatrixPanelListener) jaxx.runtime.Util.getEventListener(org.nuiton.math.matrix.gui.MatrixPanelListener.class, "matrixChanged", $InputContentUI0, "doMatrixChanged__on__populationMigrationEmigrationTable"));
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__remove"));
    }

    protected void createZoneDepartSelected() {
        zoneDepartSelected = false;
        $objectMap.put("zoneDepartSelected", zoneDepartSelected);
    }

}
