/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import fr.ifremer.isisfish.entities.Equation;
import fr.ifremer.isisfish.entities.MetierImpl;
import fr.ifremer.isisfish.entities.Species;
import fr.ifremer.isisfish.entities.TargetSpecies;
import fr.ifremer.isisfish.ui.input.metier.MetierSeasonInfoTargetSpeciesTableModel;
import fr.ifremer.isisfish.ui.input.metier.SpeciesComboModel;
import fr.ifremer.isisfish.ui.widget.editor.EquationTableEditor;

public class MetierSeasonInfoSpeciesEditorUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKVUz28bRRSeuHHSNA1NTEoBURFoJISQ1g0UVSLhR+Om1KlDK9xIFb4w3n22p+zObGfeJpscEBJXhHriwAW4c+SOEEdOXPkfEOI/4M3uZtcbjGNhH9b22/d973vvzXw//smqRrNXHvM4dnQkUQTg7N569Oh+9zG4eBuMq0WISrP0M1NhlQ5b9PK4QXat07LwegavN1QQKglyCL3ZYhcMHvlgBgCI7HKKcI2pt/PwZhxG+oQtFzOK7fu//6o89b74ocJYHJKqFWph7SxU0cFsi1WEh6xGlQ543eeyTzK0kH3SuWRjDZ8b8xEP4An7nM232FzINZEhe3XyVhOOBB+HyJbXmzKMsKEkUvp+8zqyrZ52RE9DAPRthOkJM3Ai4Qib6OwBCtBt4EbJpuypdgiuALPjCSqy3wzDhHsO2WwXuET22ig2KiWIxmRszSD0C+BycKoEso0JSIr8Mt3qMF0bfDo+QENesfN07IydbaV80lpALiPXfcCstROMfbk63J/yjpA9X9qvOaRtOQ9514cic349CWzYvy/Yx5X81fn13Rbvgv8mbd0KijOGNGqTXsxzaz0BvvdwWBqyl0eUt/eETkBXbau4THExbewOd2lZyOpjN50cjPsSdp5EHIWS+80yGWl/wCX4b53WnkTLuSuJ9gdaBFwfNTi6A5pyCdQYgPvZvwRno7sxYnTnuEdrfLZEsh0hKmkT3sjzltZ3265Wvm9lvY3sSglRvCqjamjrnhp2uc1EmU2/nqPmaJbqIAnWMz5tJdKKyFOcwlOKSz/TYVUd+ZZ+uVPYz8cUSo0niyYESfS7L789+Oann985cZka1VgqpQyZIt36UKsQNCYdXEqtJULh1/d4uNlhCyY53oljrg4JaGdhEkH86W2xMOcuNwOCVuf/+OXX5z79/Ryr3GEXfMW99FQ12QIONHWpfC8O3/8gUXLx8Dw9l60m2ilIOzla3jNbHke+1hXSo4m+F1O3q0Pd5hJ+e/rV3ktfX7150vFMquhUWtF19RM2J6QvJCSOmpnlSAddDA1EnipMcZRNztjvq2F2o99NnrdGtTaLEJMb17bS6mscyb67EQL1ZkE7iXj768MJOW24YR+3RzOsTaCqSosRvTEk1yZpzdr5lBxV1+fHx1OSXOopHdAhJxeBvtJHNrH1f+ls+N7UDOMW9PrUGiZjGKfBmVrD2QzIFgMhRRAFbXEMY8RsTEC1FGrogdbgTU121mxuTCBnQavDuyD6AxwzorOJcin/wXBz6jVZhn8AwG5QeDsLAAA=";
    protected javax.swing.JButton add;
    protected fr.ifremer.isisfish.entities.MetierImpl bean;
    protected javax.swing.JCheckBox fieldPrimaryCatch;
    protected jaxx.runtime.swing.JAXXComboBox fieldTargetSpecies;
    protected fr.ifremer.isisfish.entities.MetierSeasonInfoImpl metierSeasonInfo;
    protected java.lang.Boolean metierSeasonSelected;
    protected javax.swing.JButton remove;
    protected javax.swing.JTable tableTargetSpecies;
    protected fr.ifremer.isisfish.ui.input.InputOneEquationUI targetFactor;
    protected java.lang.Boolean targetSpeciesSelected;
    private fr.ifremer.isisfish.ui.input.MetierSeasonInfoSpeciesEditorUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel2;
    private javax.swing.JPanel $JPanel3;
    private javax.swing.JScrollPane $JScrollPane5;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table4;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource11 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldPrimaryCatch.enabled");
    private java.beans.PropertyChangeListener $DataSource12 = new jaxx.runtime.DataBindingListener($InputContentUI0, "add.enabled");
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "tableTargetSpecies.enabled");
    private java.beans.PropertyChangeListener $DataSource6 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel2.enabled");
    private java.beans.PropertyChangeListener $DataSource7 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldTargetSpecies.enabled");
    private java.beans.PropertyChangeListener $DataSource8 = new jaxx.runtime.DataBindingListener($InputContentUI0, "targetFactor.actif");
    private java.beans.PropertyChangeListener $DataSource9 = new jaxx.runtime.DataBindingListener($InputContentUI0, "targetFactor.bean");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        getVerifier().addCurrentPanel(targetFactor);
        if (getBean() != null) {
            setTableTargetSpeciesModel();
        }
        else {
            setTargetSpeciesModel();
        }
        setTargetSpeciesModel();
        remove.setEnabled(false);
        setAddButton();
        
        // is actif is not working for targetFactor
        // maybe set to true by addCurrentPanel
        targetFactor.setActif(targetSpeciesSelected);
    }
    
    @Override
    public void setActionButtons() {
    
    }
    
    protected void setTargetSpeciesModel() {
        java.util.List<Species> species = getRegion().getSpecies();
        SpeciesComboModel fieldTargetSpeciesModel = new SpeciesComboModel(species);
        fieldTargetSpecies.setModel(fieldTargetSpeciesModel);
    }
    
    protected void setTableTargetSpeciesModel() {
        if (getMetierSeasonInfo() != null) {
            java.util.List<TargetSpecies> targetSpecies = new ArrayList<TargetSpecies>();
            
            // SpeciesTargetSpecies can be null durring region creation
            if (getMetierSeasonInfo().getSpeciesTargetSpecies() != null) {
                // move collection to list
                // and add all entity to verifier
                for (TargetSpecies oneTargetSpecies : getMetierSeasonInfo().getSpeciesTargetSpecies()) {
                    getVerifier().addCurrentEntity(oneTargetSpecies);
                    targetSpecies.add(oneTargetSpecies);
                }
            }
            
            // set table model
            MetierSeasonInfoTargetSpeciesTableModel model = new MetierSeasonInfoTargetSpeciesTableModel(targetSpecies);
            tableTargetSpecies.setModel(model);
            tableTargetSpecies.setDefaultRenderer(Equation.class, model);
            tableTargetSpecies.setDefaultEditor(Equation.class, new EquationTableEditor());
        }
    }
    
    protected void add() {
        Species selectedSpecies = (Species)fieldTargetSpecies.getSelectedItem();
        if (getMetierSeasonInfo() != null && selectedSpecies != null) {
            // il n'y en a pas a la creaion de la base
            //Formule selectedFormule = (Formule)targetFactor.getFormuleComboBox().getSelectedItem();
            getContextValue(InputAction.class).addTargetSpecies(
                    getBean(),
                    getMetierSeasonInfo(),
                    selectedSpecies,
                    targetFactor.getEditor().getText(),
                    fieldPrimaryCatch.isSelected());
            setTableTargetSpeciesModel();
        }
    }
    
    protected void remove() {
        if (isMetierSeasonSelected()) {
            // TODO change delete selected truc from model
            Object[] targetSpecies = getMetierSeasonInfo().getSpeciesTargetSpecies().toArray();
    
            Object o = targetSpecies[tableTargetSpecies.getSelectedRow()];
            if (o != null) {
                TargetSpecies ts = (TargetSpecies)o;
                getAction().removeTargetSpecies(getMetierSeasonInfo(), ts);
                setTableTargetSpeciesModel();
            }
        }
    }
    
    protected void targetSpeciesChanged() {
        setTargetSpeciesSelected(fieldTargetSpecies.getSelectedItem() != null);
        setTableTargetSpeciesModel();
        setAddButton();
    }
    
    protected void setAddButton() {
        add.setEnabled(isMetierSeasonSelected() && isTargetSpeciesSelected());
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public MetierSeasonInfoSpeciesEditorUI() {
        super();
        $initialize();
    }

    public MetierSeasonInfoSpeciesEditorUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonSelected", $DataSource6);
        
        } else if ("fieldTargetSpecies.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonSelected", $DataSource7);
        
        } else if ("targetFactor.actif".equals($binding)) {
                addPropertyChangeListener("targetSpeciesSelected", $DataSource8);
        
        } else if ("targetFactor.bean".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource9);
        
        } else if ("fieldPrimaryCatch.enabled".equals($binding)) {
                addPropertyChangeListener("targetSpeciesSelected", $DataSource11);
        
        } else if ("add.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonSelected", $DataSource12);
        
        } else if ("tableTargetSpecies.enabled".equals($binding)) {
                addPropertyChangeListener("metierSeasonSelected", $DataSource15);
        
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel2.enabled".equals($dest)) {
            $JLabel2.setEnabled((isMetierSeasonSelected()));
            } else if ("fieldTargetSpecies.enabled".equals($dest)) {
            fieldTargetSpecies.setEnabled((isMetierSeasonSelected()));
            } else if ("targetFactor.actif".equals($dest)) {
            targetFactor.setActif((isTargetSpeciesSelected()));
            } else if ("targetFactor.bean".equals($dest)) {
            targetFactor.setBean((getBean()));
            } else if ("fieldPrimaryCatch.enabled".equals($dest)) {
            fieldPrimaryCatch.setEnabled((isTargetSpeciesSelected()));
            } else if ("add.enabled".equals($dest)) {
            add.setEnabled((isMetierSeasonSelected()));
            } else if ("tableTargetSpecies.enabled".equals($dest)) {
            tableTargetSpecies.setEnabled((isMetierSeasonSelected()));
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel2.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonSelected", $DataSource6);
        
        } else if ("fieldTargetSpecies.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonSelected", $DataSource7);
        
        } else if ("targetFactor.actif".equals($binding)) {
                removePropertyChangeListener("targetSpeciesSelected", $DataSource8);
        
        } else if ("targetFactor.bean".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource9);
        
        } else if ("fieldPrimaryCatch.enabled".equals($binding)) {
                removePropertyChangeListener("targetSpeciesSelected", $DataSource11);
        
        } else if ("add.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonSelected", $DataSource12);
        
        } else if ("tableTargetSpecies.enabled".equals($binding)) {
                removePropertyChangeListener("metierSeasonSelected", $DataSource15);
        
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__add(java.awt.event.ActionEvent event) {
        add();
    }

    public void doActionPerformed__on__fieldTargetSpecies(java.awt.event.ActionEvent event) {
        targetSpeciesChanged();
    }

    public void doActionPerformed__on__remove(java.awt.event.ActionEvent event) {
        remove();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public javax.swing.JButton getAdd() {
        return add;
    }

    public fr.ifremer.isisfish.entities.MetierImpl getBean() {
        return bean;
    }

    public javax.swing.JCheckBox getFieldPrimaryCatch() {
        return fieldPrimaryCatch;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldTargetSpecies() {
        return fieldTargetSpecies;
    }

    public fr.ifremer.isisfish.entities.MetierSeasonInfoImpl getMetierSeasonInfo() {
        return metierSeasonInfo;
    }

    public java.lang.Boolean getMetierSeasonSelected() {
        return metierSeasonSelected;
    }

    public javax.swing.JButton getRemove() {
        return remove;
    }

    public javax.swing.JTable getTableTargetSpecies() {
        return tableTargetSpecies;
    }

    public fr.ifremer.isisfish.ui.input.InputOneEquationUI getTargetFactor() {
        return targetFactor;
    }

    public java.lang.Boolean getTargetSpeciesSelected() {
        return targetSpeciesSelected;
    }

    public java.lang.Boolean isMetierSeasonSelected() {
        return metierSeasonSelected !=null && metierSeasonSelected;
    }

    public java.lang.Boolean isTargetSpeciesSelected() {
        return targetSpeciesSelected !=null && targetSpeciesSelected;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.MetierImpl newValue) {
        fr.ifremer.isisfish.entities.MetierImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setMetierSeasonInfo(fr.ifremer.isisfish.entities.MetierSeasonInfoImpl newValue) {
        fr.ifremer.isisfish.entities.MetierSeasonInfoImpl oldValue = this.metierSeasonInfo;
        this.metierSeasonInfo = newValue;
        firePropertyChange("metierSeasonInfo", oldValue, newValue);
    }

    public void setMetierSeasonSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.metierSeasonSelected;
        this.metierSeasonSelected = newValue;
        firePropertyChange("metierSeasonSelected", oldValue, newValue);
    }

    public void setTargetSpeciesSelected(java.lang.Boolean newValue) {
        java.lang.Boolean oldValue = this.targetSpeciesSelected;
        this.targetSpeciesSelected = newValue;
        firePropertyChange("targetSpeciesSelected", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.MetierSeasonInfoSpeciesEditorUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel2() {
        return $JLabel2;
    }

    protected javax.swing.JPanel get$JPanel3() {
        return $JPanel3;
    }

    protected javax.swing.JScrollPane get$JScrollPane5() {
        return $JScrollPane5;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table4() {
        return $Table4;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        
        addChildrenToBody();
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer($JLabel2), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldTargetSpecies), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(targetFactor), new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($JPanel3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldPrimaryCatch), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToTargetFactor();
        
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(add), new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add($JScrollPane5, new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table4.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(remove), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane5.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(tableTargetSpecies));
        
        applyDataBinding("$JLabel2.enabled");
        applyDataBinding("fieldTargetSpecies.enabled");
        applyDataBinding("targetFactor.actif");
        applyDataBinding("targetFactor.bean");
        targetFactor.setClazz((fr.ifremer.isisfish.equation.TargetSpeciesTargetFactorEquation.class));
        applyDataBinding("fieldPrimaryCatch.enabled");
        applyDataBinding("add.enabled");
        $JScrollPane5.setMinimumSize((new Dimension(0,0)));
        $JScrollPane5.setPreferredSize((new Dimension(0,0)));
        applyDataBinding("tableTargetSpecies.enabled");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createMetierSeasonInfo();
        createMetierSeasonSelected();
        createTargetSpeciesSelected();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JLabel2 = new javax.swing.JLabel();
        $objectMap.put("$JLabel2", $JLabel2);
        $JLabel2.setName("$JLabel2");
        $JLabel2.setText(_("isisfish.metierSeasonInfoSpecies.selectSpecies"));
        
        createFieldTargetSpecies();
        createTargetFactor();
        
        $JPanel3 = new javax.swing.JPanel();
        $objectMap.put("$JPanel3", $JPanel3);
        $JPanel3.setName("$JPanel3");
        
        createFieldPrimaryCatch();
        
        $Table4 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table4", $Table4);
        $Table4.setName("$Table4");
        
        createAdd();
        
        $JScrollPane5 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane5", $JScrollPane5);
        $JScrollPane5.setName("$JScrollPane5");
        
        createTableTargetSpecies();
        createRemove();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        tableTargetSpecies.addMouseListener(new MouseAdapter() {
            @Override
            public void mouseReleased(MouseEvent e) {
                remove.setEnabled(tableTargetSpecies.getSelectedRow() != -1);
            }
        });
        $completeSetup();
    }

    protected void addChildrenToBody() {
        if (!allComponentsCreated) {
            return;
        }
        body.add($Table1, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        body.add($Table4, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.5, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    protected void addChildrenToTargetFactor() {
        if (!allComponentsCreated) {
            return;
        }
        targetFactor.putClientProperty("bean", MetierImpl.class);
        targetFactor.putClientProperty("method", "");
    }

    protected void createAdd() {
        add = new javax.swing.JButton();
        $objectMap.put("add", add);
        add.setName("add");
        add.setText(_("isisfish.common.add"));
        add.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__add"));
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createBody() {
        body = new jaxx.runtime.swing.Table();
        $objectMap.put("body", body);
        body.setName("body");
    }

    protected void createFieldPrimaryCatch() {
        fieldPrimaryCatch = new javax.swing.JCheckBox();
        $objectMap.put("fieldPrimaryCatch", fieldPrimaryCatch);
        fieldPrimaryCatch.setName("fieldPrimaryCatch");
        fieldPrimaryCatch.setText(_("isisfish.metierSeasonInfoSpecies.mainSpecies"));
    }

    protected void createFieldTargetSpecies() {
        fieldTargetSpecies = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldTargetSpecies", fieldTargetSpecies);
        fieldTargetSpecies.setName("fieldTargetSpecies");
        fieldTargetSpecies.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldTargetSpecies"));
    }

    protected void createMetierSeasonInfo() {
        metierSeasonInfo = null;
        $objectMap.put("metierSeasonInfo", metierSeasonInfo);
    }

    protected void createMetierSeasonSelected() {
        metierSeasonSelected = false;
        $objectMap.put("metierSeasonSelected", metierSeasonSelected);
    }

    protected void createRemove() {
        remove = new javax.swing.JButton();
        $objectMap.put("remove", remove);
        remove.setName("remove");
        remove.setEnabled(false);
        remove.setText(_("isisfish.common.remove"));
        remove.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__remove"));
    }

    protected void createTableTargetSpecies() {
        tableTargetSpecies = new javax.swing.JTable();
        $objectMap.put("tableTargetSpecies", tableTargetSpecies);
        tableTargetSpecies.setName("tableTargetSpecies");
        tableTargetSpecies.setRowHeight(24);
    }

    protected void createTargetFactor() {
        targetFactor =  new fr.ifremer.isisfish.ui.input.InputOneEquationUI(this);
        $objectMap.put("targetFactor", targetFactor);
        targetFactor.removeDataBinding("$InputContentUI0.name");
        
        targetFactor.setName("targetFactor");
        targetFactor.removeDataBinding("$InputContentUI0.actif");
        
        targetFactor.removeDataBinding("$InputContentUI0.bean");
        
        targetFactor.removeDataBinding("$InputContentUI0.clazz");
        
        targetFactor.removeDataBinding("$InputContentUI0.formuleCategory");
        
        targetFactor.setFormuleCategory("TargetFactor");
        targetFactor.removeDataBinding("$InputContentUI0.text");
        
        targetFactor.setText(_("isisfish.metierSeasonInfoSpecies.targetFactor"));
    }

    protected void createTargetSpeciesSelected() {
        targetSpeciesSelected = false;
        $objectMap.put("targetSpeciesSelected", targetSpeciesSelected);
    }

}
