/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import java.util.ArrayList;
import fr.ifremer.isisfish.entities.EffortDescription;
import fr.ifremer.isisfish.entities.EffortDescriptionImpl;
import fr.ifremer.isisfish.entities.SetOfVesselsImpl;
import fr.ifremer.isisfish.entities.SetOfVessels;
import fr.ifremer.isisfish.types.TimeUnit;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionListModel;
import fr.ifremer.isisfish.ui.input.setofvessels.EffortDescriptionListRenderer;

public class EffortDescriptionParametersUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAKWWz28bRRTHJyZxmqaBtqQF1NKmbWiF2qybpCG0KS0hrYuD00T5gSKMRMfecT3VeneZmU02PSAkrgj1xIELcOfIvUIcOXHlf0CI/4A36/U6m0zGIyYHO56Z93nf953ZefvL32iIM3TpGY5jh0W+oG3iLC9ub6/Wn5GGeEB4g9FQBAx1/gYKqFBDo242zgW6UqvK8FIaXloK2mHgE39f9EIVHedizyO8RYgQ6EwnosF5aSMbXojDiHVpmRgV7ad//ym8cL/+uYBQHIKqCShhol9Ur4LBKipQV6DTkGkHlzzsPwUZjPpPQeeYHFvyMOePcZt8ib5Cw1VUDDEDmECXzUtNGEl8HAp0crLih5FYCnwBy7cqNwW602QObTLSJvDNKW9S3nIi6lC50HnYbAYs49LAX8MMBAnC+FYlDBNyUaDBOsG+QFMqFiSighLubBCx2vyUcE48XmmHXi/8FDmYRqAZLeuQrjxweHIT1z0yLdCbuQ3hu2Cvk8zJlSNZwNjk8kaDBZ63hn0yI9Ab0v84Xb9vSi4/nUVdb1LiuYe0HBqoUg67dk4hRR5yOSuBZw7Kn5U/x/Mpj00uV3GdeLfg4OQ0JqNy0bls7VW1vDI4CSGrIWG44/XFHKkcsDYWgribJBZlichjuxLm5O+L+TnHLOWDqJv6bC51n4zvKTJOqTM+Ipjxx1G7TtgaYVliGXQtD0jNnteY/X6W90Y2d0Gdd4mR3Q36nGSJbhyi3VbQrqlpWz6Fh5XDc5M6qMCOpNjpmwruO0ftR0zcRCr2MNvTUacV1MtH114OAlcq1iFnFMgrGjtbcO2tY6HyNGPOKpgzauY6CTFli767gqm8B7HfIPK49JN9y9yJKvZd2C1J5DrknAJ5xFO7KlqErUe+n3IV2EGOd4hAr+ceqY8iITrnvneuiw1Zc3JbrKUzTIbB9QTN0Ok1w163GqihIRbBMDSRWq9vrsNQp2OmowkgGf3xmx92vv/15Z1ue5yBHGO5Jfu6ObSrkAXwlMrbXaDXOj0xEtQrreBwoYZGoGvAq0DS6sf3CdhIh0EE8E/JMEeGOR9j3oLQoeG/fvv97JM/X0GFMjruBdgtY7m+gkZEi0GVgefG4f0PEyUndo/B50mpSaAT4JC3TnyXMJCFXr3rYoEn6jTZ2XsxlDy+r+RMxx8vvl05/93b892yBzqyDizrlT70GSpS36M+Sd4H0lav7P+jISeRG/RauqrJD8jvt8K0F24nn5+r6huGkw/3XpLxiziSX08SvfK/ujFmrLMxcEJXApdYwor1gIHfGsr5vhQ53NQQLhjoGBTQiKDD3u3szAS0Q0brkSD3/i+zn6pLRoQ9a4JOw6S5huc2BJ2Gqwa7MyqCwNukoXxb0Ijpj+pnqRlBV8671paaEXQarlv7YEYINYQp6ypK1k6aEXQapq2dNCPoNMxa+2BG0GmYs/bBjKDTMG/tgxlBp+G2tQ9mBJ2GBWsfzAg6DR9Y+2BG0Gm4b+2DGUGnYdHaBzOCTsOStQ9mBJ2Gh9Y+mBF0Gh5Z+2BG0GmoWPtgRtBp+MTaBzOCTsOKtQ+S8B+jcC2JJhYAAA==";
    protected fr.ifremer.isisfish.entities.SetOfVesselsImpl bean;
    protected javax.swing.JButton cancel;
    protected fr.ifremer.isisfish.entities.EffortDescriptionImpl effortDescription;
    protected javax.swing.JTextField fieldEffortDescriptionCrewFoodCost;
    protected javax.swing.JTextField fieldEffortDescriptionCrewShareRate;
    protected javax.swing.JTextField fieldEffortDescriptionCrewSize;
    protected jaxx.runtime.swing.JAXXList fieldEffortDescriptionEffortDescriptionList;
    protected javax.swing.JFormattedTextField fieldEffortDescriptionFishingOperation;
    protected javax.swing.JTextField fieldEffortDescriptionFishingOperationDuration;
    protected javax.swing.JTextField fieldEffortDescriptionFixedCrewSalary;
    protected javax.swing.JTextField fieldEffortDescriptionGearsNumberPerOperation;
    protected javax.swing.JTextField fieldEffortDescriptionLandingCosts;
    protected javax.swing.JTextField fieldEffortDescriptionOtherRunningCost;
    protected javax.swing.JTextField fieldEffortDescriptionRepairAndMaintenanceGearCost;
    protected javax.swing.JTextField fieldEffortDescriptionUnitCostOfFishing;
    protected javax.swing.JButton save;
    private fr.ifremer.isisfish.ui.input.EffortDescriptionParametersUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel12;
    private javax.swing.JLabel $JLabel13;
    private javax.swing.JLabel $JLabel14;
    private javax.swing.JLabel $JLabel15;
    private javax.swing.JLabel $JLabel4;
    private javax.swing.JLabel $JLabel5;
    private javax.swing.JLabel $JLabel6;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JScrollPane $JScrollPane2;
    private jaxx.runtime.swing.Table $Table1;
    private jaxx.runtime.swing.Table $Table3;
    private jaxx.runtime.swing.Table $Table7;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionEffortDescriptionList.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel4.enabled");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFishingOperation.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFishingOperation.text");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel5.enabled");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFishingOperationDuration.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFishingOperationDuration.text");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel6.enabled");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionGearsNumberPerOperation.enabled");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionGearsNumberPerOperation.text");
    private java.beans.PropertyChangeListener $DataSource30 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewSize.enabled");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewSize.text");
    private java.beans.PropertyChangeListener $DataSource33 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel9.enabled");
    private java.beans.PropertyChangeListener $DataSource34 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionUnitCostOfFishing.enabled");
    private java.beans.PropertyChangeListener $DataSource35 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionUnitCostOfFishing.text");
    private java.beans.PropertyChangeListener $DataSource36 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel10.enabled");
    private java.beans.PropertyChangeListener $DataSource37 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFixedCrewSalary.enabled");
    private java.beans.PropertyChangeListener $DataSource38 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionFixedCrewSalary.text");
    private java.beans.PropertyChangeListener $DataSource39 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel11.enabled");
    private java.beans.PropertyChangeListener $DataSource40 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewFoodCost.enabled");
    private java.beans.PropertyChangeListener $DataSource41 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewFoodCost.text");
    private java.beans.PropertyChangeListener $DataSource42 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel12.enabled");
    private java.beans.PropertyChangeListener $DataSource43 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewShareRate.enabled");
    private java.beans.PropertyChangeListener $DataSource44 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionCrewShareRate.text");
    private java.beans.PropertyChangeListener $DataSource45 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel13.enabled");
    private java.beans.PropertyChangeListener $DataSource46 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled");
    private java.beans.PropertyChangeListener $DataSource47 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionRepairAndMaintenanceGearCost.text");
    private java.beans.PropertyChangeListener $DataSource48 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel14.enabled");
    private java.beans.PropertyChangeListener $DataSource49 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionLandingCosts.enabled");
    private java.beans.PropertyChangeListener $DataSource50 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionLandingCosts.text");
    private java.beans.PropertyChangeListener $DataSource51 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel15.enabled");
    private java.beans.PropertyChangeListener $DataSource52 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionOtherRunningCost.enabled");
    private java.beans.PropertyChangeListener $DataSource53 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldEffortDescriptionOtherRunningCost.text");

    /* begin raw body code */    
    
    @Override
    public void refresh() {
        SetOfVessels setOfVessels = getVerifier().getEntity(SetOfVessels.class);
    
        // twice event for jaxx bindings detection
        setBean(null);
        setBean((SetOfVesselsImpl) setOfVessels);
    
        EffortDescriptionListModel model = new EffortDescriptionListModel();
        // getBean().getPossibleMetiers() can be null at region creation
        if (getBean() != null && getBean().getPossibleMetiers() != null) {
            java.util.List<EffortDescription> effortDescriptions = new ArrayList<EffortDescription>(getBean().getPossibleMetiers());
            model.setEffortDescriptions(effortDescriptions);
        }
        fieldEffortDescriptionEffortDescriptionList.setModel(model);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    
    protected void effortDescriptionSelectionChanged() {
        EffortDescriptionImpl selectedEffort = (EffortDescriptionImpl)fieldEffortDescriptionEffortDescriptionList.getSelectedValue();
        setEffortDescription(selectedEffort);
    
        if (getEffortDescription() != null) {
            getVerifier().addCurrentEntity(getEffortDescription());
            
            /* NumberEditor is not working
            fieldEffortDescriptionFishingOperation.init();
            fieldEffortDescriptionGearsNumberPerOperation.init();
            fieldEffortDescriptionCrewSize.init();
            fieldEffortDescriptionUnitCostOfFishing.init();
            fieldEffortDescriptionFixedCrewSalary.init();
            fieldEffortDescriptionCrewFoodCost.init();
            fieldEffortDescriptionCrewShareRate.init();
            fieldEffortDescriptionRepairAndMaintenanceGearCost.init();
            fieldEffortDescriptionLandingCosts.init();
            fieldEffortDescriptionOtherRunningCost.init();*/
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public EffortDescriptionParametersUI() {
        super();
        $initialize();
    }

    public EffortDescriptionParametersUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource17);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldEffortDescriptionFishingOperation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldEffortDescriptionFishingOperation.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource22);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("fishingOperation", $DataSource22);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldEffortDescriptionFishingOperationDuration.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldEffortDescriptionFishingOperationDuration.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource25);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("fishingOperationDuration", $DataSource25);
            }if ( getEffortDescription() != null) {
                 getEffortDescription().addPropertyChangeListener("fishingOperationDuration", $DataSource25);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldEffortDescriptionGearsNumberPerOperation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldEffortDescriptionGearsNumberPerOperation.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource28);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("gearsNumberPerOperation", $DataSource28);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource30);
            }
        } else if ("fieldEffortDescriptionCrewSize.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource31);
            }
        } else if ("fieldEffortDescriptionCrewSize.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource32);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("crewSize", $DataSource32);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource33);
            }
        } else if ("fieldEffortDescriptionUnitCostOfFishing.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource34);
            }
        } else if ("fieldEffortDescriptionUnitCostOfFishing.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource35);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("unitCostOfFishing", $DataSource35);
            }
        } else if ("$JLabel10.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource36);
            }
        } else if ("fieldEffortDescriptionFixedCrewSalary.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource37);
            }
        } else if ("fieldEffortDescriptionFixedCrewSalary.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource38);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("fixedCrewSalary", $DataSource38);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource39);
            }
        } else if ("fieldEffortDescriptionCrewFoodCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource40);
            }
        } else if ("fieldEffortDescriptionCrewFoodCost.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource41);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("crewFoodCost", $DataSource41);
            }
        } else if ("$JLabel12.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource42);
            }
        } else if ("fieldEffortDescriptionCrewShareRate.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource43);
            }
        } else if ("fieldEffortDescriptionCrewShareRate.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource44);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("crewShareRate", $DataSource44);
            }
        } else if ("$JLabel13.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource45);
            }
        } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource46);
            }
        } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource47);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("repairAndMaintenanceGearCost", $DataSource47);
            }
        } else if ("$JLabel14.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource48);
            }
        } else if ("fieldEffortDescriptionLandingCosts.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource49);
            }
        } else if ("fieldEffortDescriptionLandingCosts.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource50);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("landingCosts", $DataSource50);
            }
        } else if ("$JLabel15.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource51);
            }
        } else if ("fieldEffortDescriptionOtherRunningCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource52);
            }
        } else if ("fieldEffortDescriptionOtherRunningCost.text".equals($binding)) {
                addPropertyChangeListener("effortDescription", $DataSource53);
        if (getEffortDescription() != null) {
                getEffortDescription().addPropertyChangeListener("otherRunningCost", $DataSource53);
            }
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionEffortDescriptionList.setEnabled((isActif()));
            }
            } else if ("$JLabel4.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel4.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFishingOperation.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionFishingOperation.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFishingOperation.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionFishingOperation, String.valueOf((getEffortDescription().getFishingOperation())));
            }
            } else if ("$JLabel5.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel5.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFishingOperationDuration.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionFishingOperationDuration.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFishingOperationDuration.text".equals($dest)) {
            if ( getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionFishingOperationDuration, String.valueOf((getEffortDescription().getFishingOperationDuration() == null ? "" : getEffortDescription().getFishingOperationDuration().getHour())));
            }
            } else if ("$JLabel6.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel6.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionGearsNumberPerOperation.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionGearsNumberPerOperation.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionGearsNumberPerOperation.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionGearsNumberPerOperation, String.valueOf((getEffortDescription().getGearsNumberPerOperation())));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel8.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewSize.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionCrewSize.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewSize.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionCrewSize, String.valueOf((getEffortDescription().getCrewSize())));
            }
            } else if ("$JLabel9.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel9.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionUnitCostOfFishing.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionUnitCostOfFishing.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionUnitCostOfFishing.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionUnitCostOfFishing, String.valueOf((getEffortDescription().getUnitCostOfFishing())));
            }
            } else if ("$JLabel10.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel10.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFixedCrewSalary.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionFixedCrewSalary.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionFixedCrewSalary.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionFixedCrewSalary, String.valueOf((getEffortDescription().getFixedCrewSalary())));
            }
            } else if ("$JLabel11.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel11.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewFoodCost.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionCrewFoodCost.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewFoodCost.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionCrewFoodCost, String.valueOf((getEffortDescription().getCrewFoodCost())));
            }
            } else if ("$JLabel12.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel12.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewShareRate.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionCrewShareRate.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionCrewShareRate.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionCrewShareRate, String.valueOf((getEffortDescription().getCrewShareRate())));
            }
            } else if ("$JLabel13.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel13.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionRepairAndMaintenanceGearCost.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionRepairAndMaintenanceGearCost, String.valueOf((getEffortDescription().getRepairAndMaintenanceGearCost())));
            }
            } else if ("$JLabel14.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel14.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionLandingCosts.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionLandingCosts.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionLandingCosts.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionLandingCosts, String.valueOf((getEffortDescription().getLandingCosts())));
            }
            } else if ("$JLabel15.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel15.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionOtherRunningCost.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldEffortDescriptionOtherRunningCost.setEnabled((isActif()));
            }
            } else if ("fieldEffortDescriptionOtherRunningCost.text".equals($dest)) {
            if (getEffortDescription() != null) {
                jaxx.runtime.SwingUtil.setText(fieldEffortDescriptionOtherRunningCost, String.valueOf((getEffortDescription().getOtherRunningCost())));
            }
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("fieldEffortDescriptionEffortDescriptionList.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource17);
            }
        } else if ("$JLabel4.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource20);
            }
        } else if ("fieldEffortDescriptionFishingOperation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldEffortDescriptionFishingOperation.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource22);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("fishingOperation", $DataSource22);
            }
        } else if ("$JLabel5.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource23);
            }
        } else if ("fieldEffortDescriptionFishingOperationDuration.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldEffortDescriptionFishingOperationDuration.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource25);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("fishingOperationDuration", $DataSource25);
            }if ( getEffortDescription() != null) {
                 getEffortDescription().removePropertyChangeListener("fishingOperationDuration", $DataSource25);
            }
        } else if ("$JLabel6.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource26);
            }
        } else if ("fieldEffortDescriptionGearsNumberPerOperation.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldEffortDescriptionGearsNumberPerOperation.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource28);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("gearsNumberPerOperation", $DataSource28);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource30);
            }
        } else if ("fieldEffortDescriptionCrewSize.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource31);
            }
        } else if ("fieldEffortDescriptionCrewSize.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource32);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("crewSize", $DataSource32);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource33);
            }
        } else if ("fieldEffortDescriptionUnitCostOfFishing.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource34);
            }
        } else if ("fieldEffortDescriptionUnitCostOfFishing.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource35);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("unitCostOfFishing", $DataSource35);
            }
        } else if ("$JLabel10.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource36);
            }
        } else if ("fieldEffortDescriptionFixedCrewSalary.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource37);
            }
        } else if ("fieldEffortDescriptionFixedCrewSalary.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource38);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("fixedCrewSalary", $DataSource38);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource39);
            }
        } else if ("fieldEffortDescriptionCrewFoodCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource40);
            }
        } else if ("fieldEffortDescriptionCrewFoodCost.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource41);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("crewFoodCost", $DataSource41);
            }
        } else if ("$JLabel12.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource42);
            }
        } else if ("fieldEffortDescriptionCrewShareRate.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource43);
            }
        } else if ("fieldEffortDescriptionCrewShareRate.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource44);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("crewShareRate", $DataSource44);
            }
        } else if ("$JLabel13.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource45);
            }
        } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource46);
            }
        } else if ("fieldEffortDescriptionRepairAndMaintenanceGearCost.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource47);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("repairAndMaintenanceGearCost", $DataSource47);
            }
        } else if ("$JLabel14.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource48);
            }
        } else if ("fieldEffortDescriptionLandingCosts.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource49);
            }
        } else if ("fieldEffortDescriptionLandingCosts.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource50);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("landingCosts", $DataSource50);
            }
        } else if ("$JLabel15.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource51);
            }
        } else if ("fieldEffortDescriptionOtherRunningCost.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource52);
            }
        } else if ("fieldEffortDescriptionOtherRunningCost.text".equals($binding)) {
                removePropertyChangeListener("effortDescription", $DataSource53);
        if (getEffortDescription() != null) {
                getEffortDescription().removePropertyChangeListener("otherRunningCost", $DataSource53);
            }
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doKeyReleased__on__fieldEffortDescriptionCrewFoodCost(java.awt.event.KeyEvent event) {
        getEffortDescription().setCrewFoodCost(Double.parseDouble(fieldEffortDescriptionCrewFoodCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionCrewShareRate(java.awt.event.KeyEvent event) {
        getEffortDescription().setCrewShareRate(Double.parseDouble(fieldEffortDescriptionCrewShareRate.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionCrewSize(java.awt.event.KeyEvent event) {
        getEffortDescription().setCrewSize(Integer.parseInt(fieldEffortDescriptionCrewSize.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFishingOperation(java.awt.event.KeyEvent event) {
        getEffortDescription().setFishingOperation(Integer.parseInt(fieldEffortDescriptionFishingOperation.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFishingOperationDuration(java.awt.event.KeyEvent event) {
        getEffortDescription().setFishingOperationDuration(new TimeUnit(3600 * Double.parseDouble(fieldEffortDescriptionFishingOperationDuration.getText())));
    }

    public void doKeyReleased__on__fieldEffortDescriptionFixedCrewSalary(java.awt.event.KeyEvent event) {
        getEffortDescription().setFixedCrewSalary(Double.parseDouble(fieldEffortDescriptionFixedCrewSalary.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionGearsNumberPerOperation(java.awt.event.KeyEvent event) {
        getEffortDescription().setGearsNumberPerOperation(Integer.parseInt(fieldEffortDescriptionGearsNumberPerOperation.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionLandingCosts(java.awt.event.KeyEvent event) {
        getEffortDescription().setLandingCosts(Double.parseDouble(fieldEffortDescriptionLandingCosts.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionOtherRunningCost(java.awt.event.KeyEvent event) {
        getEffortDescription().setOtherRunningCost(Double.parseDouble(fieldEffortDescriptionOtherRunningCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionRepairAndMaintenanceGearCost(java.awt.event.KeyEvent event) {
        getEffortDescription().setRepairAndMaintenanceGearCost(Double.parseDouble(fieldEffortDescriptionRepairAndMaintenanceGearCost.getText()));
    }

    public void doKeyReleased__on__fieldEffortDescriptionUnitCostOfFishing(java.awt.event.KeyEvent event) {
        getEffortDescription().setUnitCostOfFishing(Double.parseDouble(fieldEffortDescriptionUnitCostOfFishing.getText()));
    }

    public void doValueChanged__on__fieldEffortDescriptionEffortDescriptionList(javax.swing.event.ListSelectionEvent event) {
        effortDescriptionSelectionChanged();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.SetOfVesselsImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public fr.ifremer.isisfish.entities.EffortDescriptionImpl getEffortDescription() {
        return effortDescription;
    }

    public javax.swing.JTextField getFieldEffortDescriptionCrewFoodCost() {
        return fieldEffortDescriptionCrewFoodCost;
    }

    public javax.swing.JTextField getFieldEffortDescriptionCrewShareRate() {
        return fieldEffortDescriptionCrewShareRate;
    }

    public javax.swing.JTextField getFieldEffortDescriptionCrewSize() {
        return fieldEffortDescriptionCrewSize;
    }

    public jaxx.runtime.swing.JAXXList getFieldEffortDescriptionEffortDescriptionList() {
        return fieldEffortDescriptionEffortDescriptionList;
    }

    public javax.swing.JFormattedTextField getFieldEffortDescriptionFishingOperation() {
        return fieldEffortDescriptionFishingOperation;
    }

    public javax.swing.JTextField getFieldEffortDescriptionFishingOperationDuration() {
        return fieldEffortDescriptionFishingOperationDuration;
    }

    public javax.swing.JTextField getFieldEffortDescriptionFixedCrewSalary() {
        return fieldEffortDescriptionFixedCrewSalary;
    }

    public javax.swing.JTextField getFieldEffortDescriptionGearsNumberPerOperation() {
        return fieldEffortDescriptionGearsNumberPerOperation;
    }

    public javax.swing.JTextField getFieldEffortDescriptionLandingCosts() {
        return fieldEffortDescriptionLandingCosts;
    }

    public javax.swing.JTextField getFieldEffortDescriptionOtherRunningCost() {
        return fieldEffortDescriptionOtherRunningCost;
    }

    public javax.swing.JTextField getFieldEffortDescriptionRepairAndMaintenanceGearCost() {
        return fieldEffortDescriptionRepairAndMaintenanceGearCost;
    }

    public javax.swing.JTextField getFieldEffortDescriptionUnitCostOfFishing() {
        return fieldEffortDescriptionUnitCostOfFishing;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.SetOfVesselsImpl newValue) {
        fr.ifremer.isisfish.entities.SetOfVesselsImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setEffortDescription(fr.ifremer.isisfish.entities.EffortDescriptionImpl newValue) {
        fr.ifremer.isisfish.entities.EffortDescriptionImpl oldValue = this.effortDescription;
        this.effortDescription = newValue;
        firePropertyChange("effortDescription", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.EffortDescriptionParametersUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel12() {
        return $JLabel12;
    }

    protected javax.swing.JLabel get$JLabel13() {
        return $JLabel13;
    }

    protected javax.swing.JLabel get$JLabel14() {
        return $JLabel14;
    }

    protected javax.swing.JLabel get$JLabel15() {
        return $JLabel15;
    }

    protected javax.swing.JLabel get$JLabel4() {
        return $JLabel4;
    }

    protected javax.swing.JLabel get$JLabel5() {
        return $JLabel5;
    }

    protected javax.swing.JLabel get$JLabel6() {
        return $JLabel6;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JScrollPane get$JScrollPane2() {
        return $JScrollPane2;
    }

    protected jaxx.runtime.swing.Table get$Table1() {
        return $Table1;
    }

    protected jaxx.runtime.swing.Table get$Table3() {
        return $Table3;
    }

    protected jaxx.runtime.swing.Table get$Table7() {
        return $Table7;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($Table1);
        
        $Table1.add($JScrollPane2, new GridBagConstraints(0, 0, 1, 3, 0.4, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Table3, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add($Table7, new GridBagConstraints(1, 1, 2, 1, 0.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table1.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(2, 2, 1, 1, 0.3, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        $JScrollPane2.getViewport().add(fieldEffortDescriptionEffortDescriptionList);
        
        $Table3.add($JLabel4, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFishingOperation), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel5, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFishingOperationDuration), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add($JLabel6, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table3.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionGearsNumberPerOperation), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToFieldEffortDescriptionFishingOperation();
        
        addChildrenToFieldEffortDescriptionFishingOperationDuration();
        
        addChildrenToFieldEffortDescriptionGearsNumberPerOperation();
        $Table7.add($JLabel8, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewSize), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel9, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionUnitCostOfFishing), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel10, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionFixedCrewSalary), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel11, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewFoodCost), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel12, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionCrewShareRate), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel13, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionRepairAndMaintenanceGearCost), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel14, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionLandingCosts), new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add($JLabel15, new GridBagConstraints(0, 7, 1, 1, 0.0, 1.0, 12, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table7.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldEffortDescriptionOtherRunningCost), new GridBagConstraints(1, 7, 1, 1, 1.0, 1.0, 11, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        addChildrenToFieldEffortDescriptionCrewSize();
        
        addChildrenToFieldEffortDescriptionUnitCostOfFishing();
        
        addChildrenToFieldEffortDescriptionFixedCrewSalary();
        
        addChildrenToFieldEffortDescriptionCrewFoodCost();
        
        addChildrenToFieldEffortDescriptionCrewShareRate();
        
        addChildrenToFieldEffortDescriptionRepairAndMaintenanceGearCost();
        
        addChildrenToFieldEffortDescriptionLandingCosts();
        
        addChildrenToFieldEffortDescriptionOtherRunningCost();
        fieldEffortDescriptionEffortDescriptionList.setCellRenderer((new EffortDescriptionListRenderer()));
        applyDataBinding("fieldEffortDescriptionEffortDescriptionList.enabled");
        fieldEffortDescriptionEffortDescriptionList.setSelectionMode((javax.swing.ListSelectionModel.SINGLE_SELECTION));
        $Table3.setBorder((BorderFactory.createTitledBorder(_("isisfish.effortDescription.effortTitle"))));
        applyDataBinding("$JLabel4.enabled");
        applyDataBinding("fieldEffortDescriptionFishingOperation.enabled");
        applyDataBinding("fieldEffortDescriptionFishingOperation.text");
        applyDataBinding("$JLabel5.enabled");
        applyDataBinding("fieldEffortDescriptionFishingOperationDuration.enabled");
        applyDataBinding("fieldEffortDescriptionFishingOperationDuration.text");
        applyDataBinding("$JLabel6.enabled");
        applyDataBinding("fieldEffortDescriptionGearsNumberPerOperation.enabled");
        applyDataBinding("fieldEffortDescriptionGearsNumberPerOperation.text");
        $Table7.setBorder((BorderFactory.createTitledBorder(_("isisfish.effortDescription.economicTitle"))));
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldEffortDescriptionCrewSize.enabled");
        applyDataBinding("fieldEffortDescriptionCrewSize.text");
        applyDataBinding("$JLabel9.enabled");
        applyDataBinding("fieldEffortDescriptionUnitCostOfFishing.enabled");
        applyDataBinding("fieldEffortDescriptionUnitCostOfFishing.text");
        applyDataBinding("$JLabel10.enabled");
        applyDataBinding("fieldEffortDescriptionFixedCrewSalary.enabled");
        applyDataBinding("fieldEffortDescriptionFixedCrewSalary.text");
        applyDataBinding("$JLabel11.enabled");
        applyDataBinding("fieldEffortDescriptionCrewFoodCost.enabled");
        applyDataBinding("fieldEffortDescriptionCrewFoodCost.text");
        applyDataBinding("$JLabel12.enabled");
        applyDataBinding("fieldEffortDescriptionCrewShareRate.enabled");
        applyDataBinding("fieldEffortDescriptionCrewShareRate.text");
        applyDataBinding("$JLabel13.enabled");
        applyDataBinding("fieldEffortDescriptionRepairAndMaintenanceGearCost.enabled");
        applyDataBinding("fieldEffortDescriptionRepairAndMaintenanceGearCost.text");
        applyDataBinding("$JLabel14.enabled");
        applyDataBinding("fieldEffortDescriptionLandingCosts.enabled");
        applyDataBinding("fieldEffortDescriptionLandingCosts.text");
        applyDataBinding("$JLabel15.enabled");
        applyDataBinding("fieldEffortDescriptionOtherRunningCost.enabled");
        applyDataBinding("fieldEffortDescriptionOtherRunningCost.text");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        createEffortDescription();
        
        $Table1 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table1", $Table1);
        $Table1.setName("$Table1");
        
        $JScrollPane2 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane2", $JScrollPane2);
        $JScrollPane2.setName("$JScrollPane2");
        
        createFieldEffortDescriptionEffortDescriptionList();
        
        $Table3 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table3", $Table3);
        $Table3.setName("$Table3");
        
        $JLabel4 = new javax.swing.JLabel();
        $objectMap.put("$JLabel4", $JLabel4);
        $JLabel4.setName("$JLabel4");
        $JLabel4.setText(_("isisfish.effortDescription.fishingOperation"));
        
        createFieldEffortDescriptionFishingOperation();
        
        $JLabel5 = new javax.swing.JLabel();
        $objectMap.put("$JLabel5", $JLabel5);
        $JLabel5.setName("$JLabel5");
        $JLabel5.setText(_("isisfish.effortDescription.fishingOperationDuration"));
        
        createFieldEffortDescriptionFishingOperationDuration();
        
        $JLabel6 = new javax.swing.JLabel();
        $objectMap.put("$JLabel6", $JLabel6);
        $JLabel6.setName("$JLabel6");
        $JLabel6.setText(_("isisfish.effortDescription.gearsNumberPerOperation"));
        
        createFieldEffortDescriptionGearsNumberPerOperation();
        
        $Table7 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table7", $Table7);
        $Table7.setName("$Table7");
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.effortDescription.crewSize"));
        
        createFieldEffortDescriptionCrewSize();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.effortDescription.unitCostOfFishing"));
        
        createFieldEffortDescriptionUnitCostOfFishing();
        
        $JLabel10 = new javax.swing.JLabel();
        $objectMap.put("$JLabel10", $JLabel10);
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("isisfish.effortDescription.fixedCrewSalary"));
        
        createFieldEffortDescriptionFixedCrewSalary();
        
        $JLabel11 = new javax.swing.JLabel();
        $objectMap.put("$JLabel11", $JLabel11);
        $JLabel11.setName("$JLabel11");
        $JLabel11.setText(_("isisfish.effortDescription.crewFoodCost"));
        
        createFieldEffortDescriptionCrewFoodCost();
        
        $JLabel12 = new javax.swing.JLabel();
        $objectMap.put("$JLabel12", $JLabel12);
        $JLabel12.setName("$JLabel12");
        $JLabel12.setText(_("isisfish.effortDescription.crewShareRate"));
        
        createFieldEffortDescriptionCrewShareRate();
        
        $JLabel13 = new javax.swing.JLabel();
        $objectMap.put("$JLabel13", $JLabel13);
        $JLabel13.setName("$JLabel13");
        $JLabel13.setText(_("isisfish.effortDescription.repairAndMaintenanceGearCost"));
        
        createFieldEffortDescriptionRepairAndMaintenanceGearCost();
        
        $JLabel14 = new javax.swing.JLabel();
        $objectMap.put("$JLabel14", $JLabel14);
        $JLabel14.setName("$JLabel14");
        $JLabel14.setText(_("isisfish.effortDescription.landingCosts"));
        
        createFieldEffortDescriptionLandingCosts();
        
        $JLabel15 = new javax.swing.JLabel();
        $objectMap.put("$JLabel15", $JLabel15);
        $JLabel15.setName("$JLabel15");
        $JLabel15.setText(_("isisfish.effortDescription.otherRunningCost"));
        
        createFieldEffortDescriptionOtherRunningCost();
        createSave();
        createCancel();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        addPropertyChangeListener("effortDescription", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldEffortDescriptionFishingOperation.setText("");
                    fieldEffortDescriptionFishingOperationDuration.setText("");
                    fieldEffortDescriptionGearsNumberPerOperation.setText("");
                    fieldEffortDescriptionCrewSize.setText("");
                    fieldEffortDescriptionUnitCostOfFishing.setText("");
                    fieldEffortDescriptionFixedCrewSalary.setText("");
                    fieldEffortDescriptionCrewFoodCost.setText("");
                    fieldEffortDescriptionCrewShareRate.setText("");
                    fieldEffortDescriptionRepairAndMaintenanceGearCost.setText("");
                    fieldEffortDescriptionLandingCosts.setText("");
                    fieldEffortDescriptionOtherRunningCost.setText("");
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToFieldEffortDescriptionCrewFoodCost() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionCrewFoodCost.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionCrewFoodCost.putClientProperty("method", "CrewFoodCost");
    }

    protected void addChildrenToFieldEffortDescriptionCrewShareRate() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionCrewShareRate.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionCrewShareRate.putClientProperty("method", "CrewShareRate");
    }

    protected void addChildrenToFieldEffortDescriptionCrewSize() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionCrewSize.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionCrewSize.putClientProperty("method", "CrewSize");
    }

    protected void addChildrenToFieldEffortDescriptionFishingOperation() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionFishingOperation.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionFishingOperation.putClientProperty("method", "FishingOperation");
    }

    protected void addChildrenToFieldEffortDescriptionFishingOperationDuration() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionFishingOperationDuration.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionFishingOperationDuration.putClientProperty("method", "FishingOperationDuration");
    }

    protected void addChildrenToFieldEffortDescriptionFixedCrewSalary() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionFixedCrewSalary.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionFixedCrewSalary.putClientProperty("method", "FixedCrewSalary");
    }

    protected void addChildrenToFieldEffortDescriptionGearsNumberPerOperation() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionGearsNumberPerOperation.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionGearsNumberPerOperation.putClientProperty("method", "GearsNumberPerOperation");
    }

    protected void addChildrenToFieldEffortDescriptionLandingCosts() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionLandingCosts.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionLandingCosts.putClientProperty("method", "LandingCosts");
    }

    protected void addChildrenToFieldEffortDescriptionOtherRunningCost() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionOtherRunningCost.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionOtherRunningCost.putClientProperty("method", "OtherRunningCost");
    }

    protected void addChildrenToFieldEffortDescriptionRepairAndMaintenanceGearCost() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionRepairAndMaintenanceGearCost.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionRepairAndMaintenanceGearCost.putClientProperty("method", "RepairAndMaintenanceGearCost");
    }

    protected void addChildrenToFieldEffortDescriptionUnitCostOfFishing() {
        if (!allComponentsCreated) {
            return;
        }
        fieldEffortDescriptionUnitCostOfFishing.putClientProperty("bean", EffortDescriptionImpl.class);
        fieldEffortDescriptionUnitCostOfFishing.putClientProperty("method", "UnitCostOfFishing");
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
    }

    protected void createEffortDescription() {
        effortDescription = null;
        $objectMap.put("effortDescription", effortDescription);
    }

    protected void createFieldEffortDescriptionCrewFoodCost() {
        fieldEffortDescriptionCrewFoodCost = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionCrewFoodCost", fieldEffortDescriptionCrewFoodCost);
        fieldEffortDescriptionCrewFoodCost.setName("fieldEffortDescriptionCrewFoodCost");
        fieldEffortDescriptionCrewFoodCost.setColumns(15);
        fieldEffortDescriptionCrewFoodCost.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionCrewFoodCost"));
    }

    protected void createFieldEffortDescriptionCrewShareRate() {
        fieldEffortDescriptionCrewShareRate = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionCrewShareRate", fieldEffortDescriptionCrewShareRate);
        fieldEffortDescriptionCrewShareRate.setName("fieldEffortDescriptionCrewShareRate");
        fieldEffortDescriptionCrewShareRate.setColumns(15);
        fieldEffortDescriptionCrewShareRate.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionCrewShareRate"));
    }

    protected void createFieldEffortDescriptionCrewSize() {
        fieldEffortDescriptionCrewSize = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionCrewSize", fieldEffortDescriptionCrewSize);
        fieldEffortDescriptionCrewSize.setName("fieldEffortDescriptionCrewSize");
        fieldEffortDescriptionCrewSize.setColumns(15);
        fieldEffortDescriptionCrewSize.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionCrewSize"));
    }

    protected void createFieldEffortDescriptionEffortDescriptionList() {
        fieldEffortDescriptionEffortDescriptionList = new jaxx.runtime.swing.JAXXList();
        $objectMap.put("fieldEffortDescriptionEffortDescriptionList", fieldEffortDescriptionEffortDescriptionList);
        fieldEffortDescriptionEffortDescriptionList.setName("fieldEffortDescriptionEffortDescriptionList");
        fieldEffortDescriptionEffortDescriptionList.addListSelectionListener((javax.swing.event.ListSelectionListener) jaxx.runtime.Util.getEventListener(javax.swing.event.ListSelectionListener.class, "valueChanged", $InputContentUI0, "doValueChanged__on__fieldEffortDescriptionEffortDescriptionList"));
    }

    protected void createFieldEffortDescriptionFishingOperation() {
        fieldEffortDescriptionFishingOperation = new javax.swing.JFormattedTextField();
        $objectMap.put("fieldEffortDescriptionFishingOperation", fieldEffortDescriptionFishingOperation);
        fieldEffortDescriptionFishingOperation.setName("fieldEffortDescriptionFishingOperation");
        fieldEffortDescriptionFishingOperation.setColumns(15);
        fieldEffortDescriptionFishingOperation.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionFishingOperation"));
    }

    protected void createFieldEffortDescriptionFishingOperationDuration() {
        fieldEffortDescriptionFishingOperationDuration = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionFishingOperationDuration", fieldEffortDescriptionFishingOperationDuration);
        fieldEffortDescriptionFishingOperationDuration.setName("fieldEffortDescriptionFishingOperationDuration");
        fieldEffortDescriptionFishingOperationDuration.setColumns(15);
        fieldEffortDescriptionFishingOperationDuration.setToolTipText(_("isisfish.effortDescription.fishingOperationDuration.tooltip"));
        fieldEffortDescriptionFishingOperationDuration.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionFishingOperationDuration"));
    }

    protected void createFieldEffortDescriptionFixedCrewSalary() {
        fieldEffortDescriptionFixedCrewSalary = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionFixedCrewSalary", fieldEffortDescriptionFixedCrewSalary);
        fieldEffortDescriptionFixedCrewSalary.setName("fieldEffortDescriptionFixedCrewSalary");
        fieldEffortDescriptionFixedCrewSalary.setColumns(15);
        fieldEffortDescriptionFixedCrewSalary.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionFixedCrewSalary"));
    }

    protected void createFieldEffortDescriptionGearsNumberPerOperation() {
        fieldEffortDescriptionGearsNumberPerOperation = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionGearsNumberPerOperation", fieldEffortDescriptionGearsNumberPerOperation);
        fieldEffortDescriptionGearsNumberPerOperation.setName("fieldEffortDescriptionGearsNumberPerOperation");
        fieldEffortDescriptionGearsNumberPerOperation.setColumns(15);
        fieldEffortDescriptionGearsNumberPerOperation.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionGearsNumberPerOperation"));
    }

    protected void createFieldEffortDescriptionLandingCosts() {
        fieldEffortDescriptionLandingCosts = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionLandingCosts", fieldEffortDescriptionLandingCosts);
        fieldEffortDescriptionLandingCosts.setName("fieldEffortDescriptionLandingCosts");
        fieldEffortDescriptionLandingCosts.setColumns(15);
        fieldEffortDescriptionLandingCosts.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionLandingCosts"));
    }

    protected void createFieldEffortDescriptionOtherRunningCost() {
        fieldEffortDescriptionOtherRunningCost = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionOtherRunningCost", fieldEffortDescriptionOtherRunningCost);
        fieldEffortDescriptionOtherRunningCost.setName("fieldEffortDescriptionOtherRunningCost");
        fieldEffortDescriptionOtherRunningCost.setColumns(15);
        fieldEffortDescriptionOtherRunningCost.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionOtherRunningCost"));
    }

    protected void createFieldEffortDescriptionRepairAndMaintenanceGearCost() {
        fieldEffortDescriptionRepairAndMaintenanceGearCost = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionRepairAndMaintenanceGearCost", fieldEffortDescriptionRepairAndMaintenanceGearCost);
        fieldEffortDescriptionRepairAndMaintenanceGearCost.setName("fieldEffortDescriptionRepairAndMaintenanceGearCost");
        fieldEffortDescriptionRepairAndMaintenanceGearCost.setColumns(15);
        fieldEffortDescriptionRepairAndMaintenanceGearCost.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionRepairAndMaintenanceGearCost"));
    }

    protected void createFieldEffortDescriptionUnitCostOfFishing() {
        fieldEffortDescriptionUnitCostOfFishing = new javax.swing.JTextField();
        $objectMap.put("fieldEffortDescriptionUnitCostOfFishing", fieldEffortDescriptionUnitCostOfFishing);
        fieldEffortDescriptionUnitCostOfFishing.setName("fieldEffortDescriptionUnitCostOfFishing");
        fieldEffortDescriptionUnitCostOfFishing.setColumns(15);
        fieldEffortDescriptionUnitCostOfFishing.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldEffortDescriptionUnitCostOfFishing"));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
    }

}
