/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui.input;

import fr.ifremer.isisfish.ui.input.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import java.awt.event.MouseEvent;
import fr.ifremer.isisfish.entities.Cell;
import fr.ifremer.isisfish.entities.CellImpl;
import com.bbn.openmap.gui.Tool;
import com.bbn.openmap.gui.OMToolSet;
import com.bbn.openmap.event.SelectMouseMode;
import fr.ifremer.isisfish.map.CellSelectionLayer;
import fr.ifremer.isisfish.map.CopyMapToClipboardListener;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityTabUI;

public class CellUI extends fr.ifremer.isisfish.ui.input.InputContentUI {
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAK1Wz28bRRSeuHFcN02bH03aolaE1oAQYl230ACpWhJDVEcORXUCBUuIsXdiTxnPLDOzyaYHhMS1Qj1x4ALcOXJHiGNPXPkfEOp/0De79q432awXjA/+MfO+b7/vzbz3/MvfKK8keukh9jxLulzTHrE21x48uNd6SNr6faLakjpaSBS8JnIo10TTdriuNLrarBt4uQ8vV0XPEZzwIfRqHZ1S+oAR1SVEa7QYINpKlRvh8qrnuHLAFopJYvvp2T+5J/Y3P+cQ8hxQdREsLI9CRQ4m6yhHbY3m4Ul7uMww74AMSXkHdM6YtSrDSn2Ie+Qr9DUq1NGUgyWQaXQlu1Wfw8d7jkazpRp3XF0VXEP4Tu0a5G1XWnRXkh6BT0XVLlVdy6UWNYFWlTC2U3Mcn2JKo8kWwVyjl5NAwEg1JcoH1XoOi2ALpYYvrMYhAjP6iMiKRi/6yWqDesqA6EhIKv662ZpLDblxKORkafMjzAl7E5Ju8utZah/SbQWrJqgYxp4ubTYcRrXZekujpVh8uGOCl0JMobSNW4zc1OhC7BoEKH/PRF4MAcVdSpht0jVIRhxiSgAOtyXWhWcgl4at1HGLsJXDVvzVeOxM+BRzlw572Sae3jAByQ942/wuxffmQsI6hiN3bd/Wq8kE7yQQzEcEgneOYyj2GSrXEihmhjRwqKLFmKlql7S/PJK0kLCSQHgGDrwtBWPmXCvXNTofP/JwLw6bDXXAQfX86lw8kt81SbCJX4nqSOE9OIqFWOi6q7Xgcf6pNubt4ETvxHdO9LBjvl6I36mCFoJtYSj2y1BZVqvFLeEQDsFWB8p6G3bD674eoeAZASqxHxh0DX5AxDo0gD5WGv2mgpWyogYadbiJJspLF5YhTc2o196HpaDL9ld9An/1x29/2Pv+19/eHbTUK/CMmVjI0ASAFudI8CZN09HobNBHXU1ZGXSuNlFREQbjwx8P54YENPrLIAL45wzMMjDrLlZdgOYLf/3+x9IXf55AuQ10iglsb2ATX0NF3ZXgUjDbc+685ys5vX8S3meNJjgthg8EnCI6c8vGGi+3KLfhaG97YPbckNlQwdMnj7cufXd5ZWB4IhB0KCwynf8MTVHOKCf+9OgPhsRpMe0o4toiGgBJI2HCfJ53+j3ynv/eSHJ21qZ71CayLtpQ8zA/0PytQMgy1jC1Wq4mYNPgP/F9mG+f+vQvZKCfh/m1Ldx29wPPgXoetMrP/zvjtJAUytEXOyZVvifsoGA+TiZZzkBSINy4slNormagmdTQT1L8jOYwyzJFxSuZGPbHZkjT8Fp2DcfkYTQDjChiUz3iqr0+tpdsDGn5HF/DG2PnMxvD4xSG8tgusjGkZXJ8DZWxM5mNIU3DjSx3O5h9qf1mNM8oJTczKFnoQid+BBMDszVGO9z8SUpJz2jKUQnOxpBma3Xsi/YvGI5xcXtshrVMDDspLqoZjnfG/EEk8uA+6fQn7TFkd7OQDW6t+UOt/h8yULUl7LQeb8ieA5r2aeuDEAAA";
    protected fr.ifremer.isisfish.entities.CellImpl bean;
    protected javax.swing.JButton cancel;
    protected fr.ifremer.isisfish.map.IsisMapBean cellMap;
    protected jaxx.runtime.swing.JAXXComboBox fieldCell;
    protected javax.swing.JTextArea fieldCellComment;
    protected javax.swing.JCheckBox fieldCellLand;
    protected javax.swing.JTextField fieldCellLatitude;
    protected javax.swing.JTextField fieldCellLongitude;
    protected javax.swing.JTextField fieldCellName;
    protected javax.swing.JPanel map;
    protected javax.swing.JButton save;
    protected com.bbn.openmap.gui.ToolPanel toolMap;
    private fr.ifremer.isisfish.ui.input.CellUI $InputContentUI0 = this;
    private javax.swing.JLabel $JLabel10;
    private javax.swing.JLabel $JLabel11;
    private javax.swing.JLabel $JLabel7;
    private javax.swing.JLabel $JLabel8;
    private javax.swing.JLabel $JLabel9;
    private javax.swing.JPanel $JPanel4;
    private javax.swing.JScrollPane $JScrollPane12;
    private javax.swing.JSplitPane $JSplitPane5;
    private jaxx.runtime.swing.Table $Table6;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();
    private java.beans.PropertyChangeListener $DataSource15 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel7.enabled");
    private java.beans.PropertyChangeListener $DataSource16 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellName.enabled");
    private java.beans.PropertyChangeListener $DataSource17 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellName.text");
    private java.beans.PropertyChangeListener $DataSource18 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel8.enabled");
    private java.beans.PropertyChangeListener $DataSource19 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLatitude.enabled");
    private java.beans.PropertyChangeListener $DataSource20 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLatitude.text");
    private java.beans.PropertyChangeListener $DataSource21 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel9.enabled");
    private java.beans.PropertyChangeListener $DataSource22 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLongitude.enabled");
    private java.beans.PropertyChangeListener $DataSource23 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLongitude.text");
    private java.beans.PropertyChangeListener $DataSource24 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel10.enabled");
    private java.beans.PropertyChangeListener $DataSource25 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLand.enabled");
    private java.beans.PropertyChangeListener $DataSource26 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellLand.selected");
    private java.beans.PropertyChangeListener $DataSource27 = new jaxx.runtime.DataBindingListener($InputContentUI0, "$JLabel11.enabled");
    private java.beans.PropertyChangeListener $DataSource28 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellComment.enabled");
    private java.beans.PropertyChangeListener $DataSource29 = new jaxx.runtime.DataBindingListener($InputContentUI0, "fieldCellComment.text");
    private java.beans.PropertyChangeListener $DataSource31 = new jaxx.runtime.DataBindingListener($InputContentUI0, "cellMap.fisheryRegion");
    private java.beans.PropertyChangeListener $DataSource32 = new jaxx.runtime.DataBindingListener($InputContentUI0, "cellMap.selectedCells");

    /* begin raw body code */
    protected OMToolSet toolSet;
    protected OpenMapEvents mapListener;
    boolean cellChanged;
    
    
    @Override
    public void refresh() {
        Cell cell = getVerifier().getEntity(Cell.class);
        
        // add null before, for second to be considered as a changed event
        // otherwize, setBean has no effect
        setBean(null);
        setBean((CellImpl) cell);
    
        // reload region in map
        refreshRegionInMap(cellMap);
        
        jaxx.runtime.Util.assignment(cellChanged = false, "cellChanged", fr.ifremer.isisfish.ui.input.CellUI.this);
        jaxx.runtime.SwingUtil.fillComboBox(fieldCell, getRegion().getCell(), getBean());
        jaxx.runtime.Util.assignment(cellChanged = true, "cellChanged", fr.ifremer.isisfish.ui.input.CellUI.this);
    }
    
    @Override
    public void setActionButtons() {
        getVerifier().setSaveButton(save);
        getVerifier().setCancelButton(cancel);
    }
    
    protected OpenMapEvents getMapListener() {
        if (mapListener == null){
            jaxx.runtime.Util.assignment(mapListener = new OpenMapEvents(cellMap, new SelectMouseMode(false), CellSelectionLayer.SINGLE_SELECTION) {
                @Override
                public boolean mouseClicked(MouseEvent e) {
                    boolean result = false;
                    // TODO a fixer, le clic droit du menu contextuel
                    // passe aussi par ici et change la selection
                    //if (e.getButton() == MouseEvent.BUTTON1) {
                        for (Cell c : cellMap.getSelectedCells()) {
                            if (getBean() != null) {
                                if (!c.getTopiaId().equals(getBean().getTopiaId())) {
                                    jaxx.runtime.SwingUtil.fillComboBox(fieldCell,getRegion().getCell(), c);
                                    result = true;
                                }
                            }
                        }
                    //}
                    return result;
                }
            }, "mapListener", fr.ifremer.isisfish.ui.input.CellUI.this);
        }
        return mapListener;
    }
    
    protected void fieldCellChanged() {
        if (cellChanged) {
            Cell c = (Cell)fieldCell.getSelectedItem();
            if (c==null) {
                return;
            }
            Cell oldC = getBean();
            if (oldC != null && c.getTopiaId().equals(oldC.getTopiaId())) {
                // avoid reentrant code
                return;
            }
            
            // FIXME il ne faut pas appeler le parent
            // on ne sais jamais de quel type est le parent
            InputUI inputUI = getParentContainer(InputUI.class);
            if (inputUI != null) {
                inputUI.setTreeSelection("$root/$cells/" + c.getTopiaId());
            }
            else {
                SensitivityTabUI sensitivityTabUI = getParentContainer(SensitivityTabUI.class);
                sensitivityTabUI.setTreeSelection("$root/$cells/"+c.getTopiaId());
            }
        }
    }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public CellUI() {
        super();
        $initialize();
    }

    public CellUI(jaxx.runtime.JAXXContext parentContext) {
        super(parentContext);
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldCellName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldCellName.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource17);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("name", $DataSource17);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldCellLatitude.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource19);
            }
        } else if ("fieldCellLatitude.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("latitude", $DataSource20);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldCellLongitude.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldCellLongitude.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("longitude", $DataSource23);
            }
        } else if ("$JLabel10.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldCellLand.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource25);
            }
        } else if ("fieldCellLand.selected".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("land", $DataSource26);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldCellComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("actif", $DataSource28);
            }
        } else if ("fieldCellComment.text".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource29);
        if (getBean() != null) {
                getBean().addPropertyChangeListener("comment", $DataSource29);
            }
        } else if ("cellMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.addPropertyChangeListener("region", $DataSource31);
            }
        } else if ("cellMap.selectedCells".equals($binding)) {
                addPropertyChangeListener("bean", $DataSource32);
        
        } else {
            super.applyDataBinding($binding);
            return;
        }
        processDataBinding($binding);
    }

    public void processDataBinding(String $dest, boolean $force) {
        if (!$force && $activeBindings.contains($dest)) { 
            return;
        }
        $activeBindings.add($dest);
        try {
            if ("$JLabel7.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel7.setEnabled((isActif()));
            }
            } else if ("fieldCellName.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldCellName.setEnabled((isActif()));
            }
            } else if ("fieldCellName.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellName, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getName()))));
            }
            } else if ("$JLabel8.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel8.setEnabled((isActif()));
            }
            } else if ("fieldCellLatitude.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldCellLatitude.setEnabled((isActif()));
            }
            } else if ("fieldCellLatitude.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellLatitude, String.valueOf((getBean().getLatitude())));
            }
            } else if ("$JLabel9.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel9.setEnabled((isActif()));
            }
            } else if ("fieldCellLongitude.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldCellLongitude.setEnabled((isActif()));
            }
            } else if ("fieldCellLongitude.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellLongitude, String.valueOf((getBean().getLongitude())));
            }
            } else if ("$JLabel10.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel10.setEnabled((isActif()));
            }
            } else if ("fieldCellLand.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldCellLand.setEnabled((isActif()));
            }
            } else if ("fieldCellLand.selected".equals($dest)) {
            if (getBean() != null) {
                fieldCellLand.setSelected((getBean().getLand()));
            }
            } else if ("$JLabel11.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                $JLabel11.setEnabled((isActif()));
            }
            } else if ("fieldCellComment.enabled".equals($dest)) {
            if ($InputContentUI0 != null) {
                fieldCellComment.setEnabled((isActif()));
            }
            } else if ("fieldCellComment.text".equals($dest)) {
            if (getBean() != null) {
                jaxx.runtime.SwingUtil.setText(fieldCellComment, String.valueOf((jaxx.runtime.SwingUtil.getStringValue(getBean().getComment()))));
            }
            } else if ("cellMap.fisheryRegion".equals($dest)) {
            if ($InputContentUI0 != null) {
                cellMap.setFisheryRegion((getRegion()));
            }
            } else if ("cellMap.selectedCells".equals($dest)) {
            cellMap.setSelectedCells((getBean()));
            } else {
                super.processDataBinding($dest, true);
            }
        } finally {
            $activeBindings.remove($dest);
        }
    }

    public void removeDataBinding(String $binding) {
        if ("$JLabel7.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource15);
            }
        } else if ("fieldCellName.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource16);
            }
        } else if ("fieldCellName.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource17);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("name", $DataSource17);
            }
        } else if ("$JLabel8.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource18);
            }
        } else if ("fieldCellLatitude.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource19);
            }
        } else if ("fieldCellLatitude.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource20);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("latitude", $DataSource20);
            }
        } else if ("$JLabel9.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource21);
            }
        } else if ("fieldCellLongitude.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource22);
            }
        } else if ("fieldCellLongitude.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource23);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("longitude", $DataSource23);
            }
        } else if ("$JLabel10.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource24);
            }
        } else if ("fieldCellLand.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource25);
            }
        } else if ("fieldCellLand.selected".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource26);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("land", $DataSource26);
            }
        } else if ("$JLabel11.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource27);
            }
        } else if ("fieldCellComment.enabled".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("actif", $DataSource28);
            }
        } else if ("fieldCellComment.text".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource29);
        if (getBean() != null) {
                getBean().removePropertyChangeListener("comment", $DataSource29);
            }
        } else if ("cellMap.fisheryRegion".equals($binding)) {
            if ($InputContentUI0 != null) {
                $InputContentUI0.removePropertyChangeListener("region", $DataSource31);
            }
        } else if ("cellMap.selectedCells".equals($binding)) {
                removePropertyChangeListener("bean", $DataSource32);
        
        } else {
            super.removeDataBinding($binding);
        }
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__fieldCell(java.awt.event.ActionEvent event) {
        fieldCellChanged();
    }

    public void doActionPerformed__on__fieldCellLand(java.awt.event.ActionEvent event) {
        getBean().setLand(fieldCellLand.isSelected());
    }

    public void doKeyReleased__on__fieldCellComment(java.awt.event.KeyEvent event) {
        getBean().setComment(fieldCellComment.getText());
    }

    public void doKeyReleased__on__fieldCellName(java.awt.event.KeyEvent event) {
        getBean().setName(fieldCellName.getText());
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public fr.ifremer.isisfish.entities.CellImpl getBean() {
        return bean;
    }

    public javax.swing.JButton getCancel() {
        return cancel;
    }

    public fr.ifremer.isisfish.map.IsisMapBean getCellMap() {
        return cellMap;
    }

    public jaxx.runtime.swing.JAXXComboBox getFieldCell() {
        return fieldCell;
    }

    public javax.swing.JTextArea getFieldCellComment() {
        return fieldCellComment;
    }

    public javax.swing.JCheckBox getFieldCellLand() {
        return fieldCellLand;
    }

    public javax.swing.JTextField getFieldCellLatitude() {
        return fieldCellLatitude;
    }

    public javax.swing.JTextField getFieldCellLongitude() {
        return fieldCellLongitude;
    }

    public javax.swing.JTextField getFieldCellName() {
        return fieldCellName;
    }

    public javax.swing.JPanel getMap() {
        return map;
    }

    public javax.swing.JButton getSave() {
        return save;
    }

    public com.bbn.openmap.gui.ToolPanel getToolMap() {
        return toolMap;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public mutator methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void setBean(fr.ifremer.isisfish.entities.CellImpl newValue) {
        fr.ifremer.isisfish.entities.CellImpl oldValue = this.bean;
        this.bean = newValue;
        firePropertyChange("bean", oldValue, newValue);
    }

    public void setCellMap(fr.ifremer.isisfish.map.IsisMapBean newValue) {
        fr.ifremer.isisfish.map.IsisMapBean oldValue = this.cellMap;
        this.cellMap = newValue;
        firePropertyChange("cellMap", oldValue, newValue);
    }

    public void setToolMap(com.bbn.openmap.gui.ToolPanel newValue) {
        com.bbn.openmap.gui.ToolPanel oldValue = this.toolMap;
        this.toolMap = newValue;
        firePropertyChange("toolMap", oldValue, newValue);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.input.CellUI get$InputContentUI0() {
        return $InputContentUI0;
    }

    protected javax.swing.JLabel get$JLabel10() {
        return $JLabel10;
    }

    protected javax.swing.JLabel get$JLabel11() {
        return $JLabel11;
    }

    protected javax.swing.JLabel get$JLabel7() {
        return $JLabel7;
    }

    protected javax.swing.JLabel get$JLabel8() {
        return $JLabel8;
    }

    protected javax.swing.JLabel get$JLabel9() {
        return $JLabel9;
    }

    protected javax.swing.JPanel get$JPanel4() {
        return $JPanel4;
    }

    protected javax.swing.JScrollPane get$JScrollPane12() {
        return $JScrollPane12;
    }

    protected javax.swing.JSplitPane get$JSplitPane5() {
        return $JSplitPane5;
    }

    protected jaxx.runtime.swing.Table get$Table6() {
        return $Table6;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $InputContentUI0.add($JPanel4);
        
        
        
        
        $JPanel4.add($JSplitPane5, BorderLayout.CENTER);
        
        $JSplitPane5.add($Table6, JSplitPane.LEFT);
        $JSplitPane5.add(map, JSplitPane.RIGHT);
        
        $Table6.add(fieldCell, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel7, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellName), new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel8, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellLatitude), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel9, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellLongitude), new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel10, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellLand), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JLabel11, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add($JScrollPane12, new GridBagConstraints(0, 6, 2, 1, 1.0, 1.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(save), new GridBagConstraints(0, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        $Table6.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cancel), new GridBagConstraints(1, 7, 1, 1, 0.5, 0.0, 10, 2, new Insets(3, 3, 3, 3), 0, 0));
        
        
        
        
        
        
        $JScrollPane12.getViewport().add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(fieldCellComment));
        
        addChildrenToMap();
        fieldCell.setModel((new DefaultComboBoxModel()));
        applyDataBinding("$JLabel7.enabled");
        applyDataBinding("fieldCellName.enabled");
        applyDataBinding("fieldCellName.text");
        applyDataBinding("$JLabel8.enabled");
        applyDataBinding("fieldCellLatitude.enabled");
        applyDataBinding("fieldCellLatitude.text");
        applyDataBinding("$JLabel9.enabled");
        applyDataBinding("fieldCellLongitude.enabled");
        applyDataBinding("fieldCellLongitude.text");
        applyDataBinding("$JLabel10.enabled");
        applyDataBinding("fieldCellLand.enabled");
        applyDataBinding("fieldCellLand.selected");
        applyDataBinding("$JLabel11.enabled");
        applyDataBinding("fieldCellComment.enabled");
        applyDataBinding("fieldCellComment.text");
        applyDataBinding("cellMap.fisheryRegion");
        applyDataBinding("cellMap.selectedCells");
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$InputContentUI0", this);
        createBean();
        
        toolSet = new OMToolSet();
        
        mapListener = null;
        
        cellChanged = true;
        
        $JPanel4 = new javax.swing.JPanel();
        $objectMap.put("$JPanel4", $JPanel4);
        $JPanel4.setName("$JPanel4");
        $JPanel4.setLayout((new BorderLayout()));
        
        $JSplitPane5 = new javax.swing.JSplitPane();
        $objectMap.put("$JSplitPane5", $JSplitPane5);
        $JSplitPane5.setName("$JSplitPane5");
        $JSplitPane5.setDividerLocation(200);
        $JSplitPane5.setOneTouchExpandable(true);
        $JSplitPane5.setOrientation(1);
        
        $Table6 = new jaxx.runtime.swing.Table();
        $objectMap.put("$Table6", $Table6);
        $Table6.setName("$Table6");
        
        createFieldCell();
        
        $JLabel7 = new javax.swing.JLabel();
        $objectMap.put("$JLabel7", $JLabel7);
        $JLabel7.setName("$JLabel7");
        $JLabel7.setText(_("isisfish.cell.name"));
        
        createFieldCellName();
        
        $JLabel8 = new javax.swing.JLabel();
        $objectMap.put("$JLabel8", $JLabel8);
        $JLabel8.setName("$JLabel8");
        $JLabel8.setText(_("isisfish.cell.latitude"));
        
        createFieldCellLatitude();
        
        $JLabel9 = new javax.swing.JLabel();
        $objectMap.put("$JLabel9", $JLabel9);
        $JLabel9.setName("$JLabel9");
        $JLabel9.setText(_("isisfish.cell.longitude"));
        
        createFieldCellLongitude();
        
        $JLabel10 = new javax.swing.JLabel();
        $objectMap.put("$JLabel10", $JLabel10);
        $JLabel10.setName("$JLabel10");
        $JLabel10.setText(_("isisfish.cell.land"));
        
        createFieldCellLand();
        
        $JLabel11 = new javax.swing.JLabel();
        $objectMap.put("$JLabel11", $JLabel11);
        $JLabel11.setName("$JLabel11");
        $JLabel11.setHorizontalAlignment(0);
        $JLabel11.setText(_("isisfish.cell.comments"));
        
        $JScrollPane12 = new javax.swing.JScrollPane();
        $objectMap.put("$JScrollPane12", $JScrollPane12);
        $JScrollPane12.setName("$JScrollPane12");
        
        createFieldCellComment();
        createSave();
        createCancel();
        createMap();
        createToolMap();
        createCellMap();
        $InputContentUI0.removeDataBinding("$JPanel0.name");
        
        $InputContentUI0.setName("$InputContentUI0");
        
        
        
        
        
        
        
        
        
        
        
        
        setButtonTitle(_("isisfish.input.continueZones"));setNextPath("$root/$zones");cellMap.addMapMouseListener(getMapListener());// add copy to clipboard support
        cellMap.addMapMouseListener(new CopyMapToClipboardListener(cellMap));toolSet.setupListeners(cellMap);toolMap.add((Tool)toolSet);addPropertyChangeListener("bean", new PropertyChangeListener() {
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getOldValue() != null || evt.getNewValue() == null) {
                    fieldCellName.setText("");
                    fieldCellLatitude.setText("");
                    fieldCellLongitude.setText("");
                    fieldCellComment.setText("");
                    fieldCellLand.setSelected(false);
                }
                if (evt.getNewValue() != null) {
        
                }
            }
        });
        $completeSetup();
    }

    protected void addChildrenToMap() {
        if (!allComponentsCreated) {
            return;
        }
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(toolMap), BorderLayout.NORTH);
        map.add(jaxx.runtime.SwingUtil.boxComponentWithJxLayer(cellMap), BorderLayout.CENTER);
    }

    protected void createBean() {
        bean = null;
        $objectMap.put("bean", bean);
    }

    protected void createCancel() {
        cancel = new javax.swing.JButton();
        $objectMap.put("cancel", cancel);
        cancel.setName("cancel");
        cancel.setText(_("isisfish.common.cancel"));
    }

    protected void createCellMap() {
        cellMap = new fr.ifremer.isisfish.map.IsisMapBean();
        $objectMap.put("cellMap", cellMap);
        cellMap.setName("cellMap");
        cellMap.setSelectionMode(1);
    }

    protected void createFieldCell() {
        fieldCell = new jaxx.runtime.swing.JAXXComboBox();
        $objectMap.put("fieldCell", fieldCell);
        fieldCell.setName("fieldCell");
        fieldCell.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldCell"));
    }

    protected void createFieldCellComment() {
        fieldCellComment = new javax.swing.JTextArea();
        $objectMap.put("fieldCellComment", fieldCellComment);
        fieldCellComment.setName("fieldCellComment");
        fieldCellComment.setColumns(15);
        fieldCellComment.setLineWrap(true);
        fieldCellComment.setWrapStyleWord(true);
        fieldCellComment.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldCellComment"));
    }

    protected void createFieldCellLand() {
        fieldCellLand = new javax.swing.JCheckBox();
        $objectMap.put("fieldCellLand", fieldCellLand);
        fieldCellLand.setName("fieldCellLand");
        fieldCellLand.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $InputContentUI0, "doActionPerformed__on__fieldCellLand"));
    }

    protected void createFieldCellLatitude() {
        fieldCellLatitude = new javax.swing.JTextField();
        $objectMap.put("fieldCellLatitude", fieldCellLatitude);
        fieldCellLatitude.setName("fieldCellLatitude");
        fieldCellLatitude.setColumns(15);
        fieldCellLatitude.setEditable(false);
    }

    protected void createFieldCellLongitude() {
        fieldCellLongitude = new javax.swing.JTextField();
        $objectMap.put("fieldCellLongitude", fieldCellLongitude);
        fieldCellLongitude.setName("fieldCellLongitude");
        fieldCellLongitude.setColumns(15);
        fieldCellLongitude.setEditable(false);
    }

    protected void createFieldCellName() {
        fieldCellName = new javax.swing.JTextField();
        $objectMap.put("fieldCellName", fieldCellName);
        fieldCellName.setName("fieldCellName");
        fieldCellName.setColumns(15);
        fieldCellName.addKeyListener((java.awt.event.KeyListener) jaxx.runtime.Util.getEventListener(java.awt.event.KeyListener.class, "keyReleased", $InputContentUI0, "doKeyReleased__on__fieldCellName"));
    }

    protected void createMap() {
        map = new javax.swing.JPanel();
        $objectMap.put("map", map);
        map.setName("map");
        map.setLayout((new BorderLayout()));
    }

    protected void createSave() {
        save = new javax.swing.JButton();
        $objectMap.put("save", save);
        save.setName("save");
        save.setText(_("isisfish.common.save"));
    }

    protected void createToolMap() {
        toolMap = new com.bbn.openmap.gui.ToolPanel();
        $objectMap.put("toolMap", toolMap);
        toolMap.setName("toolMap");
    }

}
