/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import static org.nuiton.i18n.I18n._;
import javax.swing.JFrame;
import fr.ifremer.isisfish.IsisFish;
import fr.ifremer.isisfish.IsisConfig;
import fr.ifremer.isisfish.ui.simulator.SimulAction;
import fr.ifremer.isisfish.ui.input.InputUI;
import fr.ifremer.isisfish.ui.input.InputAction;
import fr.ifremer.isisfish.ui.input.InputSaveVerifier;
import fr.ifremer.isisfish.ui.sensitivity.SensitivityUI;
import fr.ifremer.isisfish.ui.result.ResultAction;
import fr.ifremer.isisfish.ui.result.ResultView;
import fr.ifremer.isisfish.ui.script.ScriptUI;
import fr.ifremer.isisfish.ui.simulator.SimulUI;
import fr.ifremer.isisfish.ui.queue.QueueUI;
import fr.ifremer.isisfish.ui.config.SSHLauncherConfigUI;
import fr.ifremer.isisfish.ui.vcs.VCSConfigUI;
import org.nuiton.widget.AboutFrame;
import jaxx.runtime.DefaultJAXXContext;
import jaxx.runtime.JAXXInitialContext;
import jaxx.runtime.swing.editor.config.ConfigUI;
import jaxx.runtime.swing.editor.config.ConfigUIBuilder;
import jaxx.runtime.swing.editor.config.model.ConfigUIModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WelcomeUI extends javax.swing.JFrame implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.WelcomeUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAALWVS2/TQBDHt6FJX7Q8WiqQSgkQEOLgPPpISqvyaFU1VQqIqKIQEGzrbbPIsY13TQwSCIkrQj1x4ALcOXJHiCMnrnwHhPgGzNqJ7VCTVKzIwUnmP//fzqylmQ8/UJxZ6OQD7DiKZeuc1oiycnl9/drGA7LJFwnbtKjJDQt5n64YilXQgOrHGUenKyVhTzfs6QWjZho60UPu2RLqZ/yxRliVEM7REc+xyVi67IdnHdO2mjS/mCjau18/Yzvq8/cxhBwTqkpCC8lOrqCD7hKKUZWjw3DSI5zWsL4NZVhU34Y6B0VsQcOMXcU18hA9Qz0llDCxBTCOTu29VZfh+h2To97UypIFwAxHyS1LoVsWqRH4ZpRtUVZVbKrcJNqmUSNrRdN0fQmOhlNlF1vUKadYo0+IleXohNsq5JpUA8aulLb+nJCGgpT+1Moq0e0r2JrgaEQ07yisDnehNONBbo+XO8nRoV2JIuWQnzngZRY5qU3B696VLQSROuI79qdWygSuGcMdTnM02mLxlVZP6JS8CB1rlRvlFsTf0b/WN+M7T4SLacrZTAc920HPddAnIvTB0GVkJ0Vw7O+AqQhAr6dnpyN6D3uDa0tH6oUO+kyE3jg7l2l/di64uPwub8735iO9waXNRuqTHfSpDvp0hB5+Kbm8/1KiCyxENNcCmGkPmMhEAIbq3oi4jnWirRU5OtN+lDTyhLvPhBk57A0OxpRg6gZjsauC4pYNYY4OVoIBfQNC3mhuRF2AG3374s2j1x8/XWjO4XE4Y7AlJbQ2YC6almESi1NxxAFv+NqcaulVbM5WUB8jGuwcd6eMhAooN8JQBPDdyaMIm7KMWRWs8Z7vn7+M3v+2D8WWUL9mYHUJi/wi6uNVC7o0NNUxL15yK9lf74XnQVETR4kqodtVGOuH56iuUZ0kMYc9sGFzMu9AwyOhhv0qvu68XB17dTzfbLrLK+qPtKDx+G2U8Oju2mlslMg1M2AyYqtGsDmidkmX+O43G1N5zX3eiuxOw48NG7obmlMxx8kNqqswTaEzYbnrli5+3dszsQ9ukz7BG5pb8J1/B8U55fKQOizxqiSkmxOHt2Ec2QOjh+jiTtQ2mKMdMSLs/FfCuDQhKU04JU1ISRPOShPOSRPOSxMUaUJGmpDbE+FpG8KkdA3yhGlpQkGacEGaMCdNmJcmXJImXJEmLEoTlqUJJSD8BjJ82BpaDwAA";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected fr.ifremer.isisfish.ui.WelcomePanelUI welcomePanelUI;
    private fr.ifremer.isisfish.ui.WelcomeUI $JFrame0 = this;
    private javax.swing.JMenu $JMenu16;
    private javax.swing.JMenu $JMenu20;
    private javax.swing.JMenu $JMenu22;
    private javax.swing.JMenu $JMenu4;
    private javax.swing.JMenu $JMenu8;
    private javax.swing.JMenuBar $JMenuBar3;
    private javax.swing.JMenuItem $JMenuItem10;
    private javax.swing.JMenuItem $JMenuItem11;
    private javax.swing.JMenuItem $JMenuItem12;
    private javax.swing.JMenuItem $JMenuItem13;
    private javax.swing.JMenuItem $JMenuItem15;
    private javax.swing.JMenuItem $JMenuItem17;
    private javax.swing.JMenuItem $JMenuItem18;
    private javax.swing.JMenuItem $JMenuItem19;
    private javax.swing.JMenuItem $JMenuItem21;
    private javax.swing.JMenuItem $JMenuItem23;
    private javax.swing.JMenuItem $JMenuItem24;
    private javax.swing.JMenuItem $JMenuItem25;
    private javax.swing.JMenuItem $JMenuItem26;
    private javax.swing.JMenuItem $JMenuItem28;
    private javax.swing.JMenuItem $JMenuItem30;
    private javax.swing.JMenuItem $JMenuItem5;
    private javax.swing.JMenuItem $JMenuItem7;
    private javax.swing.JMenuItem $JMenuItem9;
    private javax.swing.JSeparator $JSeparator14;
    private javax.swing.JSeparator $JSeparator27;
    private javax.swing.JSeparator $JSeparator29;
    private javax.swing.JSeparator $JSeparator6;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */
    Map<JFrame, WelcomePanelUI> allFrameOpened;
    WelcomeSaveVerifier verifier;
    // increase tooltip display time
        ToolTipManager toolTipManager;
    
                
        protected void openFrame(Component c, String title) {
            JFrame f = new JFrame();
            f.setLayout(new BorderLayout());
    
            JAXXInitialContext childContext = new JAXXInitialContext().add(verifier).add(this);
            WelcomePanelUI welcome = new WelcomePanelUI(childContext);
    
            welcome.setContent(c);
            f.add(welcome, BorderLayout.CENTER);
            f.setTitle(title);
            f.setSize(new Dimension(800, 600));
            f.setDefaultCloseOperation(f.DO_NOTHING_ON_CLOSE);
    
            allFrameOpened.put(f, welcome);
            f.addWindowListener(new WindowAdapter() {
                @Override
                public void windowClosing(WindowEvent e) {
                    JFrame f = (JFrame) e.getSource();
                    allFrameOpened.get(f).close(f);
                }
            });
            org.nuiton.widget.SwingUtil.center(f);
            f.setVisible(true);
        }
        public void close() {
            if (verifier.allIsSaved()) {
                exit();
            }
        }
        protected void exit() {
            this.dispose();
            IsisFish.quit();
        }
        protected WelcomeSaveVerifier getVerifier() {
            return getContextValue(WelcomeSaveVerifier.class);
        }
        protected void monitorUI() {
            new ApplicationMonitorUI();
        }
        protected void updateVCS() {
    // FIXME a reimplanter
    // thread:Welcome.updateVCS()
        }
        
        /**
         * Show config frame (Jaxx based).
         */
        protected void config() {
            ConfigUIModel model = new ConfigUIModel(IsisFish.config);
    
            // categorie main
            model.addCategory(
                    _("isisfish.config.category.main"),
                    _("isisfish.config.category.main.description"),
                    IsisConfig.Option.CONFIG_FILE,
                    IsisConfig.Option.DATABASE_DIRECTORY,
                    IsisConfig.Option.COMPILATION_DIRECTORY,
                    IsisConfig.Option.MONITORING_DIRECTORY,
                    IsisConfig.Option.JAVADOC_DIRECTORY,
                    IsisConfig.Option.BACKUP_DIRECTORY,
                    IsisConfig.Option.LOCALE,
                    IsisConfig.Option.SIMULATION_SHOW_ONLY_ERROR
                    );
    
            // categorie versionning
            model.addCategory(
                    _("isisfish.config.category.versioning"),
                    _("isisfish.config.category.versioning.description"),
                    IsisConfig.Option.VCS_TYPE,
                    IsisConfig.Option.VCS_PROTOCOL,
                    IsisConfig.Option.VCS_USER_NAME,
                    IsisConfig.Option.VCS_USER_PASSWORD,
                    IsisConfig.Option.VCS_HOST_NAME,
                    IsisConfig.Option.VCS_PATH
                    );
            
            // categorie misc
            model.addCategory(
                    _("isisfish.config.category.misc"),
                    _("isisfish.config.category.misc.description"),
                    IsisConfig.Option.SSH_KEY_FILE,
                    IsisConfig.Option.USER_NAME,
                    IsisConfig.Option.SMTP_SERVER,
                    IsisConfig.Option.USER_MAIL
                    );
    
            ConfigUI configUI = ConfigUIBuilder.newConfigUI(new DefaultJAXXContext(this), model, _("isisfish.config.category.main"));
            ConfigUIBuilder.showConfigUI(configUI, this, false);
        }
        
        protected void configVCS() {
            VCSConfigUI vcsConfig = new VCSConfigUI();
            vcsConfig.pack();
            org.nuiton.widget.SwingUtil.center(vcsConfig);
            vcsConfig.setVisible(true);
        }
        
        protected void configurationSSHLauncher() {
            SSHLauncherConfigUI configUI = new SSHLauncherConfigUI();
            configUI.pack();
            configUI.setSize(600, configUI.getHeight());
            org.nuiton.widget.SwingUtil.center(configUI);
            configUI.setVisible(true);
        }
        
        protected void help(String urlAlias) {
            Help.showURL(urlAlias);
        }
    
        /**
         * Show about frame from nuiton-widgets.
         */
    	protected void about() {
    	   AboutFrame about = new AboutFrame();
    	   about.setTitle(_("isisfish.about.title"));
    	   about.setIconPath("images/strategy.jpg");
    	   about.setAboutHtmlText(_("isisfish.about.abouthtmltext", IsisConfig.getVersion()));
    	   about.setLicenseText(_("isisfish.about.licensetext"));
    	   about.setBackgroundColor(Color.WHITE);
    	   about.setSize(640, 520);
    	   org.nuiton.widget.SwingUtil.center(about);
    	   about.setVisible(true);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public WelcomeUI() {
        $initialize();
    }

    public WelcomeUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Event methods ----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void doActionPerformed__on__$JMenuItem10(java.awt.event.ActionEvent event) {
        openFrame(new ResultView(), _("isisfish.result.title"));
    }

    public void doActionPerformed__on__$JMenuItem11(java.awt.event.ActionEvent event) {
        openFrame(new InputUI(new JAXXInitialContext().add(verifier).add(new InputAction()).add(new InputSaveVerifier()).add(this)), _("isisfish.input.title"));
    }

    public void doActionPerformed__on__$JMenuItem12(java.awt.event.ActionEvent event) {
        openFrame(new ScriptUI(), _("isisfish.script.title"));
    }

    public void doActionPerformed__on__$JMenuItem13(java.awt.event.ActionEvent event) {
        openFrame(new SensitivityUI(new JAXXInitialContext().add(new InputAction()).add(new InputSaveVerifier()).add(new SimulAction()).add(this)), _("isisfish.sensitivity.title"));
    }

    public void doActionPerformed__on__$JMenuItem15(java.awt.event.ActionEvent event) {
        openFrame(new QueueUI(), _("isisfish.queue.title"));
    }

    public void doActionPerformed__on__$JMenuItem17(java.awt.event.ActionEvent event) {
        config();
    }

    public void doActionPerformed__on__$JMenuItem18(java.awt.event.ActionEvent event) {
        configVCS();
    }

    public void doActionPerformed__on__$JMenuItem19(java.awt.event.ActionEvent event) {
        configurationSSHLauncher();
    }

    public void doActionPerformed__on__$JMenuItem21(java.awt.event.ActionEvent event) {
        help("ISISFISH");
    }

    public void doActionPerformed__on__$JMenuItem23(java.awt.event.ActionEvent event) {
        help("JAVA_API");
    }

    public void doActionPerformed__on__$JMenuItem24(java.awt.event.ActionEvent event) {
        help("ISIS_API");
    }

    public void doActionPerformed__on__$JMenuItem25(java.awt.event.ActionEvent event) {
        help("MATRIX_API");
    }

    public void doActionPerformed__on__$JMenuItem26(java.awt.event.ActionEvent event) {
        help("TOPIA_API");
    }

    public void doActionPerformed__on__$JMenuItem28(java.awt.event.ActionEvent event) {
        monitorUI();
    }

    public void doActionPerformed__on__$JMenuItem30(java.awt.event.ActionEvent event) {
        about();
    }

    public void doActionPerformed__on__$JMenuItem5(java.awt.event.ActionEvent event) {
        updateVCS();
    }

    public void doActionPerformed__on__$JMenuItem7(java.awt.event.ActionEvent event) {
        close();
    }

    public void doActionPerformed__on__$JMenuItem9(java.awt.event.ActionEvent event) {
        openFrame(new SimulUI(new JAXXInitialContext().add(new SimulAction()).add(this)), _("isisfish.simulation.title"));
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public fr.ifremer.isisfish.ui.WelcomePanelUI getWelcomePanelUI() {
        return welcomePanelUI;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected fr.ifremer.isisfish.ui.WelcomeUI get$JFrame0() {
        return $JFrame0;
    }

    protected javax.swing.JMenu get$JMenu16() {
        return $JMenu16;
    }

    protected javax.swing.JMenu get$JMenu20() {
        return $JMenu20;
    }

    protected javax.swing.JMenu get$JMenu22() {
        return $JMenu22;
    }

    protected javax.swing.JMenu get$JMenu4() {
        return $JMenu4;
    }

    protected javax.swing.JMenu get$JMenu8() {
        return $JMenu8;
    }

    protected javax.swing.JMenuBar get$JMenuBar3() {
        return $JMenuBar3;
    }

    protected javax.swing.JMenuItem get$JMenuItem10() {
        return $JMenuItem10;
    }

    protected javax.swing.JMenuItem get$JMenuItem11() {
        return $JMenuItem11;
    }

    protected javax.swing.JMenuItem get$JMenuItem12() {
        return $JMenuItem12;
    }

    protected javax.swing.JMenuItem get$JMenuItem13() {
        return $JMenuItem13;
    }

    protected javax.swing.JMenuItem get$JMenuItem15() {
        return $JMenuItem15;
    }

    protected javax.swing.JMenuItem get$JMenuItem17() {
        return $JMenuItem17;
    }

    protected javax.swing.JMenuItem get$JMenuItem18() {
        return $JMenuItem18;
    }

    protected javax.swing.JMenuItem get$JMenuItem19() {
        return $JMenuItem19;
    }

    protected javax.swing.JMenuItem get$JMenuItem21() {
        return $JMenuItem21;
    }

    protected javax.swing.JMenuItem get$JMenuItem23() {
        return $JMenuItem23;
    }

    protected javax.swing.JMenuItem get$JMenuItem24() {
        return $JMenuItem24;
    }

    protected javax.swing.JMenuItem get$JMenuItem25() {
        return $JMenuItem25;
    }

    protected javax.swing.JMenuItem get$JMenuItem26() {
        return $JMenuItem26;
    }

    protected javax.swing.JMenuItem get$JMenuItem28() {
        return $JMenuItem28;
    }

    protected javax.swing.JMenuItem get$JMenuItem30() {
        return $JMenuItem30;
    }

    protected javax.swing.JMenuItem get$JMenuItem5() {
        return $JMenuItem5;
    }

    protected javax.swing.JMenuItem get$JMenuItem7() {
        return $JMenuItem7;
    }

    protected javax.swing.JMenuItem get$JMenuItem9() {
        return $JMenuItem9;
    }

    protected javax.swing.JSeparator get$JSeparator14() {
        return $JSeparator14;
    }

    protected javax.swing.JSeparator get$JSeparator27() {
        return $JSeparator27;
    }

    protected javax.swing.JSeparator get$JSeparator29() {
        return $JSeparator29;
    }

    protected javax.swing.JSeparator get$JSeparator6() {
        return $JSeparator6;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $JFrame0.getContentPane().add(welcomePanelUI);
        $JFrame0.setJMenuBar($JMenuBar3);
        
        
        
        $JMenuBar3.add($JMenu4);
        $JMenuBar3.add($JMenu8);
        $JMenuBar3.add($JMenu16);
        $JMenuBar3.add($JMenu20);
        
        $JMenu4.add($JMenuItem5);
        $JMenu4.add($JSeparator6);
        $JMenu4.add($JMenuItem7);
        
        
        
        
        $JMenu8.add($JMenuItem9);
        $JMenu8.add($JMenuItem10);
        $JMenu8.add($JMenuItem11);
        $JMenu8.add($JMenuItem12);
        $JMenu8.add($JMenuItem13);
        $JMenu8.add($JSeparator14);
        $JMenu8.add($JMenuItem15);
        
        
        
        
        
        
        
        
        $JMenu16.add($JMenuItem17);
        $JMenu16.add($JMenuItem18);
        $JMenu16.add($JMenuItem19);
        
        
        
        
        $JMenu20.add($JMenuItem21);
        $JMenu20.add($JMenu22);
        $JMenu20.add($JSeparator27);
        $JMenu20.add($JMenuItem28);
        $JMenu20.add($JSeparator29);
        $JMenu20.add($JMenuItem30);
        
        
        $JMenu22.add($JMenuItem23);
        $JMenu22.add($JMenuItem24);
        $JMenu22.add($JMenuItem25);
        $JMenu22.add($JMenuItem26);
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$JFrame0", this);
        verifier = new WelcomeSaveVerifier();
        
        toolTipManager = ToolTipManager.sharedInstance();
        
        $JMenuBar3 = new javax.swing.JMenuBar();
        $objectMap.put("$JMenuBar3", $JMenuBar3);
        $JMenuBar3.setName("$JMenuBar3");
        
        $JMenu4 = new javax.swing.JMenu();
        $objectMap.put("$JMenu4", $JMenu4);
        $JMenu4.setName("$JMenu4");
        $JMenu4.setText(_("isisfish.welcome.menu.file"));
        
        create$JMenuItem5();
        
        $JSeparator6 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator6", $JSeparator6);
        $JSeparator6.setName("$JSeparator6");
        
        $JMenuItem7 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem7", $JMenuItem7);
        $JMenuItem7.setName("$JMenuItem7");
        $JMenuItem7.setText(_("isisfish.welcome.menu.close"));
        $JMenuItem7.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem7"));
        
        $JMenu8 = new javax.swing.JMenu();
        $objectMap.put("$JMenu8", $JMenu8);
        $JMenu8.setName("$JMenu8");
        $JMenu8.setText(_("isisfish.welcome.menu.frame"));
        
        $JMenuItem9 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem9", $JMenuItem9);
        $JMenuItem9.setName("$JMenuItem9");
        $JMenuItem9.setText(_("isisfish.welcome.menu.simulation"));
        $JMenuItem9.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem9"));
        
        create$JMenuItem10();
        
        $JMenuItem11 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem11", $JMenuItem11);
        $JMenuItem11.setName("$JMenuItem11");
        $JMenuItem11.setText(_("isisfish.welcome.menu.input"));
        $JMenuItem11.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem11"));
        
        create$JMenuItem12();
        
        $JMenuItem13 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem13", $JMenuItem13);
        $JMenuItem13.setName("$JMenuItem13");
        $JMenuItem13.setText(_("isisfish.sensitivity.title"));
        $JMenuItem13.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem13"));
        
        $JSeparator14 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator14", $JSeparator14);
        $JSeparator14.setName("$JSeparator14");
        
        $JMenuItem15 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem15", $JMenuItem15);
        $JMenuItem15.setName("$JMenuItem15");
        $JMenuItem15.setText(_("isisfish.welcome.menu.queue"));
        $JMenuItem15.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem15"));
        
        $JMenu16 = new javax.swing.JMenu();
        $objectMap.put("$JMenu16", $JMenu16);
        $JMenu16.setName("$JMenu16");
        $JMenu16.setText(_("isisfish.welcome.menu.configuration"));
        
        create$JMenuItem17();
        create$JMenuItem18();
        create$JMenuItem19();
        
        $JMenu20 = new javax.swing.JMenu();
        $objectMap.put("$JMenu20", $JMenu20);
        $JMenu20.setName("$JMenu20");
        $JMenu20.setText(_("isisfish.welcome.menu.help"));
        
        create$JMenuItem21();
        
        $JMenu22 = new javax.swing.JMenu();
        $objectMap.put("$JMenu22", $JMenu22);
        $JMenu22.setName("$JMenu22");
        $JMenu22.setText(_("isisfish.welcome.menu.api"));
        
        create$JMenuItem23();
        create$JMenuItem24();
        create$JMenuItem25();
        create$JMenuItem26();
        
        $JSeparator27 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator27", $JSeparator27);
        $JSeparator27.setName("$JSeparator27");
        
        create$JMenuItem28();
        
        $JSeparator29 = new javax.swing.JSeparator();
        $objectMap.put("$JSeparator29", $JSeparator29);
        $JSeparator29.setName("$JSeparator29");
        
        $JMenuItem30 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem30", $JMenuItem30);
        $JMenuItem30.setName("$JMenuItem30");
        $JMenuItem30.setText(_("isisfish.welcome.menu.about"));
        $JMenuItem30.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem30"));
        
        createWelcomePanelUI();
        $JFrame0.setName("$JFrame0");
        jaxx.runtime.Util.setComponentHeight($JFrame0,736);
        
        $JFrame0.getContentPane().setLayout((new BorderLayout()));
        $JFrame0.setResizable(true);
        $JFrame0.setTitle(_("isisfish.welcome.title"));
        jaxx.runtime.Util.setComponentWidth($JFrame0,874);
        
        
        
        setContextValue(verifier);jaxx.runtime.Util.assignment(allFrameOpened = new java.util.HashMap<JFrame, WelcomePanelUI>(), "allFrameOpened", fr.ifremer.isisfish.ui.WelcomeUI.this);welcomePanelUI.setContent(new WelcomeTabUI(new JAXXInitialContext().add(getVerifier())));toolTipManager.setInitialDelay(0);toolTipManager.setDismissDelay(60000);
        $completeSetup();
    }

    protected void create$JMenuItem10() {
        $JMenuItem10 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem10", $JMenuItem10);
        $JMenuItem10.setName("$JMenuItem10");
        $JMenuItem10.setText(_("isisfish.welcome.menu.result"));
        $JMenuItem10.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem10"));
    }

    protected void create$JMenuItem12() {
        $JMenuItem12 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem12", $JMenuItem12);
        $JMenuItem12.setName("$JMenuItem12");
        $JMenuItem12.setText(_("isisfish.welcome.menu.script"));
        $JMenuItem12.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem12"));
    }

    protected void create$JMenuItem17() {
        $JMenuItem17 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem17", $JMenuItem17);
        $JMenuItem17.setName("$JMenuItem17");
        $JMenuItem17.setText(_("isisfish.welcome.menu.configuration"));
        $JMenuItem17.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem17"));
    }

    protected void create$JMenuItem18() {
        $JMenuItem18 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem18", $JMenuItem18);
        $JMenuItem18.setName("$JMenuItem18");
        $JMenuItem18.setEnabled(false);
        $JMenuItem18.setText(_("isisfish.welcome.menu.configuration.vcs"));
        $JMenuItem18.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem18"));
    }

    protected void create$JMenuItem19() {
        $JMenuItem19 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem19", $JMenuItem19);
        $JMenuItem19.setName("$JMenuItem19");
        $JMenuItem19.setText(_("isisfish.welcome.menu.configuration.sshlauncher"));
        $JMenuItem19.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem19"));
    }

    protected void create$JMenuItem21() {
        $JMenuItem21 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem21", $JMenuItem21);
        $JMenuItem21.setName("$JMenuItem21");
        $JMenuItem21.setText(_("isisfish.welcome.menu.help.isisfish"));
        $JMenuItem21.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem21"));
    }

    protected void create$JMenuItem23() {
        $JMenuItem23 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem23", $JMenuItem23);
        $JMenuItem23.setName("$JMenuItem23");
        $JMenuItem23.setText(_("isisfish.welcome.menu.help.javaapi"));
        $JMenuItem23.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem23"));
    }

    protected void create$JMenuItem24() {
        $JMenuItem24 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem24", $JMenuItem24);
        $JMenuItem24.setName("$JMenuItem24");
        $JMenuItem24.setText(_("isisfish.welcome.menu.help.isisfishapi"));
        $JMenuItem24.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem24"));
    }

    protected void create$JMenuItem25() {
        $JMenuItem25 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem25", $JMenuItem25);
        $JMenuItem25.setName("$JMenuItem25");
        $JMenuItem25.setText(_("isisfish.welcome.menu.help.matrixapi"));
        $JMenuItem25.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem25"));
    }

    protected void create$JMenuItem26() {
        $JMenuItem26 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem26", $JMenuItem26);
        $JMenuItem26.setName("$JMenuItem26");
        $JMenuItem26.setText(_("isisfish.welcome.menu.help.topiaapi"));
        $JMenuItem26.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem26"));
    }

    protected void create$JMenuItem28() {
        $JMenuItem28 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem28", $JMenuItem28);
        $JMenuItem28.setName("$JMenuItem28");
        $JMenuItem28.setText(_("isisfish.welcome.menu.monitor"));
        $JMenuItem28.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem28"));
    }

    protected void create$JMenuItem5() {
        $JMenuItem5 = new javax.swing.JMenuItem();
        $objectMap.put("$JMenuItem5", $JMenuItem5);
        $JMenuItem5.setName("$JMenuItem5");
        $JMenuItem5.setEnabled(false);
        $JMenuItem5.setText(_("isisfish.welcome.menu.synchro"));
        $JMenuItem5.addActionListener((java.awt.event.ActionListener) jaxx.runtime.Util.getEventListener(java.awt.event.ActionListener.class, "actionPerformed", $JFrame0, "doActionPerformed__on__$JMenuItem5"));
    }

    protected void createWelcomePanelUI() {
        welcomePanelUI =  new fr.ifremer.isisfish.ui.WelcomePanelUI(new DefaultJAXXContext(this));
        $objectMap.put("welcomePanelUI", welcomePanelUI);
        welcomePanelUI.removeDataBinding("$JPanel0.name");
        
        welcomePanelUI.setName("welcomePanelUI");
    }

}
