/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.ui;

import fr.ifremer.isisfish.ui.*;
import java.awt.*;
import java.awt.event.*;
import java.beans.*;
import java.io.*;
import java.lang.*;
import java.util.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import jaxx.runtime.swing.JAXXButtonGroup;
import jaxx.runtime.swing.HBox;
import jaxx.runtime.swing.VBox;
import jaxx.runtime.swing.Table;
import static org.nuiton.i18n.I18n._;
import static jaxx.runtime.Util.createImageIcon;
import jaxx.runtime.SwingUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StatusBarUI extends jaxx.runtime.swing.Table implements jaxx.runtime.JAXXObject {
    public static final Log log = LogFactory.getLog(fr.ifremer.isisfish.ui.StatusBarUI.class);
    private static java.lang.String $jaxxObjectDescriptor = "H4sIAAAAAAAAAI2RS0vDQBSFb0MfaFGkIghufHQ90a1dad1YgopVKGQ1bafplDQZZ27auBHBP+DKhRt179K9v0jEf+Dk0URF0GwC58535tw5z29QUhI2RjQMiQw85GNGWnudznF3xHp4wFRPcoG+hOQrGGDYUO1nukLYsq0IN1PcbPpj4XvM+0I3LJhXeOkyNWQMEVYSoqeU2c7kRigCOXPLwvzm9vjxbtz2r58MgFDoVEW9wvpfVL5B0QKD9xFq+qYJNV3qOTqG5J6jcy5EWtOlSh3RMbuAK6hYUBZUajOEzf+vGnvEfCgQKvUz2nXZtrYYSMIHko2Z/iuuBlwNScBJGykGap/K80MhYrCMsCik70imVDJFWI3ihURNdVrSOkmnmoqAuYyrurTL3BlU+wZZ0ejH8Xp2+w7Cmi8d4gUcfY9Med9hmIdLOQnL8XvrBkneYP7EBRtKMtAywpKdl32qpaTmVI0NYvXh5n5y9/K6O+sUPgEXocNmmwIAAA==";
    protected java.util.List<Object> $activeBindings = new ArrayList<Object>();
    protected java.util.Map<String,Object> $bindingSources = new HashMap<String,Object>();
    protected Map<String,Object> $objectMap = new HashMap<String,Object>();
    protected final jaxx.runtime.JAXXContext delegateContext = new jaxx.runtime.DefaultJAXXContext(this);;
    protected javax.swing.JLabel labelStatus;
    protected javax.swing.JProgressBar progressStatus;
    private org.nuiton.widget.StatusBar $StatusBar1;
    private fr.ifremer.isisfish.ui.StatusBarUI $Table0 = this;
    private boolean allComponentsCreated;
    private boolean contextInitialized = true;
    java.util.Map $previousValues = new java.util.HashMap();

    /* begin raw body code */
    /**
         * Change status message and stop progress bar if running.
         *
         * @param message new message
         */
        public void setStatusMessage(String message) {
            setStatusMessage(message, false);
        }
    
        /**
         * Change status message and progress bar state.
         *
         * @param message new message
         */
        public void setStatusMessage(String message, boolean state) {
            // use a basic mode, swap indeterminate state
            // can't known real progression here
            progressStatus.setIndeterminate(state);
            labelStatus.setText(message);
        }
    /* end raw body code */
    /*---------------------------------------------------------------------------------*/
    /*-- Statics methods --------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public static jaxx.runtime.JAXXObjectDescriptor $getJAXXObjectDescriptor() {
        return jaxx.runtime.Util.decodeCompressedJAXXObjectDescriptor($jaxxObjectDescriptor);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- Constructors -----------------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public StatusBarUI() {
        $initialize();
    }

    public StatusBarUI(jaxx.runtime.JAXXContext parentContext) {
        if (parentContext instanceof jaxx.runtime.JAXXInitialContext) {
            ((jaxx.runtime.JAXXInitialContext)parentContext).to(this);
        } else {
            setContextValue(parentContext);
        }
        $initialize();
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXObject implementation ----------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public void applyDataBinding(String $binding) {
        processDataBinding($binding);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        super.firePropertyChange(propertyName, oldValue, newValue);
    }

    public Map<String,Object> get$objectMap() {
        return $objectMap;
    }

    public java.lang.Object getObjectById(String id) {
        return $objectMap.get(id);
    }

    public void processDataBinding(String dest) {
        processDataBinding(dest, false);
    }

    public void processDataBinding(String $dest, boolean $force) {
        
    }

    public void removeDataBinding(String $binding) {
        
    }

    /*---------------------------------------------------------------------------------*/
    /*-- JAXXContext implementation ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public <T> T getContextValue(Class<T> clazz) {
        return delegateContext.getContextValue(clazz, null);
    }

    public <T> T getContextValue(Class<T> clazz, String name) {
        return delegateContext.getContextValue(clazz, name);
    }

    public jaxx.runtime.JAXXContext getDelegateContext() {
        return delegateContext;
    }

    public <O extends Container> O getParentContainer(Class<O> clazz) {
        return delegateContext.getParentContainer(clazz);
    }

    public <O extends Container> O getParentContainer(Object source, Class<O> clazz) {
        return delegateContext.getParentContainer(source, clazz);
    }

    public <T> void removeContextValue(Class<T> clazz) {
        delegateContext.removeContextValue(clazz, null);
    }

    public <T> void removeContextValue(Class<T> clazz, String name) {
        delegateContext.removeContextValue(clazz, name);
    }

    public <T> void setContextValue(T o) {
        delegateContext.setContextValue(o, null);
    }

    public <T> void setContextValue(T o, String name) {
        delegateContext.setContextValue(o, name);
    }

    /*---------------------------------------------------------------------------------*/
    /*-- public acessor methods -------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    public java.util.List<Object> get$activeBindings() {
        return $activeBindings;
    }

    public java.util.Map<String,Object> get$bindingSources() {
        return $bindingSources;
    }

    public javax.swing.JLabel getLabelStatus() {
        return labelStatus;
    }

    public javax.swing.JProgressBar getProgressStatus() {
        return progressStatus;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- protected acessors methods ---------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    protected org.nuiton.widget.StatusBar get$StatusBar1() {
        return $StatusBar1;
    }

    protected fr.ifremer.isisfish.ui.StatusBarUI get$Table0() {
        return $Table0;
    }

    protected java.lang.String get$jaxxObjectDescriptor() {
        return $jaxxObjectDescriptor;
    }

    protected java.util.Map get$previousValues() {
        return $previousValues;
    }

    protected boolean getAllComponentsCreated() {
        return allComponentsCreated;
    }

    protected boolean getContextInitialized() {
        return contextInitialized;
    }

    protected Log getLog() {
        return log;
    }

    /*---------------------------------------------------------------------------------*/
    /*-- ui creation methods ----------------------------------------------------------*/
    /*---------------------------------------------------------------------------------*/

    private void $completeSetup() {
        allComponentsCreated = true;
        $Table0.add(progressStatus, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add(labelStatus, new GridBagConstraints(1, 0, 1, 1, 5.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
        $Table0.add($StatusBar1, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private void $initialize() {
        if (allComponentsCreated || !contextInitialized) {
            return;
        }
        $objectMap.put("$Table0", this);
        createProgressStatus();
        createLabelStatus();
        
        $StatusBar1 = new org.nuiton.widget.StatusBar();
        $objectMap.put("$StatusBar1", $StatusBar1);
        $StatusBar1.setName("$StatusBar1");
        
        $Table0.setName("$Table0");
        
        
        $completeSetup();
    }

    protected void createLabelStatus() {
        labelStatus = new javax.swing.JLabel();
        $objectMap.put("labelStatus", labelStatus);
        labelStatus.setName("labelStatus");
    }

    protected void createProgressStatus() {
        progressStatus = new javax.swing.JProgressBar();
        $objectMap.put("progressStatus", progressStatus);
        progressStatus.setName("progressStatus");
    }

}
