/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator.sensitivity.domain;

import java.io.Serializable;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.DomainVisitor;

/**
 * Domaine continu.
 * 
 * Composé d'un borne min et max.
 *
 * @param <E> type des valeurs gérées par le domaine
 * @param <F> type des labels
 * 
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 24 févr. 2009 $
 * By : $Author: chatellier $
 */
public class ContinuousDomain<E extends Serializable, F extends Serializable> implements Domain<E,F> {

    /** serialVersionUID. */
    private static final long serialVersionUID = -2037768174807839046L;

    /** Borne inférieure */
    protected double minBound;

    /** Borne supérieure */
    protected double maxBound;

    /** Cardinality */
    protected int cardinality;

    /**
     * Empty constructor.
     */
    public ContinuousDomain() {

    }

    /**
     * Constructor with bounds.
     * 
     * @param minBound min bound
     * @param maxBound max bound
     */
    public ContinuousDomain(double minBound, double maxBound) {
        this();
        this.minBound = minBound;
        this.maxBound = maxBound;
    }
    
    /**
     * @return the minBound
     */
    public double getMinBound() {
        return minBound;
    }

    /**
     * @param minBound the minBound to set
     */
    public void setMinBound(double minBound) {
        this.minBound = minBound;
    }

    /**
     * @return the maxBound
     */
    public double getMaxBound() {
        return maxBound;
    }

    /**
     * @param maxBound the maxBound to set
     */
    public void setMaxBound(double maxBound) {
        this.maxBound = maxBound;
    }

    /**
     * {@inheritDoc}.
     * 
     * In continuous domain, just return identifier
     */
    public E getValueForIdentifier(F identifier) {
        // FIXME test cast
        return (E)identifier;
    }

    /**
     * Accept a new visitor.
     * 
     * @param visitor
     */
    public void accept(DomainVisitor visitor) {
        visitor.start(this);
        visitor.end(this);
    }

    /**
     * Get cardinality
     * 
     * @return cardinality
     */
    public int getCardinality() {
        return cardinality;
    }

    /**
     * Set cardinality
     * 
     * @param cardinality
     */
    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }
    
    public ContinuousDomain<E,F> clone(){
        ContinuousDomain<E,F> cloned = new ContinuousDomain<E,F>();
        cloned.setCardinality(this.cardinality);
        cloned.setMaxBound(this.maxBound);
        cloned.setMinBound(this.minBound);
        return cloned;
    }
}
