/*
 * #%L
 * IsisFish
 * 
 * $Id: SimulationResultXML.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2007 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.math.matrix.MatrixIterator;
import org.nuiton.math.matrix.MatrixND;
import static org.nuiton.i18n.I18n._;

import fr.ifremer.isisfish.IsisFishException;
import fr.ifremer.isisfish.datastore.SimulationStorage;
import fr.ifremer.isisfish.types.Date;


/**
 * <!ELEMENT outData (m,d,i,s)*>
 * <!ELEMENT m (dim+, (d|i|s)+)>
 * <!ELEMENT dim (label)+)>
 * <!ELEMENT d (#PCDATA)>
 * <!ELEMENT i (#PCDATA)>
 * <!ELEMENT s (#PCDATA)>
 * 
 * <!ATTLIST m 
 *     name CDATA #REQUIRED
 *     step CDATA #IMPLIED>
 *
 * <!ATTLIST dim 
 *     name CDATA #REQUIRED
 *     size CDATA #REQUIRED>
 * 
 * <!ATTLIST d 
 *     step CDATA #IMPLIED>
 * 
 * <!ATTLIST i
 *     step CDATA #IMPLIED>
 * 
 * <!ATTLIST s
 *     step CDATA #IMPLIED>
 * 
 * @author poussin
 */
public class SimulationResultXML implements SimulationResultListener {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(SimulationResultXML.class);

    protected Writer out = null;
    protected File outFilename = null;
    
    public SimulationResultXML() {
    }

    public SimulationResultXML(File outfilename) {
        setOutFilename(outfilename);
    }

    
    /**
     * @param outfilename The outfilename to set.
     */
    public void setOutFilename(File outfilename) {
        this.outFilename = outfilename;
    }
        
    /**
     * @return Returns the outfilename.
     */
    public File getOutFilename() {
        //if (outFilename == null) {
        //    outFilename = new File(IsisConfig.SIMULATION_RESULT_XML_FILE);
        //}
        return outFilename;
    }
    
    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.simulator.SimulationListener#afterSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    public void afterSimulation(SimulationContext context) {
        try {
            out.write("</outData>\n");
            out.close();
        } catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn(_("isisfish.error.simulation.resultXml.close",eee.getMessage()), eee);
            }
        }
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.simulator.SimulationListener#beforeSimulation(fr.ifremer.isisfish.simulator.SimulationContext)
     */
    public void beforeSimulation(SimulationContext context) {
        try {
            File file = getOutFilename();
            //TODO validate this modification
            if (file==null) {
                File simulationDir = context.getSimulationStorage().getDirectory();
                file = SimulationStorage.getSimulationResultXmlFile(simulationDir);
                setOutFilename(file);
            }
            file.getParentFile().mkdirs();
            out = new BufferedWriter(new FileWriter(file));
            out.write("<outData>\n");
        } catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn(_("isisfish.error.simulation.resultXml.open",eee.getMessage()), eee);
            }
        }
    }

    /* (non-Javadoc)
     * @see fr.ifremer.isisfish.simulator.SimulationResultListener#addResult(fr.ifremer.isisfish.simulator.SimulationContext, fr.ifremer.isisfish.types.Date, java.lang.String, org.nuiton.math.matrix.MatrixND)
     */
    public void addResult(SimulationContext context, Date date, String name,
            MatrixND mat) throws IsisFishException {
        try {
            out.write("  <m name='" + name + "' date='" + date + "'>\n");
            for (int dim=0; dim<mat.getNbDim(); dim++) {
                out.write("    <dimension name='" + mat.getDimensionName(dim) + "' size='" + mat.getDim(dim) + "'>");
                for (Object sem : mat.getSemantics(dim)) {
                    out.write("      <label>" + sem + "</label>");
                }
                out.write("    </dimension>");
            }
            for(MatrixIterator i=mat.iterator();i.hasNext();) {
                out.write("    <d>" + i.getValue() + "</d>");
            }
            out.write("  </m>\n");
        } catch (IOException eee) {
            if (log.isWarnEnabled()) {
                log.warn(_("isisfish.error.simulation.resultXml.write",eee.getMessage()), eee);
            }
        }
        
    }

}


