/*
 * #%L
 * IsisFish
 * 
 * $Id: RuleMonitor.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2006 - 2010 Ifremer, Code Lutin, Cédric Pineau, Benjamin Poussin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.simulator;

import org.apache.commons.collections.map.MultiKeyMap;

import fr.ifremer.isisfish.entities.Metier;
import fr.ifremer.isisfish.rule.Rule;
import fr.ifremer.isisfish.types.Date;

/**
 * This class keep trace of rule evalution condition for all step and all metier.
 * 
 * Created: 21 août 2006 15:45:03
 *
 * @author poussin
 * @version $Revision: 3124 $
 *
 * Last update: $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * by : $Author: chatellier $
 */
public class RuleMonitor {

    protected MultiKeyMap evalutionCondition = new MultiKeyMap();

    public boolean getEvalutionCondition(Date date, Rule rule, Metier metier) {
        return (Boolean) this.evalutionCondition.get(date, rule, metier);
    }

    public void setEvaluationCondition(Date date, Rule rule, Metier metier,
            boolean evalutionCondition) {
        this.evalutionCondition.put(date, rule, metier, evalutionCondition);
    }

}
