/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.xml;

import java.io.Serializable;

import fr.ifremer.isisfish.simulator.sensitivity.Domain;
import fr.ifremer.isisfish.simulator.sensitivity.Factor;
import fr.ifremer.isisfish.simulator.sensitivity.domain.ContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.DiscreteDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.EquationContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.domain.MatrixContinuousDomain;
import fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor;

/**
 * XML factor visitor.
 *
 * @author chatellier
 * @version $Revision: 1.0 $
 * 
 * Last update : $Date: 5 mars 2009 $
 * By : $Author: chatellier $
 */
public class FactorXMLVisitor implements FactorVisitor {

    /** XML text buffer. */
    protected StringBuffer xmlBuffer;
    
    /**
     * Constructor.
     * 
     * Init xml buffer.
     */
    public FactorXMLVisitor() {
        xmlBuffer = new StringBuffer();
    }

    /**
     * Get xml buffer content.
     * 
     * @return content as string
     */
    public String getXML() {
        String xml = xmlBuffer.toString();
        return xml;
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#start(fr.ifremer.isisfish.simulator.sensitivity.Factor)
     */
    @Override
    public void start(Factor factor) {
        xmlBuffer.append("<factor");
        xmlBuffer.append(" name=\"" + factor.getName() + "\"");
        Serializable referenceValueForType = null;
        // property attribute
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            xmlBuffer.append(" property=\"matrixcontinuous\"");
            referenceValueForType = ((MatrixContinuousDomain)factor.getDomain()).getMinBound();
        }
        else if (factor.getDomain() instanceof EquationContinuousDomain) {
            xmlBuffer.append(" property=\"equationcontinuous\"");
            referenceValueForType = ((ContinuousDomain)factor.getDomain()).getMinBound();
        }
        else if (factor.getDomain() instanceof ContinuousDomain) {
            xmlBuffer.append(" property=\"continuous\"");
            referenceValueForType = ((ContinuousDomain)factor.getDomain()).getMinBound();
        }
        else if (factor.getDomain() instanceof DiscreteDomain) {
            xmlBuffer.append(" property=\"discrete\"");
            Object firstKey = ((DiscreteDomain)factor.getDomain()).getValues().firstKey();
            referenceValueForType = (Serializable)((DiscreteDomain)factor.getDomain()).getValues().get(firstKey);
        }
        // type attribute
        if (referenceValueForType instanceof Double || referenceValueForType instanceof Float) {
            xmlBuffer.append(" type=\"real\"");
        }
        else if (referenceValueForType instanceof Integer) {
            xmlBuffer.append(" type=\"integer\"");
        }
        xmlBuffer.append(">");
        // target element
        xmlBuffer.append("<target>" + factor.getPath() + "</target>");
        // value element
        /* TODO value should be only in simulation export,
        not in design plan export
        if (factor.getValue() != null) {
            xmlBuffer.append("<value>" + factor.getValue() + "</value>");
        }*/
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#visit(fr.ifremer.isisfish.simulator.sensitivity.Domain)
     */
    @Override
    public void visit(Factor factor, Domain domain) {
        DomainXMLVisitor visitor = null;
        if (factor.getDomain() instanceof MatrixContinuousDomain) {
            visitor = new MatrixContinuousDomainXMLVisitor();
        }
        else if (factor.getDomain() instanceof EquationContinuousDomain) {
            visitor = new EquationContinuousDomainXMLVisitor();
        }
        else if (factor.getDomain() instanceof ContinuousDomain) {
            visitor = new ContinuousDomainXMLVisitor();
        }
        else if (factor.getDomain() instanceof DiscreteDomain) {
            visitor = new DiscreteDomainXMLVisitor();
        }
        domain.accept(visitor);
        xmlBuffer.append(visitor.getXML());
    }

    /*
     * @see fr.ifremer.isisfish.simulator.sensitivity.visitor.FactorVisitor#end(fr.ifremer.isisfish.simulator.sensitivity.Factor)
     */
    @Override
    public void end(Factor factor) {
        xmlBuffer.append("</factor>");
    }
}
