/*
 * #%L
 * IsisFish
 * 
 * $Id: HorizontalEntityVisitor.java 3124 2010-11-29 18:14:09Z chatellier $
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2010 Ifremer, Code Lutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */

package fr.ifremer.isisfish.mexico.export;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;

import fr.ifremer.isisfish.entities.Equation;

/**
 * Parcourt en largeur du model et délegation à un autre visiteur.
 * 
 * @author chatellier
 * @version $Revision: 3124 $
 * 
 * Last update : $Date: 2010-11-29 19:14:09 +0100 (lun., 29 nov. 2010) $
 * By : $Author$
 * 
 * @deprecated use those from topia
 */
@Deprecated
public class HorizontalEntityVisitor implements EntityVisitor {

    /** Class logger. */
    private static Log log = LogFactory.getLog(HorizontalEntityVisitor.class);
    
    /** Delegate visitor. */
    protected EntityVisitor delegateVisitor;

    /** Cache used to remember entity during exploration. */
    protected List<TopiaEntity> alreadyExplored;

    /** Entity to be visited later. */
    protected List<TopiaEntity> toVisitEntities;

    /**
     * Constructor.
     * 
     * @param delegateVisitor delegate visitor
     */
    public HorizontalEntityVisitor(EntityVisitor delegateVisitor) {
        this.delegateVisitor = delegateVisitor;
        this.alreadyExplored = new ArrayList<TopiaEntity>();
        this.toVisitEntities = new ArrayList<TopiaEntity>();
    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#start(org.nuiton.topia.persistence.TopiaEntity)
     */
    @Override
    public void start(TopiaEntity entity) {
        delegateVisitor.start(entity);
        if (!alreadyExplored.contains(entity)) {
            alreadyExplored.add(entity);
        }
    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#visit(org.nuiton.topia.persistence.TopiaEntity, java.lang.String, java.lang.Class, java.lang.Object)
     */
    @Override
    public void visit(TopiaEntity e, String name, Class<?> type, Object value) {
        // si c'est une entité
        
        // FIXME only hack about Equation is used instead of Topia visitor
        if (value instanceof TopiaEntity && !(value instanceof Equation)) {
            TopiaEntity entity = (TopiaEntity) value;
            toVisitEntities.add(entity);
        } else {
            delegateVisitor.visit(e, name, type, value);
        }
    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#visit(org.nuiton.topia.persistence.TopiaEntity, java.lang.String, java.lang.Class, java.lang.Class, java.lang.Object)
     */
    @Override
    public void visit(TopiaEntity e, String name, Class<?> collectionType,
            Class<?> type, Object value) {
        
        Collection<?> values = (Collection<?>) value;
        if (values != null && !values.isEmpty()) {
            int i = 0;
            for (Object currentValue : values) {
                visit(e, name, type, collectionType, i++, currentValue);
            }
        }

    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#visit(org.nuiton.topia.persistence.TopiaEntity, java.lang.String, java.lang.Class, java.lang.Class, int, java.lang.Object)
     */
    @Override
    public void visit(TopiaEntity e, String name, Class<?> collectionType,
            Class<?> type, int index, Object value) {
        // si c'est une entité
        if (value instanceof TopiaEntity) {
            TopiaEntity entity = (TopiaEntity) value;

            toVisitEntities.add(entity);
        } else {
            delegateVisitor.visit(e, name, collectionType, type, index, value);
        }
    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#end(org.nuiton.topia.persistence.TopiaEntity)
     */
    @Override
    public void end(TopiaEntity entity) {
        delegateVisitor.end(entity);
        
        // here, must revisit all remembered entities
        List<TopiaEntity> currentEntities = new ArrayList<TopiaEntity>(toVisitEntities);
        // TODO verify if clearing here is enought
        toVisitEntities.clear();
        for (TopiaEntity currentEntity : currentEntities) {
            try {
                if (!alreadyExplored.contains(currentEntity)) {
                    currentEntity.accept(this);
                }
            } catch (TopiaException ex) {
                if (log.isErrorEnabled()) {
                    log.error("Error on horizontal exploration", ex);
                }
            }
        }
    }

    /*
     * @see org.nuiton.topia.persistence.EntityVisitor#clear()
     */
    @Override
    public void clear() {
        alreadyExplored.clear();
        toVisitEntities.clear();
        delegateVisitor.clear();
    }
} // HorizontallyEntityVisitor
