/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class ZoneDAOAbstract<E extends Zone> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Zone.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<MetierSeasonInfo> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from metierSeasonInfo main, metierseasoninfo_zone secondary " +
                    "where main.topiaid=secondary.metierSeasonInfo" +
                    " and secondary.zone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(MetierSeasonInfo.class)).list();

            for (MetierSeasonInfo item : list) {
                item.removeZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_reproductionzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.reproductionZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removeReproductionZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_populationzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.populationZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removePopulationZone(entity);
            }
        }

        {
            List<Population> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from population main, population_recruitmentzone secondary " +
                    "where main.topiaid=secondary.population" +
                    " and secondary.recruitmentZone='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(Population.class)).list();

            for (Population item : list) {
                item.removeRecruitmentZone(entity);
            }
        }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Zone.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Zone.NAME, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Zone.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Zone.COMMENT, v);
        return result;
    }

    /**
     * findContainsCell :
     * Retourne le premier élément trouvé dont l'attribut cell contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsCell(Cell... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Zone.CELL, Arrays.asList(v));
        E result = findContainsProperties("cell", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsCell :
     * Retourne les éléments trouvé dont l'attribut cell contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsCell(Cell... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Zone.CELL, Arrays.asList(v));
        List<E> results = findAllContainsProperties("cell", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == MetierSeasonInfo.class) {
            MetierSeasonInfoDAO dao = (MetierSeasonInfoDAO)
                getContext().getDAO(MetierSeasonInfo.class);
            tmp = dao.findAllContainsZone(entity);
//            tmp = dao.findAllByProperties(MetierSeasonInfo.ZONE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsReproductionZone(entity);
//            tmp = dao.findAllByProperties(Population.REPRODUCTION_ZONE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsPopulationZone(entity);
//            tmp = dao.findAllByProperties(Population.POPULATION_ZONE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsRecruitmentZone(entity);
//            tmp = dao.findAllByProperties(Population.RECRUITMENT_ZONE, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        
        List<? extends TopiaEntity> list;

        list = findUsages(MetierSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(MetierSeasonInfo.class, list);
        }

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }


} //ZoneDAOAbstract<E extends Zone>
