/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Zone.NAME, Zone.COMMENT}
)

public interface Zone extends TopiaEntity {     String NAME = "name";
     String COMMENT = "comment";
     String CELL = "cell";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * addCell :
     * @param cell L'instance de cell à ajouter
     */

     void addCell(Cell cell);

    /**
     * addAllCell :
     * @param cell Les instances de cell à ajouter
     */

     void addAllCell(List<Cell> cell);

    /**
     * setCell :
     * @param cell La Collection de cell à ajouter
     */

     void setCell(List<Cell> cell);

    /**
     * removeCell :
     * @param cell Vide la Collection de cell
     */

     void removeCell(Cell cell);

    /**
     * clearCell :
     */

     void clearCell();

    /**
     * getCell :
     * @return List<Cell> 
     */

     List<Cell> getCell();

    /**
     * getCellByTopiaId :
     * Recupère l'attribut cell à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Cell 
     */

     Cell getCellByTopiaId(String topiaId);

    /**
     * sizeCell :
     * Retourne le nombre d'éléments de la collection cell
     * @return int 
     */

     int sizeCell();

    /**
     * isCellEmpty :
     * Retourne {@code true} si la collection cell est vide.
     * @return boolean 
     */

     boolean isCellEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();


} //Zone
