/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class VesselTypeDAOAbstract<E extends VesselType> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)VesselType.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<SetOfVessels> list = getContext()
                                                    .getDAO(SetOfVessels.class)
                                                    .findAllByProperties(SetOfVessels.VESSEL_TYPE, entity);
                        //                            .findAllByProperties("vesselType", entity);
                                            for (SetOfVessels item : list) {
                                                item.setVesselType(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(VesselType.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.NAME, v);
        return result;
    }

    /**
     * findByLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut length le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLength(int v) throws TopiaException {
        E result = findByProperty(VesselType.LENGTH, v);
        return result;
    }

    /**
     * findAllByLength :
     * Retourne les éléments ayant comme valeur pour l'attribut length le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLength(int v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.LENGTH, v);
        return result;
    }

    /**
     * findBySpeed :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut speed le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySpeed(double v) throws TopiaException {
        E result = findByProperty(VesselType.SPEED, v);
        return result;
    }

    /**
     * findAllBySpeed :
     * Retourne les éléments ayant comme valeur pour l'attribut speed le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySpeed(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.SPEED, v);
        return result;
    }

    /**
     * findByMaxTripDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxTripDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(VesselType.MAX_TRIP_DURATION, v);
        return result;
    }

    /**
     * findAllByMaxTripDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut maxTripDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.MAX_TRIP_DURATION, v);
        return result;
    }

    /**
     * findByActivityRange :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut activityRange le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByActivityRange(double v) throws TopiaException {
        E result = findByProperty(VesselType.ACTIVITY_RANGE, v);
        return result;
    }

    /**
     * findAllByActivityRange :
     * Retourne les éléments ayant comme valeur pour l'attribut activityRange le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByActivityRange(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.ACTIVITY_RANGE, v);
        return result;
    }

    /**
     * findByMinCrewSize :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minCrewSize le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinCrewSize(int v) throws TopiaException {
        E result = findByProperty(VesselType.MIN_CREW_SIZE, v);
        return result;
    }

    /**
     * findAllByMinCrewSize :
     * Retourne les éléments ayant comme valeur pour l'attribut minCrewSize le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinCrewSize(int v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.MIN_CREW_SIZE, v);
        return result;
    }

    /**
     * findByUnitFuelCostOfTravel :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut unitFuelCostOfTravel le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUnitFuelCostOfTravel(double v) throws TopiaException {
        E result = findByProperty(VesselType.UNIT_FUEL_COST_OF_TRAVEL, v);
        return result;
    }

    /**
     * findAllByUnitFuelCostOfTravel :
     * Retourne les éléments ayant comme valeur pour l'attribut unitFuelCostOfTravel le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUnitFuelCostOfTravel(double v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.UNIT_FUEL_COST_OF_TRAVEL, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(VesselType.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(VesselType.COMMENT, v);
        return result;
    }

    /**
     * findContainsTripType :
     * Retourne le premier élément trouvé dont l'attribut tripType contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsTripType(TripType... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(VesselType.TRIP_TYPE, Arrays.asList(v));
        E result = findContainsProperties("tripType", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsTripType :
     * Retourne les éléments trouvé dont l'attribut tripType contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsTripType(TripType... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(VesselType.TRIP_TYPE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("tripType", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == SetOfVessels.class) {
            SetOfVesselsDAO dao = (SetOfVesselsDAO)
                getContext().getDAO(SetOfVessels.class);
            tmp = dao.findAllByVesselType(entity);
//            tmp = dao.findAllByProperties(SetOfVessels.VESSEL_TYPE, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(SetOfVessels.class, entity);
        if (!list.isEmpty()) {
            result.put(SetOfVessels.class, list);
        }

        return result;
    }


} //VesselTypeDAOAbstract<E extends VesselType>
