/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class VesselTypeAbstract extends TopiaEntityAbstract implements VesselType {

    protected String name;
    protected int length;
    protected double speed;
    protected TimeUnit maxTripDuration;
    protected double activityRange;
    /**
     * <p>Taille minimum de l'&eacute;quipage sur ce style de bateau</p>


     */
    protected int minCrewSize;
    /**
     * <p>Co&ucirc;t d'un heure de carburant</p>


     */
    protected double unitFuelCostOfTravel;
    protected String comment;
    protected Collection<TripType> tripType;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(VesselType.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, LENGTH, int.class, length);
        visitor.visit(this, SPEED, double.class, speed);
        visitor.visit(this, MAX_TRIP_DURATION, TimeUnit.class, maxTripDuration);
        visitor.visit(this, ACTIVITY_RANGE, double.class, activityRange);
        visitor.visit(this, MIN_CREW_SIZE, int.class, minCrewSize);
        visitor.visit(this, UNIT_FUEL_COST_OF_TRAVEL, double.class, unitFuelCostOfTravel);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, TRIP_TYPE, Collection.class, TripType.class, tripType);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setLength :
     * @param value 
     */

    public void setLength(int value) {
        int _oldValue = this.length;
        fireOnPreWrite(LENGTH, _oldValue, value);
        this.length = value;
        fireOnPostWrite(LENGTH, _oldValue, value);
}

    /**
     * getLength :
     * @return int 
     */

    public int getLength() {
        fireOnPreRead(LENGTH, length);
        int result = this.length;
        fireOnPostRead(LENGTH, length);
        return result;
}

    /**
     * setSpeed :
     * @param value 
     */

    public void setSpeed(double value) {
        double _oldValue = this.speed;
        fireOnPreWrite(SPEED, _oldValue, value);
        this.speed = value;
        fireOnPostWrite(SPEED, _oldValue, value);
}

    /**
     * getSpeed :
     * @return double 
     */

    public double getSpeed() {
        fireOnPreRead(SPEED, speed);
        double result = this.speed;
        fireOnPostRead(SPEED, speed);
        return result;
}

    /**
     * setMaxTripDuration :
     * @param value 
     */

    public void setMaxTripDuration(TimeUnit value) {
        TimeUnit _oldValue = this.maxTripDuration;
        fireOnPreWrite(MAX_TRIP_DURATION, _oldValue, value);
        this.maxTripDuration = value;
        fireOnPostWrite(MAX_TRIP_DURATION, _oldValue, value);
}

    /**
     * getMaxTripDuration :
     * @return TimeUnit 
     */

    public TimeUnit getMaxTripDuration() {
        fireOnPreRead(MAX_TRIP_DURATION, maxTripDuration);
        TimeUnit result = this.maxTripDuration;
        fireOnPostRead(MAX_TRIP_DURATION, maxTripDuration);
        return result;
}

    /**
     * setActivityRange :
     * @param value 
     */

    public void setActivityRange(double value) {
        double _oldValue = this.activityRange;
        fireOnPreWrite(ACTIVITY_RANGE, _oldValue, value);
        this.activityRange = value;
        fireOnPostWrite(ACTIVITY_RANGE, _oldValue, value);
}

    /**
     * getActivityRange :
     * @return double 
     */

    public double getActivityRange() {
        fireOnPreRead(ACTIVITY_RANGE, activityRange);
        double result = this.activityRange;
        fireOnPostRead(ACTIVITY_RANGE, activityRange);
        return result;
}

    /**
     * setMinCrewSize :
     * @param value 
     */

    public void setMinCrewSize(int value) {
        int _oldValue = this.minCrewSize;
        fireOnPreWrite(MIN_CREW_SIZE, _oldValue, value);
        this.minCrewSize = value;
        fireOnPostWrite(MIN_CREW_SIZE, _oldValue, value);
}

    /**
     * getMinCrewSize :
     * @return int 
     */

    public int getMinCrewSize() {
        fireOnPreRead(MIN_CREW_SIZE, minCrewSize);
        int result = this.minCrewSize;
        fireOnPostRead(MIN_CREW_SIZE, minCrewSize);
        return result;
}

    /**
     * setUnitFuelCostOfTravel :
     * @param value 
     */

    public void setUnitFuelCostOfTravel(double value) {
        double _oldValue = this.unitFuelCostOfTravel;
        fireOnPreWrite(UNIT_FUEL_COST_OF_TRAVEL, _oldValue, value);
        this.unitFuelCostOfTravel = value;
        fireOnPostWrite(UNIT_FUEL_COST_OF_TRAVEL, _oldValue, value);
}

    /**
     * getUnitFuelCostOfTravel :
     * @return double 
     */

    public double getUnitFuelCostOfTravel() {
        fireOnPreRead(UNIT_FUEL_COST_OF_TRAVEL, unitFuelCostOfTravel);
        double result = this.unitFuelCostOfTravel;
        fireOnPostRead(UNIT_FUEL_COST_OF_TRAVEL, unitFuelCostOfTravel);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * addTripType :
     * @param tripType 
     */

    public void addTripType(TripType tripType) {    
        fireOnPreWrite(TRIP_TYPE, null, tripType);
        if (this.tripType == null) {
            this.tripType = new ArrayList<TripType>();
        }
        this.tripType.add(tripType);
        fireOnPostWrite(TRIP_TYPE, this.tripType.size(), null, tripType);
}

    /**
     * addAllTripType :
     * @param values 
     */

    public void addAllTripType(Collection<TripType> values) {
        if (values == null) {
            return;
        }
        for (TripType item : values) {
            addTripType(item);
        }
}

    /**
     * getTripTypeByTopiaId :
     * @param topiaId 
     * @return TripType 
     */

    public TripType getTripTypeByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(tripType, topiaId);
 }

    /**
     * setTripType :
     * @param values 
     */

    public void setTripType(Collection<TripType> values) {
        Collection<TripType> _oldValue = tripType;
        fireOnPreWrite(TRIP_TYPE, _oldValue, values);
        tripType = values;
        fireOnPostWrite(TRIP_TYPE, _oldValue, values);
}

    /**
     * removeTripType :
     * @param value 
     */

    public void removeTripType(TripType value) {
        fireOnPreWrite(TRIP_TYPE, value, null);
        if ((this.tripType == null) || (!this.tripType.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(TRIP_TYPE, this.tripType.size()+1, value, null);
}

    /**
     * clearTripType :
     */

    public void clearTripType() {
        if (this.tripType == null) {
            return;
        }
        Collection<TripType> _oldValue = new ArrayList<TripType>(this.tripType);
        fireOnPreWrite(TRIP_TYPE, _oldValue, this.tripType);
        this.tripType.clear();
        fireOnPostWrite(TRIP_TYPE, _oldValue, this.tripType);
}

    /**
     * getTripType :
     * @return Collection<TripType> 
     */

    public Collection<TripType> getTripType() {
        return tripType;
}

    /**
     * sizeTripType :
     * @return int 
     */

    public int sizeTripType() {
        if (tripType == null) {
            return 0;
        }
        return tripType.size();
}

    /**
     * isTripTypeEmpty :
     * @return boolean 
     */

    public boolean isTripTypeEmpty() {
        int size = sizeTripType();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(LENGTH, this.length).
            append(SPEED, this.speed).
            append(MAX_TRIP_DURATION, this.maxTripDuration).
            append(ACTIVITY_RANGE, this.activityRange).
            append(MIN_CREW_SIZE, this.minCrewSize).
            append(UNIT_FUEL_COST_OF_TRAVEL, this.unitFuelCostOfTravel).
            append(COMMENT, this.comment).
            append(TRIP_TYPE, this.tripType).
         toString();
        return result;
}


} //VesselTypeAbstract
