/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TripTypeDAOAbstract<E extends TripType> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TripType.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        {
            List<VesselType> list = getContext().getHibernate().createSQLQuery(
                    "SELECT main.topiaid " +
                    "from vesselType main, triptype_vesseltype secondary " +
                    "where main.topiaid=secondary.vesselType" +
                    " and secondary.tripType='" + entity.getTopiaId() + "'")
                    .addEntity("main", fr.ifremer.isisfish.IsisFishDAOHelper.getImplementationClass(VesselType.class)).list();

            for (VesselType item : list) {
                item.removeTripType(entity);
            }
        }

                                        {
                                        List<StrategyMonthInfo> list = getContext()
                                                    .getDAO(StrategyMonthInfo.class)
                                                    .findAllByProperties(StrategyMonthInfo.TRIP_TYPE, entity);
                        //                            .findAllByProperties("tripType", entity);
                                            for (StrategyMonthInfo item : list) {
                                                item.setTripType(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(TripType.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.NAME, v);
        return result;
    }

    /**
     * findByTripDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut tripDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTripDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.TRIP_DURATION, v);
        return result;
    }

    /**
     * findAllByTripDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut tripDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTripDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.TRIP_DURATION, v);
        return result;
    }

    /**
     * findByMinTimeBetweenTrip :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minTimeBetweenTrip le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        E result = findByProperty(TripType.MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    /**
     * findAllByMinTimeBetweenTrip :
     * Retourne les éléments ayant comme valeur pour l'attribut minTimeBetweenTrip le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinTimeBetweenTrip(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.MIN_TIME_BETWEEN_TRIP, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(TripType.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(TripType.COMMENT, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == VesselType.class) {
            VesselTypeDAO dao = (VesselTypeDAO)
                getContext().getDAO(VesselType.class);
            tmp = dao.findAllContainsTripType(entity);
//            tmp = dao.findAllByProperties(VesselType.TRIP_TYPE, entity);
            result.addAll(tmp);
        }

        if (type == StrategyMonthInfo.class) {
            StrategyMonthInfoDAO dao = (StrategyMonthInfoDAO)
                getContext().getDAO(StrategyMonthInfo.class);
            tmp = dao.findAllByTripType(entity);
//            tmp = dao.findAllByProperties(StrategyMonthInfo.TRIP_TYPE, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(2);
        
        List<? extends TopiaEntity> list;

        list = findUsages(VesselType.class, entity);
        if (!list.isEmpty()) {
            result.put(VesselType.class, list);
        }

        list = findUsages(StrategyMonthInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(StrategyMonthInfo.class, list);
        }

        return result;
    }


} //TripTypeDAOAbstract<E extends TripType>
