/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TargetSpeciesDAOAbstract<E extends TargetSpecies> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TargetSpecies.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByTargetFactorEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut targetFactorEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByTargetFactorEquation(Equation v) throws TopiaException {
        E result = findByProperty(TargetSpecies.TARGET_FACTOR_EQUATION, v);
        return result;
    }

    /**
     * findAllByTargetFactorEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut targetFactorEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByTargetFactorEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(TargetSpecies.TARGET_FACTOR_EQUATION, v);
        return result;
    }

    /**
     * findByPrimaryCatch :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut primaryCatch le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrimaryCatch(boolean v) throws TopiaException {
        E result = findByProperty(TargetSpecies.PRIMARY_CATCH, v);
        return result;
    }

    /**
     * findAllByPrimaryCatch :
     * Retourne les éléments ayant comme valeur pour l'attribut primaryCatch le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrimaryCatch(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(TargetSpecies.PRIMARY_CATCH, v);
        return result;
    }

    /**
     * findContainsSpecies :
     * Retourne le premier élément trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSpecies(Species... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(TargetSpecies.SPECIES, Arrays.asList(v));
        E result = findContainsProperties("species", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSpecies :
     * Retourne les éléments trouvé dont l'attribut species contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSpecies(Species... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(TargetSpecies.SPECIES, Arrays.asList(v));
        List<E> results = findAllContainsProperties("species", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsMetierSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(TargetSpecies.METIER_SEASON_INFO, Arrays.asList(v));
        E result = findContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsMetierSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut metierSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsMetierSeasonInfo(MetierSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(TargetSpecies.METIER_SEASON_INFO, Arrays.asList(v));
        List<E> results = findAllContainsProperties("metierSeasonInfo", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //TargetSpeciesDAOAbstract<E extends TargetSpecies>
