/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  boolFields={TargetSpecies.PRIMARY_CATCH}
)

public interface TargetSpecies extends TopiaEntity {     String TARGET_FACTOR_EQUATION = "targetFactorEquation";
     String PRIMARY_CATCH = "primaryCatch";
     String SPECIES = "species";
     String METIER_SEASON_INFO = "metierSeasonInfo";
    /**
     * setTargetFactorEquation :
     * @param targetFactorEquation La valeur de l'attribut targetFactorEquation à positionner.
     */

     void setTargetFactorEquation(Equation targetFactorEquation);

    /**
     * getTargetFactorEquation :
     * @return Equation 
     */

     Equation getTargetFactorEquation();

    /**
     * setPrimaryCatch :
     * <p>Vrai si la MetaPopulation est une esp&egrave;ce vis&eacute;e prioritairement</p>

     * @param primaryCatch La valeur de l'attribut primaryCatch à positionner.
     */

     void setPrimaryCatch(boolean primaryCatch);

    /**
     * getPrimaryCatch :
     * <p>Vrai si la MetaPopulation est une esp&egrave;ce vis&eacute;e prioritairement</p>

     * @return boolean 
     */

     boolean getPrimaryCatch();

    /**
     * setSpecies :
     * @param value La valeur de l'attribut species à positionner.
     */

     void setSpecies(Species value);

    /**
     * getSpecies :
     * Retourne la valeur de l'attribut species.
     * @return Species 
     */

     Species getSpecies();

    /**
     * setMetierSeasonInfo :
     * @param value La valeur de l'attribut metierSeasonInfo à positionner.
     */

     void setMetierSeasonInfo(MetierSeasonInfo value);

    /**
     * getMetierSeasonInfo :
     * Retourne la valeur de l'attribut metierSeasonInfo.
     * @return MetierSeasonInfo 
     */

     MetierSeasonInfo getMetierSeasonInfo();

    /**
     * getTargetFactor :
     * @param group 
     * @return double 
     */

     double getTargetFactor(PopulationGroup group);


} //TargetSpecies
