/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class StrategyMonthInfoAbstract extends TopiaEntityAbstract implements StrategyMonthInfo {

    protected Month month;
    protected double minInactivityDays;
    /**
     * <p>Nombre de Trip par mois. Le nombre de jour d'inactivite et le nombre la duree d'un trip doivent &ecirc;tre coh&eacute;rent pour le mois</p>


     */
    protected double numberOfTrips;
    protected MatrixND proportionMetier;
    protected TripType tripType;
    protected Strategy strategy;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(StrategyMonthInfo.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, MONTH, Month.class, month);
        visitor.visit(this, MIN_INACTIVITY_DAYS, double.class, minInactivityDays);
        visitor.visit(this, NUMBER_OF_TRIPS, double.class, numberOfTrips);
        visitor.visit(this, PROPORTION_METIER, MatrixND.class, proportionMetier);
        visitor.visit(this, TRIP_TYPE, TripType.class, tripType);
        visitor.visit(this, STRATEGY, Strategy.class, strategy);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setMonth :
     * @param value 
     */

    public void setMonth(Month value) {
        Month _oldValue = this.month;
        fireOnPreWrite(MONTH, _oldValue, value);
        this.month = value;
        fireOnPostWrite(MONTH, _oldValue, value);
}

    /**
     * getMonth :
     * @return Month 
     */

    public Month getMonth() {
        fireOnPreRead(MONTH, month);
        Month result = this.month;
        fireOnPostRead(MONTH, month);
        return result;
}

    /**
     * setMinInactivityDays :
     * @param value 
     */

    public void setMinInactivityDays(double value) {
        double _oldValue = this.minInactivityDays;
        fireOnPreWrite(MIN_INACTIVITY_DAYS, _oldValue, value);
        this.minInactivityDays = value;
        fireOnPostWrite(MIN_INACTIVITY_DAYS, _oldValue, value);
}

    /**
     * getMinInactivityDays :
     * @return double 
     */

    public double getMinInactivityDays() {
        fireOnPreRead(MIN_INACTIVITY_DAYS, minInactivityDays);
        double result = this.minInactivityDays;
        fireOnPostRead(MIN_INACTIVITY_DAYS, minInactivityDays);
        return result;
}

    /**
     * setNumberOfTrips :
     * @param value 
     */

    public void setNumberOfTrips(double value) {
        double _oldValue = this.numberOfTrips;
        fireOnPreWrite(NUMBER_OF_TRIPS, _oldValue, value);
        this.numberOfTrips = value;
        fireOnPostWrite(NUMBER_OF_TRIPS, _oldValue, value);
}

    /**
     * getNumberOfTrips :
     * @return double 
     */

    public double getNumberOfTrips() {
        fireOnPreRead(NUMBER_OF_TRIPS, numberOfTrips);
        double result = this.numberOfTrips;
        fireOnPostRead(NUMBER_OF_TRIPS, numberOfTrips);
        return result;
}

    /**
     * setProportionMetier :
     * @param value 
     */

    public void setProportionMetier(MatrixND value) {
        MatrixND _oldValue = this.proportionMetier;
        fireOnPreWrite(PROPORTION_METIER, _oldValue, value);
        this.proportionMetier = value;
        fireOnPostWrite(PROPORTION_METIER, _oldValue, value);
}

    /**
     * getProportionMetier :
     * @return MatrixND 
     */

    public MatrixND getProportionMetier() {
        fireOnPreRead(PROPORTION_METIER, proportionMetier);
        MatrixND result = this.proportionMetier;
        fireOnPostRead(PROPORTION_METIER, proportionMetier);
        return result;
}

    /**
     * setTripType :
     * @param value 
     */

    public void setTripType(TripType value) {
        TripType _oldValue = this.tripType;
        fireOnPreWrite(TRIP_TYPE, _oldValue, value);
        this.tripType = value;
        fireOnPostWrite(TRIP_TYPE, _oldValue, value);
}

    /**
     * getTripType :
     * @return TripType 
     */

    public TripType getTripType() {
        fireOnPreRead(TRIP_TYPE, tripType);
        TripType result = this.tripType;
        fireOnPostRead(TRIP_TYPE, tripType);
        return result;
}

    /**
     * setStrategy :
     * @param value 
     */

    public void setStrategy(Strategy value) {
        Strategy _oldValue = this.strategy;
        fireOnPreWrite(STRATEGY, _oldValue, value);
        this.strategy = value;
        fireOnPostWrite(STRATEGY, _oldValue, value);
}

    /**
     * getStrategy :
     * @return Strategy 
     */

    public Strategy getStrategy() {
        fireOnPreRead(STRATEGY, strategy);
        Strategy result = this.strategy;
        fireOnPostRead(STRATEGY, strategy);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(MONTH, this.month).
            append(MIN_INACTIVITY_DAYS, this.minInactivityDays).
            append(NUMBER_OF_TRIPS, this.numberOfTrips).
            append(PROPORTION_METIER, this.proportionMetier).
            append(TRIP_TYPE, this.tripType).
         toString();
        return result;
}


} //StrategyMonthInfoAbstract
