/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class StrategyAbstract extends TopiaEntityAbstract implements Strategy {

    protected String name;
    protected double proportionSetOfVessels;
    protected String comment;
    protected boolean inactivityEquationUsed;
    protected Equation inactivityEquation;
    protected SetOfVessels setOfVessels;
    protected List<StrategyMonthInfo> strategyMonthInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Strategy.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, PROPORTION_SET_OF_VESSELS, double.class, proportionSetOfVessels);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, INACTIVITY_EQUATION_USED, boolean.class, inactivityEquationUsed);
        visitor.visit(this, INACTIVITY_EQUATION, Equation.class, inactivityEquation);
        visitor.visit(this, SET_OF_VESSELS, SetOfVessels.class, setOfVessels);
        visitor.visit(this, STRATEGY_MONTH_INFO, List.class, StrategyMonthInfo.class, strategyMonthInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getInactivityEquation());
        if (getStrategyMonthInfo() != null) {
              tmp.addAll(getStrategyMonthInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setProportionSetOfVessels :
     * @param value 
     */

    public void setProportionSetOfVessels(double value) {
        double _oldValue = this.proportionSetOfVessels;
        fireOnPreWrite(PROPORTION_SET_OF_VESSELS, _oldValue, value);
        this.proportionSetOfVessels = value;
        fireOnPostWrite(PROPORTION_SET_OF_VESSELS, _oldValue, value);
}

    /**
     * getProportionSetOfVessels :
     * @return double 
     */

    public double getProportionSetOfVessels() {
        fireOnPreRead(PROPORTION_SET_OF_VESSELS, proportionSetOfVessels);
        double result = this.proportionSetOfVessels;
        fireOnPostRead(PROPORTION_SET_OF_VESSELS, proportionSetOfVessels);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * setInactivityEquationUsed :
     * @param value 
     */

    public void setInactivityEquationUsed(boolean value) {
        boolean _oldValue = this.inactivityEquationUsed;
        fireOnPreWrite(INACTIVITY_EQUATION_USED, _oldValue, value);
        this.inactivityEquationUsed = value;
        fireOnPostWrite(INACTIVITY_EQUATION_USED, _oldValue, value);
}

    /**
     * getInactivityEquationUsed :
     * @return boolean 
     */

    public boolean getInactivityEquationUsed() {
        fireOnPreRead(INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        boolean result = this.inactivityEquationUsed;
        fireOnPostRead(INACTIVITY_EQUATION_USED, inactivityEquationUsed);
        return result;
}

    /**
     * setInactivityEquation :
     * @param value 
     */

    public void setInactivityEquation(Equation value) {
        Equation _oldValue = this.inactivityEquation;
        fireOnPreWrite(INACTIVITY_EQUATION, _oldValue, value);
        this.inactivityEquation = value;
        fireOnPostWrite(INACTIVITY_EQUATION, _oldValue, value);
}

    /**
     * getInactivityEquation :
     * @return Equation 
     */

    public Equation getInactivityEquation() {
        fireOnPreRead(INACTIVITY_EQUATION, inactivityEquation);
        Equation result = this.inactivityEquation;
        fireOnPostRead(INACTIVITY_EQUATION, inactivityEquation);
        return result;
}

    /**
     * setSetOfVessels :
     * @param value 
     */

    public void setSetOfVessels(SetOfVessels value) {
        SetOfVessels _oldValue = this.setOfVessels;
        fireOnPreWrite(SET_OF_VESSELS, _oldValue, value);
        this.setOfVessels = value;
        fireOnPostWrite(SET_OF_VESSELS, _oldValue, value);
}

    /**
     * getSetOfVessels :
     * @return SetOfVessels 
     */

    public SetOfVessels getSetOfVessels() {
        fireOnPreRead(SET_OF_VESSELS, setOfVessels);
        SetOfVessels result = this.setOfVessels;
        fireOnPostRead(SET_OF_VESSELS, setOfVessels);
        return result;
}

    /**
     * addStrategyMonthInfo :
     * @param strategyMonthInfo 
     */

    public void addStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo) {    
        fireOnPreWrite(STRATEGY_MONTH_INFO, null, strategyMonthInfo);
        if (this.strategyMonthInfo == null) {
            this.strategyMonthInfo = new ArrayList<StrategyMonthInfo>();
        }
        strategyMonthInfo.setStrategy(this);
        this.strategyMonthInfo.add(strategyMonthInfo);
        fireOnPostWrite(STRATEGY_MONTH_INFO, this.strategyMonthInfo.size(), null, strategyMonthInfo);
}

    /**
     * addAllStrategyMonthInfo :
     * @param values 
     */

    public void addAllStrategyMonthInfo(List<StrategyMonthInfo> values) {
        if (values == null) {
            return;
        }
        for (StrategyMonthInfo item : values) {
            addStrategyMonthInfo(item);
        }
}

    /**
     * getStrategyMonthInfoByTopiaId :
     * @param topiaId 
     * @return StrategyMonthInfo 
     */

    public StrategyMonthInfo getStrategyMonthInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(strategyMonthInfo, topiaId);
 }

    /**
     * setStrategyMonthInfo :
     * @param values 
     */

    public void setStrategyMonthInfo(List<StrategyMonthInfo> values) {
        List<StrategyMonthInfo> _oldValue = strategyMonthInfo;
        fireOnPreWrite(STRATEGY_MONTH_INFO, _oldValue, values);
        strategyMonthInfo = values;
        fireOnPostWrite(STRATEGY_MONTH_INFO, _oldValue, values);
}

    /**
     * removeStrategyMonthInfo :
     * @param value 
     */

    public void removeStrategyMonthInfo(StrategyMonthInfo value) {
        fireOnPreWrite(STRATEGY_MONTH_INFO, value, null);
        if ((this.strategyMonthInfo == null) || (!this.strategyMonthInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setStrategy(null);
        fireOnPostWrite(STRATEGY_MONTH_INFO, this.strategyMonthInfo.size()+1, value, null);
}

    /**
     * clearStrategyMonthInfo :
     */

    public void clearStrategyMonthInfo() {
        if (this.strategyMonthInfo == null) {
            return;
        }
        for (StrategyMonthInfo item : this.strategyMonthInfo) {
            item.setStrategy(null);
        }
        List<StrategyMonthInfo> _oldValue = new ArrayList<StrategyMonthInfo>(this.strategyMonthInfo);
        fireOnPreWrite(STRATEGY_MONTH_INFO, _oldValue, this.strategyMonthInfo);
        this.strategyMonthInfo.clear();
        fireOnPostWrite(STRATEGY_MONTH_INFO, _oldValue, this.strategyMonthInfo);
}

    /**
     * getStrategyMonthInfo :
     * @return List<StrategyMonthInfo> 
     */

    public List<StrategyMonthInfo> getStrategyMonthInfo() {
        return strategyMonthInfo;
}

    /**
     * sizeStrategyMonthInfo :
     * @return int 
     */

    public int sizeStrategyMonthInfo() {
        if (strategyMonthInfo == null) {
            return 0;
        }
        return strategyMonthInfo.size();
}

    /**
     * isStrategyMonthInfoEmpty :
     * @return boolean 
     */

    public boolean isStrategyMonthInfoEmpty() {
        int size = sizeStrategyMonthInfo();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(PROPORTION_SET_OF_VESSELS, this.proportionSetOfVessels).
            append(COMMENT, this.comment).
            append(INACTIVITY_EQUATION_USED, this.inactivityEquationUsed).
            append(INACTIVITY_EQUATION, this.inactivityEquation).
            append(SET_OF_VESSELS, this.setOfVessels).
         toString();
        return result;
}


} //StrategyAbstract
