/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Strategy.NAME, Strategy.COMMENT},
  numFields={Strategy.PROPORTION_SET_OF_VESSELS},
  boolFields={Strategy.INACTIVITY_EQUATION_USED}
)

public interface Strategy extends TopiaEntity {     String NAME = "name";
     String PROPORTION_SET_OF_VESSELS = "proportionSetOfVessels";
     String COMMENT = "comment";
     String INACTIVITY_EQUATION_USED = "inactivityEquationUsed";
     String INACTIVITY_EQUATION = "inactivityEquation";
     String SET_OF_VESSELS = "setOfVessels";
     String STRATEGY_MONTH_INFO = "strategyMonthInfo";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setProportionSetOfVessels :
     * @param proportionSetOfVessels La valeur de l'attribut proportionSetOfVessels à positionner.
     */

     void setProportionSetOfVessels(double proportionSetOfVessels);

    /**
     * getProportionSetOfVessels :
     * @return double 
     */

     double getProportionSetOfVessels();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setInactivityEquationUsed :
     * @param inactivityEquationUsed La valeur de l'attribut inactivityEquationUsed à positionner.
     */

     void setInactivityEquationUsed(boolean inactivityEquationUsed);

    /**
     * getInactivityEquationUsed :
     * @return boolean 
     */

     boolean getInactivityEquationUsed();

    /**
     * setInactivityEquation :
     * @param inactivityEquation La valeur de l'attribut inactivityEquation à positionner.
     */

     void setInactivityEquation(Equation inactivityEquation);

    /**
     * getInactivityEquation :
     * @return Equation 
     */

     Equation getInactivityEquation();

    /**
     * setSetOfVessels :
     * @param setOfVessels La valeur de l'attribut setOfVessels à positionner.
     */

     void setSetOfVessels(SetOfVessels setOfVessels);

    /**
     * getSetOfVessels :
     * @return SetOfVessels 
     */

     SetOfVessels getSetOfVessels();

    /**
     * addStrategyMonthInfo :
     * @param strategyMonthInfo L'instance de strategyMonthInfo à ajouter
     */

     void addStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo);

    /**
     * addAllStrategyMonthInfo :
     * @param strategyMonthInfo Les instances de strategyMonthInfo à ajouter
     */

     void addAllStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo);

    /**
     * setStrategyMonthInfo :
     * @param strategyMonthInfo La Collection de strategyMonthInfo à ajouter
     */

     void setStrategyMonthInfo(List<StrategyMonthInfo> strategyMonthInfo);

    /**
     * removeStrategyMonthInfo :
     * @param strategyMonthInfo Vide la Collection de strategyMonthInfo
     */

     void removeStrategyMonthInfo(StrategyMonthInfo strategyMonthInfo);

    /**
     * clearStrategyMonthInfo :
     */

     void clearStrategyMonthInfo();

    /**
     * getStrategyMonthInfo :
     * @return List<StrategyMonthInfo> 
     */

     List<StrategyMonthInfo> getStrategyMonthInfo();

    /**
     * getStrategyMonthInfoByTopiaId :
     * Recupère l'attribut strategyMonthInfo à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return StrategyMonthInfo 
     */

     StrategyMonthInfo getStrategyMonthInfoByTopiaId(String topiaId);

    /**
     * sizeStrategyMonthInfo :
     * Retourne le nombre d'éléments de la collection strategyMonthInfo
     * @return int 
     */

     int sizeStrategyMonthInfo();

    /**
     * isStrategyMonthInfoEmpty :
     * Retourne {@code true} si la collection strategyMonthInfo est vide.
     * @return boolean 
     */

     boolean isStrategyMonthInfoEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();

    /**
     * getStrategyMonthInfo :
     * @param month 
     * @return StrategyMonthInfo 
     */

     StrategyMonthInfo getStrategyMonthInfo(Month month);

    /**
     * getInactivityDays :
     * @param month 
     * @return double 
     */

     double getInactivityDays(Month month);


} //Strategy
