/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class SpeciesDAOAbstract<E extends Species> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Species.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Population> list = getContext()
                                                    .getDAO(Population.class)
                                                    .findAllByProperties(Population.SPECIES, entity);
                        //                            .findAllByProperties("species", entity);
                                            for (Population item : list) {
                                                item.setSpecies(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Species.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.NAME, v);
        return result;
    }

    /**
     * findByScientificName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut scientificName le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByScientificName(String v) throws TopiaException {
        E result = findByProperty(Species.SCIENTIFIC_NAME, v);
        return result;
    }

    /**
     * findAllByScientificName :
     * Retourne les éléments ayant comme valeur pour l'attribut scientificName le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByScientificName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.SCIENTIFIC_NAME, v);
        return result;
    }

    /**
     * findByCodeRubbin :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut codeRubbin le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCodeRubbin(String v) throws TopiaException {
        E result = findByProperty(Species.CODE_RUBBIN, v);
        return result;
    }

    /**
     * findAllByCodeRubbin :
     * Retourne les éléments ayant comme valeur pour l'attribut codeRubbin le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCodeRubbin(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.CODE_RUBBIN, v);
        return result;
    }

    /**
     * findByCodeCEE :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut codeCEE le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCodeCEE(int v) throws TopiaException {
        E result = findByProperty(Species.CODE_CEE, v);
        return result;
    }

    /**
     * findAllByCodeCEE :
     * Retourne les éléments ayant comme valeur pour l'attribut codeCEE le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCodeCEE(int v) throws TopiaException {
        List<E> result = findAllByProperty(Species.CODE_CEE, v);
        return result;
    }

    /**
     * findByAgeGroupType :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut ageGroupType le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAgeGroupType(boolean v) throws TopiaException {
        E result = findByProperty(Species.AGE_GROUP_TYPE, v);
        return result;
    }

    /**
     * findAllByAgeGroupType :
     * Retourne les éléments ayant comme valeur pour l'attribut ageGroupType le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAgeGroupType(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Species.AGE_GROUP_TYPE, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Species.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Species.COMMENT, v);
        return result;
    }

    /**
     * findContainsPopulation :
     * Retourne le premier élément trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Species.POPULATION, Arrays.asList(v));
        E result = findContainsProperties("population", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulation :
     * Retourne les éléments trouvé dont l'attribut population contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulation(Population... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Species.POPULATION, Arrays.asList(v));
        List<E> results = findAllContainsProperties("population", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllBySpecies(entity);
//            tmp = dao.findAllByProperties(Population.SPECIES, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }


} //SpeciesDAOAbstract<E extends Species>
