/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SpeciesAbstract extends TopiaEntityAbstract implements Species {

    protected String name;
    protected String scientificName;
    protected String codeRubbin;
    protected int codeCEE;
    protected boolean ageGroupType;
    protected String comment;
    protected Collection<TargetSpecies> metierSeasonInfoTargetSpecies;
    protected Collection<Population> population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Species.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, SCIENTIFIC_NAME, String.class, scientificName);
        visitor.visit(this, CODE_RUBBIN, String.class, codeRubbin);
        visitor.visit(this, CODE_CEE, int.class, codeCEE);
        visitor.visit(this, AGE_GROUP_TYPE, boolean.class, ageGroupType);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, METIER_SEASON_INFO_TARGET_SPECIES, java.util.Collection.class, TargetSpecies.class, metierSeasonInfoTargetSpecies);
        visitor.visit(this, POPULATION, Collection.class, Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<TargetSpecies> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(TargetSpecies.class);
            List<TargetSpecies> findAllByProperties = dao.findAllByProperties("species", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulation() != null) {
              tmp.addAll(getPopulation());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setScientificName :
     * @param value 
     */

    public void setScientificName(String value) {
        String _oldValue = this.scientificName;
        fireOnPreWrite(SCIENTIFIC_NAME, _oldValue, value);
        this.scientificName = value;
        fireOnPostWrite(SCIENTIFIC_NAME, _oldValue, value);
}

    /**
     * getScientificName :
     * @return String 
     */

    public String getScientificName() {
        fireOnPreRead(SCIENTIFIC_NAME, scientificName);
        String result = this.scientificName;
        fireOnPostRead(SCIENTIFIC_NAME, scientificName);
        return result;
}

    /**
     * setCodeRubbin :
     * @param value 
     */

    public void setCodeRubbin(String value) {
        String _oldValue = this.codeRubbin;
        fireOnPreWrite(CODE_RUBBIN, _oldValue, value);
        this.codeRubbin = value;
        fireOnPostWrite(CODE_RUBBIN, _oldValue, value);
}

    /**
     * getCodeRubbin :
     * @return String 
     */

    public String getCodeRubbin() {
        fireOnPreRead(CODE_RUBBIN, codeRubbin);
        String result = this.codeRubbin;
        fireOnPostRead(CODE_RUBBIN, codeRubbin);
        return result;
}

    /**
     * setCodeCEE :
     * @param value 
     */

    public void setCodeCEE(int value) {
        int _oldValue = this.codeCEE;
        fireOnPreWrite(CODE_CEE, _oldValue, value);
        this.codeCEE = value;
        fireOnPostWrite(CODE_CEE, _oldValue, value);
}

    /**
     * getCodeCEE :
     * @return int 
     */

    public int getCodeCEE() {
        fireOnPreRead(CODE_CEE, codeCEE);
        int result = this.codeCEE;
        fireOnPostRead(CODE_CEE, codeCEE);
        return result;
}

    /**
     * setAgeGroupType :
     * @param value 
     */

    public void setAgeGroupType(boolean value) {
        boolean _oldValue = this.ageGroupType;
        fireOnPreWrite(AGE_GROUP_TYPE, _oldValue, value);
        this.ageGroupType = value;
        fireOnPostWrite(AGE_GROUP_TYPE, _oldValue, value);
}

    /**
     * getAgeGroupType :
     * @return boolean 
     */

    public boolean getAgeGroupType() {
        fireOnPreRead(AGE_GROUP_TYPE, ageGroupType);
        boolean result = this.ageGroupType;
        fireOnPostRead(AGE_GROUP_TYPE, ageGroupType);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * addPopulation :
     * @param population 
     */

    public void addPopulation(Population population) {    
        fireOnPreWrite(POPULATION, null, population);
        if (this.population == null) {
            this.population = new ArrayList<Population>();
        }
        population.setSpecies(this);
        this.population.add(population);
        fireOnPostWrite(POPULATION, this.population.size(), null, population);
}

    /**
     * addAllPopulation :
     * @param values 
     */

    public void addAllPopulation(Collection<Population> values) {
        if (values == null) {
            return;
        }
        for (Population item : values) {
            addPopulation(item);
        }
}

    /**
     * getPopulationByTopiaId :
     * @param topiaId 
     * @return Population 
     */

    public Population getPopulationByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(population, topiaId);
 }

    /**
     * setPopulation :
     * @param values 
     */

    public void setPopulation(Collection<Population> values) {
        Collection<Population> _oldValue = population;
        fireOnPreWrite(POPULATION, _oldValue, values);
        population = values;
        fireOnPostWrite(POPULATION, _oldValue, values);
}

    /**
     * removePopulation :
     * @param value 
     */

    public void removePopulation(Population value) {
        fireOnPreWrite(POPULATION, value, null);
        if ((this.population == null) || (!this.population.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setSpecies(null);
        fireOnPostWrite(POPULATION, this.population.size()+1, value, null);
}

    /**
     * clearPopulation :
     */

    public void clearPopulation() {
        if (this.population == null) {
            return;
        }
        for (Population item : this.population) {
            item.setSpecies(null);
        }
        Collection<Population> _oldValue = new ArrayList<Population>(this.population);
        fireOnPreWrite(POPULATION, _oldValue, this.population);
        this.population.clear();
        fireOnPostWrite(POPULATION, _oldValue, this.population);
}

    /**
     * getPopulation :
     * @return Collection<Population> 
     */

    public Collection<Population> getPopulation() {
        return population;
}

    /**
     * sizePopulation :
     * @return int 
     */

    public int sizePopulation() {
        if (population == null) {
            return 0;
        }
        return population.size();
}

    /**
     * isPopulationEmpty :
     * @return boolean 
     */

    public boolean isPopulationEmpty() {
        int size = sizePopulation();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(SCIENTIFIC_NAME, this.scientificName).
            append(CODE_RUBBIN, this.codeRubbin).
            append(CODE_CEE, this.codeCEE).
            append(AGE_GROUP_TYPE, this.ageGroupType).
            append(COMMENT, this.comment).
         toString();
        return result;
}


} //SpeciesAbstract
