/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.IsisFishException;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields ()

public interface Selectivity extends TopiaEntity {     String EQUATION = "equation";
     String GEAR = "gear";
     String POPULATION = "population";
    /**
     * setEquation :
     * @param equation La valeur de l'attribut equation à positionner.
     */

     void setEquation(Equation equation);

    /**
     * getEquation :
     * @return Equation 
     */

     Equation getEquation();

    /**
     * setGear :
     * @param value La valeur de l'attribut gear à positionner.
     */

     void setGear(Gear value);

    /**
     * getGear :
     * Retourne la valeur de l'attribut gear.
     * @return Gear 
     */

     Gear getGear();

    /**
     * setPopulation :
     * @param value La valeur de l'attribut population à positionner.
     */

     void setPopulation(Population value);

    /**
     * getPopulation :
     * Retourne la valeur de l'attribut population.
     * @return Population 
     */

     Population getPopulation();

    /**
     * getCoefficient :
     * @param pop 
     * @param group 
     * @param metier 
     * @return double 
     * @throws IsisFishException
     */

     double getCoefficient(Population pop, PopulationGroup group, Metier metier) throws IsisFishException;


} //Selectivity
