/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class SeasonAbstract extends TopiaEntityAbstract implements Season {

    protected Month firstMonth;
    protected Month lastMonth;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Season.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Season.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, FIRST_MONTH, Month.class, firstMonth);
        visitor.visit(this, LAST_MONTH, Month.class, lastMonth);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setFirstMonth :
     * @param value 
     */

    public void setFirstMonth(Month value) {
        Month _oldValue = this.firstMonth;
        fireOnPreWrite(FIRST_MONTH, _oldValue, value);
        this.firstMonth = value;
        fireOnPostWrite(FIRST_MONTH, _oldValue, value);
}

    /**
     * getFirstMonth :
     * @return Month 
     */

    public Month getFirstMonth() {
        fireOnPreRead(FIRST_MONTH, firstMonth);
        Month result = this.firstMonth;
        fireOnPostRead(FIRST_MONTH, firstMonth);
        return result;
}

    /**
     * setLastMonth :
     * @param value 
     */

    public void setLastMonth(Month value) {
        Month _oldValue = this.lastMonth;
        fireOnPreWrite(LAST_MONTH, _oldValue, value);
        this.lastMonth = value;
        fireOnPostWrite(LAST_MONTH, _oldValue, value);
}

    /**
     * getLastMonth :
     * @return Month 
     */

    public Month getLastMonth() {
        fireOnPreRead(LAST_MONTH, lastMonth);
        Month result = this.lastMonth;
        fireOnPostRead(LAST_MONTH, lastMonth);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(FIRST_MONTH, this.firstMonth).
            append(LAST_MONTH, this.lastMonth).
         toString();
        return result;
}


} //SeasonAbstract
