/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PopulationSeasonInfoAbstract extends SeasonImpl implements PopulationSeasonInfo {

    /**
     * <p>Matrice repr&eacute;sentant la distribution de la reproduction sur les diff&eacute;rents mois de la saison.</p>

     */
    protected MatrixND reproductionDistribution;
    /**
     * <p>Si vrai alors la population change de groupe d'age ou de longueurs en debut de saison</p>


     */
    protected boolean groupChange;
    /**
     * <p>Indique si la matrice de changementde longeur est une matrice simple ou complexe</p>


     */
    protected boolean simpleLengthChangeMatrix;
    /**
     * <p>La matrice de changement de longueur. Appliquable que si la MetaPopulation est en longueur. Cette matrice est [group x group] ou [ (group, zone) x ( group, zone)]</p>
<p></p>

     */
    protected MatrixND lengthChangeMatrix;
    /**
     * <p>Indique s'il y a de la reproduction durant la saison</p>


     */
    protected boolean reproduction;
    protected boolean useEquationMigration;
    /**
     * <p>Matrix [group x zone(left) x zone(reached)]</p>

     */
    protected MatrixND migrationMatrix;
    /**
     * <p>Matrix [group x zone(left)]</p>

     */
    protected MatrixND emigrationMatrix;
    /**
     * <p>Matrix [group x zone(reached)]</p>

     */
    protected MatrixND immigrationMatrix;
    protected Equation migrationEquation;
    protected Equation emigrationEquation;
    protected Equation immigrationEquation;
    protected Population population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationSeasonInfo.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, REPRODUCTION_DISTRIBUTION, MatrixND.class, reproductionDistribution);
        visitor.visit(this, GROUP_CHANGE, boolean.class, groupChange);
        visitor.visit(this, SIMPLE_LENGTH_CHANGE_MATRIX, boolean.class, simpleLengthChangeMatrix);
        visitor.visit(this, LENGTH_CHANGE_MATRIX, MatrixND.class, lengthChangeMatrix);
        visitor.visit(this, REPRODUCTION, boolean.class, reproduction);
        visitor.visit(this, USE_EQUATION_MIGRATION, boolean.class, useEquationMigration);
        visitor.visit(this, MIGRATION_MATRIX, MatrixND.class, migrationMatrix);
        visitor.visit(this, EMIGRATION_MATRIX, MatrixND.class, emigrationMatrix);
        visitor.visit(this, IMMIGRATION_MATRIX, MatrixND.class, immigrationMatrix);
        visitor.visit(this, MIGRATION_EQUATION, Equation.class, migrationEquation);
        visitor.visit(this, EMIGRATION_EQUATION, Equation.class, emigrationEquation);
        visitor.visit(this, IMMIGRATION_EQUATION, Equation.class, immigrationEquation);
        visitor.visit(this, POPULATION, Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getMigrationEquation());
        tmp.add(getEmigrationEquation());
        tmp.add(getImmigrationEquation());

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setReproductionDistribution :
     * @param value 
     */

    public void setReproductionDistribution(MatrixND value) {
        MatrixND _oldValue = this.reproductionDistribution;
        fireOnPreWrite(REPRODUCTION_DISTRIBUTION, _oldValue, value);
        this.reproductionDistribution = value;
        fireOnPostWrite(REPRODUCTION_DISTRIBUTION, _oldValue, value);
}

    /**
     * getReproductionDistribution :
     * @return MatrixND 
     */

    public MatrixND getReproductionDistribution() {
        fireOnPreRead(REPRODUCTION_DISTRIBUTION, reproductionDistribution);
        MatrixND result = this.reproductionDistribution;
        fireOnPostRead(REPRODUCTION_DISTRIBUTION, reproductionDistribution);
        return result;
}

    /**
     * setGroupChange :
     * @param value 
     */

    public void setGroupChange(boolean value) {
        boolean _oldValue = this.groupChange;
        fireOnPreWrite(GROUP_CHANGE, _oldValue, value);
        this.groupChange = value;
        fireOnPostWrite(GROUP_CHANGE, _oldValue, value);
}

    /**
     * getGroupChange :
     * @return boolean 
     */

    public boolean getGroupChange() {
        fireOnPreRead(GROUP_CHANGE, groupChange);
        boolean result = this.groupChange;
        fireOnPostRead(GROUP_CHANGE, groupChange);
        return result;
}

    /**
     * setSimpleLengthChangeMatrix :
     * @param value 
     */

    public void setSimpleLengthChangeMatrix(boolean value) {
        boolean _oldValue = this.simpleLengthChangeMatrix;
        fireOnPreWrite(SIMPLE_LENGTH_CHANGE_MATRIX, _oldValue, value);
        this.simpleLengthChangeMatrix = value;
        fireOnPostWrite(SIMPLE_LENGTH_CHANGE_MATRIX, _oldValue, value);
}

    /**
     * getSimpleLengthChangeMatrix :
     * @return boolean 
     */

    public boolean getSimpleLengthChangeMatrix() {
        fireOnPreRead(SIMPLE_LENGTH_CHANGE_MATRIX, simpleLengthChangeMatrix);
        boolean result = this.simpleLengthChangeMatrix;
        fireOnPostRead(SIMPLE_LENGTH_CHANGE_MATRIX, simpleLengthChangeMatrix);
        return result;
}

    /**
     * setLengthChangeMatrix :
     * @param value 
     */

    public void setLengthChangeMatrix(MatrixND value) {
        MatrixND _oldValue = this.lengthChangeMatrix;
        fireOnPreWrite(LENGTH_CHANGE_MATRIX, _oldValue, value);
        this.lengthChangeMatrix = value;
        fireOnPostWrite(LENGTH_CHANGE_MATRIX, _oldValue, value);
}

    /**
     * getLengthChangeMatrix :
     * @return MatrixND 
     */

    public MatrixND getLengthChangeMatrix() {
        fireOnPreRead(LENGTH_CHANGE_MATRIX, lengthChangeMatrix);
        MatrixND result = this.lengthChangeMatrix;
        fireOnPostRead(LENGTH_CHANGE_MATRIX, lengthChangeMatrix);
        return result;
}

    /**
     * setReproduction :
     * @param value 
     */

    public void setReproduction(boolean value) {
        boolean _oldValue = this.reproduction;
        fireOnPreWrite(REPRODUCTION, _oldValue, value);
        this.reproduction = value;
        fireOnPostWrite(REPRODUCTION, _oldValue, value);
}

    /**
     * getReproduction :
     * @return boolean 
     */

    public boolean getReproduction() {
        fireOnPreRead(REPRODUCTION, reproduction);
        boolean result = this.reproduction;
        fireOnPostRead(REPRODUCTION, reproduction);
        return result;
}

    /**
     * setUseEquationMigration :
     * @param value 
     */

    public void setUseEquationMigration(boolean value) {
        boolean _oldValue = this.useEquationMigration;
        fireOnPreWrite(USE_EQUATION_MIGRATION, _oldValue, value);
        this.useEquationMigration = value;
        fireOnPostWrite(USE_EQUATION_MIGRATION, _oldValue, value);
}

    /**
     * getUseEquationMigration :
     * @return boolean 
     */

    public boolean getUseEquationMigration() {
        fireOnPreRead(USE_EQUATION_MIGRATION, useEquationMigration);
        boolean result = this.useEquationMigration;
        fireOnPostRead(USE_EQUATION_MIGRATION, useEquationMigration);
        return result;
}

    /**
     * setMigrationMatrix :
     * @param value 
     */

    public void setMigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.migrationMatrix;
        fireOnPreWrite(MIGRATION_MATRIX, _oldValue, value);
        this.migrationMatrix = value;
        fireOnPostWrite(MIGRATION_MATRIX, _oldValue, value);
}

    /**
     * getMigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getMigrationMatrix() {
        fireOnPreRead(MIGRATION_MATRIX, migrationMatrix);
        MatrixND result = this.migrationMatrix;
        fireOnPostRead(MIGRATION_MATRIX, migrationMatrix);
        return result;
}

    /**
     * setEmigrationMatrix :
     * @param value 
     */

    public void setEmigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.emigrationMatrix;
        fireOnPreWrite(EMIGRATION_MATRIX, _oldValue, value);
        this.emigrationMatrix = value;
        fireOnPostWrite(EMIGRATION_MATRIX, _oldValue, value);
}

    /**
     * getEmigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getEmigrationMatrix() {
        fireOnPreRead(EMIGRATION_MATRIX, emigrationMatrix);
        MatrixND result = this.emigrationMatrix;
        fireOnPostRead(EMIGRATION_MATRIX, emigrationMatrix);
        return result;
}

    /**
     * setImmigrationMatrix :
     * @param value 
     */

    public void setImmigrationMatrix(MatrixND value) {
        MatrixND _oldValue = this.immigrationMatrix;
        fireOnPreWrite(IMMIGRATION_MATRIX, _oldValue, value);
        this.immigrationMatrix = value;
        fireOnPostWrite(IMMIGRATION_MATRIX, _oldValue, value);
}

    /**
     * getImmigrationMatrix :
     * @return MatrixND 
     */

    public MatrixND getImmigrationMatrix() {
        fireOnPreRead(IMMIGRATION_MATRIX, immigrationMatrix);
        MatrixND result = this.immigrationMatrix;
        fireOnPostRead(IMMIGRATION_MATRIX, immigrationMatrix);
        return result;
}

    /**
     * setMigrationEquation :
     * @param value 
     */

    public void setMigrationEquation(Equation value) {
        Equation _oldValue = this.migrationEquation;
        fireOnPreWrite(MIGRATION_EQUATION, _oldValue, value);
        this.migrationEquation = value;
        fireOnPostWrite(MIGRATION_EQUATION, _oldValue, value);
}

    /**
     * getMigrationEquation :
     * @return Equation 
     */

    public Equation getMigrationEquation() {
        fireOnPreRead(MIGRATION_EQUATION, migrationEquation);
        Equation result = this.migrationEquation;
        fireOnPostRead(MIGRATION_EQUATION, migrationEquation);
        return result;
}

    /**
     * setEmigrationEquation :
     * @param value 
     */

    public void setEmigrationEquation(Equation value) {
        Equation _oldValue = this.emigrationEquation;
        fireOnPreWrite(EMIGRATION_EQUATION, _oldValue, value);
        this.emigrationEquation = value;
        fireOnPostWrite(EMIGRATION_EQUATION, _oldValue, value);
}

    /**
     * getEmigrationEquation :
     * @return Equation 
     */

    public Equation getEmigrationEquation() {
        fireOnPreRead(EMIGRATION_EQUATION, emigrationEquation);
        Equation result = this.emigrationEquation;
        fireOnPostRead(EMIGRATION_EQUATION, emigrationEquation);
        return result;
}

    /**
     * setImmigrationEquation :
     * @param value 
     */

    public void setImmigrationEquation(Equation value) {
        Equation _oldValue = this.immigrationEquation;
        fireOnPreWrite(IMMIGRATION_EQUATION, _oldValue, value);
        this.immigrationEquation = value;
        fireOnPostWrite(IMMIGRATION_EQUATION, _oldValue, value);
}

    /**
     * getImmigrationEquation :
     * @return Equation 
     */

    public Equation getImmigrationEquation() {
        fireOnPreRead(IMMIGRATION_EQUATION, immigrationEquation);
        Equation result = this.immigrationEquation;
        fireOnPostRead(IMMIGRATION_EQUATION, immigrationEquation);
        return result;
}

    /**
     * setPopulation :
     * @param value 
     */

    public void setPopulation(Population value) {
        Population _oldValue = this.population;
        fireOnPreWrite(POPULATION, _oldValue, value);
        this.population = value;
        fireOnPostWrite(POPULATION, _oldValue, value);
}

    /**
     * getPopulation :
     * @return Population 
     */

    public Population getPopulation() {
        fireOnPreRead(POPULATION, population);
        Population result = this.population;
        fireOnPostRead(POPULATION, population);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(REPRODUCTION_DISTRIBUTION, this.reproductionDistribution).
            append(GROUP_CHANGE, this.groupChange).
            append(SIMPLE_LENGTH_CHANGE_MATRIX, this.simpleLengthChangeMatrix).
            append(LENGTH_CHANGE_MATRIX, this.lengthChangeMatrix).
            append(REPRODUCTION, this.reproduction).
            append(USE_EQUATION_MIGRATION, this.useEquationMigration).
            append(MIGRATION_MATRIX, this.migrationMatrix).
            append(EMIGRATION_MATRIX, this.emigrationMatrix).
            append(IMMIGRATION_MATRIX, this.immigrationMatrix).
            append(MIGRATION_EQUATION, this.migrationEquation).
            append(EMIGRATION_EQUATION, this.emigrationEquation).
            append(IMMIGRATION_EQUATION, this.immigrationEquation).
         toString();
        return result;
}


} //PopulationSeasonInfoAbstract
