/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PopulationGroupDAOAbstract<E extends PopulationGroup> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)PopulationGroup.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<Population> list = getContext()
                                                    .getDAO(Population.class)
                                                    .findAllByProperties(Population.MATURITY_GROUP, entity);
                        //                            .findAllByProperties("maturityGroup", entity);
                                            for (Population item : list) {
                                                item.setMaturityGroup(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findById :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut id le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findById(int v) throws TopiaException {
        E result = findByProperty(PopulationGroup.ID, v);
        return result;
    }

    /**
     * findAllById :
     * Retourne les éléments ayant comme valeur pour l'attribut id le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllById(int v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.ID, v);
        return result;
    }

    /**
     * findByReproductionRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionRate(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.REPRODUCTION_RATE, v);
        return result;
    }

    /**
     * findAllByReproductionRate :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionRate(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.REPRODUCTION_RATE, v);
        return result;
    }

    /**
     * findByAge :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut age le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAge(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.AGE, v);
        return result;
    }

    /**
     * findAllByAge :
     * Retourne les éléments ayant comme valeur pour l'attribut age le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAge(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.AGE, v);
        return result;
    }

    /**
     * findByMinLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLength le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLength(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.MIN_LENGTH, v);
        return result;
    }

    /**
     * findAllByMinLength :
     * Retourne les éléments ayant comme valeur pour l'attribut minLength le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLength(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.MIN_LENGTH, v);
        return result;
    }

    /**
     * findByMaxLength :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLength le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLength(double v) throws TopiaException {
        E result = findByProperty(PopulationGroup.MAX_LENGTH, v);
        return result;
    }

    /**
     * findAllByMaxLength :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLength le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLength(double v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.MAX_LENGTH, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(PopulationGroup.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.COMMENT, v);
        return result;
    }

    /**
     * findByPopulation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPopulation(Population v) throws TopiaException {
        E result = findByProperty(PopulationGroup.POPULATION, v);
        return result;
    }

    /**
     * findAllByPopulation :
     * Retourne les éléments ayant comme valeur pour l'attribut population le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPopulation(Population v) throws TopiaException {
        List<E> result = findAllByProperty(PopulationGroup.POPULATION, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllContainsPopulationGroup(entity);
//            tmp = dao.findAllByProperties(Population.POPULATION_GROUP, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByMaturityGroup(entity);
//            tmp = dao.findAllByProperties(Population.MATURITY_GROUP, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(1);
        
        List<? extends TopiaEntity> list;

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        return result;
    }


} //PopulationGroupDAOAbstract<E extends PopulationGroup>
