/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PopulationGroupAbstract extends TopiaEntityAbstract implements PopulationGroup {

    protected int id;
    /**
     * <p>Le taux de f&eacute;condit&eacute; pour le group</p>


     */
    protected double reproductionRate;
    protected double age;
    protected double minLength;
    protected double maxLength;
    protected String comment;
    protected Population population;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationGroup.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(PopulationGroup.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, ID, int.class, id);
        visitor.visit(this, REPRODUCTION_RATE, double.class, reproductionRate);
        visitor.visit(this, AGE, double.class, age);
        visitor.visit(this, MIN_LENGTH, double.class, minLength);
        visitor.visit(this, MAX_LENGTH, double.class, maxLength);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, POPULATION, Population.class, population);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setId :
     * @param value 
     */

    public void setId(int value) {
        int _oldValue = this.id;
        fireOnPreWrite(ID, _oldValue, value);
        this.id = value;
        fireOnPostWrite(ID, _oldValue, value);
}

    /**
     * getId :
     * @return int 
     */

    public int getId() {
        fireOnPreRead(ID, id);
        int result = this.id;
        fireOnPostRead(ID, id);
        return result;
}

    /**
     * setReproductionRate :
     * @param value 
     */

    public void setReproductionRate(double value) {
        double _oldValue = this.reproductionRate;
        fireOnPreWrite(REPRODUCTION_RATE, _oldValue, value);
        this.reproductionRate = value;
        fireOnPostWrite(REPRODUCTION_RATE, _oldValue, value);
}

    /**
     * getReproductionRate :
     * @return double 
     */

    public double getReproductionRate() {
        fireOnPreRead(REPRODUCTION_RATE, reproductionRate);
        double result = this.reproductionRate;
        fireOnPostRead(REPRODUCTION_RATE, reproductionRate);
        return result;
}

    /**
     * setAge :
     * @param value 
     */

    public void setAge(double value) {
        double _oldValue = this.age;
        fireOnPreWrite(AGE, _oldValue, value);
        this.age = value;
        fireOnPostWrite(AGE, _oldValue, value);
}

    /**
     * getAge :
     * @return double 
     */

    public double getAge() {
        fireOnPreRead(AGE, age);
        double result = this.age;
        fireOnPostRead(AGE, age);
        return result;
}

    /**
     * setMinLength :
     * @param value 
     */

    public void setMinLength(double value) {
        double _oldValue = this.minLength;
        fireOnPreWrite(MIN_LENGTH, _oldValue, value);
        this.minLength = value;
        fireOnPostWrite(MIN_LENGTH, _oldValue, value);
}

    /**
     * getMinLength :
     * @return double 
     */

    public double getMinLength() {
        fireOnPreRead(MIN_LENGTH, minLength);
        double result = this.minLength;
        fireOnPostRead(MIN_LENGTH, minLength);
        return result;
}

    /**
     * setMaxLength :
     * @param value 
     */

    public void setMaxLength(double value) {
        double _oldValue = this.maxLength;
        fireOnPreWrite(MAX_LENGTH, _oldValue, value);
        this.maxLength = value;
        fireOnPostWrite(MAX_LENGTH, _oldValue, value);
}

    /**
     * getMaxLength :
     * @return double 
     */

    public double getMaxLength() {
        fireOnPreRead(MAX_LENGTH, maxLength);
        double result = this.maxLength;
        fireOnPostRead(MAX_LENGTH, maxLength);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * setPopulation :
     * @param value 
     */

    public void setPopulation(Population value) {
        Population _oldValue = this.population;
        fireOnPreWrite(POPULATION, _oldValue, value);
        this.population = value;
        fireOnPostWrite(POPULATION, _oldValue, value);
}

    /**
     * getPopulation :
     * @return Population 
     */

    public Population getPopulation() {
        fireOnPreRead(POPULATION, population);
        Population result = this.population;
        fireOnPostRead(POPULATION, population);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ID, this.id).
            append(REPRODUCTION_RATE, this.reproductionRate).
            append(AGE, this.age).
            append(MIN_LENGTH, this.minLength).
            append(MAX_LENGTH, this.maxLength).
            append(COMMENT, this.comment).
         toString();
        return result;
}


} //PopulationGroupAbstract
