/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={PopulationGroup.COMMENT},
  numFields={PopulationGroup.ID, PopulationGroup.REPRODUCTION_RATE, PopulationGroup.AGE, PopulationGroup.MIN_LENGTH, PopulationGroup.MAX_LENGTH}
)

public interface PopulationGroup extends TopiaEntity {     String ID = "id";
     String REPRODUCTION_RATE = "reproductionRate";
     String AGE = "age";
     String MIN_LENGTH = "minLength";
     String MAX_LENGTH = "maxLength";
     String COMMENT = "comment";
     String POPULATION = "population";
    /**
     * setId :
     * @param id La valeur de l'attribut id à positionner.
     */

     void setId(int id);

    /**
     * getId :
     * @return int 
     */

     int getId();

    /**
     * setReproductionRate :
     * <p>Le taux de f&eacute;condit&eacute; pour le group</p>

     * @param reproductionRate La valeur de l'attribut reproductionRate à positionner.
     */

     void setReproductionRate(double reproductionRate);

    /**
     * getReproductionRate :
     * <p>Le taux de f&eacute;condit&eacute; pour le group</p>

     * @return double 
     */

     double getReproductionRate();

    /**
     * setAge :
     * @param age La valeur de l'attribut age à positionner.
     */

     void setAge(double age);

    /**
     * getAge :
     * @return double 
     */

     double getAge();

    /**
     * setMinLength :
     * @param minLength La valeur de l'attribut minLength à positionner.
     */

     void setMinLength(double minLength);

    /**
     * getMinLength :
     * @return double 
     */

     double getMinLength();

    /**
     * setMaxLength :
     * @param maxLength La valeur de l'attribut maxLength à positionner.
     */

     void setMaxLength(double maxLength);

    /**
     * getMaxLength :
     * @return double 
     */

     double getMaxLength();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setPopulation :
     * @param population La valeur de l'attribut population à positionner.
     */

     void setPopulation(Population population);

    /**
     * getPopulation :
     * @return Population 
     */

     Population getPopulation();

    /**
     * getLength :
     * @return double 
     */

     double getLength();

    /**
     * getNaturalDeathRate :
     * @param zone 
     * @return double 
     */

     double getNaturalDeathRate(Zone zone);

    /**
     * getMeanWeight :
     * @return double 
     */

     double getMeanWeight();

    /**
     * getPrice :
     * @return double 
     */

     double getPrice();

    /**
     * isInLength :
     * @param length 
     * @return boolean 
     */

     boolean isInLength(double length);


} //PopulationGroup
