/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class PopulationDAOAbstract<E extends Population> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Population.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                                        {
                                        List<PopulationSeasonInfo> list = getContext()
                                                    .getDAO(PopulationSeasonInfo.class)
                                                    .findAllByProperties(PopulationSeasonInfo.POPULATION, entity);
                        //                            .findAllByProperties("population", entity);
                                            for (PopulationSeasonInfo item : list) {
                                                item.setPopulation(null);
                        
                    }
                }

        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Population.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.NAME, v);
        return result;
    }

    /**
     * findByGeographicId :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut geographicId le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGeographicId(String v) throws TopiaException {
        E result = findByProperty(Population.GEOGRAPHIC_ID, v);
        return result;
    }

    /**
     * findAllByGeographicId :
     * Retourne les éléments ayant comme valeur pour l'attribut geographicId le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGeographicId(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.GEOGRAPHIC_ID, v);
        return result;
    }

    /**
     * findByPlusGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut plusGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPlusGroup(boolean v) throws TopiaException {
        E result = findByProperty(Population.PLUS_GROUP, v);
        return result;
    }

    /**
     * findAllByPlusGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut plusGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPlusGroup(boolean v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PLUS_GROUP, v);
        return result;
    }

    /**
     * findByGrowth :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut growth le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGrowth(Equation v) throws TopiaException {
        E result = findByProperty(Population.GROWTH, v);
        return result;
    }

    /**
     * findAllByGrowth :
     * Retourne les éléments ayant comme valeur pour l'attribut growth le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGrowth(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.GROWTH, v);
        return result;
    }

    /**
     * findByGrowthReverse :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut growthReverse le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGrowthReverse(Equation v) throws TopiaException {
        E result = findByProperty(Population.GROWTH_REVERSE, v);
        return result;
    }

    /**
     * findAllByGrowthReverse :
     * Retourne les éléments ayant comme valeur pour l'attribut growthReverse le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGrowthReverse(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.GROWTH_REVERSE, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(Population.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.COMMENT, v);
        return result;
    }

    /**
     * findByMeanWeight :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut meanWeight le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMeanWeight(Equation v) throws TopiaException {
        E result = findByProperty(Population.MEAN_WEIGHT, v);
        return result;
    }

    /**
     * findAllByMeanWeight :
     * Retourne les éléments ayant comme valeur pour l'attribut meanWeight le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMeanWeight(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.MEAN_WEIGHT, v);
        return result;
    }

    /**
     * findByPrice :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut price le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByPrice(Equation v) throws TopiaException {
        E result = findByProperty(Population.PRICE, v);
        return result;
    }

    /**
     * findAllByPrice :
     * Retourne les éléments ayant comme valeur pour l'attribut price le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByPrice(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.PRICE, v);
        return result;
    }

    /**
     * findByNaturalDeathRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut naturalDeathRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByNaturalDeathRate(Equation v) throws TopiaException {
        E result = findByProperty(Population.NATURAL_DEATH_RATE, v);
        return result;
    }

    /**
     * findAllByNaturalDeathRate :
     * Retourne les éléments ayant comme valeur pour l'attribut naturalDeathRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByNaturalDeathRate(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.NATURAL_DEATH_RATE, v);
        return result;
    }

    /**
     * findByCaractBioComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut caractBioComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCaractBioComment(String v) throws TopiaException {
        E result = findByProperty(Population.CARACT_BIO_COMMENT, v);
        return result;
    }

    /**
     * findAllByCaractBioComment :
     * Retourne les éléments ayant comme valeur pour l'attribut caractBioComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCaractBioComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.CARACT_BIO_COMMENT, v);
        return result;
    }

    /**
     * findByReproductionEquation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut reproductionEquation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReproductionEquation(Equation v) throws TopiaException {
        E result = findByProperty(Population.REPRODUCTION_EQUATION, v);
        return result;
    }

    /**
     * findAllByReproductionEquation :
     * Retourne les éléments ayant comme valeur pour l'attribut reproductionEquation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReproductionEquation(Equation v) throws TopiaException {
        List<E> result = findAllByProperty(Population.REPRODUCTION_EQUATION, v);
        return result;
    }

    /**
     * findByMonthGapBetweenReproRecrutement :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut monthGapBetweenReproRecrutement le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        E result = findByProperty(Population.MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, v);
        return result;
    }

    /**
     * findAllByMonthGapBetweenReproRecrutement :
     * Retourne les éléments ayant comme valeur pour l'attribut monthGapBetweenReproRecrutement le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMonthGapBetweenReproRecrutement(int v) throws TopiaException {
        List<E> result = findAllByProperty(Population.MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, v);
        return result;
    }

    /**
     * findByRecruitmentDistribution :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut recruitmentDistribution le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRecruitmentDistribution(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.RECRUITMENT_DISTRIBUTION, v);
        return result;
    }

    /**
     * findAllByRecruitmentDistribution :
     * Retourne les éléments ayant comme valeur pour l'attribut recruitmentDistribution le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRecruitmentDistribution(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.RECRUITMENT_DISTRIBUTION, v);
        return result;
    }

    /**
     * findByRecruitmentComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut recruitmentComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRecruitmentComment(String v) throws TopiaException {
        E result = findByProperty(Population.RECRUITMENT_COMMENT, v);
        return result;
    }

    /**
     * findAllByRecruitmentComment :
     * Retourne les éléments ayant comme valeur pour l'attribut recruitmentComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRecruitmentComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.RECRUITMENT_COMMENT, v);
        return result;
    }

    /**
     * findByZonesComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut zonesComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByZonesComment(String v) throws TopiaException {
        E result = findByProperty(Population.ZONES_COMMENT, v);
        return result;
    }

    /**
     * findAllByZonesComment :
     * Retourne les éléments ayant comme valeur pour l'attribut zonesComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByZonesComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.ZONES_COMMENT, v);
        return result;
    }

    /**
     * findBySeasonsComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut seasonsComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySeasonsComment(String v) throws TopiaException {
        E result = findByProperty(Population.SEASONS_COMMENT, v);
        return result;
    }

    /**
     * findAllBySeasonsComment :
     * Retourne les éléments ayant comme valeur pour l'attribut seasonsComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySeasonsComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.SEASONS_COMMENT, v);
        return result;
    }

    /**
     * findByCapturabilityComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturabilityComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturabilityComment(String v) throws TopiaException {
        E result = findByProperty(Population.CAPTURABILITY_COMMENT, v);
        return result;
    }

    /**
     * findAllByCapturabilityComment :
     * Retourne les éléments ayant comme valeur pour l'attribut capturabilityComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturabilityComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.CAPTURABILITY_COMMENT, v);
        return result;
    }

    /**
     * findByMigrationComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut migrationComment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMigrationComment(String v) throws TopiaException {
        E result = findByProperty(Population.MIGRATION_COMMENT, v);
        return result;
    }

    /**
     * findAllByMigrationComment :
     * Retourne les éléments ayant comme valeur pour l'attribut migrationComment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMigrationComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(Population.MIGRATION_COMMENT, v);
        return result;
    }

    /**
     * findByMappingZoneReproZoneRecru :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut mappingZoneReproZoneRecru le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.MAPPING_ZONE_REPRO_ZONE_RECRU, v);
        return result;
    }

    /**
     * findAllByMappingZoneReproZoneRecru :
     * Retourne les éléments ayant comme valeur pour l'attribut mappingZoneReproZoneRecru le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMappingZoneReproZoneRecru(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.MAPPING_ZONE_REPRO_ZONE_RECRU, v);
        return result;
    }

    /**
     * findByCapturability :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut capturability le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCapturability(MatrixND v) throws TopiaException {
        E result = findByProperty(Population.CAPTURABILITY, v);
        return result;
    }

    /**
     * findAllByCapturability :
     * Retourne les éléments ayant comme valeur pour l'attribut capturability le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCapturability(MatrixND v) throws TopiaException {
        List<E> result = findAllByProperty(Population.CAPTURABILITY, v);
        return result;
    }

    /**
     * findContainsPopulationGroup :
     * Retourne le premier élément trouvé dont l'attribut populationGroup contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationGroup(PopulationGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Population.POPULATION_GROUP, Arrays.asList(v));
        E result = findContainsProperties("populationGroup", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationGroup :
     * Retourne les éléments trouvé dont l'attribut populationGroup contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationGroup(PopulationGroup... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Population.POPULATION_GROUP, Arrays.asList(v));
        List<E> results = findAllContainsProperties("populationGroup", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulationSeasonInfo :
     * Retourne le premier élément trouvé dont l'attribut populationSeasonInfo contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationSeasonInfo(PopulationSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Population.POPULATION_SEASON_INFO, Arrays.asList(v));
        E result = findContainsProperties("populationSeasonInfo", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationSeasonInfo :
     * Retourne les éléments trouvé dont l'attribut populationSeasonInfo contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationSeasonInfo(PopulationSeasonInfo... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Population.POPULATION_SEASON_INFO, Arrays.asList(v));
        List<E> results = findAllContainsProperties("populationSeasonInfo", Arrays.asList(v));
        return results;
    }

    /**
     * findBySpecies :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut species le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findBySpecies(Species v) throws TopiaException {
        E result = findByProperty(Population.SPECIES, v);
        return result;
    }

    /**
     * findAllBySpecies :
     * Retourne les éléments ayant comme valeur pour l'attribut species le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllBySpecies(Species v) throws TopiaException {
        List<E> result = findAllByProperty(Population.SPECIES, v);
        return result;
    }

    /**
     * findContainsReproductionZone :
     * Retourne le premier élément trouvé dont l'attribut reproductionZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsReproductionZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Population.REPRODUCTION_ZONE, Arrays.asList(v));
        E result = findContainsProperties("reproductionZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsReproductionZone :
     * Retourne les éléments trouvé dont l'attribut reproductionZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsReproductionZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Population.REPRODUCTION_ZONE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("reproductionZone", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPopulationZone :
     * Retourne le premier élément trouvé dont l'attribut populationZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPopulationZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Population.POPULATION_ZONE, Arrays.asList(v));
        E result = findContainsProperties("populationZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPopulationZone :
     * Retourne les éléments trouvé dont l'attribut populationZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPopulationZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Population.POPULATION_ZONE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("populationZone", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsRecruitmentZone :
     * Retourne le premier élément trouvé dont l'attribut recruitmentZone contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsRecruitmentZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(Population.RECRUITMENT_ZONE, Arrays.asList(v));
        E result = findContainsProperties("recruitmentZone", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsRecruitmentZone :
     * Retourne les éléments trouvé dont l'attribut recruitmentZone contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsRecruitmentZone(Zone... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(Population.RECRUITMENT_ZONE, Arrays.asList(v));
        List<E> results = findAllContainsProperties("recruitmentZone", Arrays.asList(v));
        return results;
    }

    /**
     * findByMaturityGroup :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maturityGroup le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaturityGroup(PopulationGroup v) throws TopiaException {
        E result = findByProperty(Population.MATURITY_GROUP, v);
        return result;
    }

    /**
     * findAllByMaturityGroup :
     * Retourne les éléments ayant comme valeur pour l'attribut maturityGroup le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaturityGroup(PopulationGroup v) throws TopiaException {
        List<E> result = findAllByProperty(Population.MATURITY_GROUP, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == PopulationGroup.class) {
            PopulationGroupDAO dao = (PopulationGroupDAO)
                getContext().getDAO(PopulationGroup.class);
            tmp = dao.findAllByPopulation(entity);
//            tmp = dao.findAllByProperties(PopulationGroup.POPULATION, entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByPopulation(entity);
//            tmp = dao.findAllByProperties(PopulationSeasonInfo.POPULATION, entity);
            result.addAll(tmp);
        }

        if (type == Species.class) {
            SpeciesDAO dao = (SpeciesDAO)
                getContext().getDAO(Species.class);
            tmp = dao.findAllContainsPopulation(entity);
//            tmp = dao.findAllByProperties(Species.POPULATION, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(3);
        
        List<? extends TopiaEntity> list;

        list = findUsages(PopulationGroup.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationGroup.class, list);
        }

        list = findUsages(PopulationSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationSeasonInfo.class, list);
        }

        list = findUsages(Species.class, entity);
        if (!list.isEmpty()) {
            result.put(Species.class, list);
        }

        return result;
    }


} //PopulationDAOAbstract<E extends Population>
