/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class PopulationAbstract extends TopiaEntityAbstract implements Population {

    protected String name;
    protected String geographicId;
    protected boolean plusGroup;
    protected Equation growth;
    protected Equation growthReverse;
    protected String comment;
    protected Equation meanWeight;
    /**
     * <p>Le prix en Kg</p>


     */
    protected Equation price;
    protected Equation naturalDeathRate;
    protected String caractBioComment;
    protected Equation reproductionEquation;
    protected int monthGapBetweenReproRecrutement;
    protected MatrixND recruitmentDistribution;
    protected String recruitmentComment;
    protected String zonesComment;
    protected String seasonsComment;
    protected String capturabilityComment;
    protected String migrationComment;
    protected MatrixND mappingZoneReproZoneRecru;
    protected MatrixND capturability;
    protected Collection<Selectivity> gearSelectivity;
    protected List<PopulationGroup> populationGroup;
    protected List<PopulationSeasonInfo> populationSeasonInfo;
    protected Species species;
    protected List<Zone> reproductionZone;
    protected List<Zone> populationZone;
    protected List<Zone> recruitmentZone;
    protected PopulationGroup maturityGroup;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Population.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, GEOGRAPHIC_ID, String.class, geographicId);
        visitor.visit(this, PLUS_GROUP, boolean.class, plusGroup);
        visitor.visit(this, GROWTH, Equation.class, growth);
        visitor.visit(this, GROWTH_REVERSE, Equation.class, growthReverse);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, MEAN_WEIGHT, Equation.class, meanWeight);
        visitor.visit(this, PRICE, Equation.class, price);
        visitor.visit(this, NATURAL_DEATH_RATE, Equation.class, naturalDeathRate);
        visitor.visit(this, CARACT_BIO_COMMENT, String.class, caractBioComment);
        visitor.visit(this, REPRODUCTION_EQUATION, Equation.class, reproductionEquation);
        visitor.visit(this, MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, int.class, monthGapBetweenReproRecrutement);
        visitor.visit(this, RECRUITMENT_DISTRIBUTION, MatrixND.class, recruitmentDistribution);
        visitor.visit(this, RECRUITMENT_COMMENT, String.class, recruitmentComment);
        visitor.visit(this, ZONES_COMMENT, String.class, zonesComment);
        visitor.visit(this, SEASONS_COMMENT, String.class, seasonsComment);
        visitor.visit(this, CAPTURABILITY_COMMENT, String.class, capturabilityComment);
        visitor.visit(this, MIGRATION_COMMENT, String.class, migrationComment);
        visitor.visit(this, MAPPING_ZONE_REPRO_ZONE_RECRU, MatrixND.class, mappingZoneReproZoneRecru);
        visitor.visit(this, CAPTURABILITY, MatrixND.class, capturability);
        visitor.visit(this, GEAR_SELECTIVITY, java.util.Collection.class, Selectivity.class, gearSelectivity);
        visitor.visit(this, POPULATION_GROUP, List.class, PopulationGroup.class, populationGroup);
        visitor.visit(this, POPULATION_SEASON_INFO, List.class, PopulationSeasonInfo.class, populationSeasonInfo);
        visitor.visit(this, SPECIES, Species.class, species);
        visitor.visit(this, REPRODUCTION_ZONE, List.class, Zone.class, reproductionZone);
        visitor.visit(this, POPULATION_ZONE, List.class, Zone.class, populationZone);
        visitor.visit(this, RECRUITMENT_ZONE, List.class, Zone.class, recruitmentZone);
        visitor.visit(this, MATURITY_GROUP, PopulationGroup.class, maturityGroup);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp
        tmp.add(getGrowth());
        tmp.add(getGrowthReverse());
        tmp.add(getMeanWeight());
        tmp.add(getPrice());
        tmp.add(getNaturalDeathRate());
        tmp.add(getReproductionEquation());

        {
            org.nuiton.topia.persistence.TopiaDAO<Selectivity> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(Selectivity.class);
            List<Selectivity> findAllByProperties = dao.findAllByProperties("population", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getPopulationGroup() != null) {
              tmp.addAll(getPopulationGroup());
           }
        if (getPopulationSeasonInfo() != null) {
              tmp.addAll(getPopulationSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setGeographicId :
     * @param value 
     */

    public void setGeographicId(String value) {
        String _oldValue = this.geographicId;
        fireOnPreWrite(GEOGRAPHIC_ID, _oldValue, value);
        this.geographicId = value;
        fireOnPostWrite(GEOGRAPHIC_ID, _oldValue, value);
}

    /**
     * getGeographicId :
     * @return String 
     */

    public String getGeographicId() {
        fireOnPreRead(GEOGRAPHIC_ID, geographicId);
        String result = this.geographicId;
        fireOnPostRead(GEOGRAPHIC_ID, geographicId);
        return result;
}

    /**
     * setPlusGroup :
     * @param value 
     */

    public void setPlusGroup(boolean value) {
        boolean _oldValue = this.plusGroup;
        fireOnPreWrite(PLUS_GROUP, _oldValue, value);
        this.plusGroup = value;
        fireOnPostWrite(PLUS_GROUP, _oldValue, value);
}

    /**
     * getPlusGroup :
     * @return boolean 
     */

    public boolean getPlusGroup() {
        fireOnPreRead(PLUS_GROUP, plusGroup);
        boolean result = this.plusGroup;
        fireOnPostRead(PLUS_GROUP, plusGroup);
        return result;
}

    /**
     * setGrowth :
     * @param value 
     */

    public void setGrowth(Equation value) {
        Equation _oldValue = this.growth;
        fireOnPreWrite(GROWTH, _oldValue, value);
        this.growth = value;
        fireOnPostWrite(GROWTH, _oldValue, value);
}

    /**
     * getGrowth :
     * @return Equation 
     */

    public Equation getGrowth() {
        fireOnPreRead(GROWTH, growth);
        Equation result = this.growth;
        fireOnPostRead(GROWTH, growth);
        return result;
}

    /**
     * setGrowthReverse :
     * @param value 
     */

    public void setGrowthReverse(Equation value) {
        Equation _oldValue = this.growthReverse;
        fireOnPreWrite(GROWTH_REVERSE, _oldValue, value);
        this.growthReverse = value;
        fireOnPostWrite(GROWTH_REVERSE, _oldValue, value);
}

    /**
     * getGrowthReverse :
     * @return Equation 
     */

    public Equation getGrowthReverse() {
        fireOnPreRead(GROWTH_REVERSE, growthReverse);
        Equation result = this.growthReverse;
        fireOnPostRead(GROWTH_REVERSE, growthReverse);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * setMeanWeight :
     * @param value 
     */

    public void setMeanWeight(Equation value) {
        Equation _oldValue = this.meanWeight;
        fireOnPreWrite(MEAN_WEIGHT, _oldValue, value);
        this.meanWeight = value;
        fireOnPostWrite(MEAN_WEIGHT, _oldValue, value);
}

    /**
     * getMeanWeight :
     * @return Equation 
     */

    public Equation getMeanWeight() {
        fireOnPreRead(MEAN_WEIGHT, meanWeight);
        Equation result = this.meanWeight;
        fireOnPostRead(MEAN_WEIGHT, meanWeight);
        return result;
}

    /**
     * setPrice :
     * @param value 
     */

    public void setPrice(Equation value) {
        Equation _oldValue = this.price;
        fireOnPreWrite(PRICE, _oldValue, value);
        this.price = value;
        fireOnPostWrite(PRICE, _oldValue, value);
}

    /**
     * getPrice :
     * @return Equation 
     */

    public Equation getPrice() {
        fireOnPreRead(PRICE, price);
        Equation result = this.price;
        fireOnPostRead(PRICE, price);
        return result;
}

    /**
     * setNaturalDeathRate :
     * @param value 
     */

    public void setNaturalDeathRate(Equation value) {
        Equation _oldValue = this.naturalDeathRate;
        fireOnPreWrite(NATURAL_DEATH_RATE, _oldValue, value);
        this.naturalDeathRate = value;
        fireOnPostWrite(NATURAL_DEATH_RATE, _oldValue, value);
}

    /**
     * getNaturalDeathRate :
     * @return Equation 
     */

    public Equation getNaturalDeathRate() {
        fireOnPreRead(NATURAL_DEATH_RATE, naturalDeathRate);
        Equation result = this.naturalDeathRate;
        fireOnPostRead(NATURAL_DEATH_RATE, naturalDeathRate);
        return result;
}

    /**
     * setCaractBioComment :
     * @param value 
     */

    public void setCaractBioComment(String value) {
        String _oldValue = this.caractBioComment;
        fireOnPreWrite(CARACT_BIO_COMMENT, _oldValue, value);
        this.caractBioComment = value;
        fireOnPostWrite(CARACT_BIO_COMMENT, _oldValue, value);
}

    /**
     * getCaractBioComment :
     * @return String 
     */

    public String getCaractBioComment() {
        fireOnPreRead(CARACT_BIO_COMMENT, caractBioComment);
        String result = this.caractBioComment;
        fireOnPostRead(CARACT_BIO_COMMENT, caractBioComment);
        return result;
}

    /**
     * setReproductionEquation :
     * @param value 
     */

    public void setReproductionEquation(Equation value) {
        Equation _oldValue = this.reproductionEquation;
        fireOnPreWrite(REPRODUCTION_EQUATION, _oldValue, value);
        this.reproductionEquation = value;
        fireOnPostWrite(REPRODUCTION_EQUATION, _oldValue, value);
}

    /**
     * getReproductionEquation :
     * @return Equation 
     */

    public Equation getReproductionEquation() {
        fireOnPreRead(REPRODUCTION_EQUATION, reproductionEquation);
        Equation result = this.reproductionEquation;
        fireOnPostRead(REPRODUCTION_EQUATION, reproductionEquation);
        return result;
}

    /**
     * setMonthGapBetweenReproRecrutement :
     * @param value 
     */

    public void setMonthGapBetweenReproRecrutement(int value) {
        int _oldValue = this.monthGapBetweenReproRecrutement;
        fireOnPreWrite(MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, _oldValue, value);
        this.monthGapBetweenReproRecrutement = value;
        fireOnPostWrite(MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, _oldValue, value);
}

    /**
     * getMonthGapBetweenReproRecrutement :
     * @return int 
     */

    public int getMonthGapBetweenReproRecrutement() {
        fireOnPreRead(MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, monthGapBetweenReproRecrutement);
        int result = this.monthGapBetweenReproRecrutement;
        fireOnPostRead(MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, monthGapBetweenReproRecrutement);
        return result;
}

    /**
     * setRecruitmentDistribution :
     * @param value 
     */

    public void setRecruitmentDistribution(MatrixND value) {
        MatrixND _oldValue = this.recruitmentDistribution;
        fireOnPreWrite(RECRUITMENT_DISTRIBUTION, _oldValue, value);
        this.recruitmentDistribution = value;
        fireOnPostWrite(RECRUITMENT_DISTRIBUTION, _oldValue, value);
}

    /**
     * getRecruitmentDistribution :
     * @return MatrixND 
     */

    public MatrixND getRecruitmentDistribution() {
        fireOnPreRead(RECRUITMENT_DISTRIBUTION, recruitmentDistribution);
        MatrixND result = this.recruitmentDistribution;
        fireOnPostRead(RECRUITMENT_DISTRIBUTION, recruitmentDistribution);
        return result;
}

    /**
     * setRecruitmentComment :
     * @param value 
     */

    public void setRecruitmentComment(String value) {
        String _oldValue = this.recruitmentComment;
        fireOnPreWrite(RECRUITMENT_COMMENT, _oldValue, value);
        this.recruitmentComment = value;
        fireOnPostWrite(RECRUITMENT_COMMENT, _oldValue, value);
}

    /**
     * getRecruitmentComment :
     * @return String 
     */

    public String getRecruitmentComment() {
        fireOnPreRead(RECRUITMENT_COMMENT, recruitmentComment);
        String result = this.recruitmentComment;
        fireOnPostRead(RECRUITMENT_COMMENT, recruitmentComment);
        return result;
}

    /**
     * setZonesComment :
     * @param value 
     */

    public void setZonesComment(String value) {
        String _oldValue = this.zonesComment;
        fireOnPreWrite(ZONES_COMMENT, _oldValue, value);
        this.zonesComment = value;
        fireOnPostWrite(ZONES_COMMENT, _oldValue, value);
}

    /**
     * getZonesComment :
     * @return String 
     */

    public String getZonesComment() {
        fireOnPreRead(ZONES_COMMENT, zonesComment);
        String result = this.zonesComment;
        fireOnPostRead(ZONES_COMMENT, zonesComment);
        return result;
}

    /**
     * setSeasonsComment :
     * @param value 
     */

    public void setSeasonsComment(String value) {
        String _oldValue = this.seasonsComment;
        fireOnPreWrite(SEASONS_COMMENT, _oldValue, value);
        this.seasonsComment = value;
        fireOnPostWrite(SEASONS_COMMENT, _oldValue, value);
}

    /**
     * getSeasonsComment :
     * @return String 
     */

    public String getSeasonsComment() {
        fireOnPreRead(SEASONS_COMMENT, seasonsComment);
        String result = this.seasonsComment;
        fireOnPostRead(SEASONS_COMMENT, seasonsComment);
        return result;
}

    /**
     * setCapturabilityComment :
     * @param value 
     */

    public void setCapturabilityComment(String value) {
        String _oldValue = this.capturabilityComment;
        fireOnPreWrite(CAPTURABILITY_COMMENT, _oldValue, value);
        this.capturabilityComment = value;
        fireOnPostWrite(CAPTURABILITY_COMMENT, _oldValue, value);
}

    /**
     * getCapturabilityComment :
     * @return String 
     */

    public String getCapturabilityComment() {
        fireOnPreRead(CAPTURABILITY_COMMENT, capturabilityComment);
        String result = this.capturabilityComment;
        fireOnPostRead(CAPTURABILITY_COMMENT, capturabilityComment);
        return result;
}

    /**
     * setMigrationComment :
     * @param value 
     */

    public void setMigrationComment(String value) {
        String _oldValue = this.migrationComment;
        fireOnPreWrite(MIGRATION_COMMENT, _oldValue, value);
        this.migrationComment = value;
        fireOnPostWrite(MIGRATION_COMMENT, _oldValue, value);
}

    /**
     * getMigrationComment :
     * @return String 
     */

    public String getMigrationComment() {
        fireOnPreRead(MIGRATION_COMMENT, migrationComment);
        String result = this.migrationComment;
        fireOnPostRead(MIGRATION_COMMENT, migrationComment);
        return result;
}

    /**
     * setMappingZoneReproZoneRecru :
     * @param value 
     */

    public void setMappingZoneReproZoneRecru(MatrixND value) {
        MatrixND _oldValue = this.mappingZoneReproZoneRecru;
        fireOnPreWrite(MAPPING_ZONE_REPRO_ZONE_RECRU, _oldValue, value);
        this.mappingZoneReproZoneRecru = value;
        fireOnPostWrite(MAPPING_ZONE_REPRO_ZONE_RECRU, _oldValue, value);
}

    /**
     * getMappingZoneReproZoneRecru :
     * @return MatrixND 
     */

    public MatrixND getMappingZoneReproZoneRecru() {
        fireOnPreRead(MAPPING_ZONE_REPRO_ZONE_RECRU, mappingZoneReproZoneRecru);
        MatrixND result = this.mappingZoneReproZoneRecru;
        fireOnPostRead(MAPPING_ZONE_REPRO_ZONE_RECRU, mappingZoneReproZoneRecru);
        return result;
}

    /**
     * setCapturability :
     * @param value 
     */

    public void setCapturability(MatrixND value) {
        MatrixND _oldValue = this.capturability;
        fireOnPreWrite(CAPTURABILITY, _oldValue, value);
        this.capturability = value;
        fireOnPostWrite(CAPTURABILITY, _oldValue, value);
}

    /**
     * getCapturability :
     * @return MatrixND 
     */

    public MatrixND getCapturability() {
        fireOnPreRead(CAPTURABILITY, capturability);
        MatrixND result = this.capturability;
        fireOnPostRead(CAPTURABILITY, capturability);
        return result;
}

    /**
     * addPopulationGroup :
     * @param populationGroup 
     */

    public void addPopulationGroup(PopulationGroup populationGroup) {    
        fireOnPreWrite(POPULATION_GROUP, null, populationGroup);
        if (this.populationGroup == null) {
            this.populationGroup = new ArrayList<PopulationGroup>();
        }
        this.populationGroup.add(populationGroup);
        fireOnPostWrite(POPULATION_GROUP, this.populationGroup.size(), null, populationGroup);
}

    /**
     * addAllPopulationGroup :
     * @param values 
     */

    public void addAllPopulationGroup(List<PopulationGroup> values) {
        if (values == null) {
            return;
        }
        for (PopulationGroup item : values) {
            addPopulationGroup(item);
        }
}

    /**
     * getPopulationGroupByTopiaId :
     * @param topiaId 
     * @return PopulationGroup 
     */

    public PopulationGroup getPopulationGroupByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationGroup, topiaId);
 }

    /**
     * setPopulationGroup :
     * @param values 
     */

    public void setPopulationGroup(List<PopulationGroup> values) {
        List<PopulationGroup> _oldValue = populationGroup;
        fireOnPreWrite(POPULATION_GROUP, _oldValue, values);
        populationGroup = values;
        fireOnPostWrite(POPULATION_GROUP, _oldValue, values);
}

    /**
     * removePopulationGroup :
     * @param value 
     */

    public void removePopulationGroup(PopulationGroup value) {
        fireOnPreWrite(POPULATION_GROUP, value, null);
        if ((this.populationGroup == null) || (!this.populationGroup.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(POPULATION_GROUP, this.populationGroup.size()+1, value, null);
}

    /**
     * clearPopulationGroup :
     */

    public void clearPopulationGroup() {
        if (this.populationGroup == null) {
            return;
        }
        List<PopulationGroup> _oldValue = new ArrayList<PopulationGroup>(this.populationGroup);
        fireOnPreWrite(POPULATION_GROUP, _oldValue, this.populationGroup);
        this.populationGroup.clear();
        fireOnPostWrite(POPULATION_GROUP, _oldValue, this.populationGroup);
}

    /**
     * getPopulationGroup :
     * @return List<PopulationGroup> 
     */

    public List<PopulationGroup> getPopulationGroup() {
        return populationGroup;
}

    /**
     * sizePopulationGroup :
     * @return int 
     */

    public int sizePopulationGroup() {
        if (populationGroup == null) {
            return 0;
        }
        return populationGroup.size();
}

    /**
     * isPopulationGroupEmpty :
     * @return boolean 
     */

    public boolean isPopulationGroupEmpty() {
        int size = sizePopulationGroup();
        return size == 0;
}

    /**
     * addPopulationSeasonInfo :
     * @param populationSeasonInfo 
     */

    public void addPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo) {    
        fireOnPreWrite(POPULATION_SEASON_INFO, null, populationSeasonInfo);
        if (this.populationSeasonInfo == null) {
            this.populationSeasonInfo = new ArrayList<PopulationSeasonInfo>();
        }
        populationSeasonInfo.setPopulation(this);
        this.populationSeasonInfo.add(populationSeasonInfo);
        fireOnPostWrite(POPULATION_SEASON_INFO, this.populationSeasonInfo.size(), null, populationSeasonInfo);
}

    /**
     * addAllPopulationSeasonInfo :
     * @param values 
     */

    public void addAllPopulationSeasonInfo(List<PopulationSeasonInfo> values) {
        if (values == null) {
            return;
        }
        for (PopulationSeasonInfo item : values) {
            addPopulationSeasonInfo(item);
        }
}

    /**
     * getPopulationSeasonInfoByTopiaId :
     * @param topiaId 
     * @return PopulationSeasonInfo 
     */

    public PopulationSeasonInfo getPopulationSeasonInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationSeasonInfo, topiaId);
 }

    /**
     * setPopulationSeasonInfo :
     * @param values 
     */

    public void setPopulationSeasonInfo(List<PopulationSeasonInfo> values) {
        List<PopulationSeasonInfo> _oldValue = populationSeasonInfo;
        fireOnPreWrite(POPULATION_SEASON_INFO, _oldValue, values);
        populationSeasonInfo = values;
        fireOnPostWrite(POPULATION_SEASON_INFO, _oldValue, values);
}

    /**
     * removePopulationSeasonInfo :
     * @param value 
     */

    public void removePopulationSeasonInfo(PopulationSeasonInfo value) {
        fireOnPreWrite(POPULATION_SEASON_INFO, value, null);
        if ((this.populationSeasonInfo == null) || (!this.populationSeasonInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setPopulation(null);
        fireOnPostWrite(POPULATION_SEASON_INFO, this.populationSeasonInfo.size()+1, value, null);
}

    /**
     * clearPopulationSeasonInfo :
     */

    public void clearPopulationSeasonInfo() {
        if (this.populationSeasonInfo == null) {
            return;
        }
        for (PopulationSeasonInfo item : this.populationSeasonInfo) {
            item.setPopulation(null);
        }
        List<PopulationSeasonInfo> _oldValue = new ArrayList<PopulationSeasonInfo>(this.populationSeasonInfo);
        fireOnPreWrite(POPULATION_SEASON_INFO, _oldValue, this.populationSeasonInfo);
        this.populationSeasonInfo.clear();
        fireOnPostWrite(POPULATION_SEASON_INFO, _oldValue, this.populationSeasonInfo);
}

    /**
     * getPopulationSeasonInfo :
     * @return List<PopulationSeasonInfo> 
     */

    public List<PopulationSeasonInfo> getPopulationSeasonInfo() {
        return populationSeasonInfo;
}

    /**
     * sizePopulationSeasonInfo :
     * @return int 
     */

    public int sizePopulationSeasonInfo() {
        if (populationSeasonInfo == null) {
            return 0;
        }
        return populationSeasonInfo.size();
}

    /**
     * isPopulationSeasonInfoEmpty :
     * @return boolean 
     */

    public boolean isPopulationSeasonInfoEmpty() {
        int size = sizePopulationSeasonInfo();
        return size == 0;
}

    /**
     * setSpecies :
     * @param value 
     */

    public void setSpecies(Species value) {
        Species _oldValue = this.species;
        fireOnPreWrite(SPECIES, _oldValue, value);
        this.species = value;
        fireOnPostWrite(SPECIES, _oldValue, value);
}

    /**
     * getSpecies :
     * @return Species 
     */

    public Species getSpecies() {
        fireOnPreRead(SPECIES, species);
        Species result = this.species;
        fireOnPostRead(SPECIES, species);
        return result;
}

    /**
     * addReproductionZone :
     * @param reproductionZone 
     */

    public void addReproductionZone(Zone reproductionZone) {    
        fireOnPreWrite(REPRODUCTION_ZONE, null, reproductionZone);
        if (this.reproductionZone == null) {
            this.reproductionZone = new ArrayList<Zone>();
        }
        this.reproductionZone.add(reproductionZone);
        fireOnPostWrite(REPRODUCTION_ZONE, this.reproductionZone.size(), null, reproductionZone);
}

    /**
     * addAllReproductionZone :
     * @param values 
     */

    public void addAllReproductionZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addReproductionZone(item);
        }
}

    /**
     * getReproductionZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getReproductionZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(reproductionZone, topiaId);
 }

    /**
     * setReproductionZone :
     * @param values 
     */

    public void setReproductionZone(List<Zone> values) {
        List<Zone> _oldValue = reproductionZone;
        fireOnPreWrite(REPRODUCTION_ZONE, _oldValue, values);
        reproductionZone = values;
        fireOnPostWrite(REPRODUCTION_ZONE, _oldValue, values);
}

    /**
     * removeReproductionZone :
     * @param value 
     */

    public void removeReproductionZone(Zone value) {
        fireOnPreWrite(REPRODUCTION_ZONE, value, null);
        if ((this.reproductionZone == null) || (!this.reproductionZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(REPRODUCTION_ZONE, this.reproductionZone.size()+1, value, null);
}

    /**
     * clearReproductionZone :
     */

    public void clearReproductionZone() {
        if (this.reproductionZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.reproductionZone);
        fireOnPreWrite(REPRODUCTION_ZONE, _oldValue, this.reproductionZone);
        this.reproductionZone.clear();
        fireOnPostWrite(REPRODUCTION_ZONE, _oldValue, this.reproductionZone);
}

    /**
     * getReproductionZone :
     * @return List<Zone> 
     */

    public List<Zone> getReproductionZone() {
        return reproductionZone;
}

    /**
     * sizeReproductionZone :
     * @return int 
     */

    public int sizeReproductionZone() {
        if (reproductionZone == null) {
            return 0;
        }
        return reproductionZone.size();
}

    /**
     * isReproductionZoneEmpty :
     * @return boolean 
     */

    public boolean isReproductionZoneEmpty() {
        int size = sizeReproductionZone();
        return size == 0;
}

    /**
     * addPopulationZone :
     * @param populationZone 
     */

    public void addPopulationZone(Zone populationZone) {    
        fireOnPreWrite(POPULATION_ZONE, null, populationZone);
        if (this.populationZone == null) {
            this.populationZone = new ArrayList<Zone>();
        }
        this.populationZone.add(populationZone);
        fireOnPostWrite(POPULATION_ZONE, this.populationZone.size(), null, populationZone);
}

    /**
     * addAllPopulationZone :
     * @param values 
     */

    public void addAllPopulationZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addPopulationZone(item);
        }
}

    /**
     * getPopulationZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getPopulationZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(populationZone, topiaId);
 }

    /**
     * setPopulationZone :
     * @param values 
     */

    public void setPopulationZone(List<Zone> values) {
        List<Zone> _oldValue = populationZone;
        fireOnPreWrite(POPULATION_ZONE, _oldValue, values);
        populationZone = values;
        fireOnPostWrite(POPULATION_ZONE, _oldValue, values);
}

    /**
     * removePopulationZone :
     * @param value 
     */

    public void removePopulationZone(Zone value) {
        fireOnPreWrite(POPULATION_ZONE, value, null);
        if ((this.populationZone == null) || (!this.populationZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(POPULATION_ZONE, this.populationZone.size()+1, value, null);
}

    /**
     * clearPopulationZone :
     */

    public void clearPopulationZone() {
        if (this.populationZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.populationZone);
        fireOnPreWrite(POPULATION_ZONE, _oldValue, this.populationZone);
        this.populationZone.clear();
        fireOnPostWrite(POPULATION_ZONE, _oldValue, this.populationZone);
}

    /**
     * getPopulationZone :
     * @return List<Zone> 
     */

    public List<Zone> getPopulationZone() {
        return populationZone;
}

    /**
     * sizePopulationZone :
     * @return int 
     */

    public int sizePopulationZone() {
        if (populationZone == null) {
            return 0;
        }
        return populationZone.size();
}

    /**
     * isPopulationZoneEmpty :
     * @return boolean 
     */

    public boolean isPopulationZoneEmpty() {
        int size = sizePopulationZone();
        return size == 0;
}

    /**
     * addRecruitmentZone :
     * @param recruitmentZone 
     */

    public void addRecruitmentZone(Zone recruitmentZone) {    
        fireOnPreWrite(RECRUITMENT_ZONE, null, recruitmentZone);
        if (this.recruitmentZone == null) {
            this.recruitmentZone = new ArrayList<Zone>();
        }
        this.recruitmentZone.add(recruitmentZone);
        fireOnPostWrite(RECRUITMENT_ZONE, this.recruitmentZone.size(), null, recruitmentZone);
}

    /**
     * addAllRecruitmentZone :
     * @param values 
     */

    public void addAllRecruitmentZone(List<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addRecruitmentZone(item);
        }
}

    /**
     * getRecruitmentZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getRecruitmentZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(recruitmentZone, topiaId);
 }

    /**
     * setRecruitmentZone :
     * @param values 
     */

    public void setRecruitmentZone(List<Zone> values) {
        List<Zone> _oldValue = recruitmentZone;
        fireOnPreWrite(RECRUITMENT_ZONE, _oldValue, values);
        recruitmentZone = values;
        fireOnPostWrite(RECRUITMENT_ZONE, _oldValue, values);
}

    /**
     * removeRecruitmentZone :
     * @param value 
     */

    public void removeRecruitmentZone(Zone value) {
        fireOnPreWrite(RECRUITMENT_ZONE, value, null);
        if ((this.recruitmentZone == null) || (!this.recruitmentZone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(RECRUITMENT_ZONE, this.recruitmentZone.size()+1, value, null);
}

    /**
     * clearRecruitmentZone :
     */

    public void clearRecruitmentZone() {
        if (this.recruitmentZone == null) {
            return;
        }
        List<Zone> _oldValue = new ArrayList<Zone>(this.recruitmentZone);
        fireOnPreWrite(RECRUITMENT_ZONE, _oldValue, this.recruitmentZone);
        this.recruitmentZone.clear();
        fireOnPostWrite(RECRUITMENT_ZONE, _oldValue, this.recruitmentZone);
}

    /**
     * getRecruitmentZone :
     * @return List<Zone> 
     */

    public List<Zone> getRecruitmentZone() {
        return recruitmentZone;
}

    /**
     * sizeRecruitmentZone :
     * @return int 
     */

    public int sizeRecruitmentZone() {
        if (recruitmentZone == null) {
            return 0;
        }
        return recruitmentZone.size();
}

    /**
     * isRecruitmentZoneEmpty :
     * @return boolean 
     */

    public boolean isRecruitmentZoneEmpty() {
        int size = sizeRecruitmentZone();
        return size == 0;
}

    /**
     * setMaturityGroup :
     * @param value 
     */

    public void setMaturityGroup(PopulationGroup value) {
        PopulationGroup _oldValue = this.maturityGroup;
        fireOnPreWrite(MATURITY_GROUP, _oldValue, value);
        this.maturityGroup = value;
        fireOnPostWrite(MATURITY_GROUP, _oldValue, value);
}

    /**
     * getMaturityGroup :
     * @return PopulationGroup 
     */

    public PopulationGroup getMaturityGroup() {
        fireOnPreRead(MATURITY_GROUP, maturityGroup);
        PopulationGroup result = this.maturityGroup;
        fireOnPostRead(MATURITY_GROUP, maturityGroup);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(GEOGRAPHIC_ID, this.geographicId).
            append(PLUS_GROUP, this.plusGroup).
            append(GROWTH, this.growth).
            append(GROWTH_REVERSE, this.growthReverse).
            append(COMMENT, this.comment).
            append(MEAN_WEIGHT, this.meanWeight).
            append(PRICE, this.price).
            append(NATURAL_DEATH_RATE, this.naturalDeathRate).
            append(CARACT_BIO_COMMENT, this.caractBioComment).
            append(REPRODUCTION_EQUATION, this.reproductionEquation).
            append(MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT, this.monthGapBetweenReproRecrutement).
            append(RECRUITMENT_DISTRIBUTION, this.recruitmentDistribution).
            append(RECRUITMENT_COMMENT, this.recruitmentComment).
            append(ZONES_COMMENT, this.zonesComment).
            append(SEASONS_COMMENT, this.seasonsComment).
            append(CAPTURABILITY_COMMENT, this.capturabilityComment).
            append(MIGRATION_COMMENT, this.migrationComment).
            append(MAPPING_ZONE_REPRO_ZONE_RECRU, this.mappingZoneReproZoneRecru).
            append(CAPTURABILITY, this.capturability).
            append(POPULATION_GROUP, this.populationGroup).
            append(REPRODUCTION_ZONE, this.reproductionZone).
            append(POPULATION_ZONE, this.populationZone).
            append(RECRUITMENT_ZONE, this.recruitmentZone).
            append(MATURITY_GROUP, this.maturityGroup).
         toString();
        return result;
}


} //PopulationAbstract
