/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.math.matrix.MatrixND;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Population.NAME, Population.GEOGRAPHIC_ID, Population.COMMENT, Population.CARACT_BIO_COMMENT, Population.RECRUITMENT_COMMENT, Population.ZONES_COMMENT, Population.SEASONS_COMMENT, Population.CAPTURABILITY_COMMENT, Population.MIGRATION_COMMENT},
  numFields={Population.MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT},
  boolFields={Population.PLUS_GROUP}
)

public interface Population extends TopiaEntity {     String NAME = "name";
     String GEOGRAPHIC_ID = "geographicId";
     String PLUS_GROUP = "plusGroup";
     String GROWTH = "growth";
     String GROWTH_REVERSE = "growthReverse";
     String COMMENT = "comment";
     String MEAN_WEIGHT = "meanWeight";
     String PRICE = "price";
     String NATURAL_DEATH_RATE = "naturalDeathRate";
     String CARACT_BIO_COMMENT = "caractBioComment";
     String REPRODUCTION_EQUATION = "reproductionEquation";
     String MONTH_GAP_BETWEEN_REPRO_RECRUTEMENT = "monthGapBetweenReproRecrutement";
     String RECRUITMENT_DISTRIBUTION = "recruitmentDistribution";
     String RECRUITMENT_COMMENT = "recruitmentComment";
     String ZONES_COMMENT = "zonesComment";
     String SEASONS_COMMENT = "seasonsComment";
     String CAPTURABILITY_COMMENT = "capturabilityComment";
     String MIGRATION_COMMENT = "migrationComment";
     String MAPPING_ZONE_REPRO_ZONE_RECRU = "mappingZoneReproZoneRecru";
     String CAPTURABILITY = "capturability";
     String GEAR_SELECTIVITY = "gearSelectivity";
     String POPULATION_GROUP = "populationGroup";
     String POPULATION_SEASON_INFO = "populationSeasonInfo";
     String SPECIES = "species";
     String REPRODUCTION_ZONE = "reproductionZone";
     String POPULATION_ZONE = "populationZone";
     String RECRUITMENT_ZONE = "recruitmentZone";
     String MATURITY_GROUP = "maturityGroup";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setGeographicId :
     * @param geographicId La valeur de l'attribut geographicId à positionner.
     */

     void setGeographicId(String geographicId);

    /**
     * getGeographicId :
     * @return String 
     */

     String getGeographicId();

    /**
     * setPlusGroup :
     * @param plusGroup La valeur de l'attribut plusGroup à positionner.
     */

     void setPlusGroup(boolean plusGroup);

    /**
     * getPlusGroup :
     * @return boolean 
     */

     boolean getPlusGroup();

    /**
     * setGrowth :
     * @param growth La valeur de l'attribut growth à positionner.
     */

     void setGrowth(Equation growth);

    /**
     * getGrowth :
     * @return Equation 
     */

     Equation getGrowth();

    /**
     * setGrowthReverse :
     * @param growthReverse La valeur de l'attribut growthReverse à positionner.
     */

     void setGrowthReverse(Equation growthReverse);

    /**
     * getGrowthReverse :
     * @return Equation 
     */

     Equation getGrowthReverse();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setMeanWeight :
     * @param meanWeight La valeur de l'attribut meanWeight à positionner.
     */

     void setMeanWeight(Equation meanWeight);

    /**
     * getMeanWeight :
     * @return Equation 
     */

     Equation getMeanWeight();

    /**
     * setPrice :
     * <p>Le prix en Kg</p>

     * @param price La valeur de l'attribut price à positionner.
     */

     void setPrice(Equation price);

    /**
     * getPrice :
     * <p>Le prix en Kg</p>

     * @return Equation 
     */

     Equation getPrice();

    /**
     * setNaturalDeathRate :
     * @param naturalDeathRate La valeur de l'attribut naturalDeathRate à positionner.
     */

     void setNaturalDeathRate(Equation naturalDeathRate);

    /**
     * getNaturalDeathRate :
     * @return Equation 
     */

     Equation getNaturalDeathRate();

    /**
     * setCaractBioComment :
     * @param caractBioComment La valeur de l'attribut caractBioComment à positionner.
     */

     void setCaractBioComment(String caractBioComment);

    /**
     * getCaractBioComment :
     * @return String 
     */

     String getCaractBioComment();

    /**
     * setReproductionEquation :
     * @param reproductionEquation La valeur de l'attribut reproductionEquation à positionner.
     */

     void setReproductionEquation(Equation reproductionEquation);

    /**
     * getReproductionEquation :
     * @return Equation 
     */

     Equation getReproductionEquation();

    /**
     * setMonthGapBetweenReproRecrutement :
     * @param monthGapBetweenReproRecrutement La valeur de l'attribut monthGapBetweenReproRecrutement à positionner.
     */

     void setMonthGapBetweenReproRecrutement(int monthGapBetweenReproRecrutement);

    /**
     * getMonthGapBetweenReproRecrutement :
     * @return int 
     */

     int getMonthGapBetweenReproRecrutement();

    /**
     * setRecruitmentDistribution :
     * @param recruitmentDistribution La valeur de l'attribut recruitmentDistribution à positionner.
     */

     void setRecruitmentDistribution(MatrixND recruitmentDistribution);

    /**
     * getRecruitmentDistribution :
     * @return MatrixND 
     */

     MatrixND getRecruitmentDistribution();

    /**
     * setRecruitmentComment :
     * @param recruitmentComment La valeur de l'attribut recruitmentComment à positionner.
     */

     void setRecruitmentComment(String recruitmentComment);

    /**
     * getRecruitmentComment :
     * @return String 
     */

     String getRecruitmentComment();

    /**
     * setZonesComment :
     * @param zonesComment La valeur de l'attribut zonesComment à positionner.
     */

     void setZonesComment(String zonesComment);

    /**
     * getZonesComment :
     * @return String 
     */

     String getZonesComment();

    /**
     * setSeasonsComment :
     * @param seasonsComment La valeur de l'attribut seasonsComment à positionner.
     */

     void setSeasonsComment(String seasonsComment);

    /**
     * getSeasonsComment :
     * @return String 
     */

     String getSeasonsComment();

    /**
     * setCapturabilityComment :
     * @param capturabilityComment La valeur de l'attribut capturabilityComment à positionner.
     */

     void setCapturabilityComment(String capturabilityComment);

    /**
     * getCapturabilityComment :
     * @return String 
     */

     String getCapturabilityComment();

    /**
     * setMigrationComment :
     * @param migrationComment La valeur de l'attribut migrationComment à positionner.
     */

     void setMigrationComment(String migrationComment);

    /**
     * getMigrationComment :
     * @return String 
     */

     String getMigrationComment();

    /**
     * setMappingZoneReproZoneRecru :
     * @param mappingZoneReproZoneRecru La valeur de l'attribut mappingZoneReproZoneRecru à positionner.
     */

     void setMappingZoneReproZoneRecru(MatrixND mappingZoneReproZoneRecru);

    /**
     * getMappingZoneReproZoneRecru :
     * @return MatrixND 
     */

     MatrixND getMappingZoneReproZoneRecru();

    /**
     * setCapturability :
     * @param capturability La valeur de l'attribut capturability à positionner.
     */

     void setCapturability(MatrixND capturability);

    /**
     * getCapturability :
     * @return MatrixND 
     */

     MatrixND getCapturability();

    /**
     * addPopulationGroup :
     * @param populationGroup L'instance de populationGroup à ajouter
     */

     void addPopulationGroup(PopulationGroup populationGroup);

    /**
     * addAllPopulationGroup :
     * @param populationGroup Les instances de populationGroup à ajouter
     */

     void addAllPopulationGroup(List<PopulationGroup> populationGroup);

    /**
     * setPopulationGroup :
     * @param populationGroup La Collection de populationGroup à ajouter
     */

     void setPopulationGroup(List<PopulationGroup> populationGroup);

    /**
     * removePopulationGroup :
     * @param populationGroup Vide la Collection de populationGroup
     */

     void removePopulationGroup(PopulationGroup populationGroup);

    /**
     * clearPopulationGroup :
     */

     void clearPopulationGroup();

    /**
     * getPopulationGroup :
     * @return List<PopulationGroup> 
     */

     List<PopulationGroup> getPopulationGroup();

    /**
     * getPopulationGroupByTopiaId :
     * Recupère l'attribut populationGroup à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return PopulationGroup 
     */

     PopulationGroup getPopulationGroupByTopiaId(String topiaId);

    /**
     * sizePopulationGroup :
     * Retourne le nombre d'éléments de la collection populationGroup
     * @return int 
     */

     int sizePopulationGroup();

    /**
     * isPopulationGroupEmpty :
     * Retourne {@code true} si la collection populationGroup est vide.
     * @return boolean 
     */

     boolean isPopulationGroupEmpty();

    /**
     * addPopulationSeasonInfo :
     * @param populationSeasonInfo L'instance de populationSeasonInfo à ajouter
     */

     void addPopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo);

    /**
     * addAllPopulationSeasonInfo :
     * @param populationSeasonInfo Les instances de populationSeasonInfo à ajouter
     */

     void addAllPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo);

    /**
     * setPopulationSeasonInfo :
     * @param populationSeasonInfo La Collection de populationSeasonInfo à ajouter
     */

     void setPopulationSeasonInfo(List<PopulationSeasonInfo> populationSeasonInfo);

    /**
     * removePopulationSeasonInfo :
     * @param populationSeasonInfo Vide la Collection de populationSeasonInfo
     */

     void removePopulationSeasonInfo(PopulationSeasonInfo populationSeasonInfo);

    /**
     * clearPopulationSeasonInfo :
     */

     void clearPopulationSeasonInfo();

    /**
     * getPopulationSeasonInfo :
     * @return List<PopulationSeasonInfo> 
     */

     List<PopulationSeasonInfo> getPopulationSeasonInfo();

    /**
     * getPopulationSeasonInfoByTopiaId :
     * Recupère l'attribut populationSeasonInfo à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return PopulationSeasonInfo 
     */

     PopulationSeasonInfo getPopulationSeasonInfoByTopiaId(String topiaId);

    /**
     * sizePopulationSeasonInfo :
     * Retourne le nombre d'éléments de la collection populationSeasonInfo
     * @return int 
     */

     int sizePopulationSeasonInfo();

    /**
     * isPopulationSeasonInfoEmpty :
     * Retourne {@code true} si la collection populationSeasonInfo est vide.
     * @return boolean 
     */

     boolean isPopulationSeasonInfoEmpty();

    /**
     * setSpecies :
     * @param species La valeur de l'attribut species à positionner.
     */

     void setSpecies(Species species);

    /**
     * getSpecies :
     * @return Species 
     */

     Species getSpecies();

    /**
     * addReproductionZone :
     * @param reproductionZone L'instance de reproductionZone à ajouter
     */

     void addReproductionZone(Zone reproductionZone);

    /**
     * addAllReproductionZone :
     * @param reproductionZone Les instances de reproductionZone à ajouter
     */

     void addAllReproductionZone(List<Zone> reproductionZone);

    /**
     * setReproductionZone :
     * @param reproductionZone La Collection de reproductionZone à ajouter
     */

     void setReproductionZone(List<Zone> reproductionZone);

    /**
     * removeReproductionZone :
     * @param reproductionZone Vide la Collection de reproductionZone
     */

     void removeReproductionZone(Zone reproductionZone);

    /**
     * clearReproductionZone :
     */

     void clearReproductionZone();

    /**
     * getReproductionZone :
     * @return List<Zone> 
     */

     List<Zone> getReproductionZone();

    /**
     * getReproductionZoneByTopiaId :
     * Recupère l'attribut reproductionZone à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Zone 
     */

     Zone getReproductionZoneByTopiaId(String topiaId);

    /**
     * sizeReproductionZone :
     * Retourne le nombre d'éléments de la collection reproductionZone
     * @return int 
     */

     int sizeReproductionZone();

    /**
     * isReproductionZoneEmpty :
     * Retourne {@code true} si la collection reproductionZone est vide.
     * @return boolean 
     */

     boolean isReproductionZoneEmpty();

    /**
     * addPopulationZone :
     * @param populationZone L'instance de populationZone à ajouter
     */

     void addPopulationZone(Zone populationZone);

    /**
     * addAllPopulationZone :
     * @param populationZone Les instances de populationZone à ajouter
     */

     void addAllPopulationZone(List<Zone> populationZone);

    /**
     * setPopulationZone :
     * @param populationZone La Collection de populationZone à ajouter
     */

     void setPopulationZone(List<Zone> populationZone);

    /**
     * removePopulationZone :
     * @param populationZone Vide la Collection de populationZone
     */

     void removePopulationZone(Zone populationZone);

    /**
     * clearPopulationZone :
     */

     void clearPopulationZone();

    /**
     * getPopulationZone :
     * @return List<Zone> 
     */

     List<Zone> getPopulationZone();

    /**
     * getPopulationZoneByTopiaId :
     * Recupère l'attribut populationZone à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Zone 
     */

     Zone getPopulationZoneByTopiaId(String topiaId);

    /**
     * sizePopulationZone :
     * Retourne le nombre d'éléments de la collection populationZone
     * @return int 
     */

     int sizePopulationZone();

    /**
     * isPopulationZoneEmpty :
     * Retourne {@code true} si la collection populationZone est vide.
     * @return boolean 
     */

     boolean isPopulationZoneEmpty();

    /**
     * addRecruitmentZone :
     * @param recruitmentZone L'instance de recruitmentZone à ajouter
     */

     void addRecruitmentZone(Zone recruitmentZone);

    /**
     * addAllRecruitmentZone :
     * @param recruitmentZone Les instances de recruitmentZone à ajouter
     */

     void addAllRecruitmentZone(List<Zone> recruitmentZone);

    /**
     * setRecruitmentZone :
     * @param recruitmentZone La Collection de recruitmentZone à ajouter
     */

     void setRecruitmentZone(List<Zone> recruitmentZone);

    /**
     * removeRecruitmentZone :
     * @param recruitmentZone Vide la Collection de recruitmentZone
     */

     void removeRecruitmentZone(Zone recruitmentZone);

    /**
     * clearRecruitmentZone :
     */

     void clearRecruitmentZone();

    /**
     * getRecruitmentZone :
     * @return List<Zone> 
     */

     List<Zone> getRecruitmentZone();

    /**
     * getRecruitmentZoneByTopiaId :
     * Recupère l'attribut recruitmentZone à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Zone 
     */

     Zone getRecruitmentZoneByTopiaId(String topiaId);

    /**
     * sizeRecruitmentZone :
     * Retourne le nombre d'éléments de la collection recruitmentZone
     * @return int 
     */

     int sizeRecruitmentZone();

    /**
     * isRecruitmentZoneEmpty :
     * Retourne {@code true} si la collection recruitmentZone est vide.
     * @return boolean 
     */

     boolean isRecruitmentZoneEmpty();

    /**
     * setMaturityGroup :
     * @param maturityGroup La valeur de l'attribut maturityGroup à positionner.
     */

     void setMaturityGroup(PopulationGroup maturityGroup);

    /**
     * getMaturityGroup :
     * @return PopulationGroup 
     */

     PopulationGroup getMaturityGroup();

    /**
     * getPopulationSeasonInfo :
     * @param month 
     * @return PopulationSeasonInfo 
     */

     PopulationSeasonInfo getPopulationSeasonInfo(Month month);

    /**
     * N2DToN1D :
     * @param m 
     * @return MatrixND 
     */

     MatrixND N2DToN1D(MatrixND m);

    /**
     * split2D :
     * @param m 
     * @return MatrixND 
     */

     MatrixND split2D(MatrixND m);

    /**
     * getNaturalDeathBirth :
     * @param zone 
     * @return double 
     */

     double getNaturalDeathBirth(Zone zone);

    /**
     * getAge :
     * @param length 
     * @param group 
     * @return double 
     */

     double getAge(double length, PopulationGroup group);

    /**
     * getLength :
     * @param age 
     * @param group 
     * @return double 
     */

     double getLength(double age, PopulationGroup group);

    /**
     * getNaturalDeathRateMatrix :
     * @return MatrixND 
     */

     MatrixND getNaturalDeathRateMatrix();


} //Population
