/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class MetierSeasonInfoAbstract extends SeasonImpl implements MetierSeasonInfo {

    protected String seasonZoneComment;
    protected String comment;
    protected Collection<TargetSpecies> speciesTargetSpecies;
    protected Metier metier;
    protected Collection<Zone> zone;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(MetierSeasonInfo.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(MetierSeasonInfo.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, SEASON_ZONE_COMMENT, String.class, seasonZoneComment);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, SPECIES_TARGET_SPECIES, java.util.Collection.class, TargetSpecies.class, speciesTargetSpecies);
        visitor.visit(this, METIER, Metier.class, metier);
        visitor.visit(this, ZONE, Collection.class, Zone.class, zone);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<TargetSpecies> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(TargetSpecies.class);
            List<TargetSpecies> findAllByProperties = dao.findAllByProperties("metierSeasonInfo", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setSeasonZoneComment :
     * @param value 
     */

    public void setSeasonZoneComment(String value) {
        String _oldValue = this.seasonZoneComment;
        fireOnPreWrite(SEASON_ZONE_COMMENT, _oldValue, value);
        this.seasonZoneComment = value;
        fireOnPostWrite(SEASON_ZONE_COMMENT, _oldValue, value);
}

    /**
     * getSeasonZoneComment :
     * @return String 
     */

    public String getSeasonZoneComment() {
        fireOnPreRead(SEASON_ZONE_COMMENT, seasonZoneComment);
        String result = this.seasonZoneComment;
        fireOnPostRead(SEASON_ZONE_COMMENT, seasonZoneComment);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * addSpeciesTargetSpecies :
     * @param value 
     */

    public void addSpeciesTargetSpecies(TargetSpecies value) {
        fireOnPreWrite(SPECIES_TARGET_SPECIES, null, value);
        if (this.speciesTargetSpecies == null) {
            this.speciesTargetSpecies = new ArrayList<fr.ifremer.isisfish.entities.TargetSpecies>();
        }
        this.speciesTargetSpecies.add(value);
        fireOnPostWrite(SPECIES_TARGET_SPECIES, this.speciesTargetSpecies.size(), null, value);
}

    /**
     * getSpeciesTargetSpeciesByTopiaId :
     * @param topiaId 
     * @return TargetSpecies 
     */

    public TargetSpecies getSpeciesTargetSpeciesByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(speciesTargetSpecies, topiaId);
}

    /**
     * addAllSpeciesTargetSpecies :
     * @param values 
     */

    public void addAllSpeciesTargetSpecies(Collection<TargetSpecies> values) {
        if (values == null) {
            return;
        }
        for (fr.ifremer.isisfish.entities.TargetSpecies item : values) {
            addSpeciesTargetSpecies(item);
        }
}

    /**
     * setSpeciesTargetSpecies :
     * @param values 
     */

    public void setSpeciesTargetSpecies(Collection<TargetSpecies> values) {
//        clearSpeciesTargetSpecies();
//        addAllSpeciesTargetSpecies(values);
// FIXME
        Collection<fr.ifremer.isisfish.entities.TargetSpecies> _oldValue = speciesTargetSpecies;
        fireOnPreWrite(SPECIES_TARGET_SPECIES, _oldValue, values);
        speciesTargetSpecies = values;
        fireOnPostWrite(SPECIES_TARGET_SPECIES, _oldValue, values);
}

    /**
     * removeSpeciesTargetSpecies :
     * @param value 
     */

    public void removeSpeciesTargetSpecies(TargetSpecies value) {
        fireOnPreWrite(SPECIES_TARGET_SPECIES, value, null);
        if ((this.speciesTargetSpecies == null) || (!this.speciesTargetSpecies.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(SPECIES_TARGET_SPECIES, this.speciesTargetSpecies.size()+1, value, null);
}

    /**
     * clearSpeciesTargetSpecies :
     */

    public void clearSpeciesTargetSpecies() {
        if (this.speciesTargetSpecies == null) {
            return;
        }
        Collection<fr.ifremer.isisfish.entities.TargetSpecies> _oldValue = new ArrayList<fr.ifremer.isisfish.entities.TargetSpecies>(this.speciesTargetSpecies);
        fireOnPreWrite(SPECIES_TARGET_SPECIES, _oldValue, null);
        this.speciesTargetSpecies.clear();
        fireOnPostWrite(SPECIES_TARGET_SPECIES, _oldValue, null);
}

    /**
     * getSpeciesTargetSpecies :
     * @return Collection<TargetSpecies> 
     */

    public Collection<TargetSpecies> getSpeciesTargetSpecies() {
        return speciesTargetSpecies;
}

    /**
     * getSpeciesTargetSpecies :
     * @param value 
     * @return TargetSpecies 
     */

    public TargetSpecies getSpeciesTargetSpecies(Species value) {
        if (value == null || speciesTargetSpecies == null) {
            return null;
        }
        for (fr.ifremer.isisfish.entities.TargetSpecies item : speciesTargetSpecies) {
            if (value.equals(item.getSpecies())) {
                return item;
            }
        }
        return null;
}

    /**
     * sizeSpeciesTargetSpecies :
     * @return int 
     */

    public int sizeSpeciesTargetSpecies() {
        if (speciesTargetSpecies == null) {
            return 0;
        }
        return speciesTargetSpecies.size();
}

    /**
     * isSpeciesTargetSpeciesEmpty :
     * @return boolean 
     */

    public boolean isSpeciesTargetSpeciesEmpty() {
        int size = sizeSpeciesTargetSpecies();
        return size == 0;
}

    /**
     * setMetier :
     * @param value 
     */

    public void setMetier(Metier value) {
        Metier _oldValue = this.metier;
        fireOnPreWrite(METIER, _oldValue, value);
        this.metier = value;
        fireOnPostWrite(METIER, _oldValue, value);
}

    /**
     * getMetier :
     * @return Metier 
     */

    public Metier getMetier() {
        fireOnPreRead(METIER, metier);
        Metier result = this.metier;
        fireOnPostRead(METIER, metier);
        return result;
}

    /**
     * addZone :
     * @param zone 
     */

    public void addZone(Zone zone) {    
        fireOnPreWrite(ZONE, null, zone);
        if (this.zone == null) {
            this.zone = new ArrayList<Zone>();
        }
        this.zone.add(zone);
        fireOnPostWrite(ZONE, this.zone.size(), null, zone);
}

    /**
     * addAllZone :
     * @param values 
     */

    public void addAllZone(Collection<Zone> values) {
        if (values == null) {
            return;
        }
        for (Zone item : values) {
            addZone(item);
        }
}

    /**
     * getZoneByTopiaId :
     * @param topiaId 
     * @return Zone 
     */

    public Zone getZoneByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(zone, topiaId);
 }

    /**
     * setZone :
     * @param values 
     */

    public void setZone(Collection<Zone> values) {
        Collection<Zone> _oldValue = zone;
        fireOnPreWrite(ZONE, _oldValue, values);
        zone = values;
        fireOnPostWrite(ZONE, _oldValue, values);
}

    /**
     * removeZone :
     * @param value 
     */

    public void removeZone(Zone value) {
        fireOnPreWrite(ZONE, value, null);
        if ((this.zone == null) || (!this.zone.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        fireOnPostWrite(ZONE, this.zone.size()+1, value, null);
}

    /**
     * clearZone :
     */

    public void clearZone() {
        if (this.zone == null) {
            return;
        }
        Collection<Zone> _oldValue = new ArrayList<Zone>(this.zone);
        fireOnPreWrite(ZONE, _oldValue, this.zone);
        this.zone.clear();
        fireOnPostWrite(ZONE, _oldValue, this.zone);
}

    /**
     * getZone :
     * @return Collection<Zone> 
     */

    public Collection<Zone> getZone() {
        return zone;
}

    /**
     * sizeZone :
     * @return int 
     */

    public int sizeZone() {
        if (zone == null) {
            return 0;
        }
        return zone.size();
}

    /**
     * isZoneEmpty :
     * @return boolean 
     */

    public boolean isZoneEmpty() {
        int size = sizeZone();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(SEASON_ZONE_COMMENT, this.seasonZoneComment).
            append(COMMENT, this.comment).
            append(ZONE, this.zone).
         toString();
        return result;
}


} //MetierSeasonInfoAbstract
