/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class MetierAbstract extends TopiaEntityAbstract implements Metier {

    protected String name;
    protected String gearParameterValue;
    protected String comment;
    protected String capturableSpeciesComment;
    protected Gear gear;
    protected Collection<EffortDescription> setOfVesselsEffortDescription;
    protected List<MetierSeasonInfo> metierSeasonInfo;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(Metier.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, GEAR_PARAMETER_VALUE, String.class, gearParameterValue);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.visit(this, CAPTURABLE_SPECIES_COMMENT, String.class, capturableSpeciesComment);
        visitor.visit(this, GEAR, Gear.class, gear);
        visitor.visit(this, SET_OF_VESSELS_EFFORT_DESCRIPTION, java.util.Collection.class, EffortDescription.class, setOfVesselsEffortDescription);
        visitor.visit(this, METIER_SEASON_INFO, List.class, MetierSeasonInfo.class, metierSeasonInfo);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        {
            org.nuiton.topia.persistence.TopiaDAO<EffortDescription> dao = ((TopiaContextImplementor) getTopiaContext()).getDAO(EffortDescription.class);
            List<EffortDescription> findAllByProperties = dao.findAllByProperties("possibleMetiers", this);
            if (findAllByProperties != null) {
                tmp.addAll(findAllByProperties);
            }
        }
        if (getMetierSeasonInfo() != null) {
              tmp.addAll(getMetierSeasonInfo());
           }

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setGearParameterValue :
     * @param value 
     */

    public void setGearParameterValue(String value) {
        String _oldValue = this.gearParameterValue;
        fireOnPreWrite(GEAR_PARAMETER_VALUE, _oldValue, value);
        this.gearParameterValue = value;
        fireOnPostWrite(GEAR_PARAMETER_VALUE, _oldValue, value);
}

    /**
     * getGearParameterValue :
     * @return String 
     */

    public String getGearParameterValue() {
        fireOnPreRead(GEAR_PARAMETER_VALUE, gearParameterValue);
        String result = this.gearParameterValue;
        fireOnPostRead(GEAR_PARAMETER_VALUE, gearParameterValue);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * setCapturableSpeciesComment :
     * @param value 
     */

    public void setCapturableSpeciesComment(String value) {
        String _oldValue = this.capturableSpeciesComment;
        fireOnPreWrite(CAPTURABLE_SPECIES_COMMENT, _oldValue, value);
        this.capturableSpeciesComment = value;
        fireOnPostWrite(CAPTURABLE_SPECIES_COMMENT, _oldValue, value);
}

    /**
     * getCapturableSpeciesComment :
     * @return String 
     */

    public String getCapturableSpeciesComment() {
        fireOnPreRead(CAPTURABLE_SPECIES_COMMENT, capturableSpeciesComment);
        String result = this.capturableSpeciesComment;
        fireOnPostRead(CAPTURABLE_SPECIES_COMMENT, capturableSpeciesComment);
        return result;
}

    /**
     * setGear :
     * @param value 
     */

    public void setGear(Gear value) {
        Gear _oldValue = this.gear;
        fireOnPreWrite(GEAR, _oldValue, value);
        this.gear = value;
        fireOnPostWrite(GEAR, _oldValue, value);
}

    /**
     * getGear :
     * @return Gear 
     */

    public Gear getGear() {
        fireOnPreRead(GEAR, gear);
        Gear result = this.gear;
        fireOnPostRead(GEAR, gear);
        return result;
}

    /**
     * addMetierSeasonInfo :
     * @param metierSeasonInfo 
     */

    public void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo) {    
        fireOnPreWrite(METIER_SEASON_INFO, null, metierSeasonInfo);
        if (this.metierSeasonInfo == null) {
            this.metierSeasonInfo = new ArrayList<MetierSeasonInfo>();
        }
        metierSeasonInfo.setMetier(this);
        this.metierSeasonInfo.add(metierSeasonInfo);
        fireOnPostWrite(METIER_SEASON_INFO, this.metierSeasonInfo.size(), null, metierSeasonInfo);
}

    /**
     * addAllMetierSeasonInfo :
     * @param values 
     */

    public void addAllMetierSeasonInfo(List<MetierSeasonInfo> values) {
        if (values == null) {
            return;
        }
        for (MetierSeasonInfo item : values) {
            addMetierSeasonInfo(item);
        }
}

    /**
     * getMetierSeasonInfoByTopiaId :
     * @param topiaId 
     * @return MetierSeasonInfo 
     */

    public MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId) {
        return org.nuiton.topia.persistence.util.TopiaEntityHelper.getEntityByTopiaId(metierSeasonInfo, topiaId);
 }

    /**
     * setMetierSeasonInfo :
     * @param values 
     */

    public void setMetierSeasonInfo(List<MetierSeasonInfo> values) {
        List<MetierSeasonInfo> _oldValue = metierSeasonInfo;
        fireOnPreWrite(METIER_SEASON_INFO, _oldValue, values);
        metierSeasonInfo = values;
        fireOnPostWrite(METIER_SEASON_INFO, _oldValue, values);
}

    /**
     * removeMetierSeasonInfo :
     * @param value 
     */

    public void removeMetierSeasonInfo(MetierSeasonInfo value) {
        fireOnPreWrite(METIER_SEASON_INFO, value, null);
        if ((this.metierSeasonInfo == null) || (!this.metierSeasonInfo.remove(value))) {
            throw new IllegalArgumentException("List does not contain given element");
        }
        value.setMetier(null);
        fireOnPostWrite(METIER_SEASON_INFO, this.metierSeasonInfo.size()+1, value, null);
}

    /**
     * clearMetierSeasonInfo :
     */

    public void clearMetierSeasonInfo() {
        if (this.metierSeasonInfo == null) {
            return;
        }
        for (MetierSeasonInfo item : this.metierSeasonInfo) {
            item.setMetier(null);
        }
        List<MetierSeasonInfo> _oldValue = new ArrayList<MetierSeasonInfo>(this.metierSeasonInfo);
        fireOnPreWrite(METIER_SEASON_INFO, _oldValue, this.metierSeasonInfo);
        this.metierSeasonInfo.clear();
        fireOnPostWrite(METIER_SEASON_INFO, _oldValue, this.metierSeasonInfo);
}

    /**
     * getMetierSeasonInfo :
     * @return List<MetierSeasonInfo> 
     */

    public List<MetierSeasonInfo> getMetierSeasonInfo() {
        return metierSeasonInfo;
}

    /**
     * sizeMetierSeasonInfo :
     * @return int 
     */

    public int sizeMetierSeasonInfo() {
        if (metierSeasonInfo == null) {
            return 0;
        }
        return metierSeasonInfo.size();
}

    /**
     * isMetierSeasonInfoEmpty :
     * @return boolean 
     */

    public boolean isMetierSeasonInfoEmpty() {
        int size = sizeMetierSeasonInfo();
        return size == 0;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(GEAR_PARAMETER_VALUE, this.gearParameterValue).
            append(COMMENT, this.comment).
            append(CAPTURABLE_SPECIES_COMMENT, this.capturableSpeciesComment).
            append(GEAR, this.gear).
         toString();
        return result;
}


} //MetierAbstract
