/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.Month;
import java.util.List;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Metier.NAME, Metier.GEAR_PARAMETER_VALUE, Metier.COMMENT, Metier.CAPTURABLE_SPECIES_COMMENT}
)

public interface Metier extends TopiaEntity {     String NAME = "name";
     String GEAR_PARAMETER_VALUE = "gearParameterValue";
     String COMMENT = "comment";
     String CAPTURABLE_SPECIES_COMMENT = "capturableSpeciesComment";
     String GEAR = "gear";
     String SET_OF_VESSELS_EFFORT_DESCRIPTION = "setOfVesselsEffortDescription";
     String METIER_SEASON_INFO = "metierSeasonInfo";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setGearParameterValue :
     * @param gearParameterValue La valeur de l'attribut gearParameterValue à positionner.
     */

     void setGearParameterValue(String gearParameterValue);

    /**
     * getGearParameterValue :
     * @return String 
     */

     String getGearParameterValue();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * setCapturableSpeciesComment :
     * @param capturableSpeciesComment La valeur de l'attribut capturableSpeciesComment à positionner.
     */

     void setCapturableSpeciesComment(String capturableSpeciesComment);

    /**
     * getCapturableSpeciesComment :
     * @return String 
     */

     String getCapturableSpeciesComment();

    /**
     * setGear :
     * @param gear La valeur de l'attribut gear à positionner.
     */

     void setGear(Gear gear);

    /**
     * getGear :
     * @return Gear 
     */

     Gear getGear();

    /**
     * addMetierSeasonInfo :
     * @param metierSeasonInfo L'instance de metierSeasonInfo à ajouter
     */

     void addMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    /**
     * addAllMetierSeasonInfo :
     * @param metierSeasonInfo Les instances de metierSeasonInfo à ajouter
     */

     void addAllMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    /**
     * setMetierSeasonInfo :
     * @param metierSeasonInfo La Collection de metierSeasonInfo à ajouter
     */

     void setMetierSeasonInfo(List<MetierSeasonInfo> metierSeasonInfo);

    /**
     * removeMetierSeasonInfo :
     * @param metierSeasonInfo Vide la Collection de metierSeasonInfo
     */

     void removeMetierSeasonInfo(MetierSeasonInfo metierSeasonInfo);

    /**
     * clearMetierSeasonInfo :
     */

     void clearMetierSeasonInfo();

    /**
     * getMetierSeasonInfo :
     * @return List<MetierSeasonInfo> 
     */

     List<MetierSeasonInfo> getMetierSeasonInfo();

    /**
     * getMetierSeasonInfoByTopiaId :
     * Recupère l'attribut metierSeasonInfo à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return MetierSeasonInfo 
     */

     MetierSeasonInfo getMetierSeasonInfoByTopiaId(String topiaId);

    /**
     * sizeMetierSeasonInfo :
     * Retourne le nombre d'éléments de la collection metierSeasonInfo
     * @return int 
     */

     int sizeMetierSeasonInfo();

    /**
     * isMetierSeasonInfoEmpty :
     * Retourne {@code true} si la collection metierSeasonInfo est vide.
     * @return boolean 
     */

     boolean isMetierSeasonInfoEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();

    /**
     * getMetierSeasonInfo :
     * @param month 
     * @return MetierSeasonInfo 
     */

     MetierSeasonInfo getMetierSeasonInfo(Month month);

    /**
     * getGearParameterValueAsDouble :
     * @return double 
     */

     double getGearParameterValueAsDouble();


} //Metier
