/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.RangeOfValues;
import java.util.Collection;
import org.nuiton.topia.persistence.SearchFields;
import org.nuiton.topia.persistence.TopiaEntity;

@SearchFields (
  txtFields={Gear.NAME, Gear.EFFORT_UNIT, Gear.PARAMETER_NAME, Gear.COMMENT},
  numFields={Gear.STANDARDISATION_FACTOR, Gear.COST}
)

public interface Gear extends TopiaEntity {     String NAME = "name";
     String EFFORT_UNIT = "effortUnit";
     String STANDARDISATION_FACTOR = "standardisationFactor";
     String PARAMETER_NAME = "parameterName";
     String COST = "cost";
     String POSSIBLE_VALUE = "possibleValue";
     String COMMENT = "comment";
     String POPULATION_SELECTIVITY = "populationSelectivity";
    /**
     * setName :
     * @param name La valeur de l'attribut name à positionner.
     */

     void setName(String name);

    /**
     * getName :
     * @return String 
     */

     String getName();

    /**
     * setEffortUnit :
     * @param effortUnit La valeur de l'attribut effortUnit à positionner.
     */

     void setEffortUnit(String effortUnit);

    /**
     * getEffortUnit :
     * @return String 
     */

     String getEffortUnit();

    /**
     * setStandardisationFactor :
     * @param standardisationFactor La valeur de l'attribut standardisationFactor à positionner.
     */

     void setStandardisationFactor(double standardisationFactor);

    /**
     * getStandardisationFactor :
     * @return double 
     */

     double getStandardisationFactor();

    /**
     * setParameterName :
     * @param parameterName La valeur de l'attribut parameterName à positionner.
     */

     void setParameterName(String parameterName);

    /**
     * getParameterName :
     * @return String 
     */

     String getParameterName();

    /**
     * setCost :
     * <p>Co&ucirc;t d'achat de l'engin</p>

     * @param cost La valeur de l'attribut cost à positionner.
     */

     void setCost(double cost);

    /**
     * getCost :
     * <p>Co&ucirc;t d'achat de l'engin</p>

     * @return double 
     */

     double getCost();

    /**
     * setPossibleValue :
     * @param possibleValue La valeur de l'attribut possibleValue à positionner.
     */

     void setPossibleValue(RangeOfValues possibleValue);

    /**
     * getPossibleValue :
     * @return RangeOfValues 
     */

     RangeOfValues getPossibleValue();

    /**
     * setComment :
     * @param comment La valeur de l'attribut comment à positionner.
     */

     void setComment(String comment);

    /**
     * getComment :
     * @return String 
     */

     String getComment();

    /**
     * addPopulationSelectivity :
     * @param selectivity L'instance de Selectivity à ajouter
     */

     void addPopulationSelectivity(Selectivity selectivity);

    /**
     * addAllPopulationSelectivity :
     * @param selectivity Les instances de Selectivity à ajouter
     */

     void addAllPopulationSelectivity(Collection<Selectivity> selectivity);

    /**
     * setPopulationSelectivity :
     * @param selectivity La Collection de Selectivity à ajouter
     */

     void setPopulationSelectivity(Collection<Selectivity> selectivity);

    /**
     * removePopulationSelectivity :
     * @param selectivity L'instance de Selectivity à retirer
     */

     void removePopulationSelectivity(Selectivity selectivity);

    /**
     * clearPopulationSelectivity :
     * Vide la Collection de Selectivity .
     */

     void clearPopulationSelectivity();

    /**
     * getPopulationSelectivity :
     * @return Collection<Selectivity> 
     */

     Collection<Selectivity> getPopulationSelectivity();

    /**
     * getPopulationSelectivityByTopiaId :
     * Recupère l'attribut population à partir de son topiaId
     * @param topiaId le topia id de l'entité recherchée
     * @return Selectivity 
     */

     Selectivity getPopulationSelectivityByTopiaId(String topiaId);

    /**
     * getPopulationSelectivity :
     * @param value 
     * @return Selectivity 
     */

     Selectivity getPopulationSelectivity(Population value);

    /**
     * sizePopulationSelectivity :
     * @return int 
     */

     int sizePopulationSelectivity();

    /**
     * isPopulationSelectivityEmpty :
     * @return boolean 
     */

     boolean isPopulationSelectivityEmpty();

    /**
     * getFisheryRegion :
     * @return FisheryRegion 
     */

     FisheryRegion getFisheryRegion();


} //Gear
