/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class FisheryRegionDAOAbstract<E extends FisheryRegion> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)FisheryRegion.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(FisheryRegion.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.NAME, v);
        return result;
    }

    /**
     * findByMinLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLongitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.MIN_LONGITUDE, v);
        return result;
    }

    /**
     * findAllByMinLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut minLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.MIN_LONGITUDE, v);
        return result;
    }

    /**
     * findByMaxLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLongitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.MAX_LONGITUDE, v);
        return result;
    }

    /**
     * findAllByMaxLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.MAX_LONGITUDE, v);
        return result;
    }

    /**
     * findByMinLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut minLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMinLatitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.MIN_LATITUDE, v);
        return result;
    }

    /**
     * findAllByMinLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut minLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMinLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.MIN_LATITUDE, v);
        return result;
    }

    /**
     * findByMaxLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut maxLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMaxLatitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.MAX_LATITUDE, v);
        return result;
    }

    /**
     * findAllByMaxLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut maxLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMaxLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.MAX_LATITUDE, v);
        return result;
    }

    /**
     * findByCellLengthLongitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cellLengthLongitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCellLengthLongitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.CELL_LENGTH_LONGITUDE, v);
        return result;
    }

    /**
     * findAllByCellLengthLongitude :
     * Retourne les éléments ayant comme valeur pour l'attribut cellLengthLongitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCellLengthLongitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.CELL_LENGTH_LONGITUDE, v);
        return result;
    }

    /**
     * findByCellLengthLatitude :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut cellLengthLatitude le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCellLengthLatitude(float v) throws TopiaException {
        E result = findByProperty(FisheryRegion.CELL_LENGTH_LATITUDE, v);
        return result;
    }

    /**
     * findAllByCellLengthLatitude :
     * Retourne les éléments ayant comme valeur pour l'attribut cellLengthLatitude le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCellLengthLatitude(float v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.CELL_LENGTH_LATITUDE, v);
        return result;
    }

    /**
     * findByMapFiles :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut mapFiles le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByMapFiles(String v) throws TopiaException {
        E result = findByProperty(FisheryRegion.MAP_FILES, v);
        return result;
    }

    /**
     * findAllByMapFiles :
     * Retourne les éléments ayant comme valeur pour l'attribut mapFiles le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByMapFiles(String v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.MAP_FILES, v);
        return result;
    }

    /**
     * findByComment :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByComment(String v) throws TopiaException {
        E result = findByProperty(FisheryRegion.COMMENT, v);
        return result;
    }

    /**
     * findAllByComment :
     * Retourne les éléments ayant comme valeur pour l'attribut comment le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByComment(String v) throws TopiaException {
        List<E> result = findAllByProperty(FisheryRegion.COMMENT, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //FisheryRegionDAOAbstract<E extends FisheryRegion>
