/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class FisheryRegionAbstract extends TopiaEntityAbstract implements FisheryRegion {

    protected String name;
    protected float minLongitude;
    protected float maxLongitude;
    protected float minLatitude;
    protected float maxLatitude;
    protected float cellLengthLongitude;
    protected float cellLengthLatitude;
    protected String mapFiles;
    protected String comment;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(FisheryRegion.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, NAME, String.class, name);
        visitor.visit(this, MIN_LONGITUDE, float.class, minLongitude);
        visitor.visit(this, MAX_LONGITUDE, float.class, maxLongitude);
        visitor.visit(this, MIN_LATITUDE, float.class, minLatitude);
        visitor.visit(this, MAX_LATITUDE, float.class, maxLatitude);
        visitor.visit(this, CELL_LENGTH_LONGITUDE, float.class, cellLengthLongitude);
        visitor.visit(this, CELL_LENGTH_LATITUDE, float.class, cellLengthLatitude);
        visitor.visit(this, MAP_FILES, String.class, mapFiles);
        visitor.visit(this, COMMENT, String.class, comment);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setName :
     * @param value 
     */

    public void setName(String value) {
        String _oldValue = this.name;
        fireOnPreWrite(NAME, _oldValue, value);
        this.name = value;
        fireOnPostWrite(NAME, _oldValue, value);
}

    /**
     * getName :
     * @return String 
     */

    public String getName() {
        fireOnPreRead(NAME, name);
        String result = this.name;
        fireOnPostRead(NAME, name);
        return result;
}

    /**
     * setMinLongitude :
     * @param value 
     */

    public void setMinLongitude(float value) {
        float _oldValue = this.minLongitude;
        fireOnPreWrite(MIN_LONGITUDE, _oldValue, value);
        this.minLongitude = value;
        fireOnPostWrite(MIN_LONGITUDE, _oldValue, value);
}

    /**
     * getMinLongitude :
     * @return float 
     */

    public float getMinLongitude() {
        fireOnPreRead(MIN_LONGITUDE, minLongitude);
        float result = this.minLongitude;
        fireOnPostRead(MIN_LONGITUDE, minLongitude);
        return result;
}

    /**
     * setMaxLongitude :
     * @param value 
     */

    public void setMaxLongitude(float value) {
        float _oldValue = this.maxLongitude;
        fireOnPreWrite(MAX_LONGITUDE, _oldValue, value);
        this.maxLongitude = value;
        fireOnPostWrite(MAX_LONGITUDE, _oldValue, value);
}

    /**
     * getMaxLongitude :
     * @return float 
     */

    public float getMaxLongitude() {
        fireOnPreRead(MAX_LONGITUDE, maxLongitude);
        float result = this.maxLongitude;
        fireOnPostRead(MAX_LONGITUDE, maxLongitude);
        return result;
}

    /**
     * setMinLatitude :
     * @param value 
     */

    public void setMinLatitude(float value) {
        float _oldValue = this.minLatitude;
        fireOnPreWrite(MIN_LATITUDE, _oldValue, value);
        this.minLatitude = value;
        fireOnPostWrite(MIN_LATITUDE, _oldValue, value);
}

    /**
     * getMinLatitude :
     * @return float 
     */

    public float getMinLatitude() {
        fireOnPreRead(MIN_LATITUDE, minLatitude);
        float result = this.minLatitude;
        fireOnPostRead(MIN_LATITUDE, minLatitude);
        return result;
}

    /**
     * setMaxLatitude :
     * @param value 
     */

    public void setMaxLatitude(float value) {
        float _oldValue = this.maxLatitude;
        fireOnPreWrite(MAX_LATITUDE, _oldValue, value);
        this.maxLatitude = value;
        fireOnPostWrite(MAX_LATITUDE, _oldValue, value);
}

    /**
     * getMaxLatitude :
     * @return float 
     */

    public float getMaxLatitude() {
        fireOnPreRead(MAX_LATITUDE, maxLatitude);
        float result = this.maxLatitude;
        fireOnPostRead(MAX_LATITUDE, maxLatitude);
        return result;
}

    /**
     * setCellLengthLongitude :
     * @param value 
     */

    public void setCellLengthLongitude(float value) {
        float _oldValue = this.cellLengthLongitude;
        fireOnPreWrite(CELL_LENGTH_LONGITUDE, _oldValue, value);
        this.cellLengthLongitude = value;
        fireOnPostWrite(CELL_LENGTH_LONGITUDE, _oldValue, value);
}

    /**
     * getCellLengthLongitude :
     * @return float 
     */

    public float getCellLengthLongitude() {
        fireOnPreRead(CELL_LENGTH_LONGITUDE, cellLengthLongitude);
        float result = this.cellLengthLongitude;
        fireOnPostRead(CELL_LENGTH_LONGITUDE, cellLengthLongitude);
        return result;
}

    /**
     * setCellLengthLatitude :
     * @param value 
     */

    public void setCellLengthLatitude(float value) {
        float _oldValue = this.cellLengthLatitude;
        fireOnPreWrite(CELL_LENGTH_LATITUDE, _oldValue, value);
        this.cellLengthLatitude = value;
        fireOnPostWrite(CELL_LENGTH_LATITUDE, _oldValue, value);
}

    /**
     * getCellLengthLatitude :
     * @return float 
     */

    public float getCellLengthLatitude() {
        fireOnPreRead(CELL_LENGTH_LATITUDE, cellLengthLatitude);
        float result = this.cellLengthLatitude;
        fireOnPostRead(CELL_LENGTH_LATITUDE, cellLengthLatitude);
        return result;
}

    /**
     * setMapFiles :
     * @param value 
     */

    public void setMapFiles(String value) {
        String _oldValue = this.mapFiles;
        fireOnPreWrite(MAP_FILES, _oldValue, value);
        this.mapFiles = value;
        fireOnPostWrite(MAP_FILES, _oldValue, value);
}

    /**
     * getMapFiles :
     * @return String 
     */

    public String getMapFiles() {
        fireOnPreRead(MAP_FILES, mapFiles);
        String result = this.mapFiles;
        fireOnPostRead(MAP_FILES, mapFiles);
        return result;
}

    /**
     * setComment :
     * @param value 
     */

    public void setComment(String value) {
        String _oldValue = this.comment;
        fireOnPreWrite(COMMENT, _oldValue, value);
        this.comment = value;
        fireOnPostWrite(COMMENT, _oldValue, value);
}

    /**
     * getComment :
     * @return String 
     */

    public String getComment() {
        fireOnPreRead(COMMENT, comment);
        String result = this.comment;
        fireOnPostRead(COMMENT, comment);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(NAME, this.name).
            append(MIN_LONGITUDE, this.minLongitude).
            append(MAX_LONGITUDE, this.maxLongitude).
            append(MIN_LATITUDE, this.minLatitude).
            append(MAX_LATITUDE, this.maxLatitude).
            append(CELL_LENGTH_LONGITUDE, this.cellLengthLongitude).
            append(CELL_LENGTH_LATITUDE, this.cellLengthLatitude).
            append(MAP_FILES, this.mapFiles).
            append(COMMENT, this.comment).
         toString();
        return result;
}


} //FisheryRegionAbstract
