/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class EquationDAOAbstract<E extends Equation> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Equation.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByName :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByName(String v) throws TopiaException {
        E result = findByProperty(Equation.NAME, v);
        return result;
    }

    /**
     * findAllByName :
     * Retourne les éléments ayant comme valeur pour l'attribut name le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByName(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.NAME, v);
        return result;
    }

    /**
     * findByContent :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut content le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByContent(String v) throws TopiaException {
        E result = findByProperty(Equation.CONTENT, v);
        return result;
    }

    /**
     * findAllByContent :
     * Retourne les éléments ayant comme valeur pour l'attribut content le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByContent(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.CONTENT, v);
        return result;
    }

    /**
     * findByCategory :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut category le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCategory(String v) throws TopiaException {
        E result = findByProperty(Equation.CATEGORY, v);
        return result;
    }

    /**
     * findAllByCategory :
     * Retourne les éléments ayant comme valeur pour l'attribut category le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCategory(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.CATEGORY, v);
        return result;
    }

    /**
     * findByLanguage :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut language le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLanguage(String v) throws TopiaException {
        E result = findByProperty(Equation.LANGUAGE, v);
        return result;
    }

    /**
     * findAllByLanguage :
     * Retourne les éléments ayant comme valeur pour l'attribut language le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLanguage(String v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.LANGUAGE, v);
        return result;
    }

    /**
     * findByJavaInterface :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut javaInterface le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByJavaInterface(Class v) throws TopiaException {
        E result = findByProperty(Equation.JAVA_INTERFACE, v);
        return result;
    }

    /**
     * findAllByJavaInterface :
     * Retourne les éléments ayant comme valeur pour l'attribut javaInterface le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByJavaInterface(Class v) throws TopiaException {
        List<E> result = findAllByProperty(Equation.JAVA_INTERFACE, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        List<?> result = new ArrayList();
        List tmp;

        if (type == TargetSpecies.class) {
            TargetSpeciesDAO dao = (TargetSpeciesDAO)
                getContext().getDAO(TargetSpecies.class);
            tmp = dao.findAllByTargetFactorEquation(entity);
//            tmp = dao.findAllByProperties(TargetSpecies.TARGET_FACTOR_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == Strategy.class) {
            StrategyDAO dao = (StrategyDAO)
                getContext().getDAO(Strategy.class);
            tmp = dao.findAllByInactivityEquation(entity);
//            tmp = dao.findAllByProperties(Strategy.INACTIVITY_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByGrowth(entity);
//            tmp = dao.findAllByProperties(Population.GROWTH, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByGrowthReverse(entity);
//            tmp = dao.findAllByProperties(Population.GROWTH_REVERSE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByMeanWeight(entity);
//            tmp = dao.findAllByProperties(Population.MEAN_WEIGHT, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByPrice(entity);
//            tmp = dao.findAllByProperties(Population.PRICE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByNaturalDeathRate(entity);
//            tmp = dao.findAllByProperties(Population.NATURAL_DEATH_RATE, entity);
            result.addAll(tmp);
        }

        if (type == Population.class) {
            PopulationDAO dao = (PopulationDAO)
                getContext().getDAO(Population.class);
            tmp = dao.findAllByReproductionEquation(entity);
//            tmp = dao.findAllByProperties(Population.REPRODUCTION_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByMigrationEquation(entity);
//            tmp = dao.findAllByProperties(PopulationSeasonInfo.MIGRATION_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByEmigrationEquation(entity);
//            tmp = dao.findAllByProperties(PopulationSeasonInfo.EMIGRATION_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == PopulationSeasonInfo.class) {
            PopulationSeasonInfoDAO dao = (PopulationSeasonInfoDAO)
                getContext().getDAO(PopulationSeasonInfo.class);
            tmp = dao.findAllByImmigrationEquation(entity);
//            tmp = dao.findAllByProperties(PopulationSeasonInfo.IMMIGRATION_EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == Selectivity.class) {
            SelectivityDAO dao = (SelectivityDAO)
                getContext().getDAO(Selectivity.class);
            tmp = dao.findAllByEquation(entity);
//            tmp = dao.findAllByProperties(Selectivity.EQUATION, entity);
            result.addAll(tmp);
        }

        if (type == SetOfVessels.class) {
            SetOfVesselsDAO dao = (SetOfVesselsDAO)
                getContext().getDAO(SetOfVessels.class);
            tmp = dao.findAllByTechnicalEfficiencyEquation(entity);
//            tmp = dao.findAllByProperties(SetOfVessels.TECHNICAL_EFFICIENCY_EQUATION, entity);
            result.addAll(tmp);
        }

        return (List<U>) result;
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        Map<Class<? extends TopiaEntity>,List<? extends TopiaEntity>> result;
        result = new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>(6);
        
        List<? extends TopiaEntity> list;

        list = findUsages(TargetSpecies.class, entity);
        if (!list.isEmpty()) {
            result.put(TargetSpecies.class, list);
        }

        list = findUsages(Strategy.class, entity);
        if (!list.isEmpty()) {
            result.put(Strategy.class, list);
        }

        list = findUsages(Population.class, entity);
        if (!list.isEmpty()) {
            result.put(Population.class, list);
        }

        list = findUsages(PopulationSeasonInfo.class, entity);
        if (!list.isEmpty()) {
            result.put(PopulationSeasonInfo.class, list);
        }

        list = findUsages(Selectivity.class, entity);
        if (!list.isEmpty()) {
            result.put(Selectivity.class, list);
        }

        list = findUsages(SetOfVessels.class, entity);
        if (!list.isEmpty()) {
            result.put(SetOfVessels.class, list);
        }

        return result;
    }


} //EquationDAOAbstract<E extends Equation>
