/*
 * #%L
 * IsisFish
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 1999 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 2 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-2.0.html>.
 * #L%
 */
package fr.ifremer.isisfish.entities;

import fr.ifremer.isisfish.types.TimeUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class EffortDescriptionDAOAbstract<E extends EffortDescription> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)EffortDescription.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByFishingOperation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fishingOperation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFishingOperation(int v) throws TopiaException {
        E result = findByProperty(EffortDescription.FISHING_OPERATION, v);
        return result;
    }

    /**
     * findAllByFishingOperation :
     * Retourne les éléments ayant comme valeur pour l'attribut fishingOperation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFishingOperation(int v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.FISHING_OPERATION, v);
        return result;
    }

    /**
     * findByFishingOperationDuration :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fishingOperationDuration le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFishingOperationDuration(TimeUnit v) throws TopiaException {
        E result = findByProperty(EffortDescription.FISHING_OPERATION_DURATION, v);
        return result;
    }

    /**
     * findAllByFishingOperationDuration :
     * Retourne les éléments ayant comme valeur pour l'attribut fishingOperationDuration le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFishingOperationDuration(TimeUnit v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.FISHING_OPERATION_DURATION, v);
        return result;
    }

    /**
     * findByGearsNumberPerOperation :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut gearsNumberPerOperation le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByGearsNumberPerOperation(int v) throws TopiaException {
        E result = findByProperty(EffortDescription.GEARS_NUMBER_PER_OPERATION, v);
        return result;
    }

    /**
     * findAllByGearsNumberPerOperation :
     * Retourne les éléments ayant comme valeur pour l'attribut gearsNumberPerOperation le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByGearsNumberPerOperation(int v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.GEARS_NUMBER_PER_OPERATION, v);
        return result;
    }

    /**
     * findByCrewSize :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewSize le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewSize(int v) throws TopiaException {
        E result = findByProperty(EffortDescription.CREW_SIZE, v);
        return result;
    }

    /**
     * findAllByCrewSize :
     * Retourne les éléments ayant comme valeur pour l'attribut crewSize le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewSize(int v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.CREW_SIZE, v);
        return result;
    }

    /**
     * findByUnitCostOfFishing :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut unitCostOfFishing le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByUnitCostOfFishing(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.UNIT_COST_OF_FISHING, v);
        return result;
    }

    /**
     * findAllByUnitCostOfFishing :
     * Retourne les éléments ayant comme valeur pour l'attribut unitCostOfFishing le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByUnitCostOfFishing(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.UNIT_COST_OF_FISHING, v);
        return result;
    }

    /**
     * findByFixedCrewSalary :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut fixedCrewSalary le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByFixedCrewSalary(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.FIXED_CREW_SALARY, v);
        return result;
    }

    /**
     * findAllByFixedCrewSalary :
     * Retourne les éléments ayant comme valeur pour l'attribut fixedCrewSalary le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByFixedCrewSalary(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.FIXED_CREW_SALARY, v);
        return result;
    }

    /**
     * findByCrewShareRate :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewShareRate le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewShareRate(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.CREW_SHARE_RATE, v);
        return result;
    }

    /**
     * findAllByCrewShareRate :
     * Retourne les éléments ayant comme valeur pour l'attribut crewShareRate le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewShareRate(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.CREW_SHARE_RATE, v);
        return result;
    }

    /**
     * findByCrewFoodCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut crewFoodCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCrewFoodCost(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.CREW_FOOD_COST, v);
        return result;
    }

    /**
     * findAllByCrewFoodCost :
     * Retourne les éléments ayant comme valeur pour l'attribut crewFoodCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCrewFoodCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.CREW_FOOD_COST, v);
        return result;
    }

    /**
     * findByRepairAndMaintenanceGearCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut repairAndMaintenanceGearCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByRepairAndMaintenanceGearCost(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.REPAIR_AND_MAINTENANCE_GEAR_COST, v);
        return result;
    }

    /**
     * findAllByRepairAndMaintenanceGearCost :
     * Retourne les éléments ayant comme valeur pour l'attribut repairAndMaintenanceGearCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByRepairAndMaintenanceGearCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.REPAIR_AND_MAINTENANCE_GEAR_COST, v);
        return result;
    }

    /**
     * findByOtherRunningCost :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut otherRunningCost le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByOtherRunningCost(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.OTHER_RUNNING_COST, v);
        return result;
    }

    /**
     * findAllByOtherRunningCost :
     * Retourne les éléments ayant comme valeur pour l'attribut otherRunningCost le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByOtherRunningCost(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.OTHER_RUNNING_COST, v);
        return result;
    }

    /**
     * findByLandingCosts :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut landingCosts le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByLandingCosts(double v) throws TopiaException {
        E result = findByProperty(EffortDescription.LANDING_COSTS, v);
        return result;
    }

    /**
     * findAllByLandingCosts :
     * Retourne les éléments ayant comme valeur pour l'attribut landingCosts le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByLandingCosts(double v) throws TopiaException {
        List<E> result = findAllByProperty(EffortDescription.LANDING_COSTS, v);
        return result;
    }

    /**
     * findContainsSetOfVessels :
     * Retourne le premier élément trouvé dont l'attribut setOfVessels contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsSetOfVessels(SetOfVessels... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(EffortDescription.SET_OF_VESSELS, Arrays.asList(v));
        E result = findContainsProperties("setOfVessels", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsSetOfVessels :
     * Retourne les éléments trouvé dont l'attribut setOfVessels contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsSetOfVessels(SetOfVessels... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(EffortDescription.SET_OF_VESSELS, Arrays.asList(v));
        List<E> results = findAllContainsProperties("setOfVessels", Arrays.asList(v));
        return results;
    }

    /**
     * findContainsPossibleMetiers :
     * Retourne le premier élément trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findContainsPossibleMetiers(Metier... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //E  result = findContainsProperties(EffortDescription.POSSIBLE_METIERS, Arrays.asList(v));
        E result = findContainsProperties("possibleMetiers", Arrays.asList(v));
        return result;
    }

    /**
     * findAllContainsPossibleMetiers :
     * Retourne les éléments trouvé dont l'attribut possibleMetiers contient le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllContainsPossibleMetiers(Metier... v) throws TopiaException {
        //FIXME TC-20100129 : really strange behaviour : contains on sub-sub properties instead of sub properties ?
        //List<E> results = findAllContainsProperties(EffortDescription.POSSIBLE_METIERS, Arrays.asList(v));
        List<E> results = findAllContainsProperties("possibleMetiers", Arrays.asList(v));
        return results;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //EffortDescriptionDAOAbstract<E extends EffortDescription>
